/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.abc.semantics;

import com.adobe.flash.abc.graph.IBasicBlock;
import com.adobe.flash.abc.graph.IFlowgraph;
import com.adobe.flash.abc.semantics.ExceptionInfo;
import com.adobe.flash.abc.semantics.Instruction;
import com.adobe.flash.abc.semantics.MethodBodyInfo;
import com.adobe.flash.abc.semantics.Name;
import com.adobe.flash.abc.visitors.IDiagnosticsVisitor;
import com.adobe.flash.abc.visitors.IFlowGraphVisitor;
import java.util.HashMap;
import java.util.Map;

public class FrameCountVisitor
implements IFlowGraphVisitor {
    final MethodBodyInfo mbi;
    final IDiagnosticsVisitor diagnosticsVisitor;
    final IFlowgraph cfg;
    final int initial_scope;
    final Iterable<ExceptionInfo> exceptions;
    int max_stack;
    int max_local;
    int max_scope;
    int max_slot;
    boolean hasNewclass = false;
    Map<IBasicBlock, Integer> stkin = new HashMap<IBasicBlock, Integer>();
    Map<IBasicBlock, Integer> scpin = new HashMap<IBasicBlock, Integer>();
    int stkdepth = 0;
    int scpdepth = 0;
    int instructionIndex;
    IBasicBlock currentBlock;

    FrameCountVisitor(MethodBodyInfo mbi, IDiagnosticsVisitor diagnosticsVisitor, int initial_scope) {
        this.diagnosticsVisitor = diagnosticsVisitor;
        this.cfg = mbi.getCfg();
        this.mbi = mbi;
        this.initial_scope = initial_scope;
        this.exceptions = mbi.getExceptions();
        this.instructionIndex = 0;
    }

    @Override
    public boolean visitBlock(IBasicBlock b) {
        this.currentBlock = b;
        if (this.cfg.isCatchTarget(b)) {
            this.stkdepth = 1;
            this.scpdepth = 0;
        } else if (this.stkin.containsKey(b)) {
            this.stkdepth = this.stkin.get(b);
            this.scpdepth = this.scpin.get(b);
        }
        return true;
    }

    @Override
    public void visitInstruction(Instruction i) {
        switch (i.opcode) {
            case 135: 
            case 160: 
            case 168: 
            case 169: 
            case 170: 
            case 197: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -1);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 16: 
            case 43: 
            case 71: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 128: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 136: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: {
                break;
            }
            case 83: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -i.getImmediate());
                break;
            }
            case 65: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -(i.getImmediate() + 1));
                break;
            }
            case 67: {
                assert (false) : "internal only instruction!";
                this.stkdepth = this.adjustValueStack(this.stkdepth, -i.getImmediate());
                break;
            }
            case 68: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -((Integer)i.getOperand(1)).intValue());
                break;
            }
            case 69: 
            case 70: 
            case 74: 
            case 76: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -((Integer)i.getOperand(1)).intValue() + this.runtimeNameAllowance((Name)i.getOperand(0)));
                break;
            }
            case 78: 
            case 79: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -((Integer)i.getOperand(1)).intValue() + this.runtimeNameAllowance((Name)i.getOperand(0)) - 1);
                break;
            }
            case 66: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -i.getImmediate());
                break;
            }
            case 73: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -i.getImmediate() - 1);
                break;
            }
            case 106: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, this.runtimeNameAllowance((Name)i.getOperand(0)));
                break;
            }
            case 163: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -1);
                break;
            }
            case 42: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, 1);
                break;
            }
            case 7: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -1);
                break;
            }
            case 171: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -1);
                break;
            }
            case 93: 
            case 94: 
            case 95: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, 1 + this.runtimeNameAllowance((Name)i.getOperand(0)));
                break;
            }
            case 4: 
            case 89: 
            case 102: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, this.runtimeNameAllowance((Name)i.getOperand(0)));
                break;
            }
            case 96: 
            case 100: 
            case 103: 
            case 110: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, 1);
                break;
            }
            case 98: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, 1);
                this.adjustMaxLocal(i.getImmediate());
                if (i.getImmediate() >= 4) break;
                i.opcode = 208 + i.getImmediate();
                break;
            }
            case 208: 
            case 209: 
            case 210: 
            case 211: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, 1);
                this.adjustMaxLocal(i.opcode - 208);
                break;
            }
            case 108: {
                if (i.getImmediate() <= this.max_slot) break;
                this.max_slot = i.getImmediate();
                break;
            }
            case 101: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, 1);
                break;
            }
            case 31: 
            case 175: 
            case 176: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -1);
                break;
            }
            case 50: {
                this.adjustMaxLocal((Integer)i.getOperand(0));
                this.adjustMaxLocal((Integer)i.getOperand(1));
                this.stkdepth = this.adjustValueStack(this.stkdepth, 1);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -2);
                break;
            }
            case 17: 
            case 18: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -1);
                break;
            }
            case 180: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -1);
                break;
            }
            case 104: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -2 + this.runtimeNameAllowance((Name)i.getOperand(0)));
                break;
            }
            case 177: 
            case 179: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -1);
                break;
            }
            case 178: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, this.runtimeNameAllowance((Name)i.getOperand(0)));
                break;
            }
            case 27: 
            case 162: 
            case 164: 
            case 165: 
            case 173: 
            case 174: 
            case 199: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -1);
                break;
            }
            case 64: 
            case 87: 
            case 90: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, 1);
                break;
            }
            case 86: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, 1 - i.getImmediate());
                break;
            }
            case 85: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, 1 - i.getImmediate() * 2);
                break;
            }
            case 30: 
            case 35: 
            case 41: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -1);
                break;
            }
            case 29: {
                this.scpdepth = this.adjustScopeStack(this.scpdepth, -1);
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 84: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, 1);
                break;
            }
            case 28: 
            case 48: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -1);
                this.scpdepth = this.adjustScopeStack(this.scpdepth, 1);
                break;
            }
            case 72: 
            case 166: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -1);
                break;
            }
            case 99: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -1);
                this.adjustMaxLocal(i.getImmediate());
                if (i.getImmediate() >= 4) break;
                i.opcode = 212 + i.getImmediate();
                break;
            }
            case 212: 
            case 213: 
            case 214: 
            case 215: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -1);
                this.adjustMaxLocal(i.opcode - 212);
                break;
            }
            case 111: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -1);
                break;
            }
            case 5: 
            case 97: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -2 + this.runtimeNameAllowance((Name)i.getOperand(0)));
                break;
            }
            case 109: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -2);
                if (this.max_slot >= i.getImmediate()) break;
                this.max_slot = i.getImmediate();
                break;
            }
            case 3: 
            case 161: 
            case 167: 
            case 172: 
            case 198: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -1);
                break;
            }
            case 88: {
                this.hasNewclass = true;
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 80: 
            case 81: 
            case 82: {
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                this.stkdepth = this.adjustValueStack(this.stkdepth, -2);
                break;
            }
            case 75: 
            case 77: 
            case 105: 
            case 107: {
                assert (false) : "internal only instruction!";
                break;
            }
            default: {
                assert (false) : "unknown instruction!";
                break;
            }
        }
        ++this.instructionIndex;
    }

    @Override
    public void visitEnd(IBasicBlock b) {
        for (IBasicBlock iBasicBlock : b.getSuccessors()) {
            if (this.stkin.containsKey(iBasicBlock)) continue;
            this.stkin.put(iBasicBlock, this.stkdepth);
            this.scpin.put(iBasicBlock, this.scpdepth);
        }
    }

    private int adjustValueStack(int stkdepth, int incr) {
        if ((stkdepth += incr) < 0) {
            this.diagnosticsVisitor.operandStackUnderflow(this.mbi, this.cfg, this.currentBlock, this.instructionIndex);
        }
        if (stkdepth > this.max_stack) {
            this.max_stack = stkdepth;
        }
        return stkdepth;
    }

    private int adjustScopeStack(int scpdepth, int incr) {
        if ((scpdepth += incr) < 0) {
            this.diagnosticsVisitor.scopeStackUnderflow(this.mbi, this.cfg, this.currentBlock, this.instructionIndex);
        }
        if (scpdepth > this.max_scope - this.initial_scope) {
            this.max_scope = scpdepth + this.initial_scope;
        }
        return scpdepth;
    }

    private void adjustMaxLocal(int idx) {
        if (this.max_local <= idx) {
            this.max_local = idx + 1;
        }
    }

    private int runtimeNameAllowance(Object operand) {
        return operand instanceof Name ? -((Name)operand).runtimeNameAllowance() : 0;
    }

    public boolean hasNewclassInstruction() {
        return this.hasNewclass;
    }
}

