/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.abc.semantics;

public class Float4 {
    private static final int PRIME_MULTIPLIER = 2887;
    private final float[] values;
    private Integer cachedHashCode;

    public Float4(float[] value) {
        assert (value.length == 4) : "float4 must be constructed with 4 values";
        this.values = value;
    }

    public float[] getValues() {
        return this.values;
    }

    public int hashCode() {
        if (this.cachedHashCode == null) {
            int result = 0;
            for (float f : this.values) {
                result = 2887 * result + Float.floatToIntBits(f);
            }
            this.cachedHashCode = result;
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Float4) {
            Float4 otherFloat4 = (Float4)other;
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == otherFloat4.values[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

