/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.abc.print;

import com.adobe.flash.abc.ABCConstants;
import com.adobe.flash.abc.ABCParser;
import com.adobe.flash.abc.PoolingABCVisitor;
import com.adobe.flash.abc.graph.IBasicBlock;
import com.adobe.flash.abc.graph.IFlowgraph;
import com.adobe.flash.abc.print.ABCDumpUtils;
import com.adobe.flash.abc.semantics.ClassInfo;
import com.adobe.flash.abc.semantics.ExceptionInfo;
import com.adobe.flash.abc.semantics.InstanceInfo;
import com.adobe.flash.abc.semantics.Instruction;
import com.adobe.flash.abc.semantics.Label;
import com.adobe.flash.abc.semantics.Metadata;
import com.adobe.flash.abc.semantics.MethodBodyInfo;
import com.adobe.flash.abc.semantics.MethodInfo;
import com.adobe.flash.abc.semantics.Name;
import com.adobe.flash.abc.semantics.Namespace;
import com.adobe.flash.abc.semantics.ScriptInfo;
import com.adobe.flash.abc.semantics.Trait;
import com.adobe.flash.abc.semantics.Traits;
import com.adobe.flash.utils.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ABCDumpVisitor
extends PoolingABCVisitor {
    private IndentingPrinter printer;
    private Set<MethodInfo> dumpedMethods;

    public ABCDumpVisitor(PrintWriter p) {
        this.printer = new IndentingPrinter(p, 0, 2);
        this.dumpedMethods = new HashSet<MethodInfo>();
    }

    public void write() {
        this.traverse();
        this.writeIterable(this.getMethodInfos(), new IWriteFunction(){

            @Override
            public void write(Object v, int index) {
                ABCDumpVisitor.this.writeAnonMethodInfo((MethodInfo)v, index);
            }
        });
    }

    public void traverse() {
        int nScripts = this.getScriptInfos().size();
        for (int i = 0; i < nScripts; ++i) {
            ScriptInfo si = this.getScriptInfos().get(i);
            this.traverseScript(i, si);
        }
    }

    protected void traverseScript(int id, ScriptInfo scriptInfo) {
        this.printer.println("// script " + id);
        this.traverseScriptTraits(scriptInfo.getTraits(), scriptInfo);
        MethodInfo initMethodInfo = scriptInfo.getInit();
        this.traverseScriptInit(initMethodInfo, scriptInfo, id);
        this.printer.println("");
    }

    protected void traverseScriptTraits(Traits traits, ScriptInfo si) {
        for (Trait t : traits) {
            switch (t.getKind()) {
                case 6: {
                    this.traverseScriptConstTrait(t, si);
                    break;
                }
                case 0: {
                    this.traverseScriptSlotTrait(t, si);
                    break;
                }
                case 1: {
                    this.traverseScriptMethodTrait(t, si);
                    break;
                }
                case 2: {
                    this.traverseScriptGetterTrait(t, si);
                    break;
                }
                case 3: {
                    this.traverseScriptSetterTrait(t, si);
                    break;
                }
                case 5: {
                    this.traverseScriptFunctionTrait(t, si);
                    break;
                }
                case 4: {
                    this.traverseScriptClassTrait(t, si);
                }
            }
        }
    }

    protected void traverseInstanceTraits(Traits traits) {
        for (Trait t : traits) {
            switch (t.getKind()) {
                case 6: {
                    this.traverseInstanceConstTrait(t);
                    break;
                }
                case 0: {
                    this.traverseInstanceSlotTrait(t);
                    break;
                }
                case 1: {
                    this.traverseInstanceMethodTrait(t);
                    break;
                }
                case 2: {
                    this.traverseInstanceGetterTrait(t);
                    break;
                }
                case 3: {
                    this.traverseInstanceSetterTrait(t);
                    break;
                }
                case 5: {
                    this.traverseInstanceFunctionTrait(t);
                }
            }
        }
    }

    protected void traverseClassTraits(Traits traits) {
        for (Trait t : traits) {
            switch (t.getKind()) {
                case 6: {
                    this.traverseClassConstTrait(t);
                    break;
                }
                case 0: {
                    this.traverseClassSlotTrait(t);
                    break;
                }
                case 1: {
                    this.traverseClassMethodTrait(t);
                    break;
                }
                case 2: {
                    this.traverseClassGetterTrait(t);
                    break;
                }
                case 3: {
                    this.traverseClassSetterTrait(t);
                    break;
                }
                case 5: {
                    this.traverseClassFunctionTrait(t);
                }
            }
        }
    }

    protected void traverseScriptSlotTrait(Trait trait, ScriptInfo scriptInfo) {
        this.writeSlotTrait("var", trait, false);
    }

    protected void traverseScriptConstTrait(Trait trait, ScriptInfo scriptInfo) {
        this.writeSlotTrait("const", trait, false);
    }

    protected void traverseScriptMethodTrait(Trait trait, ScriptInfo scriptInfo) {
        this.writeMethodTrait("function", trait, false);
    }

    protected void traverseScriptGetterTrait(Trait trait, ScriptInfo scriptInfo) {
        this.writeMethodTrait("function get", trait, false);
    }

    protected void traverseScriptSetterTrait(Trait trait, ScriptInfo scriptInfo) {
        this.writeMethodTrait("function set", trait, false);
    }

    protected void traverseScriptFunctionTrait(Trait trait, ScriptInfo scriptInfo) {
        this.writeMethodTrait("function", trait, false);
    }

    protected void traverseScriptClassTrait(Trait trait, ScriptInfo scriptInfo) {
        ClassInfo ci = (ClassInfo)trait.getAttr("class_id");
        int classIndex = this.getClassId(ci);
        PoolingABCVisitor.ClassVisitor cv = this.getDefinedClasses().get(classIndex);
        InstanceInfo iinfo = cv.getInstanceInfo();
        this.traverseScriptClassTrait(classIndex, iinfo, ci, trait, scriptInfo);
    }

    protected void traverseScriptClassTrait(int classId, InstanceInfo instanceInfo, ClassInfo classInfo, Trait trait, ScriptInfo scriptInfo) {
        String def;
        this.printer.println("");
        int slotId = 0;
        if (trait.hasAttr("slot_id")) {
            slotId = trait.getIntAttr("slot_id");
        }
        this.printer.println("// class_id=" + classId + " slot_id=" + String.valueOf(slotId));
        if (instanceInfo.isInterface()) {
            def = "interface";
        } else {
            def = "class";
            if (!instanceInfo.isSealed()) {
                def = "dynamic " + def;
            }
            if (instanceInfo.isFinal()) {
                def = "final " + def;
            }
        }
        this.writeMetaData(trait);
        this.printer.println(ABCDumpUtils.nsQualifierForName(trait.getName()) + def + " " + ABCDumpUtils.nameToString(trait.getName()) + " extends " + ABCDumpUtils.nameToString(instanceInfo.superName));
        if (instanceInfo.interfaceNames.length > 0) {
            this.printer.indent();
            ArrayList<String> interfaceNames = new ArrayList<String>();
            for (Name interfaceName : instanceInfo.interfaceNames) {
                interfaceNames.add(ABCDumpUtils.nameToString(interfaceName));
            }
            this.printer.println(StringUtils.joinOn(",", interfaceNames));
            this.printer.unindent();
        }
        this.printer.println("{");
        this.printer.indent();
        this.traverseInstanceInit(instanceInfo.iInit, instanceInfo, trait, scriptInfo);
        this.traverseInstanceTraits(instanceInfo.traits);
        this.traverseClassInit(classInfo.cInit, classInfo, trait, scriptInfo);
        this.traverseClassTraits(classInfo.classTraits);
        this.printer.unindent();
        this.printer.println("}");
    }

    protected void traverseScriptInit(MethodInfo init, ScriptInfo scriptInfo, int scriptId) {
        this.printer.println("");
        this.writeMethodInfo("", "script" + scriptId + "$init", "function", init, false, false, false);
    }

    protected void traverseInstanceInit(MethodInfo init, InstanceInfo instanceInfo, Trait classTrait, ScriptInfo scriptInfo) {
        this.printer.println("");
        this.printer.println("// method_id=" + this.getMethodInfos().getId(instanceInfo.iInit));
        this.writeMethodInfo("public ", ABCDumpUtils.nameToString(classTrait.getName()), "function", init, false, false, false);
    }

    protected void traverseInstanceSlotTrait(Trait trait) {
        this.writeSlotTrait("var", trait, false);
    }

    protected void traverseInstanceConstTrait(Trait trait) {
        this.writeSlotTrait("const", trait, false);
    }

    protected void traverseInstanceMethodTrait(Trait trait) {
        this.writeMethodTrait("function", trait, false);
    }

    protected void traverseInstanceGetterTrait(Trait trait) {
        this.writeMethodTrait("function get", trait, false);
    }

    protected void traverseInstanceSetterTrait(Trait trait) {
        this.writeMethodTrait("function set", trait, false);
    }

    protected void traverseInstanceFunctionTrait(Trait trait) {
        this.writeMethodTrait("function", trait, false);
    }

    protected void traverseClassInit(MethodInfo init, ClassInfo classInfo, Trait classTrait, ScriptInfo scriptInfo) {
        this.printer.println("");
        this.writeMethodInfo("public ", ABCDumpUtils.nameToString(classTrait.getName()) + "$", "function", init, true, false, false);
    }

    protected void traverseClassSlotTrait(Trait trait) {
        this.writeSlotTrait("var", trait, true);
    }

    protected void traverseClassConstTrait(Trait trait) {
        this.writeSlotTrait("const", trait, true);
    }

    protected void traverseClassMethodTrait(Trait trait) {
        this.writeMethodTrait("function", trait, true);
    }

    protected void traverseClassGetterTrait(Trait trait) {
        this.writeMethodTrait("function get", trait, true);
    }

    protected void traverseClassSetterTrait(Trait trait) {
        this.writeMethodTrait("function set", trait, true);
    }

    protected void traverseClassFunctionTrait(Trait trait) {
        this.writeMethodTrait("function", trait, true);
    }

    private void writeMetaData(Trait t) {
        if (!t.hasMetadata()) {
            return;
        }
        for (Metadata mid : t.getMetadata()) {
            Vector<String> entries = new Vector<String>();
            String[] keys = mid.getKeys();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                String value = mid.getValues()[i];
                if (key == null || key.length() == 0) {
                    entries.add("\"" + value + "\"");
                    continue;
                }
                entries.add(key + "=\"" + value + "\"");
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < entries.size(); ++i) {
                sb.append((String)entries.get(i));
                if (i >= entries.size() - 1) continue;
                sb.append(", ");
            }
            this.printer.println("[" + mid.getName() + "(" + sb.toString() + ")]" + " // metadata_id=" + mid);
        }
    }

    private void writeAnonMethodInfo(MethodInfo mi, int id) {
        if (this.dumpedMethods.contains(mi)) {
            return;
        }
        this.printer.println("");
        this.printer.println("// " + id + " " + mi.getMethodName());
        this.writeMethodInfo("", "", "function ", mi, false, false, false);
    }

    private void writeSlotTrait(String kindStr, Trait t, boolean isStatic) {
        this.printer.println("");
        String qual = ABCDumpUtils.nsQualifierForName(t.getName());
        String nameStr = ABCDumpUtils.nameToString(t.getName());
        Object value = null;
        if (t.hasAttr("value")) {
            value = t.getAttr("value");
        }
        String valueStr = "";
        if (value instanceof String) {
            valueStr = " = \"" + value + "\"";
        } else if (value instanceof Namespace) {
            valueStr = " = " + ((Namespace)value).getName();
        } else if (value == ABCConstants.NULL_VALUE) {
            valueStr = " = null";
        } else if (value == ABCConstants.UNDEFINED_VALUE) {
            valueStr = "";
        } else if (value != null) {
            valueStr = " = " + value.toString();
        }
        String staticStr = isStatic ? "static " : "";
        this.writeMetaData(t);
        this.printer.println(qual + staticStr + kindStr + " " + nameStr + ":" + ABCDumpUtils.nameToString((Name)t.getAttr("type")) + valueStr);
    }

    private String stringForLookupSwitch(Instruction inst, MethodBodyInfo mb, Map<IBasicBlock, String> blockNames, IFlowgraph cfg) {
        int case_size = inst.getOperandCount() - 1;
        String defaultStr = "default: " + blockNames.get(cfg.getBlock((Label)inst.getOperand(case_size)));
        String maxCaseStr = "maxcase: " + case_size;
        Vector<String> result = new Vector<String>();
        result.add(defaultStr);
        result.add(maxCaseStr);
        for (int i = 0; i < case_size; ++i) {
            result.add(blockNames.get(cfg.getBlock((Label)inst.getOperand(i))));
        }
        return StringUtils.joinOn(" ", result);
    }

    protected void writeMethodInfo(String qualStr, String nameStr, String kindStr, MethodInfo methodInfo, boolean isStatic, boolean isOverride, boolean isFinal) {
        String finalStr;
        this.dumpedMethods.add(methodInfo);
        Vector<String> paramTypeStrings = new Vector<String>();
        for (Name paramTypeName : methodInfo.getParamTypes()) {
            paramTypeStrings.add(ABCDumpUtils.nameToString(paramTypeName));
        }
        String staticStr = isStatic ? "static " : "";
        String overrideStr = isOverride ? "override " : "";
        String nativeStr = methodInfo.isNative() ? "native " : "";
        String string = finalStr = isFinal ? "final " : "";
        if (nameStr == "") {
            nameStr = methodInfo.getMethodName();
        }
        this.printer.println(qualStr + staticStr + nativeStr + finalStr + overrideStr + kindStr + " " + nameStr + "(" + StringUtils.joinOn(",", paramTypeStrings) + "):" + ABCDumpUtils.nameToString(methodInfo.getReturnType()));
        MethodBodyInfo mb = this.getMethodBodyForMethodInfo(methodInfo);
        if (mb != null) {
            this.printer.println("{");
            this.printer.indent();
            TablePrinter tablePrinter = new TablePrinter(3, 2);
            tablePrinter.addRow(new String[]{"//", "derivedName", methodInfo.getMethodName()});
            tablePrinter.addRow(new String[]{"//", "method_info", String.valueOf(this.getMethodInfos().getId(mb.getMethodInfo()))});
            tablePrinter.addRow(new String[]{"//", "max_stack", String.valueOf(mb.max_stack)});
            tablePrinter.addRow(new String[]{"//", "max_regs", String.valueOf(mb.max_local)});
            tablePrinter.addRow(new String[]{"//", "scope_depth", String.valueOf(mb.initial_scope)});
            tablePrinter.addRow(new String[]{"//", "max_scope", String.valueOf(mb.max_scope)});
            tablePrinter.addRow(new String[]{"//", "code_length", String.valueOf(mb.code_len)});
            tablePrinter.print(this.printer);
            if (mb.getTraits() != null && mb.getTraits().getTraitCount() > 0) {
                this.printer.println("activation_traits {");
                this.printer.indent();
                for (Trait trait : mb.getTraits()) {
                    switch (trait.getKind()) {
                        case 0: {
                            kindStr = "var";
                            break;
                        }
                        case 6: {
                            kindStr = "const";
                            break;
                        }
                        default: {
                            throw new Error("Illegal activation trait in " + methodInfo.getMethodName());
                        }
                    }
                    this.writeSlotTrait(kindStr, trait, false);
                }
                this.printer.unindent();
                this.printer.println("}");
            }
            IFlowgraph cfg = mb.getCfg();
            HashMap<IBasicBlock, String> blockNames = new HashMap<IBasicBlock, String>();
            int i = 0;
            for (IBasicBlock block : cfg.getBlocksInEntryOrder()) {
                blockNames.put(block, "bb" + i++);
            }
            int offset = 0;
            for (IBasicBlock block : cfg.getBlocksInEntryOrder()) {
                this.printer.println((String)blockNames.get(block));
                this.printer.indent();
                Collection<? extends IBasicBlock> succs = block.getSuccessors();
                ArrayList succNames = new ArrayList();
                for (IBasicBlock iBasicBlock : succs) {
                    succNames.add(blockNames.get(iBasicBlock));
                }
                this.printer.println("succs=[" + StringUtils.joinOn(",", succNames) + "]");
                tablePrinter = new TablePrinter(4, 2);
                for (int j = 0; j < block.size(); ++j) {
                    Instruction instruction = block.get(j);
                    String constantStr = "";
                    if (instruction.hasOperands() && instruction.getOperand(0) instanceof Name) {
                        constantStr = ABCDumpUtils.nameToString((Name)instruction.getOperand(0));
                    } else if (instruction.isBranch() && instruction.getOpcode() != 27) {
                        constantStr = (String)blockNames.get(cfg.getBlock((Label)instruction.getOperand(0)));
                    } else {
                        switch (instruction.getOpcode()) {
                            case 44: 
                            case 241: {
                                constantStr = "\"" + StringUtils.stringToEscapedString((String)instruction.getOperand(0)) + "\"";
                                break;
                            }
                            case 240: {
                                constantStr = String.valueOf(instruction.getImmediate());
                                break;
                            }
                            case 27: {
                                constantStr = this.stringForLookupSwitch(instruction, mb, blockNames, cfg);
                            }
                        }
                    }
                    tablePrinter.addRow(new String[]{offset + "    ", Instruction.decodeOp(instruction.getOpcode()), constantStr, instruction.isImmediate() ? String.valueOf(instruction.getImmediate()) : ""});
                    ++offset;
                }
                tablePrinter.print(this.printer);
                this.printer.unindent();
            }
            this.printer.unindent();
            this.printer.println("}");
            if (mb.getExceptions().size() > 0) {
                tablePrinter = new TablePrinter(7, 2);
                tablePrinter.addRow(new String[]{"//", "exception", "start", "end", "target", "type string", "name string"});
                for (i = 0; i < mb.getExceptions().size(); ++i) {
                    ExceptionInfo exception = mb.getExceptions().get(i);
                    tablePrinter.addRow(new String[]{"//", String.valueOf(i), String.valueOf(exception.getFrom().getPosition()), String.valueOf(exception.getTo().getPosition()), String.valueOf(exception.getTarget().getPosition()), ABCDumpUtils.nameToString(exception.getExceptionType()), ABCDumpUtils.nameToString(exception.getCatchVar())});
                }
                tablePrinter.print(this.printer);
                this.printer.println("");
            }
        }
    }

    private void writeMethodTrait(String kindStr, Trait t, boolean isStatic) {
        String qual = ABCDumpUtils.nsQualifierForName(t.getName());
        String nameStr = ABCDumpUtils.nameToString(t.getName());
        MethodInfo methodInfo = (MethodInfo)t.getAttr("method_id");
        this.printer.println("");
        this.writeMetaData(t);
        this.writeMethodInfo(qual, nameStr, kindStr, methodInfo, isStatic, t.getBooleanAttr("override"), t.getBooleanAttr("final"));
    }

    private <T> void writeIterable(Iterable<T> p, IWriteFunction writefunc) {
        int i = 0;
        for (T v : p) {
            writefunc.write(v, i++);
        }
    }

    public static void main(String[] args) throws Exception {
        for (String arg : args) {
            File f = new File(arg);
            if (!f.exists()) continue;
            ABCParser parser = new ABCParser(new BufferedInputStream(new FileInputStream(f)));
            ABCDumpVisitor printer = new ABCDumpVisitor(new PrintWriter(System.out));
            parser.parseABC(printer);
        }
    }

    @Override
    public void visitEnd() {
        this.write();
        this.printer.flush();
    }

    public static class TablePrinter {
        private int cols;
        private int minPadding;
        private Vector<Row> m_rows;

        public TablePrinter(int nCols, int minPadding) {
            this.cols = nCols;
            this.minPadding = minPadding;
            this.m_rows = new Vector();
        }

        public void addRow(String[] r) {
            if (r.length != this.cols) {
                throw new Error("Invalid row");
            }
            this.m_rows.add(new Row(r));
        }

        public void print(IndentingPrinter p) {
            int[] colWidths = new int[this.cols];
            for (int i = 0; i < this.cols; ++i) {
                colWidths[i] = 0;
            }
            for (Row r : this.m_rows) {
                r.measure(colWidths, this.minPadding);
            }
            for (Row r : this.m_rows) {
                r.print(p, colWidths);
            }
        }

        private class Row {
            private String[] cells;

            public Row(String[] cells) {
                this.cells = cells;
            }

            public void measure(int[] colWidths, int minPadding) {
                for (int i = 0; i < this.cells.length; ++i) {
                    colWidths[i] = Math.max(colWidths[i], this.getRowItemStr(i).length() + minPadding);
                }
            }

            public void print(IndentingPrinter p, int[] colWidths) {
                String rowStr = "";
                for (int i = 0; i < this.cells.length; ++i) {
                    rowStr = rowStr + this.padString(this.getRowItemStr(i), colWidths[i]);
                }
                p.println(rowStr);
            }

            private String getRowItemStr(int i) {
                if (this.cells[i] == null) {
                    return "null";
                }
                if (i < this.cells.length) {
                    return this.cells[i];
                }
                return "error - out of range " + i;
            }

            private String padString(String s, int minLength) {
                while (s.length() < minLength) {
                    s = s + " ";
                }
                return s;
            }
        }
    }

    private static class IndentingPrinter {
        private PrintWriter delegate;
        private String currentIndent;
        private int indentIncrement;

        public IndentingPrinter(PrintWriter delegate, int initialIndent, int indentIncrement) {
            this.delegate = delegate;
            this.currentIndent = IndentingPrinter.makeIndentStr(initialIndent);
            this.indentIncrement = indentIncrement;
        }

        private static String makeIndentStr(int indent) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < indent; ++i) {
                sb.append(" ");
            }
            String result = sb.toString();
            return result;
        }

        public void println(String s) {
            if (s.length() > 0) {
                s = this.currentIndent + s;
            }
            this.delegate.println(s);
        }

        public void indent() {
            int newIndent = this.currentIndent.length() + this.indentIncrement;
            this.currentIndent = IndentingPrinter.makeIndentStr(newIndent);
        }

        public void unindent() {
            int newIndent = this.currentIndent.length() - this.indentIncrement;
            this.currentIndent = IndentingPrinter.makeIndentStr(newIndent);
        }

        public void flush() {
            this.delegate.flush();
        }
    }

    static interface IWriteFunction {
        public void write(Object var1, int var2);
    }
}

