/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.abc.print;

import com.adobe.flash.abc.semantics.Name;
import com.adobe.flash.abc.semantics.Namespace;
import com.adobe.flash.abc.semantics.Nsset;

public class ABCDumpUtils {
    public static String qnameToString(Namespace ns, String n) {
        if (ns == null) {
            return n;
        }
        if (ns.getKind() == 22 && ns.getName().length() > 0) {
            return ns.getName() + "::" + n;
        }
        String qual = ABCDumpUtils.nsQualifierForNamespace(ns);
        if (qual.length() > 0) {
            return n;
        }
        if (ns.getName().length() == 0) {
            return n;
        }
        return ns.getName() + "::" + n;
    }

    public static String nssetToString(Nsset nsSet) {
        String s = "";
        for (Namespace ns : nsSet) {
            if (ns.getKind() != 5) {
                s = s + ns.getName() + ", ";
                continue;
            }
            s = s + "private, ";
        }
        return "{" + s + "}";
    }

    public static String nameToString(Name n) {
        if (n == null || n.couldBeAnyType()) {
            return "*";
        }
        switch (n.getKind()) {
            case 7: 
            case 13: {
                return ABCDumpUtils.qnameToString(n.getSingleQualifier(), n.getBaseName());
            }
            case 9: 
            case 14: {
                Nsset nsset = n.getQualifiers();
                if (nsset.length() == 1) {
                    return ABCDumpUtils.qnameToString(nsset.iterator().next(), n.getBaseName());
                }
                return ABCDumpUtils.nssetToString(nsset) + "::" + n.getBaseName();
            }
            case 15: 
            case 16: {
                return "<error> " + n.toString();
            }
            case 27: {
                return "<error> " + n.toString();
            }
            case 29: {
                Name typeName = n.getTypeNameParameter();
                return ABCDumpUtils.nameToString(n.getTypeNameBase()) + ".<" + ABCDumpUtils.nameToString(typeName) + ">";
            }
        }
        return "<error> " + n.toString();
    }

    public static String nsQualifierForName(Name n) {
        switch (n.getKind()) {
            case 7: 
            case 13: {
                return ABCDumpUtils.nsQualifierForNamespace(n.getSingleQualifier());
            }
            case 9: 
            case 14: {
                Nsset nsset = n.getQualifiers();
                if (nsset.length() != 1) break;
                return ABCDumpUtils.nsQualifierForNamespace(nsset.iterator().next());
            }
            case 15: 
            case 16: {
                break;
            }
            case 27: {
                break;
            }
        }
        return "";
    }

    public static String nsQualifierForNamespace(Namespace ns) {
        switch (ns.getKind()) {
            case 22: {
                return "public ";
            }
            case 24: 
            case 26: {
                return "protected ";
            }
            case 23: {
                return "internal ";
            }
            case 5: {
                return "private ";
            }
        }
        if (ns.getKind() == 8 && ns.getName().equals("http://adobe.com/AS3/2006/builtin")) {
            return "AS3 ";
        }
        return ns.getName() + " ";
    }
}

