/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.abc.optimize;

import com.adobe.flash.abc.instructionlist.InstructionList;
import com.adobe.flash.abc.semantics.ECMASupport;
import com.adobe.flash.abc.semantics.Instruction;
import com.adobe.flash.abc.semantics.InstructionFactory;
import com.adobe.flash.abc.semantics.Label;
import com.adobe.flash.abc.visitors.DelegatingMethodBodyVisitor;
import com.adobe.flash.abc.visitors.IMethodBodyVisitor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class PeepholeOptimizerMethodBodyVisitor
extends DelegatingMethodBodyVisitor {
    private static final int PEEPHOLE_WINDOW_SIZE = 4;
    private static final int NO_LABEL = -1;
    private List<InstructionInfo> instructions = new LinkedList<InstructionInfo>();
    private int lastLabelSeen = -1;
    private List<Label> labelsFromDeletedInsns = null;
    private InstructionFinisher finisher = new DelegateFinisher();
    private static InstructionInfo noInstruction = new InstructionInfo();

    public PeepholeOptimizerMethodBodyVisitor(IMethodBodyVisitor delegate) {
        super(delegate);
    }

    @Override
    public void visitInstructionList(InstructionList new_list) {
        InstructionList newInstructions = new InstructionList();
        InstructionFinisher old = this.finisher;
        this.finisher = new InstructionListFinisher(newInstructions);
        for (Instruction inst : new_list.getInstructions()) {
            this.visitInstruction(inst);
        }
        this.flush();
        super.visitInstructionList(newInstructions);
        this.finisher = old;
    }

    @Override
    public void visitInstruction(int opcode) {
        this.visitInstruction(InstructionFactory.getInstruction(opcode));
    }

    @Override
    public void visitInstruction(int opcode, int immediate_operand) {
        this.visitInstruction(InstructionFactory.getInstruction(opcode, immediate_operand));
    }

    @Override
    public void visitInstruction(int opcode, Object[] operands) {
        this.visitInstruction(InstructionFactory.getInstruction(opcode, operands));
    }

    @Override
    public void visitInstruction(int opcode, Object single_operand) {
        this.visitInstruction(InstructionFactory.getInstruction(opcode, single_operand));
    }

    @Override
    public void visitInstruction(Instruction instruction) {
        this.processPreviousInstructions();
        this.addInstruction(instruction);
    }

    private void processPreviousInstructions() {
        InstructionInfo last = this.previous(0);
        InstructionInfo secondLast = this.previous(1);
        if (last.getLabelCurrents().isEmpty() && secondLast.getLabelNexts().isEmpty()) {
            switch (last.getOpcode()) {
                case 118: {
                    this.op_convert_b(last);
                    break;
                }
                case 117: {
                    this.op_convert_d(last);
                    break;
                }
                case 115: {
                    this.op_convert_i(last);
                    break;
                }
                case 116: {
                    this.op_convert_u(last);
                    break;
                }
                case 112: {
                    this.op_convert_s(last);
                    break;
                }
                case 102: {
                    this.op_getproperty(last);
                    break;
                }
                case 18: {
                    this.op_iffalse(last);
                    break;
                }
                case 17: {
                    this.op_iftrue(last);
                    break;
                }
                case 41: {
                    this.op_pop(last);
                    break;
                }
                case 2: {
                    this.delete(0);
                    break;
                }
                case 98: {
                    this.OP_getlocal(last);
                    break;
                }
                case 71: {
                    this.op_returnvoid(last);
                    break;
                }
            }
        }
    }

    @Override
    public void visitEnd() {
        this.flush();
        super.visitEnd();
    }

    private void flush() {
        this.processPreviousInstructions();
        for (InstructionInfo info : this.instructions) {
            this.finishInstruction(info);
        }
        this.instructions.clear();
    }

    @Override
    public void labelCurrent(Label l) {
        this.jumpOptimizations(l, LabelKind.LABEL_CURRENT);
        int idx = this.getLastInstructionIndex();
        InstructionInfo instructionInfo = this.instructions.get(idx);
        this.lastLabelSeen = idx;
        instructionInfo.addLabelCurrent(l);
    }

    private void jumpOptimizations(Label l, LabelKind kind) {
        int idx = kind == LabelKind.LABEL_CURRENT ? 1 : 0;
        InstructionInfo prev = this.previous(idx);
        switch (prev.getOpcode()) {
            case 16: {
                InstructionInfo prev2 = this.previous(idx + 1);
                Instruction insn = prev2.getInstruction();
                if (insn != null && insn.isBranch() && insn.getTarget() == l && prev.getLabelCurrents().size() == 0) {
                    Instruction newIf = this.invertIf(prev2, prev);
                    if (newIf == null) break;
                    if (kind == LabelKind.LABEL_CURRENT) {
                        Instruction[] newInsns = new Instruction[]{newIf, this.previous(0).getInstruction()};
                        this.replace(idx + 1, newInsns);
                        break;
                    }
                    this.replace(idx + 1, newIf);
                    break;
                }
                if (prev.getOperand(0) != l) break;
                if (kind == LabelKind.LABEL_NEXT) {
                    this.delete(idx);
                    break;
                }
                this.replace(idx, this.previous(0).getInstruction());
            }
        }
    }

    private Instruction invertIf(InstructionInfo oldIf, InstructionInfo oldJump) {
        Instruction newIf = null;
        switch (oldIf.getOpcode()) {
            case 19: {
                newIf = InstructionFactory.createModifiedInstruction(20, oldJump.getInstruction());
                break;
            }
            case 25: {
                newIf = InstructionFactory.createModifiedInstruction(26, oldJump.getInstruction());
                break;
            }
            case 26: {
                newIf = InstructionFactory.createModifiedInstruction(25, oldJump.getInstruction());
                break;
            }
            case 24: {
                newIf = InstructionFactory.createModifiedInstruction(15, oldJump.getInstruction());
                break;
            }
            case 23: {
                newIf = InstructionFactory.createModifiedInstruction(14, oldJump.getInstruction());
                break;
            }
            case 21: {
                newIf = InstructionFactory.createModifiedInstruction(12, oldJump.getInstruction());
                break;
            }
            case 22: {
                newIf = InstructionFactory.createModifiedInstruction(13, oldJump.getInstruction());
                break;
            }
            case 20: {
                newIf = InstructionFactory.createModifiedInstruction(19, oldJump.getInstruction());
                break;
            }
            case 15: {
                newIf = InstructionFactory.createModifiedInstruction(24, oldJump.getInstruction());
                break;
            }
            case 14: {
                newIf = InstructionFactory.createModifiedInstruction(23, oldJump.getInstruction());
                break;
            }
            case 12: {
                newIf = InstructionFactory.createModifiedInstruction(21, oldJump.getInstruction());
                break;
            }
            case 13: {
                newIf = InstructionFactory.createModifiedInstruction(22, oldJump.getInstruction());
                break;
            }
            case 17: {
                newIf = InstructionFactory.createModifiedInstruction(18, oldJump.getInstruction());
                break;
            }
            case 18: {
                newIf = InstructionFactory.createModifiedInstruction(17, oldJump.getInstruction());
            }
        }
        return newIf;
    }

    private int getLastInstructionIndex() {
        return this.instructions.size() - 1;
    }

    @Override
    public void labelNext(Label l) {
        this.jumpOptimizations(l, LabelKind.LABEL_NEXT);
        int idx = this.getLastInstructionIndex();
        this.instructions.get(idx).addLabelNext(l);
        this.lastLabelSeen = idx + 1;
    }

    private InstructionInfo previous(int i) {
        int idx;
        int size = this.instructions.size();
        if (size >= (idx = i + 1)) {
            int realIdx = size - idx;
            if (this.indexBeforeLabel(realIdx)) {
                return noInstruction;
            }
            return this.instructions.get(realIdx);
        }
        return noInstruction;
    }

    private boolean indexBeforeLabel(int idx) {
        return this.lastLabelSeen != -1 && this.lastLabelSeen < 4 && idx < this.lastLabelSeen;
    }

    private void replace(int i, Instruction insn) {
        Instruction[] newInsns = new Instruction[]{insn};
        this.replace(i, newInsns);
    }

    private void replace(int i, Instruction[] insns) {
        int idx;
        if (insns.length == 0) {
            return;
        }
        int size = this.instructions.size();
        if (size >= (idx = i + 1)) {
            int r;
            int realIdx = size - idx;
            assert (!this.indexBeforeLabel(realIdx)) : "Attempting to replace instruction sequence that spans a label";
            InstructionInfo info = this.instructions.get(realIdx);
            info.setInstruction(insns[0]);
            List<Label> labelNexts = null;
            for (r = size - 1; r >= realIdx + 1; --r) {
                InstructionInfo temp = this.instructions.remove(r);
                if (r != size - 1) continue;
                labelNexts = temp.getLabelNexts();
            }
            int l = insns.length;
            for (r = 1; r < l; ++r) {
                this.addInstruction(insns[r]);
            }
            if (labelNexts != null) {
                for (Label l2 : labelNexts) {
                    this.labelNext(l2);
                }
            }
        } else assert (false) : "Trying to replace instructions that fall outside the peephole window";
    }

    private void delete(int i) {
        int idx;
        int size = this.instructions.size();
        if (size >= (idx = i + 1)) {
            int realIdx = size - idx;
            assert (!this.indexBeforeLabel(realIdx)) : "Attempting to delete instruction sequence that spans a label";
            ArrayList<Label> labels = null;
            for (int r = size - 1; r >= realIdx; --r) {
                List<Label> labelCurrents;
                InstructionInfo temp = this.instructions.remove(r);
                if (r == size - 1) {
                    List<Label> labelNexts = temp.getLabelNexts();
                    if (labelNexts.isEmpty()) continue;
                    if (labels == null) {
                        labels = new ArrayList<Label>();
                    }
                    labels.addAll(labelNexts);
                    continue;
                }
                if (r != realIdx || (labelCurrents = temp.getLabelCurrents()).isEmpty()) continue;
                if (labels == null) {
                    labels = new ArrayList();
                }
                labels.addAll(labelCurrents);
            }
            if (labels != null) {
                if (this.labelsFromDeletedInsns == null) {
                    this.labelsFromDeletedInsns = labels;
                } else {
                    this.labelsFromDeletedInsns.addAll(labels);
                }
            }
        } else assert (false) : "Trying to delete instructions that fall outside the peephole window";
    }

    private void op_convert_b(InstructionInfo i) {
        InstructionInfo prev = this.previous(1);
        switch (prev.getOpcode()) {
            case 38: 
            case 39: 
            case 106: 
            case 118: 
            case 150: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: {
                this.delete(0);
                break;
            }
        }
    }

    private void op_convert_d(InstructionInfo i) {
        InstructionInfo prev = this.previous(1);
        switch (prev.getOpcode()) {
            case 36: {
                this.replace(1, InstructionFactory.getInstruction(47, new Double(this.convertByteImmediateToDouble(prev.getImmediate()))));
                break;
            }
            case 45: 
            case 46: {
                this.replace(1, InstructionFactory.getInstruction(47, new Double(((Number)prev.getOperand(0)).doubleValue())));
                break;
            }
            case 40: 
            case 47: 
            case 56: 
            case 57: 
            case 117: {
                this.delete(0);
                break;
            }
        }
    }

    private void op_convert_i(InstructionInfo i) {
        InstructionInfo prev = this.previous(1);
        switch (prev.getOpcode()) {
            case 36: 
            case 37: 
            case 45: 
            case 53: 
            case 54: 
            case 55: 
            case 80: 
            case 81: 
            case 82: 
            case 115: 
            case 131: 
            case 165: 
            case 166: 
            case 168: 
            case 169: 
            case 170: 
            case 192: 
            case 193: 
            case 197: 
            case 198: 
            case 199: {
                this.delete(0);
                break;
            }
        }
    }

    private void op_convert_s(InstructionInfo i) {
        InstructionInfo prev = this.previous(1);
        switch (prev.getOpcode()) {
            case 44: 
            case 112: 
            case 133: 
            case 149: {
                this.delete(0);
                break;
            }
        }
    }

    private void op_convert_u(InstructionInfo i) {
        InstructionInfo prev = this.previous(1);
        switch (prev.getOpcode()) {
            case 46: 
            case 116: {
                this.delete(0);
                break;
            }
        }
    }

    private void op_getproperty(InstructionInfo i) {
        InstructionInfo prev = this.previous(1);
        switch (prev.getOpcode()) {
            case 93: {
                if (!i.getOperand(0).equals(prev.getOperand(0))) break;
                this.replace(1, InstructionFactory.createModifiedInstruction(96, prev.getInstruction()));
            }
        }
    }

    private void op_iffalse(InstructionInfo i) {
        InstructionInfo prev = this.previous(1);
        switch (PeepholeOptimizerMethodBodyVisitor.isTrueInstructionInfo(prev)) {
            case TRUE: {
                this.delete(1);
                return;
            }
            case FALSE: {
                this.replace(1, InstructionFactory.createModifiedInstruction(16, i.getInstruction()));
                return;
            }
            case DONT_KNOW: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        block5 : switch (prev.getOpcode()) {
            case 118: {
                this.replace(1, i.getInstruction());
                break;
            }
            case 171: {
                this.replace(1, InstructionFactory.createModifiedInstruction(20, i.getInstruction()));
                break;
            }
            case 172: {
                this.replace(1, InstructionFactory.createModifiedInstruction(26, i.getInstruction()));
                break;
            }
            case 173: {
                this.replace(1, InstructionFactory.createModifiedInstruction(12, i.getInstruction()));
                break;
            }
            case 174: {
                this.replace(1, InstructionFactory.createModifiedInstruction(13, i.getInstruction()));
                break;
            }
            case 175: {
                this.replace(1, InstructionFactory.createModifiedInstruction(14, i.getInstruction()));
                break;
            }
            case 176: {
                this.replace(1, InstructionFactory.createModifiedInstruction(15, i.getInstruction()));
                break;
            }
            case 150: {
                InstructionInfo prev2 = this.previous(2);
                switch (prev2.getOpcode()) {
                    case 172: {
                        this.replace(2, InstructionFactory.createModifiedInstruction(25, i.getInstruction()));
                        break block5;
                    }
                    case 171: {
                        this.replace(2, InstructionFactory.createModifiedInstruction(19, i.getInstruction()));
                        break block5;
                    }
                    case 173: {
                        this.replace(2, InstructionFactory.createModifiedInstruction(21, i.getInstruction()));
                        break block5;
                    }
                    case 174: {
                        this.replace(2, InstructionFactory.createModifiedInstruction(22, i.getInstruction()));
                        break block5;
                    }
                    case 175: {
                        this.replace(2, InstructionFactory.createModifiedInstruction(23, i.getInstruction()));
                        break block5;
                    }
                    case 176: {
                        this.replace(2, InstructionFactory.createModifiedInstruction(24, i.getInstruction()));
                        break block5;
                    }
                }
                this.replace(1, InstructionFactory.createModifiedInstruction(17, i.getInstruction()));
                break;
            }
        }
    }

    private void op_iftrue(InstructionInfo i) {
        InstructionInfo prev = this.previous(1);
        switch (PeepholeOptimizerMethodBodyVisitor.isTrueInstructionInfo(prev)) {
            case FALSE: {
                this.delete(1);
                return;
            }
            case TRUE: {
                this.replace(1, InstructionFactory.createModifiedInstruction(16, i.getInstruction()));
                return;
            }
            case DONT_KNOW: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        block5 : switch (prev.getOpcode()) {
            case 118: {
                this.replace(1, i.getInstruction());
                break;
            }
            case 171: {
                this.replace(1, InstructionFactory.createModifiedInstruction(19, i.getInstruction()));
                break;
            }
            case 172: {
                this.replace(1, InstructionFactory.createModifiedInstruction(25, i.getInstruction()));
                break;
            }
            case 173: {
                this.replace(1, InstructionFactory.createModifiedInstruction(21, i.getInstruction()));
                break;
            }
            case 174: {
                this.replace(1, InstructionFactory.createModifiedInstruction(22, i.getInstruction()));
                break;
            }
            case 175: {
                this.replace(1, InstructionFactory.createModifiedInstruction(23, i.getInstruction()));
                break;
            }
            case 176: {
                this.replace(1, InstructionFactory.createModifiedInstruction(24, i.getInstruction()));
                break;
            }
            case 150: {
                InstructionInfo prev2 = this.previous(2);
                switch (prev2.getOpcode()) {
                    case 172: {
                        this.replace(2, InstructionFactory.createModifiedInstruction(26, i.getInstruction()));
                        break block5;
                    }
                    case 171: {
                        this.replace(2, InstructionFactory.createModifiedInstruction(20, i.getInstruction()));
                        break block5;
                    }
                    case 173: {
                        this.replace(2, InstructionFactory.createModifiedInstruction(12, i.getInstruction()));
                        break block5;
                    }
                    case 174: {
                        this.replace(2, InstructionFactory.createModifiedInstruction(13, i.getInstruction()));
                        break block5;
                    }
                    case 175: {
                        this.replace(2, InstructionFactory.createModifiedInstruction(14, i.getInstruction()));
                        break block5;
                    }
                    case 176: {
                        this.replace(2, InstructionFactory.createModifiedInstruction(15, i.getInstruction()));
                        break block5;
                    }
                }
                this.replace(1, InstructionFactory.createModifiedInstruction(18, i.getInstruction()));
                break;
            }
        }
    }

    private static ConstantBoolean isTrueInstructionInfo(InstructionInfo i) {
        ConstantBoolean ret = ConstantBoolean.DONT_KNOW;
        switch (i.getOpcode()) {
            case 38: {
                ret = ConstantBoolean.TRUE;
                break;
            }
            case 39: {
                ret = ConstantBoolean.FALSE;
                break;
            }
            case 36: {
                int value = i.getImmediate();
                assert (value >= 0);
                ret = ECMASupport.toBoolean(value) ? ConstantBoolean.TRUE : ConstantBoolean.FALSE;
                break;
            }
            case 45: {
                int value = (Integer)i.getOperand(0);
                ret = ECMASupport.toBoolean(value) ? ConstantBoolean.TRUE : ConstantBoolean.FALSE;
                break;
            }
            case 46: {
                long value = (Long)i.getOperand(0);
                ret = ECMASupport.toBoolean(value) ? ConstantBoolean.TRUE : ConstantBoolean.FALSE;
                break;
            }
            case 44: {
                String value = i.getOperand(0).toString();
                ret = ECMASupport.toBoolean(value) ? ConstantBoolean.TRUE : ConstantBoolean.FALSE;
                break;
            }
            case 32: {
                ret = ConstantBoolean.FALSE;
            }
        }
        return ret;
    }

    private void op_pop(InstructionInfo i) {
        InstructionInfo prev = this.previous(1);
        switch (prev.getOpcode()) {
            case 70: {
                this.replace(1, InstructionFactory.createModifiedInstruction(79, prev.getInstruction()));
                break;
            }
            case 69: {
                this.replace(1, InstructionFactory.createModifiedInstruction(78, prev.getInstruction()));
                break;
            }
        }
    }

    private void op_returnvoid(InstructionInfo i) {
        InstructionInfo prev = this.previous(1);
        switch (prev.getOpcode()) {
            case 71: {
                this.delete(0);
                break;
            }
            case 41: {
                this.replace(1, i.getInstruction());
                break;
            }
            case 48: {
                if (this.previous(2).getOpcode() != 208) break;
                this.replace(2, i.getInstruction());
                break;
            }
        }
    }

    private void OP_getlocal(InstructionInfo i) {
        InstructionInfo prev = this.previous(1);
        InstructionInfo cur = this.previous(0);
        switch (prev.getOpcode()) {
            case 99: {
                if (cur.getInstruction().getImmediate() != prev.getInstruction().getImmediate()) break;
                Instruction[] newInsns = new Instruction[]{InstructionFactory.getInstruction(42), prev.getInstruction()};
                this.replace(1, newInsns);
                break;
            }
        }
    }

    double convertByteImmediateToDouble(int i) {
        byte b = (byte)i;
        return b;
    }

    private void addInstruction(Instruction insn) {
        int size = this.instructions.size();
        InstructionInfo info = null;
        if (size == 4) {
            info = this.instructions.remove(0);
            this.finishInstruction(info);
            if (this.lastLabelSeen != -1) {
                --this.lastLabelSeen;
            }
        } else {
            info = new InstructionInfo();
        }
        info.reset(insn);
        this.instructions.add(info);
        if (this.labelsFromDeletedInsns != null) {
            for (Label l : this.labelsFromDeletedInsns) {
                this.labelCurrent(l);
            }
            this.labelsFromDeletedInsns = null;
        }
    }

    private void finishInstruction(InstructionInfo info) {
        this.finisher.visitInstruction(info.getInstruction());
        for (Label l : info.getLabelCurrents()) {
            this.finisher.labelCurrent(l);
        }
        for (Label l : info.getLabelNexts()) {
            this.finisher.labelNext(l);
        }
    }

    static class InstructionListFinisher
    implements InstructionFinisher {
        private InstructionList list;

        public InstructionListFinisher(InstructionList list) {
            this.list = list;
        }

        @Override
        public void visitInstruction(Instruction i) {
            this.list.addInstruction(i);
        }

        @Override
        public void labelNext(Label l) {
            this.list.labelNext(l);
        }

        @Override
        public void labelCurrent(Label l) {
            this.list.labelCurrent(l);
        }
    }

    class DelegateFinisher
    implements InstructionFinisher {
        DelegateFinisher() {
        }

        @Override
        public void visitInstruction(Instruction i) {
            PeepholeOptimizerMethodBodyVisitor.super.visitInstruction(i);
        }

        @Override
        public void labelNext(Label l) {
            PeepholeOptimizerMethodBodyVisitor.super.labelNext(l);
        }

        @Override
        public void labelCurrent(Label l) {
            PeepholeOptimizerMethodBodyVisitor.super.labelCurrent(l);
        }
    }

    static interface InstructionFinisher {
        public void visitInstruction(Instruction var1);

        public void labelNext(Label var1);

        public void labelCurrent(Label var1);
    }

    private static class InstructionInfo {
        private Instruction insn;
        private List<Label> labelNexts = new ArrayList<Label>();
        private List<Label> labelCurrents = new ArrayList<Label>();

        InstructionInfo() {
        }

        void reset(Instruction i) {
            this.insn = i;
            this.labelNexts.clear();
            this.labelCurrents.clear();
        }

        void setInstruction(Instruction i) {
            this.insn = i;
        }

        public Instruction getInstruction() {
            return this.insn;
        }

        public void addLabelCurrent(Label l) {
            this.labelCurrents.add(l);
        }

        public void addLabelNext(Label l) {
            this.labelNexts.add(l);
        }

        public List<Label> getLabelCurrents() {
            return this.labelCurrents;
        }

        public List<Label> getLabelNexts() {
            return this.labelNexts;
        }

        public int getOpcode() {
            return this.insn != null ? this.insn.getOpcode() : -1;
        }

        public int getImmediate() {
            return this.insn != null ? this.insn.getImmediate() : -1;
        }

        public Object getOperand(int i) {
            return this.insn != null ? this.insn.getOperand(i) : null;
        }
    }

    private static enum ConstantBoolean {
        TRUE,
        FALSE,
        DONT_KNOW;

    }

    private static enum LabelKind {
        LABEL_CURRENT,
        LABEL_NEXT;

    }
}

