/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.abc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class Pool<T> {
    final Map<T, Integer> refs = new HashMap<T, Integer>();
    final ArrayList<T> values = new ArrayList();
    final boolean hasDefaultZero;

    public Pool(DefaultType default_type) {
        this.hasDefaultZero = default_type == DefaultType.HasDefaultZero;
    }

    public int add(T e) {
        int result;
        if (null == e) {
            if (this.hasDefaultZero) {
                return 0;
            }
            throw new NullPointerException();
        }
        Integer cached_value = this.refs.get(e);
        if (cached_value != null) {
            result = cached_value;
        } else {
            this.values.add(e);
            result = this.size();
            this.refs.put(e, result);
        }
        return result;
    }

    public ArrayList<T> getValues() {
        return this.values;
    }

    public int id(T e) {
        if (null == e && this.hasDefaultZero) {
            return 0;
        }
        Integer result = this.refs.get(e);
        if (result == null) {
            throw new IllegalArgumentException("Unknown pool item \"" + e.toString() + "\"");
        }
        return result;
    }

    public int size() {
        return (this.hasDefaultZero ? 1 : 0) + this.refs.size();
    }

    public int getNominalSize() {
        int poolSize = this.size();
        if (this.hasDefaultZero && poolSize == 1) {
            assert (this.refs.size() == 0) : "pool collection for pool with default zero entry should be empty when computed pool size is 1";
            return 0;
        }
        assert (!this.hasDefaultZero && poolSize == this.refs.size() || this.hasDefaultZero && poolSize == this.refs.size() + 1) : "size of pool collection does not match computed size of pool";
        return poolSize;
    }

    public String toString() {
        return String.valueOf(this.refs);
    }

    public static enum DefaultType {
        HasDefaultZero,
        NoDefaultZero;

    }
}

