/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.EncodedValue;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.ValueType;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.EncodedValueUtils;
import org.jf.dexlib.Util.Input;

public class MethodEncodedValue
extends EncodedValue {
    public final MethodIdItem value;

    protected MethodEncodedValue(DexFile dexFile, Input in, byte valueArg) {
        int index = (int)EncodedValueUtils.decodeUnsignedIntegralValue(in.readBytes(valueArg + 1));
        this.value = dexFile.MethodIdsSection.getItemByIndex(index);
    }

    public MethodEncodedValue(MethodIdItem value) {
        this.value = value;
    }

    public void writeValue(AnnotatedOutput out) {
        byte[] bytes = EncodedValueUtils.encodeUnsignedIntegralValue(this.value.getIndex());
        if (out.annotates()) {
            out.annotate(1, "value_type=" + ValueType.VALUE_METHOD.name() + ",value_arg=" + (bytes.length - 1));
            out.annotate(bytes.length, "value: " + this.value.getMethodString());
        }
        out.writeByte(ValueType.VALUE_METHOD.value | bytes.length - 1 << 5);
        out.write(bytes);
    }

    public int placeValue(int offset) {
        return offset + EncodedValueUtils.getRequiredBytesForUnsignedIntegralValue(this.value.getIndex()) + 1;
    }

    protected int compareValue(EncodedValue o) {
        MethodEncodedValue other = (MethodEncodedValue)o;
        return this.value.getIndex() - other.value.getIndex();
    }

    public ValueType getValueType() {
        return ValueType.VALUE_METHOD;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

