/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.EncodedValue;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.ValueType;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;
import org.jf.dexlib.Util.Leb128Utils;

public class ArrayEncodedSubValue
extends EncodedValue {
    private int hashCode = 0;
    public final EncodedValue[] values;

    public ArrayEncodedSubValue(DexFile dexFile, Input in) {
        this.values = new EncodedValue[in.readUnsignedLeb128()];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = EncodedValue.readEncodedValue(dexFile, in);
        }
    }

    public ArrayEncodedSubValue(EncodedValue[] values) {
        this.values = values;
    }

    public void writeValue(AnnotatedOutput out) {
        if (out.annotates()) {
            out.annotate("array_size: 0x" + Integer.toHexString(this.values.length) + " (" + this.values.length + ")");
            out.writeUnsignedLeb128(this.values.length);
            int index = 0;
            for (EncodedValue encodedValue : this.values) {
                out.annotate(0, "[" + index++ + "] array_element");
                out.indent();
                encodedValue.writeValue(out);
                out.deindent();
            }
        } else {
            out.writeUnsignedLeb128(this.values.length);
            for (EncodedValue encodedValue : this.values) {
                encodedValue.writeValue(out);
            }
        }
    }

    public int placeValue(int offset) {
        offset += Leb128Utils.unsignedLeb128Size(this.values.length);
        for (EncodedValue encodedValue : this.values) {
            offset = encodedValue.placeValue(offset);
        }
        return offset;
    }

    protected int compareValue(EncodedValue o) {
        ArrayEncodedSubValue other = (ArrayEncodedSubValue)o;
        int comp = this.values.length - other.values.length;
        if (comp != 0) {
            return comp;
        }
        for (int i = 0; i < this.values.length; ++i) {
            comp = this.values[i].compareTo(other.values[i]);
            if (comp == 0) continue;
            return comp;
        }
        return comp;
    }

    public ValueType getValueType() {
        return ValueType.VALUE_ARRAY;
    }

    private void calcHashCode() {
        this.hashCode = 0;
        for (EncodedValue encodedValue : this.values) {
            this.hashCode = 31 * this.hashCode + encodedValue.hashCode();
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.calcHashCode();
        }
        return this.hashCode;
    }
}

