/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.fonts;

import com.adobe.flash.fonts.ADFAlgnZones;
import com.adobe.flash.fonts.ADFTypeSystem;
import com.adobe.flash.fonts.FlexADFData;
import com.adobe.flash.fonts.ZoneRecordBuilder;
import com.adobe.flash.swf.types.CurvedEdgeRecord;
import com.adobe.flash.swf.types.GlyphEntry;
import com.adobe.flash.swf.types.ShapeRecord;
import com.adobe.flash.swf.types.StraightEdgeRecord;
import com.adobe.flash.swf.types.StyleChangeRecord;
import com.adobe.flash.swf.types.ZoneData;
import com.adobe.flash.swf.types.ZoneRecord;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class FlashTypeZoneRecordBuilder
extends ZoneRecordBuilder {
    private static final String ZONE_STATE = "ZONESTATE";

    @Override
    public ZoneRecord build(int character) {
        ADFAlgnZones.AlgnZoneState state = (ADFAlgnZones.AlgnZoneState)this.fontFace.getProperty(ZONE_STATE);
        if (state == null) {
            state = this.initializeAlignZoneState(this.fontFace.getFamily());
            this.fontFace.setProperty(ZONE_STATE, state);
        }
        return this.createZoneRecord(state, (char)character);
    }

    public ZoneRecord createZoneRecord(ADFAlgnZones.AlgnZoneState state, char character) {
        ZoneRecord zoneRecord = new ZoneRecord();
        if (character == ' ') {
            ZoneData zoneData0 = new ZoneData();
            zoneData0.setData(0L);
            ZoneData zoneData1 = new ZoneData();
            zoneData1.setData(0L);
            zoneRecord.setZoneData0(zoneData0);
            zoneRecord.setZoneData1(zoneData1);
            zoneRecord.setZoneMaskX(false);
            zoneRecord.setZoneMaskY(false);
        } else {
            FlexADFData data = new FlexADFData();
            ADFTypeSystem.ADFPath pOnePath = this.getFontOutline(null, data, character);
            try {
                ADFAlgnZones.ADFDetectAlgnZones(null, state, pOnePath);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create ZoneTable for character " + character + " in font " + this.fontAlias);
            }
            ZoneData zoneData0 = new ZoneData();
            ZoneData zoneData1 = new ZoneData();
            if (pOnePath.algnZones == null) {
                zoneData0.setData(0L);
                zoneData1.setData(0L);
                zoneRecord.setZoneMaskX(false);
                zoneRecord.setZoneMaskY(false);
            } else {
                assert (pOnePath.algnZones.length == 2);
                zoneData0.setData(pOnePath.algnZones[0]);
                zoneData1.setData(pOnePath.algnZones[1]);
                if (pOnePath.algnZonesMask >= 1) {
                    zoneRecord.setZoneMaskX(true);
                    zoneRecord.setZoneMaskY(true);
                } else {
                    zoneRecord.setZoneMaskX(false);
                    zoneRecord.setZoneMaskY(false);
                }
            }
            zoneRecord.setZoneData0(zoneData0);
            zoneRecord.setZoneData1(zoneData1);
        }
        return zoneRecord;
    }

    public ADFTypeSystem.ADFPath getFontOutline(Object libInst, Object fontID, char charCode) {
        FlexADFData data = (FlexADFData)fontID;
        GlyphEntry ge = this.fontBuilder.getGlyph(charCode);
        if (ge == null) {
            ge = this.fontFace.getGlyphEntry(charCode);
        }
        assert (ge != null) : "Glyph entry " + charCode + " not found as expected in map.";
        data.mPath.fontUnitsPerEM = 20480.0f;
        data.mPath.charCode = charCode;
        float xMin = 10000.0f;
        float yMin = 10000.0f;
        float xMax = -10000.0f;
        float yMax = -10000.0f;
        int numCountours = 0;
        int numPenCmds = 0;
        int x = 0;
        int y = 0;
        boolean previousMove = false;
        int prevX = 0;
        int prevY = 0;
        data.mPath.penCmds = new ArrayList(ge.shape.getShapeRecords().size() * 2);
        for (ShapeRecord r : ge.shape.getShapeRecords()) {
            if (r == null) continue;
            if (r instanceof StyleChangeRecord) {
                ADFTypeSystem.ADFPenCmd penCmd;
                StyleChangeRecord scr = (StyleChangeRecord)r;
                if (previousMove && x != prevX && y != prevY) {
                    penCmd = new ADFTypeSystem.ADFPenCmd();
                    penCmd.opCode = 1L;
                    penCmd.x = prevX;
                    penCmd.y = prevY * -1;
                    data.mPath.penCmds.add(penCmd);
                    ++numPenCmds;
                }
                x = scr.getMoveDeltaX();
                y = scr.getMoveDeltaY();
                previousMove = true;
                prevX = x;
                prevY = y;
                penCmd = new ADFTypeSystem.ADFPenCmd();
                penCmd.opCode = 0L;
                penCmd.x = x;
                penCmd.y = y * -1;
                data.mPath.penCmds.add(penCmd);
                ++numCountours;
                ++numPenCmds;
            } else if (r instanceof StraightEdgeRecord) {
                StraightEdgeRecord ser = (StraightEdgeRecord)r;
                ADFTypeSystem.ADFPenCmd penCmd = new ADFTypeSystem.ADFPenCmd();
                penCmd.opCode = 1L;
                penCmd.x = x += ser.getDeltaX();
                penCmd.y = (y += ser.getDeltaY()) * -1;
                data.mPath.penCmds.add(penCmd);
                ++numPenCmds;
            } else if (r instanceof CurvedEdgeRecord) {
                CurvedEdgeRecord cer = (CurvedEdgeRecord)r;
                int cx = x + cer.getControlDeltaX();
                int cy = y + cer.getControlDeltaY();
                x = cx + cer.getAnchorDeltaX();
                y = cy + cer.getAnchorDeltaY();
                ADFTypeSystem.ADFPenCmd penCmd = new ADFTypeSystem.ADFPenCmd();
                penCmd.opCode = 2L;
                penCmd.x = x;
                penCmd.y = y * -1;
                penCmd.cx = cx;
                penCmd.cy = cy * -1;
                data.mPath.penCmds.add(penCmd);
                ++numPenCmds;
                if ((float)cx < xMin) {
                    xMin = cx;
                }
                if ((float)cx > xMax) {
                    xMax = cx;
                }
                if ((float)cy < yMin) {
                    yMin = cy;
                }
                if ((float)cy > yMax) {
                    yMax = cy;
                }
            } else assert (false) : "Unknown ShapeRecord: " + r.getClass();
            if ((float)x < xMin) {
                xMin = x;
            }
            if ((float)x > xMax) {
                xMax = x;
            }
            if ((float)y < yMin) {
                yMin = y;
            }
            if (!((float)y > yMax)) continue;
            yMax = y;
        }
        if (previousMove && x != prevX && y != prevY) {
            ADFTypeSystem.ADFPenCmd penCmd = new ADFTypeSystem.ADFPenCmd();
            penCmd.opCode = 1L;
            penCmd.x = prevX;
            penCmd.y = prevY * -1;
            data.mPath.penCmds.add(penCmd);
            ++numPenCmds;
        }
        data.mPath.glyphMinX = xMin;
        data.mPath.glyphMinY = yMax * -1.0f;
        data.mPath.glyphMaxX = xMax;
        data.mPath.glyphMaxY = yMin * -1.0f;
        data.mPath.numContours = numCountours;
        data.mPath.numPenCmds = numPenCmds;
        return data.mPath;
    }

    private ADFAlgnZones.AlgnZoneState initializeAlignZoneState(String fontName) {
        ADFAlgnZones.AlgnZoneState mpZoneInst;
        Method method = null;
        Method[] methodArr = this.getClass().getMethods();
        for (int i = 0; i < methodArr.length; ++i) {
            if (!methodArr[i].getName().equals("getFontOutline")) continue;
            method = methodArr[i];
            break;
        }
        try {
            mpZoneInst = (ADFAlgnZones.AlgnZoneState)ADFAlgnZones.ADFInitAlgnZoneDetection(null, new FlexADFData(), null, method, this);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize FlashType for font " + fontName);
        }
        return mpZoneInst;
    }
}

