/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting.infontformatting;

import com.adobe.agl.lang.UCharacter;
import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.CharUtil;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTSelector;
import com.adobe.fontengine.font.opentype.OTSelectors;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.opentype.Tag;
import com.adobe.fontengine.font.type1.Type1Font;
import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.DigitCase;
import com.adobe.fontengine.inlineformatting.DigitWidth;
import com.adobe.fontengine.inlineformatting.ElementAttribute;
import com.adobe.fontengine.inlineformatting.FontStyle;
import com.adobe.fontengine.inlineformatting.InterElementAttribute;
import com.adobe.fontengine.inlineformatting.LigatureLevel;
import com.adobe.fontengine.inlineformatting.TypographicCase;
import com.adobe.fontengine.inlineformatting.infontformatting.BaseFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.InFontFormatter;
import com.adobe.fontengine.inlineformatting.infontformatting.LookupsCache;

class GenericFormatter
extends BaseFormatter {
    private static final int[] gsubFeatures = new int[]{Tag.feature_ccmp, Tag.feature_locl, Tag.feature_rtla, Tag.feature_rlig, Tag.feature_liga, Tag.feature_clig, Tag.feature_ital, Tag.feature_titl, Tag.feature_case, Tag.feature_lnum, Tag.feature_onum, Tag.feature_c2sc, Tag.feature_smcp, Tag.feature_c2pc, Tag.feature_pcap, Tag.feature_unic, Tag.feature_dlig, Tag.feature_hlig, Tag.feature_pnum, Tag.feature_tnum};
    private static final int[] gposFeatures = new int[]{Tag.feature_kern, Tag.feature_mark, Tag.feature_mkmk, Tag.feature_cpsp};
    private static final OTSelector italSelector = new OTSelector(){

        public boolean isApplied(AttributedRun attributedRun, int n) {
            Object object = attributedRun.getElementStyle(n, ElementAttribute.fontStyle);
            return object == FontStyle.ITALIC || object == FontStyle.OBLIQUE;
        }
    };
    private static final OTSelector titlSelector = new OTSelector(){

        public boolean isApplied(AttributedRun attributedRun, int n) {
            Object object = attributedRun.getElementStyle(n, ElementAttribute.typographicCase);
            return object == TypographicCase.TITLE;
        }
    };
    private static final OTSelector caseSelector = new OTSelector(){

        public boolean isApplied(AttributedRun attributedRun, int n) {
            Object object = attributedRun.getElementStyle(n, ElementAttribute.typographicCase);
            return object == TypographicCase.TITLE || object == TypographicCase.CAPS;
        }
    };
    private static final OTSelector c2scSelector = new OTSelector(){

        public boolean isApplied(AttributedRun attributedRun, int n) {
            Object object = attributedRun.getElementStyle(n, ElementAttribute.typographicCase);
            return object == TypographicCase.SMALLCAPS;
        }
    };
    private static final OTSelector smcpSelector = new OTSelector(){

        public boolean isApplied(AttributedRun attributedRun, int n) {
            Object object = attributedRun.getElementStyle(n, ElementAttribute.typographicCase);
            return object == TypographicCase.SMALLCAPS || object == TypographicCase.CAPS_AND_SMALLCAPS;
        }
    };
    private static final OTSelector c2pcSelector = new OTSelector(){

        public boolean isApplied(AttributedRun attributedRun, int n) {
            Object object = attributedRun.getElementStyle(n, ElementAttribute.typographicCase);
            return object == TypographicCase.PETITECAPS;
        }
    };
    private static final OTSelector pcapSelector = new OTSelector(){

        public boolean isApplied(AttributedRun attributedRun, int n) {
            Object object = attributedRun.getElementStyle(n, ElementAttribute.typographicCase);
            return object == TypographicCase.PETITECAPS;
        }
    };
    private static final OTSelector unicSelector = new OTSelector(){

        public boolean isApplied(AttributedRun attributedRun, int n) {
            Object object = attributedRun.getElementStyle(n, ElementAttribute.typographicCase);
            return object == TypographicCase.UNICASE;
        }
    };
    private static final OTSelector cpspSelector = new OTSelector(){

        public boolean isApplied(AttributedRun attributedRun, int n) {
            Object object = attributedRun.getElementStyle(n, ElementAttribute.typographicCase);
            return object == TypographicCase.TITLE || object == TypographicCase.CAPS;
        }
    };
    private static final OTSelector lnumSelector = new OTSelector(){

        public boolean isApplied(AttributedRun attributedRun, int n) {
            Object object = attributedRun.getElementStyle(n, ElementAttribute.digitCase);
            if (object == DigitCase.FROM_TYPOGRAPHIC_CASE) {
                object = attributedRun.getElementStyle(n, ElementAttribute.typographicCase);
                return object == TypographicCase.TITLE || object == TypographicCase.CAPS;
            }
            return object == DigitCase.LINING;
        }
    };
    private static final OTSelector onumSelector = new OTSelector(){

        public boolean isApplied(AttributedRun attributedRun, int n) {
            Object object = attributedRun.getElementStyle(n, ElementAttribute.digitCase);
            if (object == DigitCase.FROM_TYPOGRAPHIC_CASE) {
                object = attributedRun.getElementStyle(n, ElementAttribute.typographicCase);
                return object == TypographicCase.TEXT || object == TypographicCase.CAPS_AND_SMALLCAPS || object == TypographicCase.SMALLCAPS || object == TypographicCase.PETITECAPS || object == TypographicCase.UNICASE;
            }
            return object == DigitCase.OLD_STYLE;
        }
    };
    private static final OTSelector tnumSelector = new OTSelector(){

        public boolean isApplied(AttributedRun attributedRun, int n) {
            Object object = attributedRun.getElementStyle(n, ElementAttribute.digitWidth);
            return object == DigitWidth.TABULAR;
        }
    };
    private static final OTSelector pnumSelector = new OTSelector(){

        public boolean isApplied(AttributedRun attributedRun, int n) {
            Object object = attributedRun.getElementStyle(n, ElementAttribute.digitWidth);
            return object == DigitWidth.PROPORTIONAL;
        }
    };

    GenericFormatter() {
    }

    protected int setGlyphs(AttributedRun attributedRun, int n, int n2, FontData fontData) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        while (n < n2) {
            int n3;
            int n4;
            int n5;
            if (attributedRun.getElementStyle(n, ElementAttribute.isGlyph) == Boolean.TRUE) {
                ++n;
                continue;
            }
            int n6 = attributedRun.elementAt(n);
            if (n6 == 8205) {
                attributedRun.remove(n);
                --n2;
                attributedRun.setInterElementStyleBefore(n, InterElementAttribute.ligatureLevel, LigatureLevel.EXOTIC);
                continue;
            }
            if (n6 == 8204) {
                attributedRun.remove(n);
                --n2;
                attributedRun.setInterElementStyleBefore(n, InterElementAttribute.ligatureLevel, LigatureLevel.NONE);
                continue;
            }
            if (CharUtil.isControl(n6) && !fontData.isSymbolic()) {
                attributedRun.remove(n);
                --n2;
                continue;
            }
            if ((Integer)attributedRun.getElementStyle(n, ElementAttribute.bidiLevel) % 2 == 1) {
                n6 = UCharacter.getMirror((int)n6);
            }
            if (!CharUtil.isBase(n6) || n + 1 == n2 || attributedRun.getElementStyle(n + 1, ElementAttribute.isGlyph) == Boolean.TRUE || !CharUtil.isCombining(attributedRun.elementAt(n + 1))) {
                n5 = fontData.getGlyphForChar(n6);
                attributedRun.replace(n, n5);
                attributedRun.setElementStyle(n, ElementAttribute.isGlyph, Boolean.TRUE);
                ++n;
                continue;
            }
            for (n5 = n + 1; n5 < n2 && attributedRun.getElementStyle(n5, ElementAttribute.isGlyph) != Boolean.TRUE && CharUtil.isCombining(attributedRun.elementAt(n5)); ++n5) {
            }
            boolean bl = false;
            int[] nArray = new int[n5 - n];
            int[] nArray2 = new int[n5 - n];
            for (n4 = n; n4 < n5; ++n4) {
                nArray[n4 - n] = attributedRun.elementAt(n4);
                n3 = fontData.getGlyphForChar(nArray[n4 - n]);
                if (n3 == 0) {
                    bl = true;
                }
                nArray2[n4 - n] = n3;
            }
            if (bl && (n4 = CharUtil.compose(nArray, 0, n5 - n)) != -1 && (n3 = fontData.getGlyphForChar(n4)) != 0) {
                attributedRun.replace(n, n5, n3);
                attributedRun.setElementStyle(n, ElementAttribute.isGlyph, Boolean.TRUE);
                n2 -= n5 - n - 1;
                ++n;
                continue;
            }
            for (n4 = n; n4 < n5; ++n4) {
                attributedRun.replace(n4, nArray2[n4 - n]);
                attributedRun.setElementStyle(n, ElementAttribute.isGlyph, Boolean.TRUE);
            }
            n = n5;
        }
        return n2;
    }

    protected boolean canFormatOT() {
        return true;
    }

    protected int formatOT(OpenTypeFont openTypeFont, AttributedRun attributedRun, int n, int n2, boolean bl) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        int[][] nArray;
        Integer n3 = (Integer)attributedRun.getElementStyle(n, ElementAttribute.bidiLevel);
        int n4 = GenericFormatter.getOTScriptTag((Integer)attributedRun.getElementStyle(n, InFontFormatter.scriptAttribute));
        int n5 = GenericFormatter.getOTLanguageTag((ULocale)attributedRun.getElementStyle(n, ElementAttribute.locale));
        n2 = this.setGlyphs(attributedRun, n, n2, openTypeFont);
        if (openTypeFont.gsub != null) {
            nArray = LookupsCache.resolveFeatureTag(openTypeFont.gsub, n4, n5, gsubFeatures);
            n2 = openTypeFont.gsub.applyLookups(nArray[0], attributedRun, n, n2, OTSelectors.everywhere, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[1], attributedRun, n, n2, OTSelectors.everywhere, openTypeFont.gdef);
            if (n3 % 2 == 1) {
                n2 = openTypeFont.gsub.applyLookups(nArray[2], attributedRun, n, n2, OTSelectors.everywhere, openTypeFont.gdef);
            }
            n2 = openTypeFont.gsub.applyLookups(nArray[6], attributedRun, n, n2, italSelector, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[7], attributedRun, n, n2, titlSelector, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[8], attributedRun, n, n2, caseSelector, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[9], attributedRun, n, n2, lnumSelector, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[10], attributedRun, n, n2, onumSelector, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[18], attributedRun, n, n2, pnumSelector, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[19], attributedRun, n, n2, tnumSelector, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[11], attributedRun, n, n2, c2scSelector, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[12], attributedRun, n, n2, smcpSelector, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[13], attributedRun, n, n2, c2pcSelector, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[14], attributedRun, n, n2, pcapSelector, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[15], attributedRun, n, n2, unicSelector, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[3], attributedRun, n, n2, OTSelectors.minimumLigatures, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[4], attributedRun, n, n2, OTSelectors.commonLigatures, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[5], attributedRun, n, n2, OTSelectors.commonLigatures, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[16], attributedRun, n, n2, OTSelectors.uncommonLigatures, openTypeFont.gdef);
            n2 = openTypeFont.gsub.applyLookups(nArray[17], attributedRun, n, n2, OTSelectors.exoticLigatures, openTypeFont.gdef);
        }
        this.posFromAdvanceWidth(attributedRun, openTypeFont, n, n2);
        if (openTypeFont.gpos != null) {
            nArray = LookupsCache.resolveFeatureTag(openTypeFont.gpos, n4, n5, gposFeatures);
            if (bl) {
                if (nArray[0].length != 0) {
                    n2 = openTypeFont.gpos.applyLookups(nArray[0], attributedRun, n, n2, OTSelectors.everywhere, openTypeFont.gdef);
                } else {
                    this.applyKernTable(openTypeFont, attributedRun, n, n2);
                }
            }
            n2 = openTypeFont.gpos.applyLookups(nArray[3], attributedRun, n, n2, cpspSelector, openTypeFont.gdef);
            n2 = openTypeFont.gpos.applyLookups(nArray[1], attributedRun, n, n2, OTSelectors.everywhere, openTypeFont.gdef);
            n2 = openTypeFont.gpos.applyLookups(nArray[2], attributedRun, n, n2, OTSelectors.everywhere, openTypeFont.gdef);
        } else if (bl) {
            this.applyKernTable(openTypeFont, attributedRun, n, n2);
        }
        return n2;
    }

    protected boolean canFormatTT() {
        return true;
    }

    protected int formatTT(OpenTypeFont openTypeFont, AttributedRun attributedRun, int n, int n2, boolean bl) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        n2 = this.setGlyphs(attributedRun, n, n2, openTypeFont);
        this.posFromAdvanceWidth(attributedRun, openTypeFont, n, n2);
        if (bl) {
            this.applyKernTable(openTypeFont, attributedRun, n, n2);
        }
        return n2;
    }

    protected boolean canFormatT1() {
        return true;
    }

    protected int formatT1(Type1Font type1Font, AttributedRun attributedRun, int n, int n2, boolean bl) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        n2 = this.setGlyphs(attributedRun, n, n2, type1Font);
        this.posFromAdvanceWidth(attributedRun, type1Font, n, n2);
        if (bl) {
            for (int i = n; i < n2 - 1; ++i) {
                double d = type1Font.getKernValue(attributedRun.elementAt(i), attributedRun.elementAt(i + 1));
                attributedRun.adjustPlacementAndAdvance(i, 0.0, 0.0, d, 0.0);
            }
        }
        return n2;
    }

    protected boolean canFormatGeneric() {
        return true;
    }

    protected int formatGeneric(FontData fontData, AttributedRun attributedRun, int n, int n2, boolean bl) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        n2 = this.setGlyphs(attributedRun, n, n2, fontData);
        this.posFromAdvanceWidth(attributedRun, fontData, n, n2);
        return n2;
    }
}

