/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement;

import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.type1.MetricFile;
import com.adobe.fontengine.font.type1.Type1Font;
import com.adobe.fontengine.fontmanagement.FontLoader;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.SoftReference;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class URLFont
extends FontImpl {
    static final long serialVersionUID = 1L;
    protected final URL outlineFileURL;
    protected URL metricFileURL;
    protected final int index;
    protected String canonicalPath;
    protected long length;
    protected long lastModified;
    protected ConcurrentHashMap<String, Object> descCache = new ConcurrentHashMap(16, 0.75f, 1);
    protected transient SoftReference fontRef;

    URLFont(URL uRL, int n) {
        this.outlineFileURL = uRL;
        this.index = n;
        this.fontRef = new SoftReference<Object>(null);
        this.initCacheTags();
    }

    URLFont(URL uRL, int n, FontData fontData) throws UnsupportedFontException {
        this.outlineFileURL = uRL;
        this.index = n;
        this.fontRef = new SoftReference<FontData>(fontData);
        this.initCacheTags();
    }

    void setMetricURL(URL uRL, MetricFile metricFile) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        FontData fontData = this.retrieveFontData();
        if (!(fontData instanceof Type1Font)) {
            return;
        }
        if (((Type1Font)fontData).setMetricFile(metricFile)) {
            this.metricFileURL = uRL;
        }
    }

    @Override
    protected synchronized FontData retrieveFontData() throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        FontData fontData = null;
        fontData = (FontData)this.fontRef.get();
        if (fontData == null) {
            FontData[] fontDataArray;
            try {
                fontDataArray = FontLoader.fromURL(this.outlineFileURL, this.metricFileURL);
            }
            catch (IOException iOException) {
                throw new FontLoadingException(iOException);
            }
            fontData = fontDataArray[this.index];
            this.fontRef = new SoftReference<FontData>(fontData);
        }
        return fontData;
    }

    @Override
    public int hashCode() {
        int n = this.index;
        n ^= this.outlineFileURL.hashCode();
        if (this.metricFileURL != null) {
            n ^= this.metricFileURL.hashCode();
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null) {
            if (this == object) {
                return true;
            }
            if (object instanceof URLFont) {
                URLFont uRLFont = (URLFont)object;
                if (this.index == uRLFont.index) {
                    try {
                        if (!this.outlineFileURL.toURI().equals(uRLFont.outlineFileURL.toURI())) {
                            return false;
                        }
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        return false;
                    }
                    if (this.metricFileURL == null && uRLFont.metricFileURL == null) {
                        return true;
                    }
                    try {
                        if (this.metricFileURL == null || uRLFont.metricFileURL == null || !this.metricFileURL.toURI().equals(uRLFont.metricFileURL.toURI())) {
                            return false;
                        }
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return this.outlineFileURL.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.fontRef = new SoftReference<Object>(null);
    }

    private void initCacheTags() {
        try {
            try {
                this.canonicalPath = this.outlineFileURL.toURI().getPath();
                if (this.canonicalPath == null) {
                    throw new IOException("Cannot resolve path to file");
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IOException(uRISyntaxException.toString());
            }
            File file = new File(this.canonicalPath);
            this.canonicalPath = file.getCanonicalPath();
            this.length = file.length();
            this.lastModified = file.lastModified();
        }
        catch (IOException iOException) {
            this.canonicalPath = null;
            this.length = 0L;
            this.lastModified = 0L;
        }
    }

    @Override
    public String getCanonicalPath() {
        return this.canonicalPath;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public Object getCachedFontDescription(String string) {
        return this.descCache.get(string);
    }

    @Override
    public Map<String, Object> getCachedFontDescriptionMap() {
        return this.descCache;
    }

    @Override
    public void setCachedFontDescription(String string, Object object) {
        this.descCache.put(string, object);
    }
}

