/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.type1;

import com.adobe.fontengine.font.FontInputStream;
import java.io.IOException;

final class PFBInputStream
extends FontInputStream {
    private int bytesLeftInSegment;

    PFBInputStream(FontInputStream fontInputStream) {
        super(fontInputStream);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            if (this.bytesLeftInSegment > 0) {
                if (this.bytesLeftInSegment < n2) {
                    n2 = this.bytesLeftInSegment;
                }
                if ((n3 = super.read(byArray, n, n2)) == -1) {
                    throw new IOException("unexpected EOF");
                }
                this.bytesLeftInSegment -= n3;
                return n3;
            }
            int n4 = super.read();
            int n5 = super.read();
            if (n4 != 128 || n5 != 1 && n5 != 2 && n5 != 3) {
                throw new IOException("invalid segment");
            }
            if (n5 == 3) {
                if (n3 > 0) {
                    return n3;
                }
                return -1;
            }
            n5 = super.read();
            if (n5 == -1) {
                throw new IOException("unexpected bytes read");
            }
            this.bytesLeftInSegment = n5 & 0xFF;
            n5 = super.read();
            if (n5 == -1) {
                throw new IOException("unexpected bytes read");
            }
            this.bytesLeftInSegment |= (n5 & 0xFF) << 8;
            n5 = super.read();
            if (n5 == -1) {
                throw new IOException("unexpected bytes read");
            }
            this.bytesLeftInSegment |= (n5 & 0xFF) << 16;
            n5 = super.read();
            if (n5 == -1) {
                throw new IOException("unexpected bytes read");
            }
            this.bytesLeftInSegment |= (n5 & 0xFF) << 24;
        }
        return n3;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        if (this.read(byArray, 0, 1) != 1) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    public void unread(int n) throws IOException {
        super.unread(n);
        ++this.bytesLeftInSegment;
    }

    public void unread(byte[] byArray, int n, int n2) throws IOException {
        if (n != 0) {
            throw new IOException("unsupported unread offset");
        }
        super.unread(byArray, n, n2);
        this.bytesLeftInSegment += n2;
    }
}

