/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.AutoColor;
import com.adobe.fontengine.font.cff.NonOverlappingOutlineConsumer;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ZoneHint {
    static final int kBotZoneBaseline = 0;
    static final int kBotZoneBaseline5 = 1;
    static final int kBotZoneBaseline6 = 2;
    static final int kBotZoneDescender = 3;
    static final int kBotZoneColon = 4;
    static final int kTopZoneCapHeight = 5;
    static final int kTopZoneAscender = 6;
    static final int kTopZonexHeight = 7;
    static final int kTopZoneijHeight = 8;
    static final int kTopZoneHeight5 = 9;
    static final int kTopZoneHeight6 = 10;
    static final int kTopZoneColon = 11;
    static final int kZoneNone = 12;
    static final int kBotZoneFirst = 0;
    static final int kTopZoneFirst = 5;
    static final int kBotZoneLast = 4;
    static final int kTopZoneLast = 11;
    static final int kBotZoneCount = 5;
    static final int kTopZoneCount = 7;
    static final double kMaxZoneHeight = 36.0;
    static final int kBlueFuzz = 0;
    static final int kStrayCountDenom = 3;
    private Zone mVStems = new Zone(12);
    private Zone[] mTopZones = new Zone[7];
    private Zone[] mBotZones = new Zone[5];
    private ArrayList mTopZonesSorted;
    private ArrayList mBotZonesSorted;
    boolean mTopZoneWasSet;
    boolean mBotZoneWasSet;
    private int mCharTopExtreme;
    private int mCharBotExtreme;
    private int mScaledMaxZoneHeight;
    private int[] mTopZoneData;
    private int[] mBotZoneData;
    private int[] mBlueValues;
    private int[] mOtherBlues;
    private int mBlueFuzz;
    private double mStdVStem;
    private double mBlueScale;
    private static final ZoneTestChar[] gZoneTestCharList = new ZoneTestChar[]{new ZoneTestChar('.', 12, 0), new ZoneTestChar(':', 11, 4), new ZoneTestChar(';', 11, 4), new ZoneTestChar('0', 9, 2), new ZoneTestChar('1', 10, 2), new ZoneTestChar('2', 10, 2), new ZoneTestChar('3', 9, 1), new ZoneTestChar('4', 9, 1), new ZoneTestChar('5', 9, 1), new ZoneTestChar('6', 10, 2), new ZoneTestChar('7', 9, 1), new ZoneTestChar('8', 10, 2), new ZoneTestChar('9', 9, 1), new ZoneTestChar('A', 5, 0), new ZoneTestChar('B', 5, 0), new ZoneTestChar('C', 5, 0), new ZoneTestChar('D', 5, 0), new ZoneTestChar('E', 5, 0), new ZoneTestChar('F', 5, 0), new ZoneTestChar('G', 5, 0), new ZoneTestChar('H', 5, 0), new ZoneTestChar('I', 5, 0), new ZoneTestChar('J', 5, 12), new ZoneTestChar('K', 5, 0), new ZoneTestChar('L', 5, 0), new ZoneTestChar('M', 5, 0), new ZoneTestChar('N', 5, 0), new ZoneTestChar('O', 5, 0), new ZoneTestChar('P', 5, 0), new ZoneTestChar('Q', 5, 12), new ZoneTestChar('R', 5, 0), new ZoneTestChar('S', 5, 0), new ZoneTestChar('T', 5, 0), new ZoneTestChar('U', 5, 0), new ZoneTestChar('V', 5, 0), new ZoneTestChar('W', 5, 0), new ZoneTestChar('X', 5, 0), new ZoneTestChar('Y', 5, 0), new ZoneTestChar('Z', 5, 0), new ZoneTestChar('a', 7, 0), new ZoneTestChar('b', 6, 0), new ZoneTestChar('c', 7, 0), new ZoneTestChar('d', 6, 0), new ZoneTestChar('e', 7, 0), new ZoneTestChar('f', 6, 0), new ZoneTestChar('g', 7, 3), new ZoneTestChar('h', 6, 0), new ZoneTestChar('i', 8, 0), new ZoneTestChar('j', 8, 3), new ZoneTestChar('k', 6, 0), new ZoneTestChar('l', 6, 0), new ZoneTestChar('m', 7, 0), new ZoneTestChar('n', 7, 0), new ZoneTestChar('o', 7, 0), new ZoneTestChar('p', 7, 3), new ZoneTestChar('q', 7, 3), new ZoneTestChar('r', 7, 0), new ZoneTestChar('s', 7, 0), new ZoneTestChar('t', 12, 0), new ZoneTestChar('u', 7, 0), new ZoneTestChar('v', 7, 0), new ZoneTestChar('w', 7, 0), new ZoneTestChar('x', 7, 0), new ZoneTestChar('y', 7, 3), new ZoneTestChar('z', 7, 0)};

    public ZoneHint(OpenTypeFont openTypeFont) throws InvalidFontException, UnsupportedFontException {
        int n;
        int n2;
        int n3;
        double d = openTypeFont.getUnitsPerEmX();
        this.mScaledMaxZoneHeight = (int)(36.0 * d / 1000.0);
        AutoColor autoColor = new AutoColor(null, d, 14, false, true, null, null);
        NonOverlappingOutlineConsumer nonOverlappingOutlineConsumer = new NonOverlappingOutlineConsumer(autoColor, d);
        for (n3 = 0; n3 < 7; ++n3) {
            this.mTopZones[n3] = new Zone(5 + n3);
        }
        for (n3 = 0; n3 < 5; ++n3) {
            this.mBotZones[n3] = new Zone(0 + n3);
        }
        for (n3 = 0; n3 < gZoneTestCharList.length; ++n3) {
            ZoneTestChar zoneTestChar = gZoneTestCharList[n3];
            n2 = openTypeFont.getGlyphForChar(zoneTestChar.mCode);
            if (n2 <= 0) continue;
            try {
                this.mCharBotExtreme = Integer.MAX_VALUE;
                this.mCharTopExtreme = Integer.MAX_VALUE;
                this.mBotZoneWasSet = false;
                this.mTopZoneWasSet = false;
                double d2 = openTypeFont.getHorizontalAdvance(n3);
                autoColor.newGlyph(n2, d2, zoneTestChar.mCode);
                openTypeFont.getGlyphOutline(n2, nonOverlappingOutlineConsumer, 2);
                int[] nArray = autoColor.reportZones();
                int n4 = 0;
                while (n4 < nArray.length) {
                    int n5 = nArray[n4++];
                    switch (n5) {
                        case 0: {
                            int n6 = nArray[n4++];
                            int n7 = nArray[n4++];
                            this.addVStem(n6, n7);
                            break;
                        }
                        case 1: {
                            n4 += 2;
                            break;
                        }
                        case 2: {
                            int n8 = nArray[n4++];
                            int n9 = nArray[n4++];
                            this.addCharExtreme(n8, n9);
                            break;
                        }
                        case 3: {
                            int n8 = nArray[n4++];
                            int n9 = nArray[n4++];
                            this.addCharZone(n8, n9, zoneTestChar);
                            break;
                        }
                        case 4: {
                            n4 += 2;
                        }
                    }
                }
                if (zoneTestChar.mTopZone < 11 && !this.mTopZoneWasSet && this.mCharTopExtreme != Integer.MAX_VALUE) {
                    this.mTopZones[zoneTestChar.mTopZone - 5].addValue(this.mCharTopExtreme);
                }
                if (zoneTestChar.mBotZone >= 4 || this.mBotZoneWasSet || this.mCharBotExtreme == Integer.MAX_VALUE) continue;
                this.mBotZones[zoneTestChar.mBotZone - 0].addValue(this.mCharBotExtreme);
                continue;
            }
            catch (InvalidGlyphException invalidGlyphException) {
                // empty catch block
            }
        }
        this.mTopZonesSorted = this.sortZones(this.mTopZones);
        this.mBotZonesSorted = this.sortZones(this.mBotZones);
        Zone zone = this.findZone(this.mBotZonesSorted, 0);
        if (zone != null) {
            int n10 = 0;
            this.mTopZoneData = new int[this.mTopZonesSorted.size() * 2];
            for (n2 = 0; n2 < this.mTopZonesSorted.size(); ++n2) {
                Zone zone2 = (Zone)this.mTopZonesSorted.get(n2);
                if (zone2.getHeight() > n10) {
                    n10 = zone2.getHeight();
                }
                this.mTopZoneData[n2 * 2] = zone2.mMinValue;
                this.mTopZoneData[n2 * 2 + 1] = zone2.mMaxValue;
            }
            this.mBotZoneData = new int[this.mBotZonesSorted.size() * 2];
            for (n2 = 0; n2 < this.mBotZonesSorted.size(); ++n2) {
                Zone zone3 = (Zone)this.mBotZonesSorted.get(n2);
                if (zone3.getHeight() > n10) {
                    n10 = zone3.getHeight();
                }
                this.mBotZoneData[n2 * 2] = zone3.mMinValue;
                this.mBotZoneData[n2 * 2 + 1] = zone3.mMaxValue;
            }
            this.mBlueValues = new int[this.mTopZoneData.length + 2];
            this.mBlueValues[0] = zone.mMinValue;
            this.mBlueValues[1] = zone.mMaxValue;
            for (n2 = 0; n2 < this.mTopZoneData.length; ++n2) {
                this.mBlueValues[n2 + 2] = this.mTopZoneData[n2];
            }
            this.mOtherBlues = new int[this.mBotZoneData.length - 2];
            int n11 = 0;
            for (n2 = 0; n2 < this.mBotZonesSorted.size(); ++n2) {
                Zone zone4 = (Zone)this.mBotZonesSorted.get(n2);
                if (zone4 == zone) continue;
                this.mOtherBlues[n11++] = zone4.mMinValue;
                this.mOtherBlues[n11++] = zone4.mMaxValue;
            }
            if (n10 > 0) {
                this.mBlueScale = 1.0 / (double)n10 * 0.8;
            }
            this.mBlueFuzz = 0;
        }
        if ((n = this.mVStems.getMode()) == Integer.MAX_VALUE) {
            n = (int)(this.mVStems.getAverage() + 0.5);
        }
        this.mStdVStem = n;
    }

    ArrayList sortZones(Zone[] zoneArray) {
        int n;
        ArrayList<Zone> arrayList = new ArrayList<Zone>();
        block0: for (n = 0; n < zoneArray.length; ++n) {
            Zone zone = zoneArray[n];
            if (zoneArray[n].mNumValues == 0) continue;
            for (int i = 0; i <= arrayList.size(); ++i) {
                if (i != arrayList.size() && zone.mMinValue > ((Zone)arrayList.get((int)i)).mMinValue) continue;
                arrayList.add(i, zone);
                continue block0;
            }
        }
        n = 0;
        while (n < arrayList.size()) {
            boolean bl = true;
            Zone zone = (Zone)arrayList.get(n);
            if (n + 1 < arrayList.size()) {
                Zone zone2 = (Zone)arrayList.get(n + 1);
                if (zone.mMaxValue + 0 + 1 >= zone2.mMinValue || zone.mMinValue + this.mScaledMaxZoneHeight >= zone2.mMaxValue) {
                    for (Integer n2 : zone2.mHistValueList.keySet()) {
                        Integer n3 = (Integer)zone2.mHistValueList.get(n2);
                        zone.addValue(n2, n3);
                    }
                    if (zone.mZoneType > zone2.mZoneType) {
                        zone.mZoneType = zone2.mZoneType;
                    }
                    arrayList.remove(n + 1);
                    bl = false;
                }
            }
            for (int i = zone.mNumValues / 3; zone.getHeight() > this.mScaledMaxZoneHeight && i > 0; --i) {
                double d;
                double d2 = zone.getAverage();
                if (d2 >= (d = (double)(zone.mMinValue + zone.mMaxValue) / 2.0)) {
                    zone.removeValue(zone.mMinValue);
                    continue;
                }
                zone.removeValue(zone.mMaxValue);
            }
            if (zone.getHeight() > this.mScaledMaxZoneHeight) {
                arrayList.remove(n);
                bl = false;
            }
            if (!bl) continue;
            ++n;
        }
        return arrayList;
    }

    Zone findZone(ArrayList arrayList, int n) {
        for (int i = 0; i < arrayList.size(); ++i) {
            Zone zone = (Zone)arrayList.get(i);
            if (zone.mZoneType != n) continue;
            return zone;
        }
        return null;
    }

    public int[] getTopZones() {
        return this.mTopZoneData != null ? this.mTopZoneData : new int[]{};
    }

    public int[] getBottomZones() {
        return this.mBotZoneData != null ? this.mBotZoneData : new int[]{};
    }

    public double[] getBlueValues() {
        int n;
        int n2 = n = this.mBlueValues != null ? this.mBlueValues.length : 0;
        if (n != 0) {
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.mBlueValues[i];
            }
            return dArray;
        }
        return null;
    }

    public double[] getOtherBlues() {
        int n;
        int n2 = n = this.mOtherBlues != null ? this.mOtherBlues.length : 0;
        if (n != 0) {
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.mOtherBlues[i];
            }
            return dArray;
        }
        return null;
    }

    public int getBlueFuzz() {
        return this.mBlueFuzz;
    }

    public double getStdVStem() {
        return this.mStdVStem;
    }

    public double getBlueScale() {
        return this.mBlueScale;
    }

    private void addVStem(int n, int n2) {
        this.mVStems.addValue(n - n2);
    }

    private void addCharExtreme(int n, int n2) {
        this.mCharTopExtreme = n;
        this.mCharBotExtreme = n2;
    }

    private void addCharZone(int n, int n2, ZoneTestChar zoneTestChar) {
        if (zoneTestChar.mTopZone != 12 && (this.mCharTopExtreme == Integer.MAX_VALUE || n + this.mScaledMaxZoneHeight >= this.mCharTopExtreme)) {
            this.mTopZones[zoneTestChar.mTopZone - 5].addValue(n);
            this.mTopZoneWasSet = true;
        }
        if (zoneTestChar.mBotZone != 12 && (this.mCharBotExtreme == Integer.MAX_VALUE || n2 - this.mScaledMaxZoneHeight <= this.mCharBotExtreme)) {
            this.mBotZones[zoneTestChar.mBotZone - 0].addValue(n2);
            this.mBotZoneWasSet = true;
        }
    }

    private static final class ZoneTestChar {
        final char mCode;
        final int mTopZone;
        final int mBotZone;

        private ZoneTestChar(char c, int n, int n2) {
            this.mCode = c;
            this.mTopZone = n;
            this.mBotZone = n2;
        }
    }

    private final class Zone {
        int mZoneType;
        int mNumValues;
        int mMaxValue;
        int mMinValue;
        HashMap mHistValueList = new HashMap();

        Zone(int n) {
            this.mZoneType = n;
        }

        void addValue(int n) {
            this.addValue(n, 1);
        }

        void addValue(int n, int n2) {
            Integer n3 = new Integer(n);
            Integer n4 = (Integer)this.mHistValueList.get(n3);
            int n5 = n4 != null ? n4 : 0;
            this.mHistValueList.put(n3, new Integer(n5 + n2));
            this.setMinMaxWithValue(n);
            this.mNumValues += n2;
        }

        void removeValue(int n) {
            Integer n2 = new Integer(n);
            Integer n3 = (Integer)this.mHistValueList.get(n2);
            if (n3 != null) {
                int n4 = n3;
                if (--n4 == 0) {
                    this.mHistValueList.remove(n2);
                    if (n == this.mMinValue || n == this.mMaxValue) {
                        this.mMaxValue = 0;
                        this.mMinValue = 0;
                        Iterator iterator = this.mHistValueList.keySet().iterator();
                        boolean bl = true;
                        while (iterator.hasNext()) {
                            n2 = (Integer)iterator.next();
                            if (bl) {
                                this.mMinValue = this.mMaxValue = n2.intValue();
                                bl = false;
                            }
                            this.setMinMaxWithValue(n2);
                        }
                    }
                } else {
                    this.mHistValueList.put(n2, new Integer(n4));
                }
                --this.mNumValues;
            }
        }

        int getMode() {
            int n = 0;
            int n2 = 0;
            for (Integer n3 : this.mHistValueList.keySet()) {
                Integer n4 = (Integer)this.mHistValueList.get(n3);
                if (n4 <= n2) continue;
                n = n3;
                n2 = n4;
            }
            return n2 == 1 ? Integer.MAX_VALUE : n;
        }

        double getAverage() {
            double d = 0.0;
            for (Integer n : this.mHistValueList.keySet()) {
                Integer n2 = (Integer)this.mHistValueList.get(n);
                d += (double)(n * n2);
            }
            return d / (double)this.mNumValues;
        }

        void setMinMaxWithValue(int n) {
            if (this.mNumValues == 0 || n > this.mMaxValue) {
                this.mMaxValue = n;
            }
            if (this.mNumValues == 0 || n < this.mMinValue) {
                this.mMinValue = n;
            }
        }

        int getHeight() {
            return this.mMaxValue - this.mMinValue;
        }
    }
}

