/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.PDFEncodingBuilder;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.Cmap;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class PDFEncodingBuilderImpl
extends PDFEncodingBuilder
implements Cmap.CmapSelector {
    private final List revMapList;
    private Subset s;
    private OpenTypeFont f;

    public PDFEncodingBuilderImpl(OpenTypeFont openTypeFont, Subset subset) throws UnsupportedFontException, InvalidFontException {
        this.s = subset;
        this.f = openTypeFont;
        this.revMapList = new ArrayList(5);
        openTypeFont.cmap.enumerateCmaps(this);
        this.f = null;
    }

    public int getCodePoint(int n, PDFEncodingBuilder.Encoding encoding) {
        Iterator iterator = this.revMapList.iterator();
        int n2 = this.s.getFullGid(n);
        while (iterator.hasNext()) {
            RevMap revMap = (RevMap)iterator.next();
            if (revMap.encoding != encoding || revMap.revMap[n2] == -1) continue;
            return revMap.revMap[n2];
        }
        return Integer.MAX_VALUE;
    }

    public PDFEncodingBuilder.Encoding getEncoding(int n) {
        Iterator iterator = this.revMapList.iterator();
        int n2 = this.s.getFullGid(n);
        while (iterator.hasNext()) {
            RevMap revMap = (RevMap)iterator.next();
            if (revMap.revMap[n2] == -1) continue;
            return revMap.encoding;
        }
        return null;
    }

    public void cmapFound(int n, int n2, int n3) throws UnsupportedFontException, InvalidFontException {
        int[] nArray = null;
        PDFEncodingBuilder.Encoding encoding = null;
        switch (n) {
            case 3: {
                switch (n2) {
                    case 1: 
                    case 10: {
                        encoding = PDFEncodingBuilder.Encoding.UNICODE;
                        break;
                    }
                    case 4: {
                        encoding = PDFEncodingBuilder.Encoding.MS_BIG5;
                        break;
                    }
                    case 6: {
                        encoding = PDFEncodingBuilder.Encoding.MS_JOHAB;
                        break;
                    }
                    case 3: {
                        encoding = PDFEncodingBuilder.Encoding.MS_PRC;
                        break;
                    }
                    case 2: {
                        encoding = PDFEncodingBuilder.Encoding.MS_SHIFT_JIS;
                        break;
                    }
                    case 5: {
                        encoding = PDFEncodingBuilder.Encoding.MS_WANSUNG;
                    }
                }
                if (encoding == null) break;
                nArray = this.f.cmap.glyph2char(this.f.getNumGlyphs(), n3);
                break;
            }
            case 0: {
                encoding = PDFEncodingBuilder.Encoding.UNICODE;
                nArray = this.f.cmap.glyph2char(this.f.getNumGlyphs(), n3);
            }
        }
        if (encoding != null) {
            RevMap revMap;
            int n4 = 0;
            for (int i = 0; i < this.s.getNumGlyphs(); ++i) {
                if (nArray[this.s.getFullGid(i)] == -1) continue;
                ++n4;
            }
            ListIterator<RevMap> listIterator = this.revMapList.listIterator();
            while (listIterator.hasNext()) {
                revMap = (RevMap)listIterator.next();
                if (revMap.numGlyphsCovered > n4) continue;
                break;
            }
            revMap = new RevMap(encoding, nArray, n4);
            if (listIterator.hasPrevious()) {
                listIterator.previous();
            } else {
                listIterator = this.revMapList.listIterator();
            }
            listIterator.add(revMap);
        }
    }

    private static class RevMap {
        final PDFEncodingBuilder.Encoding encoding;
        final int[] revMap;
        final int numGlyphsCovered;

        RevMap(PDFEncodingBuilder.Encoding encoding, int[] nArray, int n) {
            this.revMap = nArray;
            this.numGlyphsCovered = n;
            this.encoding = encoding;
        }
    }
}

