/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class Kern
extends Table {
    private final KernInterpretter interpretter;
    private static final MSKernTable msKernTable = new MSKernTable();
    private static final AppleKernTable appleKernTable = new AppleKernTable();

    protected Kern(FontByteArray fontByteArray) throws IOException, InvalidFontException, UnsupportedFontException {
        super(fontByteArray);
        int n = this.getTableMajorVersion();
        switch (n) {
            case 0: {
                this.interpretter = msKernTable;
                break;
            }
            case 1: {
                if (this.data.getuint16(2) != 0) {
                    throw new UnsupportedFontException("'kern' table version 1.x not supported yet");
                }
                this.interpretter = appleKernTable;
                break;
            }
            default: {
                throw new UnsupportedFontException("'kern' table major version = " + n + " not supported");
            }
        }
    }

    public int getTableMajorVersion() throws InvalidFontException {
        return this.data.getuint16(0);
    }

    public int[] getKernVector(int n, int n2) throws InvalidFontException, UnsupportedFontException {
        int[] nArray = new int[2];
        nArray[1] = 0;
        nArray[0] = 0;
        boolean bl = false;
        int n3 = this.interpretter.getNumTables(this.data);
        int n4 = this.interpretter.getOffsetOfFirstSubtable();
        for (int i = 0; i < n3; ++i) {
            bl = this.applyKernSubtable(nArray, n4, bl, n, n2);
            n4 += this.interpretter.getLength(this.data, n4);
        }
        return nArray;
    }

    private boolean applyKernSubtable(int[] nArray, int n, boolean bl, int n2, int n3) throws InvalidFontException, UnsupportedFontException {
        int n4 = this.interpretter.getCoverage(this.data, n);
        int n5 = this.interpretter.subtableFormat(n4);
        if (this.interpretter.verticalSubtable(n4)) {
            return bl;
        }
        switch (n5) {
            case 0: {
                bl = this.applyKernSubtableFormat0(nArray, n, bl, n2, n3);
                break;
            }
            case 2: {
                bl = this.applyKernSubtableFormat2(nArray, n, bl, n2, n3);
                break;
            }
            default: {
                throw new InvalidFontException("invalid kern subtable format (" + n5 + ")");
            }
        }
        return bl;
    }

    private boolean applyKernSubtableFormat2(int[] nArray, int n, boolean bl, int n2, int n3) throws InvalidFontException {
        int n4;
        int n5 = this.data.getOffset(n, this.interpretter.getSubtableHeaderSize() + 2);
        int n6 = this.data.getOffset(n, this.interpretter.getSubtableHeaderSize() + 4);
        int n7 = this.data.getuint16(n5);
        int n8 = this.data.getuint16(n5 + 2);
        if (n2 < n7 || n2 >= n7 + n8) {
            return bl;
        }
        int n9 = this.data.getuint16(n6);
        int n10 = this.data.getuint16(n6 + 2);
        if (n3 < n9 || n3 >= n9 + n10) {
            return bl;
        }
        int n11 = this.data.getuint16(n5 + (n2 - n7) * 2 + 4);
        int n12 = this.data.getint16(n + n11 + (n4 = this.data.getuint16(n6 + (n3 - n9) * 2 + 4)));
        if ((n12 & 0xFFFF) == 32768) {
            bl = false;
        } else {
            int n13 = bl ? 1 : 0;
            int n14 = this.interpretter.getCoverage(this.data, n);
            if (this.interpretter.minimumSubtable(n14)) {
                nArray[n13] = Math.max(nArray[n13], n12);
            } else if (this.interpretter.overrideSubtable(n14)) {
                nArray[n13] = n12;
            } else {
                int n15 = n13;
                nArray[n15] = nArray[n15] + n12;
            }
        }
        return bl;
    }

    private boolean applyKernSubtableFormat0(int[] nArray, int n, boolean bl, int n2, int n3) throws InvalidFontException {
        int n4 = this.data.getuint16(n + this.interpretter.getSubtableHeaderSize());
        int n5 = 0;
        int n6 = n4;
        while (n5 < n6) {
            int n7 = (n5 + n6) / 2;
            int n8 = this.data.getuint16(n + this.interpretter.getSubtableHeaderSize() + 8 + 6 * n7);
            int n9 = this.data.getuint16(n + this.interpretter.getSubtableHeaderSize() + 8 + 6 * n7 + 2);
            if (n8 < n2 || n8 == n2 && n9 < n3) {
                n5 = n7 + 1;
                continue;
            }
            if (n2 < n8 || n2 == n8 && n3 < n9) {
                n6 = n7;
                continue;
            }
            int n10 = this.data.getint16(n + this.interpretter.getSubtableHeaderSize() + 8 + 6 * n7 + 4);
            if ((n10 & 0xFFFF) == 32768) {
                bl = false;
            } else {
                int n11;
                int n12 = this.interpretter.getCoverage(this.data, n);
                int n13 = n11 = bl ? 1 : 0;
                if (this.interpretter.minimumSubtable(n12)) {
                    nArray[n11] = Math.max(nArray[n11], n10);
                } else if (this.interpretter.overrideSubtable(n12)) {
                    nArray[n11] = n10;
                } else {
                    int n14 = n11;
                    nArray[n14] = nArray[n14] + n10;
                }
            }
            return bl;
        }
        return bl;
    }

    public void stream(Map map) {
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = this.getDataAsByteArray();
        map.put(new Integer(1801810542), oTByteArrayBuilder);
    }

    private int writeTableDataFormat0(OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, List list) {
        if (list.size() == 0) {
            return 0;
        }
        Collections.sort(list);
        int n2 = 8 + 6 * list.size();
        oTByteArrayBuilder.ensureCapacity(n + n2);
        int n3 = (int)Math.floor(Kern.log2(list.size()));
        int n4 = (int)Math.pow(2.0, n3);
        oTByteArrayBuilder.setuint16(n, list.size());
        oTByteArrayBuilder.setuint16(n + 2, n4 * 6);
        oTByteArrayBuilder.setuint16(n + 4, n3);
        oTByteArrayBuilder.setuint16(n + 6, (list.size() - n4) * 6);
        for (int i = 0; i < list.size(); ++i) {
            KernEntry kernEntry = (KernEntry)list.get(i);
            oTByteArrayBuilder.setuint16(n + 8 + 6 * i, kernEntry.left);
            oTByteArrayBuilder.setuint16(n + 8 + 6 * i + 2, kernEntry.right);
            oTByteArrayBuilder.setuint16(n + 8 + 6 * i + 4, kernEntry.kern);
        }
        return n2;
    }

    private int writeTableDataFormat0(OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2, Subset subset) throws InvalidFontException, UnsupportedFontException {
        int n3 = this.data.getuint16(n);
        ArrayList<KernEntry> arrayList = new ArrayList<KernEntry>();
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5;
            try {
                n5 = this.data.getuint16(n + 8 + 6 * i);
            }
            catch (InvalidFontException invalidFontException) {
                break;
            }
            if (subset.getExistingSubsetGid(n5) == -1 || subset.getExistingSubsetGid(n4 = this.data.getuint16(n + 8 + 6 * i + 2)) == -1) continue;
            arrayList.add(new KernEntry(subset.getExistingSubsetGid(n5), subset.getExistingSubsetGid(n4), this.data.getint16(n + 8 + 6 * i + 4)));
        }
        return this.writeTableDataFormat0(oTByteArrayBuilder, n2, arrayList);
    }

    private int writeTableDataFormat2As0(OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2, Subset subset) throws InvalidFontException {
        int n3 = n - this.interpretter.getSubtableHeaderSize() + this.data.getuint16(n + 2);
        int n4 = n - this.interpretter.getSubtableHeaderSize() + this.data.getuint16(n + 4);
        int n5 = this.data.getuint16(n3);
        int n6 = this.data.getuint16(n3 + 2);
        int n7 = this.data.getuint16(n4);
        int n8 = this.data.getuint16(n4 + 2);
        ArrayList<KernEntry> arrayList = new ArrayList<KernEntry>();
        for (int i = 0; i < subset.getNumGlyphs(); ++i) {
            int n9 = subset.getFullGid(i);
            if (n9 < n5 || n9 >= n5 + n6) continue;
            for (int j = 0; j < subset.getNumGlyphs(); ++j) {
                int n10 = subset.getFullGid(j);
                if (n10 < n7 || n10 >= n7 + n8) continue;
                int n11 = this.data.getuint16(n3 + (n9 - n5) * 2 + 4);
                int n12 = this.data.getuint16(n4 + (n10 - n7) * 2 + 4);
                int n13 = this.data.getint16(n - this.interpretter.getSubtableHeaderSize() + n11 + n12);
                if (n13 == 0) continue;
                arrayList.add(new KernEntry(i, j, n13));
            }
        }
        return this.writeTableDataFormat0(oTByteArrayBuilder, n2, arrayList);
    }

    private int writeFormat0TableData(OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2, Subset subset, int n3) throws InvalidFontException, UnsupportedFontException {
        switch (n3) {
            case 0: {
                return this.writeTableDataFormat0(oTByteArrayBuilder, n, n2, subset);
            }
            case 2: {
                return this.writeTableDataFormat2As0(oTByteArrayBuilder, n, n2, subset);
            }
        }
        return 0;
    }

    private static double log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    public void subsetAndStreamForSWF(Subset subset, Map map) throws InvalidFontException, UnsupportedFontException {
        OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = OTByteArray.getOTByteArrayBuilderInstance();
        int n = this.interpretter.getNumTables(this.data);
        if (n > 0) {
            int n2 = 0;
            int n3 = this.interpretter.getOffsetOfFirstSubtable();
            int n4 = this.interpretter.getOffsetOfFirstSubtable();
            for (int i = 0; i < n; ++i) {
                int n5 = this.interpretter.getCoverage(this.data, n3);
                if (this.interpretter.verticalSubtable(n5) || this.interpretter.minimumSubtable(n5) || this.interpretter.crossStreamSubtable(n5)) continue;
                int n6 = this.interpretter.subtableFormat(n5);
                int n7 = this.writeFormat0TableData(oTByteArrayBuilder, n3 + this.interpretter.getSubtableHeaderSize(), n4 + this.interpretter.getSubtableHeaderSize(), subset, n6);
                if (n7 > 0) {
                    this.interpretter.writeSubtableHeader(this.data, oTByteArrayBuilder, n3, n4, n7, 0);
                    ++n2;
                }
                n3 += this.interpretter.getLength(this.data, n3);
                n4 += n7;
            }
            if (n2 != 0) {
                this.interpretter.writeHeader(oTByteArrayBuilder, n2);
                map.put(new Integer(1801810542), oTByteArrayBuilder);
            }
        }
    }

    private class KernEntry
    implements Comparable {
        final int left;
        final int right;
        final int kern;

        KernEntry(int n, int n2, int n3) {
            this.left = n;
            this.right = n2;
            this.kern = n3;
        }

        public int compareTo(Object object) {
            KernEntry kernEntry = (KernEntry)object;
            if (this.left < kernEntry.left) {
                return -1;
            }
            if (this.left > kernEntry.left) {
                return 1;
            }
            if (this.right < kernEntry.right) {
                return -1;
            }
            if (this.right > kernEntry.right) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return "[" + this.left + ", " + this.right + ", " + this.kern + "]";
        }
    }

    private static class AppleKernTable
    implements KernInterpretter {
        private static final int COVERAGE_VERTICAL = 32768;
        private static final int CROSS_STREAM = 16384;

        private AppleKernTable() {
        }

        public int getOffsetOfFirstSubtable() {
            return 8;
        }

        public int getSubtableHeaderSize() {
            return 8;
        }

        public int getNumTables(OTByteArray oTByteArray) throws InvalidFontException, UnsupportedFontException {
            if (oTByteArray.getSize() < 8) {
                return 0;
            }
            return oTByteArray.getuint32asint(4, "Too many subtables in kern table");
        }

        public int getCoverage(OTByteArray oTByteArray, int n) throws InvalidFontException {
            return oTByteArray.getuint16(n + 4);
        }

        public int getLength(OTByteArray oTByteArray, int n) throws InvalidFontException, UnsupportedFontException {
            return oTByteArray.getuint32asint(n, "Kern subtable too large");
        }

        public boolean minimumSubtable(int n) {
            return false;
        }

        public boolean overrideSubtable(int n) {
            return false;
        }

        public int subtableFormat(int n) {
            return n & 0xFF;
        }

        public boolean verticalSubtable(int n) {
            return (n & 0x8000) != 0;
        }

        public boolean crossStreamSubtable(int n) {
            return (n & 0x4000) != 0;
        }

        public void writeHeader(OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n) {
            oTByteArrayBuilder.setuint32(0, 65536);
            oTByteArrayBuilder.setuint32(4, n);
        }

        public void writeSubtableHeader(OTByteArray oTByteArray, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2, int n3, int n4) throws InvalidFontException {
            int n5 = this.getCoverage(oTByteArray, n);
            n5 = n5 & 0xFF00 | n4 & 0xFF;
            oTByteArrayBuilder.setuint32(n2, n3);
            oTByteArrayBuilder.setuint16(n2 + 4, n5);
            oTByteArrayBuilder.setuint16(n2 + 6, oTByteArray.getuint16(n + 6));
        }
    }

    private static class MSKernTable
    implements KernInterpretter {
        private static final int COVERAGE_HORIZONTAL = 1;
        private static final int COVERAGE_MINIMUM = 2;
        private static final int CROSS_STREAM = 4;
        private static final int COVERAGE_OVERRIDES = 8;

        private MSKernTable() {
        }

        public int getNumTables(OTByteArray oTByteArray) throws InvalidFontException {
            if (oTByteArray.getSize() < 4) {
                return 0;
            }
            return oTByteArray.getuint16(2);
        }

        public int getSubtableHeaderSize() {
            return 6;
        }

        public int getOffsetOfFirstSubtable() {
            return 4;
        }

        public int getCoverage(OTByteArray oTByteArray, int n) throws InvalidFontException {
            return oTByteArray.getuint16(n + 4);
        }

        public int getLength(OTByteArray oTByteArray, int n) throws InvalidFontException {
            return oTByteArray.getuint16(n + 2);
        }

        public boolean minimumSubtable(int n) {
            return (n & 2) != 0;
        }

        public boolean overrideSubtable(int n) {
            return (n & 8) != 0;
        }

        public int subtableFormat(int n) {
            return n >> 8;
        }

        public boolean verticalSubtable(int n) {
            return (n & 1) == 0;
        }

        public boolean crossStreamSubtable(int n) {
            return (n & 4) != 0;
        }

        public void writeSubtableHeader(OTByteArray oTByteArray, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2, int n3, int n4) throws InvalidFontException {
            int n5 = this.getCoverage(oTByteArray, n);
            n5 = n5 & 0xFF | n4 << 8 & 0xFF00;
            oTByteArrayBuilder.setuint16(n2, oTByteArray.getuint16(n));
            oTByteArrayBuilder.setuint16(n2 + 2, n3);
            oTByteArrayBuilder.setuint16(n2 + 4, n5);
        }

        public void writeHeader(OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n) {
            oTByteArrayBuilder.setuint16(0, 0);
            oTByteArrayBuilder.setuint16(2, n);
        }
    }

    private static interface KernInterpretter {
        public int getNumTables(OTByteArray var1) throws InvalidFontException, UnsupportedFontException;

        public int getOffsetOfFirstSubtable();

        public int getSubtableHeaderSize();

        public int getCoverage(OTByteArray var1, int var2) throws InvalidFontException;

        public int getLength(OTByteArray var1, int var2) throws InvalidFontException, UnsupportedFontException;

        public boolean verticalSubtable(int var1);

        public boolean minimumSubtable(int var1);

        public boolean overrideSubtable(int var1);

        public boolean crossStreamSubtable(int var1);

        public int subtableFormat(int var1);

        public void writeSubtableHeader(OTByteArray var1, OTByteArray.OTByteArrayBuilder var2, int var3, int var4, int var5, int var6) throws InvalidFontException;

        public void writeHeader(OTByteArray.OTByteArrayBuilder var1, int var2);
    }
}

