/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.ChainingGenerator;
import com.adobe.fontengine.font.opentype.ContextualGenerator;
import com.adobe.fontengine.font.opentype.LayoutTable;
import com.adobe.fontengine.font.opentype.LookupTable;
import com.adobe.fontengine.font.opentype.LookupTableSubsetter;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.SetGenerator;
import java.util.Arrays;
import java.util.Map;

class GsubSubsetter
extends LookupTableSubsetter {
    public GsubSubsetter(LookupTable lookupTable, int n) {
        super(lookupTable, OTByteArray.getOTByteArrayBuilderInstance(10), n);
    }

    void patchSubtableCoverage(int n, int n2, Map map, int n3) throws InvalidFontException {
        switch (n3) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                GsubSubsetter.patchCoverageAtOffset(this.origTable, this.builder, n, n2, 2, map);
                break;
            }
            case 5: {
                ContextualGenerator.patchSubtableCoverage(this.origTable, this.builder, n, n2, map, n3);
                break;
            }
            case 6: {
                ChainingGenerator.patchSubtableCoverage(this.origTable, this.builder, n, n2, map, n3);
                break;
            }
            case 7: {
                break;
            }
            default: {
                throw new InvalidFontException("Unrecognized lookup type: " + n3);
            }
        }
    }

    private int writeType1Format1(int n, int n2, int n3) throws InvalidFontException {
        this.builder.ensureCapacity(n2 + 6);
        this.builder.setuint16(n2, 1);
        this.builder.setint16(n2 + 4, n3);
        return 6;
    }

    int writeSubtable(int n, int n2, Map map, int n3, Subset subset, LookupTableSubsetter.LookupSubset lookupSubset) throws InvalidFontException, UnsupportedFontException {
        LookupTableSubsetter.LookupSubtableGenerator lookupSubtableGenerator;
        switch (n3) {
            case 1: {
                Type1TargetGIDFetcher type1TargetGIDFetcher;
                int n4 = this.origTable.data.getuint16(n);
                switch (n4) {
                    case 1: {
                        type1TargetGIDFetcher = new Type1Format1TargetGIDFetcher();
                        ((Type1Format1TargetGIDFetcher)type1TargetGIDFetcher).setDelta(this.origTable.data.getint16(n + 4));
                        break;
                    }
                    case 2: {
                        type1TargetGIDFetcher = new Type1Format2TargetGIDFetcher();
                        ((Type1Format2TargetGIDFetcher)type1TargetGIDFetcher).setOrigSTOffset(n);
                        break;
                    }
                    default: {
                        throw new InvalidFontException("Invalid lookup type 1 format:" + n4);
                    }
                }
                DeltaDeterminer deltaDeterminer = new DeltaDeterminer(subset, type1TargetGIDFetcher);
                this.origTable.iterateCoverage(this.origTable.data.getOffset(n, 2), subset, deltaDeterminer);
                if (deltaDeterminer.canUseFormat1()) {
                    return this.writeType1Format1(n, n2, deltaDeterminer.delta());
                }
                lookupSubtableGenerator = new Type1Format2Generator(n, subset, this.builder, n2, type1TargetGIDFetcher, map);
                break;
            }
            case 2: 
            case 3: {
                lookupSubtableGenerator = new Type2Or3Generator(subset, this.builder, n2, n, map);
                break;
            }
            case 4: {
                lookupSubtableGenerator = Type4Generator.newInstance(this.origTable, subset, this.builder, n2, n, map);
                break;
            }
            case 5: {
                lookupSubtableGenerator = ContextualGenerator.newContextualGenerator(this.origTable, this.builder, n, n2, subset, map, lookupSubset, this.origNumGlyphs);
                break;
            }
            case 6: {
                lookupSubtableGenerator = ChainingGenerator.newChainingInstance(this.origTable, this.builder, n, n2, subset, map, lookupSubset, this.origNumGlyphs);
                break;
            }
            case 7: {
                this.builder.ensureCapacity(n2 + 4);
                this.builder.setuint16(n2, 1);
                this.builder.setuint16(n2 + 2, this.origTable.data.getuint16(n + 2));
                return 8;
            }
            default: {
                throw new InvalidFontException("Invalid GSUB lookup type (" + n3 + ")");
            }
        }
        return lookupSubtableGenerator.writeSubtable();
    }

    int getExtensionSubtableSize() {
        return 8;
    }

    void gatherCoveragesForSubtable(int n, int n2, int n3, Integer n4, Map map, Map map2, Subset subset) throws InvalidFontException, UnsupportedFontException {
        Map map3 = map;
        if (n2 == 7) {
            n2 = this.origTable.data.getuint16(n + 2);
            n += this.origTable.data.getuint32asint(n + 4, "Unhandled extension offset");
            map3 = map2;
        }
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                int n5 = this.origTable.data.getOffset(n, 2);
                GsubSubsetter.addToCoveragesMap(this.origTable, n5, map3, n3, n4, subset);
                break;
            }
            case 5: {
                ContextualGenerator.gatherCoveragesForSubtable(this.origTable, n, n2, n3, n4, map3, subset);
                break;
            }
            case 6: {
                ChainingGenerator.gatherCoveragesForSubtable(this.origTable, n, n2, n3, n4, map3, subset);
                break;
            }
            default: {
                throw new InvalidFontException("Invalid GSUB lookup type (" + n2 + ")");
            }
        }
    }

    int getReferencedLookupType(int n) throws InvalidFontException {
        return this.origTable.data.getuint16(n + 2);
    }

    void patchExtensionOffset(int n, int n2) {
        this.builder.setuint32(n + 4, n2 - n);
    }

    int getReferencedSubtableOffset(int n) throws InvalidFontException, UnsupportedFontException {
        return n + this.origTable.data.getuint32asint(n + 4, "Only handle extensions that fit in 31 bits");
    }

    int getExtensionLookupType() {
        return 7;
    }

    int writeExtensionSubtable(int n, int n2) {
        this.builder.setuint16(n, 1);
        this.builder.setuint16(n + 2, n2);
        return 8;
    }

    boolean mustKeepFeature(int n) {
        return false;
    }

    private static class Type4Generator
    extends SetGenerator
    implements LayoutTable.CoverageConsumer {
        private Type4Generator(LayoutTable layoutTable, Subset subset, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2, int n3) throws InvalidFontException {
            super(layoutTable, subset, oTByteArrayBuilder, n, n2, n3, 4, false, true);
            this.writeHeader(n, n3);
        }

        private void writeHeader(int n, int n2) {
            this.builder.ensureCapacity(n + 6 + 2 * n2);
            this.builder.setuint16(n, 1);
            this.builder.setuint16(n + 4, n2);
        }

        static Type4Generator newInstance(LayoutTable layoutTable, Subset subset, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2, Map map) throws InvalidFontException, UnsupportedFontException {
            int n3 = layoutTable.data.getOffset(n2, 2);
            LookupTableSubsetter.NewCoverage newCoverage = (LookupTableSubsetter.NewCoverage)map.get(new Integer(n3));
            Type4Generator type4Generator = new Type4Generator(layoutTable, subset, oTByteArrayBuilder, n, n2, newCoverage.glyphCount);
            layoutTable.iterateCoverage(n3, subset, type4Generator);
            return type4Generator;
        }

        boolean[] computeMembersToKeep(int n, int n2) throws InvalidFontException, UnsupportedFontException {
            int n3 = this.origTable.data.getuint16(n2);
            boolean[] blArray = new boolean[n3];
            Arrays.fill(blArray, true);
            block0: for (int i = 0; i < n3; ++i) {
                int n4 = this.origTable.data.getOffset(n2, 2 + 2 * i);
                int n5 = this.origTable.data.getuint16(n4);
                if (this.subset.getExistingSubsetGid(n5) == -1) {
                    blArray[i] = false;
                    continue;
                }
                int n6 = this.origTable.data.getuint16(n4 + 2);
                for (int j = 0; j < n6 - 1; ++j) {
                    n5 = this.origTable.data.getuint16(n4 + 4 + 2 * j);
                    if (this.subset.getExistingSubsetGid(n5) != -1) continue;
                    blArray[i] = false;
                    continue block0;
                }
            }
            return blArray;
        }

        int writeMember(int n, int n2) throws InvalidFontException, UnsupportedFontException {
            int n3 = this.origTable.data.getuint16(n2 + 2);
            int n4 = 4 + 2 * (n3 - 1);
            this.builder.ensureCapacity(n + n4);
            this.builder.setuint16(n, this.subset.getExistingSubsetGid(this.origTable.data.getuint16(n2)));
            this.builder.setuint16(n + 2, n3);
            for (int i = 0; i < n3 - 1; ++i) {
                this.builder.setuint16(n + 4 + 2 * i, this.subset.getExistingSubsetGid(this.origTable.data.getuint16(n2 + 4 + 2 * i)));
            }
            return n4;
        }

        int whichRuleSetIndexApplies(int n, int n2) {
            return n2;
        }

        int getOrigRecordSize() {
            return 0;
        }
    }

    private class Type2Or3Generator
    implements LayoutTable.CoverageConsumer,
    LookupTableSubsetter.LookupSubtableGenerator {
        private final Subset subset;
        private final OTByteArray.OTByteArrayBuilder builder;
        private final int newSTOffset;
        private final int origSTOffset;
        private int[] subsetToCoverageIndex;
        private final int glyphCount;

        Type2Or3Generator(Subset subset, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2, Map map) throws InvalidFontException {
            int n3 = GsubSubsetter.this.origTable.data.getOffset(n2, 2);
            LookupTableSubsetter.NewCoverage newCoverage = (LookupTableSubsetter.NewCoverage)map.get(new Integer(n3));
            this.subset = subset;
            this.builder = oTByteArrayBuilder;
            this.newSTOffset = n;
            this.origSTOffset = n2;
            this.glyphCount = newCoverage.glyphCount;
            this.subsetToCoverageIndex = new int[subset.getNumGlyphs()];
            Arrays.fill(this.subsetToCoverageIndex, -1);
        }

        private void writeHeader(int n) {
            this.builder.ensureCapacity(this.newSTOffset + 6 + 2 * n);
            this.builder.setuint16(this.newSTOffset, 1);
            this.builder.setuint16(this.newSTOffset + 4, n);
        }

        public boolean glyphInfo(int n, int n2) throws InvalidFontException, UnsupportedFontException {
            this.subsetToCoverageIndex[this.subset.getExistingSubsetGid((int)n)] = n2;
            return true;
        }

        public int writeSubtable() throws InvalidFontException, UnsupportedFontException {
            int n = 6 + 2 * this.glyphCount;
            this.writeHeader(this.glyphCount);
            GsubSubsetter.this.origTable.iterateCoverage(GsubSubsetter.this.origTable.data.getOffset(this.origSTOffset, 2), this.subset, this);
            int n2 = 0;
            for (int i = 0; i < this.subsetToCoverageIndex.length; ++i) {
                if (this.subsetToCoverageIndex[i] == -1) continue;
                this.builder.setuint16(this.newSTOffset + 6 + 2 * n2, n);
                int n3 = GsubSubsetter.this.origTable.data.getOffset(this.origSTOffset, 6 + 2 * this.subsetToCoverageIndex[i]);
                int n4 = GsubSubsetter.this.origTable.data.getuint16(n3);
                this.builder.ensureCapacity(this.newSTOffset + n + 2 + 2 * n4);
                this.builder.setuint16(this.newSTOffset + n, n4);
                for (int j = 0; j < n4; ++j) {
                    int n5 = this.subset.getExistingSubsetGid(GsubSubsetter.this.origTable.data.getuint16(n3 + 2 + 2 * j));
                    if (n5 == -1) {
                        throw new RuntimeException("Matched a gid not in our subset?? Can't happen..");
                    }
                    this.builder.setuint16(this.newSTOffset + n + 2 + 2 * j, n5);
                }
                n += 2 + 2 * n4;
                ++n2;
            }
            return n;
        }
    }

    private class Type1Format2Generator
    implements LayoutTable.CoverageConsumer,
    LookupTableSubsetter.LookupSubtableGenerator {
        private final Subset subset;
        private final OTByteArray.OTByteArrayBuilder builder;
        private final int newSTOffset;
        int glyphCount = 0;
        private final Type1TargetGIDFetcher fetcher;
        private int[] subsetToTarget;
        private final int origSTOffset;
        private final Map newCoverages;

        Type1Format2Generator(int n, Subset subset, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n2, Type1TargetGIDFetcher type1TargetGIDFetcher, Map map) {
            this.builder = oTByteArrayBuilder;
            this.subset = subset;
            this.newSTOffset = n2;
            this.origSTOffset = n;
            this.fetcher = type1TargetGIDFetcher;
            this.newCoverages = map;
            this.subsetToTarget = new int[subset.getNumGlyphs()];
            Arrays.fill(this.subsetToTarget, -1);
        }

        void writeHeader(int n) {
            this.builder.ensureCapacity(this.newSTOffset + 6 + 2 * n);
            this.builder.setuint16(this.newSTOffset, 2);
            this.builder.setuint16(this.newSTOffset + 4, n);
        }

        public boolean glyphInfo(int n, int n2) throws InvalidFontException, UnsupportedFontException {
            int n3;
            int n4 = this.fetcher.getTarget(n, n2);
            this.subsetToTarget[this.subset.getExistingSubsetGid((int)n)] = n3 = this.subset.getExistingSubsetGid(n4);
            if (n3 == -1) {
                throw new RuntimeException("Matched a gid not in our subset?? Can't happen..");
            }
            ++this.glyphCount;
            return true;
        }

        public int writeSubtable() throws InvalidFontException, UnsupportedFontException {
            int n = GsubSubsetter.this.origTable.data.getOffset(this.origSTOffset, 2);
            LookupTableSubsetter.NewCoverage newCoverage = (LookupTableSubsetter.NewCoverage)this.newCoverages.get(new Integer(n));
            this.writeHeader(newCoverage.glyphCount);
            GsubSubsetter.this.origTable.iterateCoverage(n, this.subset, this);
            int n2 = 0;
            for (int i = 0; i < this.subsetToTarget.length; ++i) {
                if (this.subsetToTarget[i] == -1) continue;
                this.builder.setuint16(this.newSTOffset + 6 + 2 * n2, this.subsetToTarget[i]);
                ++n2;
            }
            return 6 + 2 * newCoverage.glyphCount;
        }
    }

    class DeltaDeterminer
    implements LayoutTable.CoverageConsumer {
        private final Subset subset;
        private boolean format1Ok = true;
        private int delta;
        private boolean deltaInitialized = false;
        private Type1TargetGIDFetcher fetcher;

        public DeltaDeterminer(Subset subset, Type1TargetGIDFetcher type1TargetGIDFetcher) {
            this.subset = subset;
            this.fetcher = type1TargetGIDFetcher;
        }

        public boolean glyphInfo(int n, int n2) throws InvalidFontException, UnsupportedFontException {
            int n3 = this.subset.getExistingSubsetGid(n);
            int n4 = this.fetcher.getTarget(n, n2);
            int n5 = this.subset.getExistingSubsetGid(n4);
            if (this.deltaInitialized) {
                if (n5 - n3 == this.delta) {
                    return true;
                }
                this.format1Ok = false;
                return false;
            }
            this.delta = n5 - n3;
            this.deltaInitialized = true;
            if (this.delta > Short.MAX_VALUE || this.delta < Short.MIN_VALUE) {
                this.format1Ok = false;
                return false;
            }
            return true;
        }

        boolean canUseFormat1() {
            return this.format1Ok;
        }

        int delta() {
            return this.delta;
        }
    }

    class Type1Format2TargetGIDFetcher
    implements Type1TargetGIDFetcher {
        private int origSTOffset;

        Type1Format2TargetGIDFetcher() {
        }

        void setOrigSTOffset(int n) {
            this.origSTOffset = n;
        }

        public int getTarget(int n, int n2) throws InvalidFontException {
            return GsubSubsetter.this.origTable.data.getuint16(this.origSTOffset + 6 + 2 * n2);
        }
    }

    class Type1Format1TargetGIDFetcher
    implements Type1TargetGIDFetcher {
        private int delta;

        Type1Format1TargetGIDFetcher() {
        }

        void setDelta(int n) {
            this.delta = n;
        }

        public int getTarget(int n, int n2) {
            return n + this.delta;
        }
    }

    static interface Type1TargetGIDFetcher {
        public int getTarget(int var1, int var2) throws InvalidFontException;
    }
}

