/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.FontInputStream;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.opentype.Table;
import com.adobe.fontengine.font.opentype.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class FontFactory {
    public static OpenTypeFont[] load(FontInputStream fontInputStream) throws IOException, InvalidFontException, UnsupportedFontException {
        return FontFactory.load(fontInputStream, null, null);
    }

    public static OpenTypeFont[] load(FontInputStream fontInputStream, String string, String string2) throws IOException, InvalidFontException, UnsupportedFontException {
        FontByteArray fontByteArray = new FontByteArray(fontInputStream, 12);
        OTByteArray oTByteArray = new OTByteArray(fontByteArray);
        BlockToLoad blockToLoad = oTByteArray.getint32(0) == Tag.misc_ttcf ? new TTCToLoad(oTByteArray) : new FontToLoad(0L, oTByteArray);
        blockToLoad.load(fontInputStream, blockToLoad);
        byte[] byArray = fontInputStream.getDigest();
        ArrayList arrayList = new ArrayList();
        blockToLoad.buildFonts(arrayList, byArray, string, string2);
        OpenTypeFont[] openTypeFontArray = new OpenTypeFont[arrayList.size()];
        arrayList.toArray(openTypeFontArray);
        return openTypeFontArray;
    }

    public static int getNumBytesNeededToIdentify() {
        return 4;
    }

    public static boolean isOpenType(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n = n << 8 | byArray[i];
        }
        return n == Tag.misc_ttcf || n == Tag.misc_1_0 || n == Tag.misc_OTTO || n == Tag.misc_true;
    }

    private static class TableToLoad
    extends BlockToLoad {
        public int length;
        public Table table;
        public int tag;

        public TableToLoad(long l, int n, int n2) {
            super(l, n);
            this.length = n;
            this.tag = n2;
        }

        public OTByteArray getByteArray() {
            return this.table.data;
        }

        public void load(FontInputStream fontInputStream, BlockToLoad blockToLoad) throws IOException, InvalidFontException, UnsupportedFontException {
            FontByteArray fontByteArray = null;
            if (fontInputStream.getCurrentOffset() <= this.offset) {
                fontInputStream.skipTo(this.offset);
                fontByteArray = new FontByteArray(fontInputStream, this.length);
            } else {
                BlockToLoad blockToLoad2 = blockToLoad;
                OTByteArray.OTByteArrayBuilder oTByteArrayBuilder = OTByteArray.getOTByteArrayBuilderInstance(this.length);
                int n = (int)(fontInputStream.getCurrentOffset() - this.offset);
                if (this.length < n) {
                    n = this.length;
                }
                int n2 = 0;
                while (blockToLoad2.offset + (long)blockToLoad2.length < this.offset) {
                    if (blockToLoad2.next == this) {
                        if (Table.knownTable(this.tag)) {
                            throw new InvalidFontException("Cannot find overlapped data");
                        }
                        blockToLoad2 = null;
                        break;
                    }
                    blockToLoad2 = blockToLoad2.next;
                }
                if (blockToLoad2 != null) {
                    while (n2 < n && blockToLoad2 != null && blockToLoad2.offset <= (long)n2 + this.offset) {
                        OTByteArray oTByteArray = blockToLoad2.getByteArray();
                        if (oTByteArray == null) {
                            throw new InvalidFontException("Overlapping data cannot be accessed.");
                        }
                        int n3 = (int)((long)n2 + this.offset - blockToLoad2.offset);
                        int n4 = Math.min(n, blockToLoad2.length - n3);
                        oTByteArrayBuilder.replace(n2, oTByteArray, n3, n4);
                        blockToLoad2 = blockToLoad2.next;
                        n2 += n4;
                    }
                    if (n2 < n) {
                        if (Table.knownTable(this.tag)) {
                            throw new InvalidFontException("Data could not be copied");
                        }
                    } else {
                        if (this.length > n2) {
                            oTByteArrayBuilder.append(fontInputStream, this.length - n2, n2);
                        }
                        fontByteArray = oTByteArrayBuilder.toOTByteArray();
                    }
                }
            }
            if (fontByteArray != null) {
                this.table = Table.factory(this.tag, fontByteArray);
            }
            if (this.next != null) {
                this.next.load(fontInputStream, blockToLoad);
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof TableToLoad)) {
                return false;
            }
            TableToLoad tableToLoad = (TableToLoad)object;
            return this.length == tableToLoad.length && this.tag == tableToLoad.tag && this.offset == tableToLoad.offset;
        }

        public String toString() {
            return "" + this.length + "/" + this.tag + "/" + this.offset;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }

    private static class FontToLoad
    extends BlockToLoad {
        ArrayList myTablesToLoad = new ArrayList();
        OTByteArray fontHeader;
        private static final int headerLength = 12;

        public FontToLoad(long l) {
            super(l, 12);
        }

        public FontToLoad(long l, OTByteArray oTByteArray) {
            super(l, oTByteArray.getSize());
            this.fontHeader = oTByteArray;
        }

        public OTByteArray getByteArray() {
            return this.fontHeader;
        }

        public void load(FontInputStream fontInputStream, BlockToLoad blockToLoad) throws IOException, InvalidFontException, UnsupportedFontException {
            if (this.fontHeader == null) {
                fontInputStream.skipTo(this.offset);
                FontByteArray fontByteArray = new FontByteArray(fontInputStream, 12);
                this.fontHeader = new OTByteArray(fontByteArray);
            } else {
                fontInputStream.skipTo(this.offset + 12L);
            }
            int n = this.fontHeader.getint32(0);
            if (Tag.misc_OTTO != n && Tag.misc_1_0 != n && Tag.misc_true != n) {
                throw new InvalidFontException("FontData header does not have correct version (is: 0x" + Integer.toHexString(n) + ")");
            }
            int n2 = this.fontHeader.getuint16(4);
            FontByteArray fontByteArray = new FontByteArray(fontInputStream, 16 * n2);
            OTByteArray oTByteArray = new OTByteArray(fontByteArray);
            for (int i = 0; i < n2; ++i) {
                int n3 = oTByteArray.getuint32asint(16 * i + 12, "OT tables larger than 2^31 bytes not supported");
                int n4 = oTByteArray.getint32(i * 16);
                if (n3 == 0) continue;
                TableToLoad tableToLoad = new TableToLoad(oTByteArray.getuint32(16 * i + 8), n3, n4);
                tableToLoad = (TableToLoad)this.add(tableToLoad);
                this.myTablesToLoad.add(tableToLoad);
            }
            if (this.next != null) {
                this.next.load(fontInputStream, blockToLoad);
            }
        }

        public void buildFonts(List list, byte[] byArray, String string, String string2) throws InvalidFontException, UnsupportedFontException {
            HashMap<Integer, Table> hashMap = new HashMap<Integer, Table>();
            for (TableToLoad tableToLoad : this.myTablesToLoad) {
                hashMap.put(new Integer(tableToLoad.tag), tableToLoad.table);
            }
            OpenTypeFont openTypeFont = new OpenTypeFont(hashMap, byArray, string, string2);
            list.add(openTypeFont);
            if (this.next != null) {
                this.next.buildFonts(list, byArray, string, string2);
            }
        }
    }

    private static class TTCToLoad
    extends BlockToLoad {
        private OTByteArray ttcHeader;

        public TTCToLoad(OTByteArray oTByteArray) {
            super(0L, 0);
            this.ttcHeader = oTByteArray;
        }

        public OTByteArray getByteArray() {
            return null;
        }

        public void load(FontInputStream fontInputStream, BlockToLoad blockToLoad) throws IOException, InvalidFontException, UnsupportedFontException {
            if (this.ttcHeader == null) {
                fontInputStream.skipTo(this.offset);
                FontByteArray fontByteArray = new FontByteArray(fontInputStream, 12);
                this.ttcHeader = new OTByteArray(fontByteArray);
            } else {
                fontInputStream.skipTo(this.offset + 12L);
            }
            if ((long)Tag.misc_ttcf != this.ttcHeader.getuint32(0)) {
                throw new InvalidFontException("TTC header does not start with 'ttcf'");
            }
            int n = this.ttcHeader.getuint16(4);
            if (n != 1 && n != 2) {
                throw new UnsupportedFontException("TTC major version " + n + " is not supported");
            }
            int n2 = this.ttcHeader.getuint32asint(8, "TTC fonts with 2^31 fonts or more not supported");
            FontByteArray fontByteArray = new FontByteArray(fontInputStream, 4 * n2);
            OTByteArray oTByteArray = new OTByteArray(fontByteArray);
            for (int i = 0; i < n2; ++i) {
                this.add(new FontToLoad(oTByteArray.getuint32(4 * i)));
            }
            if (this.next != null) {
                this.next.load(fontInputStream, this.next);
            }
        }
    }

    private static abstract class BlockToLoad {
        public BlockToLoad next;
        public long offset;
        public int length;

        public BlockToLoad(long l, int n) {
            this.offset = l;
            this.length = n;
            this.next = null;
        }

        public abstract void load(FontInputStream var1, BlockToLoad var2) throws IOException, InvalidFontException, UnsupportedFontException;

        protected abstract OTByteArray getByteArray();

        public BlockToLoad add(BlockToLoad blockToLoad) throws InvalidFontException {
            if (this.next == null) {
                this.next = blockToLoad;
                return blockToLoad;
            }
            if (blockToLoad.offset < this.next.offset || blockToLoad.offset == this.next.offset && blockToLoad.length < this.next.length) {
                blockToLoad.next = this.next;
                this.next = blockToLoad;
                return blockToLoad;
            }
            if (!blockToLoad.equals(this.next)) {
                return this.next.add(blockToLoad);
            }
            return this.next;
        }

        public void buildFonts(List list, byte[] byArray, String string, String string2) throws UnsupportedFontException, InvalidFontException {
            if (this.next != null) {
                this.next.buildFonts(list, byArray, string, string2);
            }
        }
    }
}

