/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.LayoutTable;
import com.adobe.fontengine.font.opentype.LayoutTableSubsetter;
import com.adobe.fontengine.font.opentype.LookupTableSubsetter;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.SetGenerator;
import java.util.Arrays;
import java.util.Map;

class ContextualGenerator {
    private static final boolean warnAboutDroppedSublookups = false;

    ContextualGenerator() {
    }

    static void gatherCoveragesForSubtable(LayoutTable layoutTable, int n, int n2, int n3, Integer n4, Map map, Subset subset) throws InvalidFontException, UnsupportedFontException {
        int n5 = layoutTable.data.getuint16(n);
        switch (n5) {
            case 1: 
            case 2: {
                int n6 = layoutTable.data.getOffset(n, 2);
                LookupTableSubsetter.addToCoveragesMap(layoutTable, n6, map, n3, n4, subset);
                break;
            }
            case 3: {
                int n7 = layoutTable.data.getuint16(n + 2);
                for (int i = 0; i < n7; ++i) {
                    int n8 = layoutTable.data.getOffset(n, 6 + 2 * i);
                    LookupTableSubsetter.addToCoveragesMap(layoutTable, n8, map, n3, n4, subset);
                }
                break;
            }
            default: {
                throw new InvalidFontException("Invalid contextual subtable format (" + n5 + ")");
            }
        }
    }

    static void patchSubtableCoverage(LayoutTable layoutTable, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2, Map map, int n3) throws InvalidFontException {
        int n4 = layoutTable.data.getuint16(n);
        switch (n4) {
            case 1: 
            case 2: {
                LookupTableSubsetter.patchCoverageAtOffset(layoutTable, oTByteArrayBuilder, n, n2, 2, map);
                break;
            }
            case 3: {
                int n5 = layoutTable.data.getuint16(n + 2);
                for (int i = 0; i < n5; ++i) {
                    LookupTableSubsetter.patchCoverageAtOffset(layoutTable, oTByteArrayBuilder, n, n2, 6 + 2 * i, map);
                }
                break;
            }
            default: {
                throw new InvalidFontException("Unrecognized lookup type 5 format: " + n4);
            }
        }
    }

    static LookupTableSubsetter.LookupSubtableGenerator newContextualGenerator(LayoutTable layoutTable, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2, Subset subset, Map map, LookupTableSubsetter.LookupSubset lookupSubset, int n3) throws InvalidFontException, UnsupportedFontException {
        int n4 = layoutTable.data.getuint16(n);
        switch (n4) {
            case 1: {
                return ContextualFormat1Generator.newInstance(n, n2, layoutTable, subset, oTByteArrayBuilder, map, lookupSubset);
            }
            case 2: {
                return ContextualFormat2Generator.newInstance(layoutTable, subset, oTByteArrayBuilder, n2, n, lookupSubset, n3);
            }
            case 3: {
                return ContextualFormat3Generator.newInstance(layoutTable, oTByteArrayBuilder, n, n2, map, lookupSubset);
            }
        }
        throw new InvalidFontException("Invalid contextual lookup format: " + n4);
    }

    private static class ContextualFormat3Generator
    implements LookupTableSubsetter.LookupSubtableGenerator {
        private final int origSTOffset;
        private final int newSTOffset;
        private final LookupTableSubsetter.LookupSubset lookupSubset;
        private final LayoutTable origTable;
        private final OTByteArray.OTByteArrayBuilder builder;

        private ContextualFormat3Generator(LayoutTable layoutTable, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2, Map map, LookupTableSubsetter.LookupSubset lookupSubset) {
            this.lookupSubset = lookupSubset;
            this.newSTOffset = n2;
            this.origSTOffset = n;
            this.origTable = layoutTable;
            this.builder = oTByteArrayBuilder;
        }

        static ContextualFormat3Generator newInstance(LayoutTable layoutTable, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2, Map map, LookupTableSubsetter.LookupSubset lookupSubset) {
            return new ContextualFormat3Generator(layoutTable, oTByteArrayBuilder, n, n2, map, lookupSubset);
        }

        public int writeSubtable() throws InvalidFontException, UnsupportedFontException {
            int n = this.origTable.data.getuint16(this.origSTOffset + 2);
            int n2 = this.origTable.data.getuint16(this.origSTOffset + 4);
            int n3 = 6 + 2 * n;
            this.builder.ensureCapacity(this.newSTOffset + n3);
            this.builder.setuint16(this.newSTOffset, 3);
            this.builder.setuint16(this.newSTOffset + 2, n);
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                int n5 = this.origTable.data.getuint16(this.origSTOffset + 6 + 2 * n + 4 * i + 2);
                int n6 = this.lookupSubset.getExistingSubsetGid(n5);
                if (n6 == -1) continue;
                this.builder.ensureCapacity(this.newSTOffset + (n3 += 4));
                this.builder.setuint16(this.newSTOffset + 6 + 2 * n + 4 * n4, this.origTable.data.getuint16(this.origSTOffset + 6 + 2 * n + 4 * i));
                this.builder.setuint16(this.newSTOffset + 6 + 2 * n + 4 * n4 + 2, n6);
                ++n4;
            }
            this.builder.setuint16(this.newSTOffset + 4, n4);
            return n3;
        }
    }

    private static class ContextualFormat2Generator
    extends SetGenerator
    implements LayoutTable.CoverageConsumer {
        private final LookupTableSubsetter.LookupSubset lookupSubset;
        private final LayoutTableSubsetter.ClassCoveredBySubset classCovered;
        private final int origClassDefOffset;
        private final int numGlyphs;
        private final int classCount;

        private ContextualFormat2Generator(LayoutTable layoutTable, Subset subset, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2, int n3, LookupTableSubsetter.LookupSubset lookupSubset, int n4) throws InvalidFontException {
            super(layoutTable, subset, oTByteArrayBuilder, n, n2, n3, 6, true, true);
            this.lookupSubset = lookupSubset;
            this.classCovered = new LayoutTableSubsetter.ClassCoveredBySubset(subset);
            this.origClassDefOffset = layoutTable.data.getOffset(n2, 4);
            this.numGlyphs = n4;
            this.classCount = n3;
        }

        static ContextualFormat2Generator newInstance(LayoutTable layoutTable, Subset subset, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2, LookupTableSubsetter.LookupSubset lookupSubset, int n3) throws InvalidFontException {
            int n4 = layoutTable.data.getuint16(n2 + 6);
            ContextualFormat2Generator contextualFormat2Generator = new ContextualFormat2Generator(layoutTable, subset, oTByteArrayBuilder, n, n2, n4, lookupSubset, n3);
            return contextualFormat2Generator;
        }

        public int writeSubtable() throws InvalidFontException, UnsupportedFontException {
            int n = this.origTable.data.getOffset(this.origSTOffset, 2);
            this.builder.ensureCapacity(this.newSTOffset + 8 + 2 * this.classCount);
            this.builder.setuint16(this.newSTOffset, 2);
            this.builder.setuint16(this.newSTOffset + 6, this.classCount);
            this.origTable.iterateCoverage(n, this.subset, this);
            this.writeClassDef();
            return this.subtableSize;
        }

        boolean[] computeMembersToKeep(int n, int n2) throws InvalidFontException, UnsupportedFontException {
            int n3 = this.origTable.data.getuint16(n2);
            boolean[] blArray = new boolean[n3];
            Arrays.fill(blArray, true);
            block0: for (int i = 0; i < n3; ++i) {
                int n4 = this.origTable.data.getOffset(n2, 2 + 2 * i);
                int n5 = this.origTable.data.getuint16(n4);
                for (int j = 0; j < n5 - 1; ++j) {
                    if (this.classCovered.classCoveredBySubset(this.origTable, this.origClassDefOffset, this.numGlyphs, this.origTable.data.getuint16(n4 + 4 + 2 * j))) continue;
                    blArray[i] = false;
                    continue block0;
                }
            }
            return blArray;
        }

        int writeMember(int n, int n2) throws InvalidFontException, UnsupportedFontException {
            int n3;
            int n4 = this.origTable.data.getuint16(n2);
            int n5 = this.origTable.data.getuint16(n2 + 2);
            int n6 = 4 + 2 * (n4 - 1);
            this.builder.ensureCapacity(n + n6);
            this.builder.setuint16(n, n4);
            for (n3 = 0; n3 < n4 - 1; ++n3) {
                this.builder.setuint16(n + 4 + 2 * n3, this.origTable.data.getuint16(n2 + 4 + n3 * 2));
            }
            n3 = 0;
            for (int i = 0; i < n5; ++i) {
                int n7 = this.lookupSubset.getExistingSubsetGid(this.origTable.data.getuint16(n2 + 4 + 2 * (n4 - 1) + i * 4 + 2));
                if (n7 == -1) continue;
                this.builder.ensureCapacity(n + (n6 += 4));
                int n8 = this.origTable.data.getuint16(n2 + 4 + 2 * (n4 - 1) + i * 4);
                this.builder.setuint16(n + 4 + 2 * (n4 - 1) + 4 * n3, n8);
                this.builder.setuint16(n + 4 + 2 * (n4 - 1) + 4 * n3 + 2, n7);
                ++n3;
            }
            this.builder.setuint16(n + 2, n3);
            return n6;
        }

        void writeClassDef() throws InvalidFontException, UnsupportedFontException {
            LayoutTableSubsetter.ClassDefGenerator classDefGenerator = LayoutTableSubsetter.ClassDefGenerator.newInstance(this.origTable, this.origClassDefOffset, this.subset, this.numGlyphs);
            this.builder.setuint16(this.newSTOffset + 4, this.subtableSize);
            OTByteArray oTByteArray = classDefGenerator.generateClass().toOTByteArray();
            this.subtableSize += this.writeByteArrayAtOffset(this.newSTOffset + this.subtableSize, oTByteArray);
        }

        int whichRuleSetIndexApplies(int n, int n2) throws InvalidFontException {
            return this.origTable.getClassIndex(n, this.origClassDefOffset);
        }

        int getOrigRecordSize() {
            return 0;
        }
    }

    private static class ContextualFormat1Generator
    extends SetGenerator
    implements LayoutTable.CoverageConsumer {
        private final LookupTableSubsetter.LookupSubset lookupSubset;

        private ContextualFormat1Generator(LayoutTable layoutTable, Subset subset, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, int n, int n2, int n3, LookupTableSubsetter.LookupSubset lookupSubset) throws InvalidFontException {
            super(layoutTable, subset, oTByteArrayBuilder, n, n2, n3, 4, false, true);
            this.writeHeader(n, n3);
            this.lookupSubset = lookupSubset;
        }

        private void writeHeader(int n, int n2) {
            this.builder.ensureCapacity(n + 6 + 2 * n2);
            this.builder.setuint16(n, 1);
            this.builder.setuint16(n + 4, n2);
        }

        static ContextualFormat1Generator newInstance(int n, int n2, LayoutTable layoutTable, Subset subset, OTByteArray.OTByteArrayBuilder oTByteArrayBuilder, Map map, LookupTableSubsetter.LookupSubset lookupSubset) throws InvalidFontException, UnsupportedFontException {
            int n3 = layoutTable.data.getOffset(n, 2);
            LookupTableSubsetter.NewCoverage newCoverage = (LookupTableSubsetter.NewCoverage)map.get(new Integer(n3));
            ContextualFormat1Generator contextualFormat1Generator = new ContextualFormat1Generator(layoutTable, subset, oTByteArrayBuilder, n2, n, newCoverage.glyphCount, lookupSubset);
            layoutTable.iterateCoverage(n3, subset, contextualFormat1Generator);
            return contextualFormat1Generator;
        }

        boolean[] computeMembersToKeep(int n, int n2) throws InvalidFontException, UnsupportedFontException {
            int n3 = this.origTable.data.getuint16(n2);
            boolean[] blArray = new boolean[n3];
            Arrays.fill(blArray, true);
            block0: for (int i = 0; i < n3; ++i) {
                int n4 = this.origTable.data.getOffset(n2, 2 + 2 * i);
                int n5 = this.origTable.data.getuint16(n4);
                for (int j = 0; j < n5 - 1; ++j) {
                    if (this.subset.getExistingSubsetGid(this.origTable.data.getuint16(n4 + 4 + 2 * j)) != -1) continue;
                    blArray[i] = false;
                    continue block0;
                }
            }
            return blArray;
        }

        int writeMember(int n, int n2) throws InvalidFontException, UnsupportedFontException {
            int n3;
            int n4;
            int n5 = this.origTable.data.getuint16(n2);
            int n6 = this.origTable.data.getuint16(n2 + 2);
            int n7 = 4 + 2 * (n5 - 1);
            this.builder.ensureCapacity(n + n7);
            this.builder.setuint16(n, n5);
            for (n4 = 0; n4 < n5 - 1; ++n4) {
                n3 = this.subset.getExistingSubsetGid(this.origTable.data.getuint16(n2 + 4 + n4 * 2));
                this.builder.setuint16(n + 4 + 2 * n4, n3);
            }
            n4 = 0;
            for (n3 = 0; n3 < n6; ++n3) {
                int n8 = this.lookupSubset.getExistingSubsetGid(this.origTable.data.getuint16(n2 + 4 + 2 * (n5 - 1) + n3 * 4 + 2));
                if (n8 == -1) continue;
                this.builder.ensureCapacity(n + (n7 += 4));
                int n9 = this.origTable.data.getuint16(n2 + 4 + 2 * (n5 - 1) + n3 * 4);
                this.builder.setuint16(n + 4 + 2 * (n5 - 1) + 4 * n4, n9);
                this.builder.setuint16(n + 4 + 2 * (n5 - 1) + 4 * n4 + 2, n8);
                ++n4;
            }
            this.builder.setuint16(n + 2, n4);
            return n7;
        }

        int whichRuleSetIndexApplies(int n, int n2) {
            return n2;
        }

        int getOrigRecordSize() {
            return 0;
        }
    }
}

