/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.CodePage;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.LineMetrics;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OrigFontType;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.Permission;
import com.adobe.fontengine.font.ROS;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.SubsetDefaultImpl;
import com.adobe.fontengine.font.SubsetSimpleTrueType;
import com.adobe.fontengine.font.SubsetSimpleType1;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.XDCFontDescription;
import com.adobe.fontengine.font.cff.CFFByteArray;
import com.adobe.fontengine.font.cff.CFFFont;
import com.adobe.fontengine.font.cff.CFFSubrize;
import com.adobe.fontengine.font.cff.CIDComponentFont;
import com.adobe.fontengine.font.cff.CharStrings;
import com.adobe.fontengine.font.cff.Charset;
import com.adobe.fontengine.font.cff.Dict;
import com.adobe.fontengine.font.cff.FdSelect;
import com.adobe.fontengine.font.cff.Header;
import com.adobe.fontengine.font.cff.Index;
import com.adobe.fontengine.font.cff.NameIndex;
import com.adobe.fontengine.font.cff.StringIndex;
import com.adobe.fontengine.font.cff.Type2OutlineParser;
import com.adobe.fontengine.font.postscript.UnicodeCmap;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class CIDKeyedFont
extends CFFFont {
    protected final CharStrings charStrings;
    protected final Charset charset;
    protected final FdSelect fdSelect;
    protected final CIDComponentFont[] components;
    private final XDCFontDescription xdcDescription;
    UnicodeCmap cmap = null;
    Object cmapMutex = new Object();
    static final Dict.Key[] topDictKeysForSubset = new Dict.Key[]{Dict.Key.Notice, Dict.Key.FullName, Dict.Key.FamilyName, Dict.Key.FontName, Dict.Key.BaseFontName, Dict.Key.BaseFontBlend, Dict.Key.Weight, Dict.Key.FontBBox, Dict.Key.Copyright, Dict.Key.isFixedPitch, Dict.Key.ItalicAngle, Dict.Key.UnderlinePosition, Dict.Key.UnderlineThickness, Dict.Key.PaintType, Dict.Key.CharstringType, Dict.Key.StrokeWidth, Dict.Key.CIDFontType};
    static final Dict.Key[] fontDictKeysForSubset = new Dict.Key[]{Dict.Key.FontMatrix};
    static final Dict.Key[] privateDictKeysForSubset = new Dict.Key[]{Dict.Key.BlueValues, Dict.Key.OtherBlues, Dict.Key.FamilyBlues, Dict.Key.FamilyOtherBlues, Dict.Key.StdHW, Dict.Key.StdVW, Dict.Key.defaultWidthX, Dict.Key.nominalWidthX, Dict.Key.BlueScale, Dict.Key.BlueShift, Dict.Key.BlueFuzz, Dict.Key.StemSnapH, Dict.Key.StemSnapV, Dict.Key.ForceBold, Dict.Key.ForceBoldThreshold, Dict.Key.LanguageGroup, Dict.Key.ExpansionFactor, Dict.Key.initialRandomSeed};
    private static final int MAX_CFF_SIZE_FOR_SUBRIZE = 614400;

    public Subset createSubset() throws InvalidFontException, UnsupportedFontException {
        SubsetDefaultImpl subsetDefaultImpl = new SubsetDefaultImpl(this.getNumGlyphs(), true);
        subsetDefaultImpl.getSubsetGid(0);
        return subsetDefaultImpl;
    }

    CIDKeyedFont(StringIndex stringIndex, CharStrings charStrings, String string, Dict dict, CFFByteArray cFFByteArray, byte[] byArray) throws InvalidFontException, UnsupportedFontException {
        super(stringIndex, charStrings, dict, string, byArray);
        this.xdcDescription = new CIDKeyedFontXDCFontDescription();
        Dict.OffsetValue offsetValue = dict.get(Dict.Key.CharStrings, false);
        if (offsetValue == null) {
            throw new InvalidFontException("missing TopDICT/CharStrings");
        }
        this.charStrings = new CharStrings(cFFByteArray, offsetValue.offset);
        int n = this.charStrings.getCount();
        Object object = dict.get(Dict.Key.charset, false);
        this.charset = object != null ? new Charset(cFFByteArray, object.offset, n) : null;
        object = null;
        Dict.OffsetValue offsetValue2 = dict.get(Dict.Key.FDArray, false);
        if (offsetValue2 != null) {
            Index index = new Index(cFFByteArray, offsetValue2.offset);
            object = new CIDComponentFont[index.getCount()];
            for (int i = 0; i < ((CIDComponentFont[])object).length; ++i) {
                object[i] = new CIDComponentFont(cFFByteArray, index.offsetOf(i), index.sizeOf(i), stringIndex);
            }
        }
        this.components = object;
        object = null;
        offsetValue2 = dict.get(Dict.Key.FDSelect, false);
        if (offsetValue2 != null) {
            object = new FdSelect(cFFByteArray, offsetValue2.offset, n);
        }
        this.fdSelect = object;
    }

    CIDKeyedFont(StringIndex stringIndex, CharStrings charStrings, String string, Dict dict, CharStrings charStrings2, Charset charset, CIDComponentFont[] cIDComponentFontArray, FdSelect fdSelect) throws UnsupportedFontException, InvalidFontException {
        super(stringIndex, charStrings, dict, string, null);
        this.xdcDescription = new CIDKeyedFontXDCFontDescription();
        this.charStrings = charStrings2;
        this.charset = charset;
        this.components = (CIDComponentFont[])cIDComponentFontArray.clone();
        this.fdSelect = fdSelect;
    }

    public CIDKeyedFont(String string, Dict dict, CharStrings charStrings, int n, Dict dict2, Dict dict3) throws InvalidFontException, UnsupportedFontException {
        super(null, CharStrings.createEmptyCharstrings(), dict, string, null);
        this.xdcDescription = new CIDKeyedFontXDCFontDescription();
        CIDComponentFont[] cIDComponentFontArray = new CIDComponentFont[]{new CIDComponentFont(dict2, dict3, CharStrings.createEmptyCharstrings())};
        this.charStrings = charStrings;
        this.charset = Charset.identityCharset(n);
        this.components = cIDComponentFontArray;
        this.fdSelect = FdSelect.singleFont(n);
    }

    public CIDKeyedFont(String string, Dict dict, CharStrings charStrings, int n, Dict dict2, Dict dict3, CharStrings charStrings2, CharStrings charStrings3) throws InvalidFontException, UnsupportedFontException {
        super(null, charStrings3, dict, string, null);
        this.xdcDescription = new CIDKeyedFontXDCFontDescription();
        CIDComponentFont[] cIDComponentFontArray = new CIDComponentFont[]{new CIDComponentFont(dict2, dict3, charStrings2)};
        this.charStrings = charStrings;
        this.charset = Charset.identityCharset(n);
        this.components = cIDComponentFontArray;
        this.fdSelect = FdSelect.singleFont(n);
    }

    public int getNumGlyphs() {
        return this.charStrings.getCount();
    }

    public String getGlyphName(int n) {
        return null;
    }

    public ROS getROS() {
        return this.topDict.getROS();
    }

    public int getCIDCount() {
        return this.topDict.get((Dict.IntegerKey)Dict.Key.CIDCount, (boolean)true).value;
    }

    public int getGlyphCid(int n) throws InvalidFontException, UnsupportedFontException {
        return this.charset.gid2sid(n);
    }

    public int cid2gid(int n) throws InvalidFontException, UnsupportedFontException {
        return this.charset.sid2gid(n);
    }

    int[] getXUID() {
        Dict.NumbersValue numbersValue = this.topDict.get(Dict.Key.XUID, true);
        return numbersValue == null ? null : numbersValue.getValuesAsInt();
    }

    String getNotice() {
        Dict.StringValue stringValue = this.topDict.get(Dict.Key.Notice, true);
        return stringValue == null ? null : stringValue.value;
    }

    String getCopyright() {
        Dict.StringValue stringValue = this.topDict.get(Dict.Key.Copyright, true);
        return stringValue == null ? null : stringValue.value;
    }

    String getFullName() {
        Dict.StringValue stringValue = this.topDict.get(Dict.Key.FullName, true);
        return stringValue == null ? null : stringValue.value;
    }

    Integer getFSType() {
        return this.topDict.getFSType();
    }

    OrigFontType getOrigFontType() {
        return this.topDict.getOrigFontType();
    }

    public void getGlyphOutline(int n, OutlineConsumer outlineConsumer) throws InvalidFontException, UnsupportedFontException {
        if (this.topDict.get(Dict.Key.CharstringType, true).getFirstValueAsDouble() != 2.0) {
            throw new InvalidFontException("Unsupported Charstring type");
        }
        this.getOutline(n, new Type2OutlineParser(false), outlineConsumer);
    }

    public void getOutline(int n, Type2OutlineParser type2OutlineParser, OutlineConsumer outlineConsumer) throws InvalidFontException, UnsupportedFontException {
        this.components[this.fdSelect.componentOf(n)].getOutline(this.charStrings, n, this.globalSubrs, type2OutlineParser, outlineConsumer, this.topDict.get(Dict.Key.FontMatrix, false));
    }

    public double getStemVForGlyph(int n) throws InvalidFontException {
        return this.components[this.fdSelect.componentOf(n)].getStemV();
    }

    public Matrix getFontMatrix() {
        return new Matrix(this.topDict.get(Dict.Key.FontMatrix, true).getValuesAsDouble());
    }

    public Matrix getFontMatrix(int n) {
        Dict.NumbersValue numbersValue = this.topDict.get(Dict.Key.FontMatrix, false);
        Matrix matrix = n >= 0 && n < this.components.length ? this.components[n].getOutlineMatrix(numbersValue) : new Matrix(numbersValue.getValuesAsDouble());
        return matrix;
    }

    private Matrix getFontToMetricsMatrix() throws InvalidFontException, UnsupportedFontException {
        Matrix matrix = this.getFontMatrix();
        double d = this.getUnitsPerEmX();
        double d2 = this.getUnitsPerEmY();
        return new Matrix(d * matrix.a, d2 * matrix.b, d * matrix.c, d2 * matrix.d, d * matrix.tx, d2 * matrix.ty);
    }

    public double getHorizontalAdvance(int n) throws InvalidFontException, UnsupportedFontException {
        return this.components[this.fdSelect.componentOf(n)].getHorizontalAdvance(this.charStrings, n, this.globalSubrs);
    }

    double getItalicAngle() {
        Dict.NumbersValue numbersValue = this.topDict.get(Dict.NumbersKey.ItalicAngle, false);
        if (numbersValue != null) {
            return numbersValue.getFirstValueAsDouble();
        }
        return 0.0;
    }

    public Rect getRawFontBBox() {
        Dict.NumbersValue numbersValue = this.topDict.get(Dict.NumbersKey.FontBBox, false);
        if (numbersValue != null && numbersValue.values.length == 4) {
            return new Rect(numbersValue.getValuesAsDouble());
        }
        return null;
    }

    private double getCoolTypeLineGapForCJK() throws UnsupportedFontException, InvalidFontException {
        return this.getUnitsPerEmY() / 2.0;
    }

    private LineMetrics getCoolTypeLineMetricsFromTypicalCharacters(double d) throws UnsupportedFontException, InvalidFontException {
        double d2;
        double d3;
        int n = this.getCoolTypeGlyphForChar(100);
        int n2 = this.getCoolTypeGlyphForChar(112);
        if (n != 0 && n2 != 0 && (d3 = this.getGlyphBBox((int)n2).ymin) < (d2 = this.getGlyphBBox((int)n).ymax)) {
            return new LineMetrics(d2, d3, d);
        }
        return null;
    }

    private LineMetrics getCoolTypeLineMetricsFromICFBox(double d) throws UnsupportedFontException, InvalidFontException {
        Rect rect = this.getCoolTypeIcfBox();
        return new LineMetrics(rect.ymax, rect.ymax - this.getUnitsPerEmY(), d);
    }

    public Rect getFontBBox() throws InvalidFontException, UnsupportedFontException {
        Rect rect = this.getRawFontBBox();
        if (rect == null) {
            return null;
        }
        return rect.applyMatrix(this.getFontToMetricsMatrix());
    }

    protected Rect getCoolTypeRawFontBBox() throws InvalidFontException, UnsupportedFontException {
        return this.getFontBBox();
    }

    public LineMetrics getCoolTypeLineMetrics() throws UnsupportedFontException, InvalidFontException {
        if (this.useCoolTypeCJKHeuristics()) {
            double d = this.getCoolTypeLineGapForCJK();
            LineMetrics lineMetrics = this.getCoolTypeLineMetricsFromTypicalCharacters(d);
            if (lineMetrics != null) {
                return lineMetrics;
            }
            return this.getCoolTypeLineMetricsFromICFBox(d);
        }
        return this.getCoolTypeLineMetricsFromFontBbox();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFirstChar() throws InvalidFontException, UnsupportedFontException {
        Object object = this.cmapMutex;
        synchronized (object) {
            this.initCmap();
            return this.cmap.getFirstSupportedChar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastChar() throws InvalidFontException, UnsupportedFontException {
        Object object = this.cmapMutex;
        synchronized (object) {
            this.initCmap();
            return this.cmap.getLastSupportedChar();
        }
    }

    private void initCmap() throws InvalidFontException, UnsupportedFontException {
        if (this.cmap == null) {
            Dict.ROSValue rOSValue = this.topDict.get(Dict.ROSKey.ROS, true);
            this.cmap = UnicodeCmap.computeCmapFromCids(this.getNumGlyphs(), new UnicodeCmap.GlyphCidAccessor(){

                public int getAGlyphCid(int n) throws UnsupportedFontException, InvalidFontException {
                    return CIDKeyedFont.this.charset.gid2sid(n);
                }
            }, rOSValue.ros.registry, rOSValue.ros.ordering);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGlyphForChar(int n) throws InvalidFontException, UnsupportedFontException {
        Object object = this.cmapMutex;
        synchronized (object) {
            this.initCmap();
            return this.cmap.getGlyphForChar(n);
        }
    }

    public Permission getEmbeddingPermission(boolean bl) {
        return this.getEmbeddingPermissionGivenFT(bl, OrigFontType.kCID);
    }

    int getNumFDs() {
        return this.components.length;
    }

    CharStrings getCharStrings() {
        return this.charStrings;
    }

    CharStrings getLocalSubrsForFD(int n) {
        return this.components[n].localSubrs;
    }

    double getDefaultWidthForFD(int n) {
        return this.components[n].privateDict.get(Dict.NumbersKey.defaultWidthX, true).getFirstValueAsDouble();
    }

    double getNominalWidthForFD(int n) {
        return this.components[n].privateDict.get(Dict.NumbersKey.nominalWidthX, true).getFirstValueAsDouble();
    }

    int getFDForGlyph(int n) throws InvalidFontException {
        return this.fdSelect.componentOf(n);
    }

    private void setCIDCount(boolean bl, CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder, Subset subset, boolean bl2, List list) throws InvalidFontException, UnsupportedFontException {
        if (!bl) {
            Dict.streamKeyVal(cFFByteArrayBuilder, Dict.Key.CIDCount, subset.getNumGlyphs());
        } else if (bl2) {
            int n = -1;
            for (int i = 0; i < subset.getNumGlyphs(); ++i) {
                int n2 = subset.getFullGid(i);
                int n3 = this.charset.gid2sid(n2);
                if (n3 <= n) continue;
                n = n3;
            }
            Dict.streamKeyVal(cFFByteArrayBuilder, Dict.Key.CIDCount, n + 1);
        } else {
            this.topDict.streamValue(cFFByteArrayBuilder, list, Dict.Key.CIDCount);
        }
    }

    private void setPSString(CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder, Integer n, List list) {
        OrigFontType origFontType;
        String string = null;
        if (n == null) {
            n = this.topDict.getFSType();
        }
        if (n != null) {
            string = "/FSType " + n.toString() + " def ";
        }
        if ((origFontType = this.topDict.getOrigFontType()) != null) {
            string = string != null ? string + " /OrigFontType /" + origFontType.toString() + " def" : "/OrigFontType /" + origFontType.toString() + " def";
        }
        if (string != null) {
            if (list.indexOf(string) == -1) {
                list.add(string);
            }
            Dict.streamKeyVal(cFFByteArrayBuilder, Dict.Key.PostScript, string, list);
        }
    }

    private boolean checkSubrizeLimit(Subset subset) throws InvalidFontException, UnsupportedFontException {
        int n = this.charStrings.data.getSize();
        if (n <= 614400) {
            return true;
        }
        if (subset == null) {
            return false;
        }
        return (double)n * (double)subset.getNumGlyphs() <= 614400.0 * (double)this.getNumGlyphs();
    }

    public void subsetAndStream(Subset subset, OutputStream outputStream, boolean bl, Integer n) throws InvalidFontException, UnsupportedFontException, IOException {
        this.subsetAndStream(subset, outputStream, bl, n, false, true);
    }

    public void subsetAndStream(Subset subset, OutputStream outputStream, boolean bl, Integer n, boolean bl2) throws InvalidFontException, UnsupportedFontException, IOException {
        this.subsetAndStream(subset, outputStream, bl, n, bl2, true);
    }

    public void subsetAndStream(Subset subset, OutputStream outputStream, boolean bl, Integer n, boolean bl2, boolean bl3) throws InvalidFontException, UnsupportedFontException, IOException {
        int n2;
        Object[] objectArray;
        int n3;
        boolean bl4 = !(subset instanceof SubsetDefaultImpl) || ((SubsetDefaultImpl)subset).doSubset() || bl2;
        List list = StringIndex.collectPredefinedStrings();
        this.topDict.collectStrings(list);
        Dict.StringValue stringValue = this.topDict.get(Dict.StringKey.PostScript, false);
        if (stringValue != null) {
            list.remove(list.indexOf(stringValue.value));
        }
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].collectStrings(list);
        }
        CFFByteArray.CFFByteArrayBuilder cFFByteArrayBuilder = CFFByteArray.getCFFByteArrayBuilderInstance();
        Header.toBinary(cFFByteArrayBuilder);
        NameIndex.toBinary(cFFByteArrayBuilder, this.name);
        Index.Cursor cursor = Index.startIndex(cFFByteArrayBuilder, 1);
        if (bl || !bl3) {
            this.topDict.streamValue(cFFByteArrayBuilder, list, Dict.Key.ROS);
        } else {
            Dict.ROSValue rOSValue = new Dict.ROSValue("Adobe", "Identity", 1);
            rOSValue.collectStrings(list);
            rOSValue.stream(cFFByteArrayBuilder, list);
            Dict.Key.ROS.stream(cFFByteArrayBuilder);
        }
        this.topDict.stream(cFFByteArrayBuilder, list, topDictKeysForSubset);
        this.setCIDCount(bl, cFFByteArrayBuilder, subset, bl4, list);
        this.setPSString(cFFByteArrayBuilder, n, list);
        int n4 = Dict.Key.FDArray.streamDummyValue(cFFByteArrayBuilder);
        int n5 = Dict.Key.FDSelect.streamDummyValue(cFFByteArrayBuilder);
        int n6 = this.charset.predefinedOffset();
        if (bl4 || !bl) {
            n3 = Dict.Key.charset.streamDummyValue(cFFByteArrayBuilder);
        } else if (n6 != -1) {
            new Dict.IntegerValue(n6).stream(cFFByteArrayBuilder, null);
            n3 = -1;
        } else {
            n3 = Dict.Key.charset.streamDummyValue(cFFByteArrayBuilder);
        }
        int n7 = Dict.Key.CharStrings.streamDummyValue(cFFByteArrayBuilder);
        cursor = Index.elementEntered(cFFByteArrayBuilder, cursor);
        StringIndex.toBinary(cFFByteArrayBuilder, list);
        CFFSubrize cFFSubrize = null;
        CharStrings charStrings = null;
        CharStrings charStrings2 = null;
        if (!bl4 || !bl3) {
            if (this.globalSubrs != null) {
                this.globalSubrs.stream(cFFByteArrayBuilder);
            } else {
                cFFByteArrayBuilder.addCard16(0);
            }
        } else {
            if (bl2) {
                bl2 = this.checkSubrizeLimit(subset);
            }
            charStrings = this.createSubsetCharstringIndex(subset, bl2);
            if (bl2) {
                objectArray = new byte[subset.getNumGlyphs()];
                for (n2 = 0; n2 < subset.getNumGlyphs(); ++n2) {
                    objectArray[n2] = (byte)this.getFDForGlyph(subset.getFullGid(n2));
                }
                cFFSubrize = new CFFSubrize();
                charStrings = cFFSubrize.subrize(charStrings, (byte[])objectArray);
                charStrings2 = cFFSubrize.getGSubrs();
                if (charStrings2 == null) {
                    charStrings2 = CharStrings.createEmptyCharstrings();
                }
                charStrings2.stream(cFFByteArrayBuilder);
            } else {
                cFFByteArrayBuilder.addCard16(0);
            }
        }
        Dict.Key.FDArray.fixOffset(cFFByteArrayBuilder, n4, cFFByteArrayBuilder.getSize());
        objectArray = new int[this.components.length];
        cursor = Index.startIndex(cFFByteArrayBuilder, this.components.length);
        for (n2 = 0; n2 < this.components.length; ++n2) {
            this.components[n2].fontDict.stream(cFFByteArrayBuilder, list, fontDictKeysForSubset);
            objectArray[n2] = Dict.Key.Private.streamDummyValue(cFFByteArrayBuilder);
            cursor = Index.elementEntered(cFFByteArrayBuilder, cursor);
        }
        for (n2 = 0; n2 < this.components.length; ++n2) {
            CharStrings charStrings3 = null;
            if (cFFSubrize != null && (charStrings3 = cFFSubrize.getLSubrs(n2)) == null) {
                charStrings3 = CharStrings.createEmptyCharstrings();
            }
            Dict.Key.Private.fixOffset(cFFByteArrayBuilder, objectArray[n2], cFFByteArrayBuilder.getSize());
            int n8 = cFFByteArrayBuilder.getSize();
            this.components[n2].privateDict.stream(cFFByteArrayBuilder, list, privateDictKeysForSubset);
            int n9 = 0;
            if (charStrings3 != null || (!bl4 || !bl3) && this.components[n2].localSubrs != null) {
                n9 = Dict.Key.Subrs.streamDummyValue(cFFByteArrayBuilder);
            }
            int n10 = cFFByteArrayBuilder.getSize() - n8;
            Dict.Key.Private.fixSize(cFFByteArrayBuilder, objectArray[n2], n10);
            if (charStrings3 == null && (bl4 && bl3 || this.components[n2].localSubrs == null)) continue;
            Dict.Key.Subrs.fixOffset(cFFByteArrayBuilder, n9, cFFByteArrayBuilder.getSize() - n8);
            if (charStrings3 != null) {
                charStrings3.stream(cFFByteArrayBuilder);
                continue;
            }
            this.components[n2].localSubrs.stream(cFFByteArrayBuilder);
        }
        Dict.Key.FDSelect.fixOffset(cFFByteArrayBuilder, n5, cFFByteArrayBuilder.getSize());
        if (!bl4 || !bl3) {
            this.fdSelect.stream(cFFByteArrayBuilder);
        } else if (this.components.length > 1) {
            FdSelect.fdSelectFromSubset(this.fdSelect, subset).stream(cFFByteArrayBuilder);
        } else {
            FdSelect.singleFont(subset.getNumGlyphs()).stream(cFFByteArrayBuilder);
        }
        if (n3 != -1) {
            Dict.Key.charset.fixOffset(cFFByteArrayBuilder, n3, cFFByteArrayBuilder.getSize());
            if (!bl4 && bl || !bl3) {
                this.charset.stream(cFFByteArrayBuilder);
            } else if (!bl) {
                Charset.identityCharset(subset.getNumGlyphs()).stream(cFFByteArrayBuilder);
            } else {
                Charset.charSetFromSubset(this.charset, subset).stream(cFFByteArrayBuilder);
            }
        }
        Dict.Key.CharStrings.fixOffset(cFFByteArrayBuilder, n7, cFFByteArrayBuilder.getSize());
        if (!bl4 || !bl3) {
            this.charStrings.stream(cFFByteArrayBuilder);
        } else {
            charStrings.stream(cFFByteArrayBuilder);
        }
        CFFByteArray cFFByteArray = cFFByteArrayBuilder.toCFFByteArray();
        cFFByteArray.write(outputStream);
    }

    public PDFFontDescription getPDFFontDescription(Font font) throws UnsupportedFontException, InvalidFontException {
        return this.xdcDescription;
    }

    public XDCFontDescription getXDCFontDescription(Font font) throws UnsupportedFontException, InvalidFontException {
        return this.xdcDescription;
    }

    public void stream(OutputStream outputStream, Integer n) throws InvalidFontException, UnsupportedFontException, IOException {
        SubsetDefaultImpl subsetDefaultImpl = new SubsetDefaultImpl(this.getNumGlyphs(), false);
        this.subsetAndStream(subsetDefaultImpl, outputStream, true, n);
    }

    private class CIDKeyedFontXDCFontDescription
    extends CFFFont.CFFFontXDCFontDescription {
        private CIDKeyedFontXDCFontDescription() {
        }

        public void subsetAndStream(Subset subset, OutputStream outputStream, boolean bl) throws InvalidFontException, UnsupportedFontException, IOException {
            CIDKeyedFont.this.subsetAndStream(subset, outputStream, bl);
        }

        public void stream(OutputStream outputStream, boolean bl) throws InvalidFontException, UnsupportedFontException, IOException {
            CIDKeyedFont.this.stream(outputStream, null);
        }

        public void subsetAndStream(SubsetSimpleType1 subsetSimpleType1, OutputStream outputStream) throws UnsupportedFontException {
            throw new UnsupportedFontException("Not a name-keyed font");
        }

        public void subsetAndStream(SubsetSimpleTrueType subsetSimpleTrueType, OutputStream outputStream) throws UnsupportedFontException {
            throw new UnsupportedFontException("Not a TrueType font");
        }

        public CodePage[] getXDCCodePages() throws InvalidFontException, UnsupportedFontException {
            HashSet<CodePage> hashSet = new HashSet<CodePage>();
            ROS rOS = this.getROS();
            if (rOS != null && rOS.registry.equals("Adobe")) {
                if (rOS.ordering.equals("Japan1") || rOS.ordering.equals("Japan2")) {
                    hashSet.add(CodePage.JAPANESE);
                } else if (rOS.ordering.equals("Korea1")) {
                    hashSet.add(CodePage.KOREAN);
                } else if (rOS.ordering.equals("GB1")) {
                    hashSet.add(CodePage.SIMPLIFIED_CHINESE);
                } else if (rOS.ordering.equals("CNS1")) {
                    hashSet.add(CodePage.TRADITIONAL_CHINESE);
                }
            }
            CodePage[] codePageArray = new CodePage[hashSet.size()];
            Iterator iterator = hashSet.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                codePageArray[n++] = (CodePage)iterator.next();
            }
            return codePageArray;
        }

        public int getCIDCount() {
            return CIDKeyedFont.this.getCIDCount();
        }
    }
}

