/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine;

import com.adobe.agl.charset.CharsetICU;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.util.concurrent.ConcurrentHashMap;

public class CharsetUtil {
    private static ConcurrentHashMap<String, Charset> charSetMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer, CharsetEncoder charsetEncoder, boolean bl) throws MalformedInputException, UnmappableCharacterException {
        CoderResult coderResult = null;
        try {
            coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true);
            if ((coderResult.isMalformed() || !coderResult.isError()) && (coderResult = charsetEncoder.flush(byteBuffer)).isError() && !coderResult.isUnderflow()) {
                CharsetUtil.conditionallyThrowCodingError(coderResult);
            }
            CharsetUtil.conditionallyThrowCodingError(coderResult);
        }
        catch (MalformedInputException malformedInputException) {
            if (bl) {
                throw malformedInputException;
            }
        }
        catch (UnmappableCharacterException unmappableCharacterException) {
            if (bl) {
                throw unmappableCharacterException;
            }
        }
        return coderResult;
    }

    public static CoderResult encodeLoopNoExceptions(CharBuffer charBuffer, ByteBuffer byteBuffer, CharsetEncoder charsetEncoder) {
        CoderResult coderResult = null;
        try {
            coderResult = CharsetUtil.encodeLoop(charBuffer, byteBuffer, charsetEncoder, false);
        }
        catch (MalformedInputException malformedInputException) {
        }
        catch (UnmappableCharacterException unmappableCharacterException) {
            // empty catch block
        }
        return coderResult;
    }

    public static CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer, Charset charset, boolean bl) throws MalformedInputException, UnmappableCharacterException {
        CharsetEncoder charsetEncoder = charset.newEncoder();
        return CharsetUtil.encodeLoop(charBuffer, byteBuffer, charsetEncoder, bl);
    }

    public static CoderResult encodeLoopNoExceptions(CharBuffer charBuffer, ByteBuffer byteBuffer, Charset charset) throws MalformedInputException, UnmappableCharacterException {
        CharsetEncoder charsetEncoder = charset.newEncoder();
        return CharsetUtil.encodeLoopNoExceptions(charBuffer, byteBuffer, charsetEncoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer, CharsetDecoder charsetDecoder, boolean bl) throws MalformedInputException, UnmappableCharacterException {
        CoderResult coderResult = null;
        try {
            coderResult = charsetDecoder.decode(byteBuffer, charBuffer, true);
            CharsetUtil.conditionallyThrowCodingError(coderResult);
            coderResult = charsetDecoder.flush(charBuffer);
            CharsetUtil.conditionallyThrowCodingError(coderResult);
            charsetDecoder.reset();
        }
        catch (MalformedInputException malformedInputException) {
            if (bl) {
                throw malformedInputException;
            }
        }
        catch (UnmappableCharacterException unmappableCharacterException) {
            if (bl) {
                throw unmappableCharacterException;
            }
        }
        return coderResult;
    }

    public static CoderResult decodeLoopNoExceptions(ByteBuffer byteBuffer, CharBuffer charBuffer, CharsetDecoder charsetDecoder) {
        CoderResult coderResult = null;
        try {
            coderResult = CharsetUtil.decodeLoop(byteBuffer, charBuffer, charsetDecoder, false);
        }
        catch (MalformedInputException malformedInputException) {
        }
        catch (UnmappableCharacterException unmappableCharacterException) {
            // empty catch block
        }
        return coderResult;
    }

    public static CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer, Charset charset, boolean bl) throws MalformedInputException, UnmappableCharacterException {
        CharsetDecoder charsetDecoder = charset.newDecoder();
        return CharsetUtil.decodeLoop(byteBuffer, charBuffer, charsetDecoder, bl);
    }

    public static CoderResult decodeLoopNoExceptions(ByteBuffer byteBuffer, CharBuffer charBuffer, Charset charset) throws MalformedInputException, UnmappableCharacterException {
        CharsetDecoder charsetDecoder = charset.newDecoder();
        return CharsetUtil.decodeLoopNoExceptions(byteBuffer, charBuffer, charsetDecoder);
    }

    public static void conditionallyThrowCodingError(CoderResult coderResult) throws MalformedInputException, UnmappableCharacterException {
        if (coderResult.isError()) {
            if (coderResult.isMalformed()) {
                throw new MalformedInputException(coderResult.length());
            }
            if (coderResult.isOverflow()) {
                // empty if block
            }
            if (coderResult.isUnmappable()) {
                throw new UnmappableCharacterException(coderResult.length());
            }
            if (coderResult.isUnderflow()) {
                // empty if block
            }
        }
    }

    public static Charset forNameICU(String string) {
        Charset charset;
        if (string == null) {
            return null;
        }
        Charset charset2 = charSetMap.get(string);
        if (charset2 == null && (charset = charSetMap.putIfAbsent(string, charset2 = CharsetICU.forNameICU((String)string))) != null) {
            charset2 = charset;
        }
        return charset2;
    }
}

