/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.structurals;

import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import org.apache.bcel.verifier.structurals.UninitializedObjectType;

public class LocalVariables {
    private Type[] locals;

    public LocalVariables(int maxLocals) {
        this.locals = new Type[maxLocals];
        for (int i2 = 0; i2 < maxLocals; ++i2) {
            this.locals[i2] = Type.UNKNOWN;
        }
    }

    protected Object clone() {
        LocalVariables lvs = new LocalVariables(this.locals.length);
        for (int i2 = 0; i2 < this.locals.length; ++i2) {
            lvs.locals[i2] = this.locals[i2];
        }
        return lvs;
    }

    public Type get(int i2) {
        return this.locals[i2];
    }

    public LocalVariables getClone() {
        return (LocalVariables)this.clone();
    }

    public int maxLocals() {
        return this.locals.length;
    }

    public void set(int i2, Type type) {
        if (type == Type.BYTE || type == Type.SHORT || type == Type.BOOLEAN || type == Type.CHAR) {
            throw new AssertionViolatedException("LocalVariables do not know about '" + type + "'. Use Type.INT instead.");
        }
        this.locals[i2] = type;
    }

    public int hashCode() {
        return this.locals.length;
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof LocalVariables)) {
            return false;
        }
        LocalVariables lv = (LocalVariables)o2;
        if (this.locals.length != lv.locals.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.locals.length; ++i2) {
            if (this.locals[i2].equals(lv.locals[i2])) continue;
            return false;
        }
        return true;
    }

    public void merge(LocalVariables lv) {
        if (this.locals.length != lv.locals.length) {
            throw new AssertionViolatedException("Merging LocalVariables of different size?!? From different methods or what?!?");
        }
        for (int i2 = 0; i2 < this.locals.length; ++i2) {
            this.merge(lv, i2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void merge(LocalVariables lv, int i2) {
        try {
            if (!(this.locals[i2] instanceof UninitializedObjectType) && lv.locals[i2] instanceof UninitializedObjectType) {
                throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object in the local variables detected.");
            }
            if (!this.locals[i2].equals(lv.locals[i2]) && this.locals[i2] instanceof UninitializedObjectType && lv.locals[i2] instanceof UninitializedObjectType) {
                throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object in the local variables detected.");
            }
            if (this.locals[i2] instanceof UninitializedObjectType && !(lv.locals[i2] instanceof UninitializedObjectType)) {
                this.locals[i2] = ((UninitializedObjectType)this.locals[i2]).getInitialized();
            }
            if (this.locals[i2] instanceof ReferenceType && lv.locals[i2] instanceof ReferenceType) {
                if (this.locals[i2].equals(lv.locals[i2])) return;
                ReferenceType sup = ((ReferenceType)this.locals[i2]).getFirstCommonSuperclass((ReferenceType)lv.locals[i2]);
                if (sup == null) throw new AssertionViolatedException("Could not load all the super classes of '" + this.locals[i2] + "' and '" + lv.locals[i2] + "'.");
                this.locals[i2] = sup;
                return;
            } else {
                if (this.locals[i2].equals(lv.locals[i2])) return;
                this.locals[i2] = Type.UNKNOWN;
            }
            return;
        }
        catch (ClassNotFoundException e2) {
            throw new AssertionViolatedException("Missing class: " + e2.toString());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < this.locals.length; ++i2) {
            sb.append(Integer.toString(i2));
            sb.append(": ");
            sb.append(this.locals[i2]);
            sb.append("\n");
        }
        return sb.toString();
    }

    public void initializeObject(UninitializedObjectType u2) {
        for (int i2 = 0; i2 < this.locals.length; ++i2) {
            if (this.locals[i2] != u2) continue;
            this.locals[i2] = u2.getInitialized();
        }
    }
}

