/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.structurals;

import org.apache.bcel.Repository;
import org.apache.bcel.classfile.AccessFlags;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.AALOAD;
import org.apache.bcel.generic.AASTORE;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.ARRAYLENGTH;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BALOAD;
import org.apache.bcel.generic.BASTORE;
import org.apache.bcel.generic.BIPUSH;
import org.apache.bcel.generic.BREAKPOINT;
import org.apache.bcel.generic.CALOAD;
import org.apache.bcel.generic.CASTORE;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.CPInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.D2F;
import org.apache.bcel.generic.D2I;
import org.apache.bcel.generic.D2L;
import org.apache.bcel.generic.DADD;
import org.apache.bcel.generic.DALOAD;
import org.apache.bcel.generic.DASTORE;
import org.apache.bcel.generic.DCMPG;
import org.apache.bcel.generic.DCMPL;
import org.apache.bcel.generic.DCONST;
import org.apache.bcel.generic.DDIV;
import org.apache.bcel.generic.DLOAD;
import org.apache.bcel.generic.DMUL;
import org.apache.bcel.generic.DNEG;
import org.apache.bcel.generic.DREM;
import org.apache.bcel.generic.DRETURN;
import org.apache.bcel.generic.DSTORE;
import org.apache.bcel.generic.DSUB;
import org.apache.bcel.generic.DUP;
import org.apache.bcel.generic.DUP2;
import org.apache.bcel.generic.DUP2_X1;
import org.apache.bcel.generic.DUP2_X2;
import org.apache.bcel.generic.DUP_X1;
import org.apache.bcel.generic.DUP_X2;
import org.apache.bcel.generic.EmptyVisitor;
import org.apache.bcel.generic.F2D;
import org.apache.bcel.generic.F2I;
import org.apache.bcel.generic.F2L;
import org.apache.bcel.generic.FADD;
import org.apache.bcel.generic.FALOAD;
import org.apache.bcel.generic.FASTORE;
import org.apache.bcel.generic.FCMPG;
import org.apache.bcel.generic.FCMPL;
import org.apache.bcel.generic.FCONST;
import org.apache.bcel.generic.FDIV;
import org.apache.bcel.generic.FLOAD;
import org.apache.bcel.generic.FMUL;
import org.apache.bcel.generic.FNEG;
import org.apache.bcel.generic.FREM;
import org.apache.bcel.generic.FRETURN;
import org.apache.bcel.generic.FSTORE;
import org.apache.bcel.generic.FSUB;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.GOTO_W;
import org.apache.bcel.generic.I2B;
import org.apache.bcel.generic.I2C;
import org.apache.bcel.generic.I2D;
import org.apache.bcel.generic.I2F;
import org.apache.bcel.generic.I2L;
import org.apache.bcel.generic.I2S;
import org.apache.bcel.generic.IADD;
import org.apache.bcel.generic.IALOAD;
import org.apache.bcel.generic.IAND;
import org.apache.bcel.generic.IASTORE;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.IDIV;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IFGE;
import org.apache.bcel.generic.IFGT;
import org.apache.bcel.generic.IFLE;
import org.apache.bcel.generic.IFLT;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.IF_ACMPEQ;
import org.apache.bcel.generic.IF_ACMPNE;
import org.apache.bcel.generic.IF_ICMPEQ;
import org.apache.bcel.generic.IF_ICMPGE;
import org.apache.bcel.generic.IF_ICMPGT;
import org.apache.bcel.generic.IF_ICMPLE;
import org.apache.bcel.generic.IF_ICMPLT;
import org.apache.bcel.generic.IF_ICMPNE;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.IMPDEP1;
import org.apache.bcel.generic.IMPDEP2;
import org.apache.bcel.generic.IMUL;
import org.apache.bcel.generic.INEG;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.IOR;
import org.apache.bcel.generic.IREM;
import org.apache.bcel.generic.IRETURN;
import org.apache.bcel.generic.ISHL;
import org.apache.bcel.generic.ISHR;
import org.apache.bcel.generic.ISTORE;
import org.apache.bcel.generic.ISUB;
import org.apache.bcel.generic.IUSHR;
import org.apache.bcel.generic.IXOR;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.JSR;
import org.apache.bcel.generic.JSR_W;
import org.apache.bcel.generic.L2D;
import org.apache.bcel.generic.L2F;
import org.apache.bcel.generic.L2I;
import org.apache.bcel.generic.LADD;
import org.apache.bcel.generic.LALOAD;
import org.apache.bcel.generic.LAND;
import org.apache.bcel.generic.LASTORE;
import org.apache.bcel.generic.LCMP;
import org.apache.bcel.generic.LCONST;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.LDC_W;
import org.apache.bcel.generic.LDIV;
import org.apache.bcel.generic.LLOAD;
import org.apache.bcel.generic.LMUL;
import org.apache.bcel.generic.LNEG;
import org.apache.bcel.generic.LOOKUPSWITCH;
import org.apache.bcel.generic.LOR;
import org.apache.bcel.generic.LREM;
import org.apache.bcel.generic.LRETURN;
import org.apache.bcel.generic.LSHL;
import org.apache.bcel.generic.LSHR;
import org.apache.bcel.generic.LSTORE;
import org.apache.bcel.generic.LSUB;
import org.apache.bcel.generic.LUSHR;
import org.apache.bcel.generic.LXOR;
import org.apache.bcel.generic.LoadClass;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MONITORENTER;
import org.apache.bcel.generic.MONITOREXIT;
import org.apache.bcel.generic.MULTIANEWARRAY;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.POP;
import org.apache.bcel.generic.POP2;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.PUTSTATIC;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.RETURN;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.ReturnaddressType;
import org.apache.bcel.generic.SALOAD;
import org.apache.bcel.generic.SASTORE;
import org.apache.bcel.generic.SIPUSH;
import org.apache.bcel.generic.SWAP;
import org.apache.bcel.generic.StackConsumer;
import org.apache.bcel.generic.StackInstruction;
import org.apache.bcel.generic.StackProducer;
import org.apache.bcel.generic.StoreInstruction;
import org.apache.bcel.generic.TABLESWITCH;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.Visitor;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.Verifier;
import org.apache.bcel.verifier.VerifierFactory;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import org.apache.bcel.verifier.structurals.Frame;
import org.apache.bcel.verifier.structurals.LocalVariables;
import org.apache.bcel.verifier.structurals.OperandStack;
import org.apache.bcel.verifier.structurals.UninitializedObjectType;

public class InstConstraintVisitor
extends EmptyVisitor
implements Visitor {
    private static ObjectType GENERIC_ARRAY = new ObjectType("org.apache.bcel.verifier.structurals.GenericArray");
    private Frame frame = null;
    private ConstantPoolGen cpg = null;
    private MethodGen mg = null;

    private OperandStack stack() {
        return this.frame.getStack();
    }

    private LocalVariables locals() {
        return this.frame.getLocals();
    }

    private void constraintViolated(Instruction violator, String description) {
        String fq_classname = violator.getClass().getName();
        throw new StructuralCodeConstraintException("Instruction " + fq_classname.substring(fq_classname.lastIndexOf(46) + 1) + " constraint violated: " + description);
    }

    public void setFrame(Frame f2) {
        this.frame = f2;
    }

    public void setConstantPoolGen(ConstantPoolGen cpg) {
        this.cpg = cpg;
    }

    public void setMethodGen(MethodGen mg) {
        this.mg = mg;
    }

    private void indexOfInt(Instruction o2, Type index) {
        if (!index.equals(Type.INT)) {
            this.constraintViolated(o2, "The 'index' is not of type int but of type " + index + ".");
        }
    }

    private void referenceTypeIsInitialized(Instruction o2, ReferenceType r2) {
        if (r2 instanceof UninitializedObjectType) {
            this.constraintViolated(o2, "Working on an uninitialized object '" + r2 + "'.");
        }
    }

    private void valueOfInt(Instruction o2, Type value) {
        if (!value.equals(Type.INT)) {
            this.constraintViolated(o2, "The 'value' is not of type int but of type " + value + ".");
        }
    }

    private boolean arrayrefOfArrayType(Instruction o2, Type arrayref) {
        if (!(arrayref instanceof ArrayType) && !arrayref.equals(Type.NULL)) {
            this.constraintViolated(o2, "The 'arrayref' does not refer to an array but is of type " + arrayref + ".");
        }
        return arrayref instanceof ArrayType;
    }

    private void _visitStackAccessor(Instruction o2) {
        int produce;
        int consume = o2.consumeStack(this.cpg);
        if (consume > this.stack().slotsUsed()) {
            this.constraintViolated(o2, "Cannot consume " + consume + " stack slots: only " + this.stack().slotsUsed() + " slot(s) left on stack!\nStack:\n" + this.stack());
        }
        if ((produce = o2.produceStack(this.cpg) - o2.consumeStack(this.cpg)) + this.stack().slotsUsed() > this.stack().maxStack()) {
            this.constraintViolated(o2, "Cannot produce " + produce + " stack slots: only " + (this.stack().maxStack() - this.stack().slotsUsed()) + " free stack slot(s) left.\nStack:\n" + this.stack());
        }
    }

    public void visitLoadClass(LoadClass o2) {
        Verifier v2;
        VerificationResult vr;
        ObjectType t2 = o2.getLoadClassType(this.cpg);
        if (t2 != null && (vr = (v2 = VerifierFactory.getVerifier(t2.getClassName())).doPass2()).getStatus() != 1) {
            this.constraintViolated((Instruction)((Object)o2), "Class '" + o2.getLoadClassType(this.cpg).getClassName() + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
        }
    }

    public void visitStackConsumer(StackConsumer o2) {
        this._visitStackAccessor((Instruction)((Object)o2));
    }

    public void visitStackProducer(StackProducer o2) {
        this._visitStackAccessor((Instruction)((Object)o2));
    }

    public void visitCPInstruction(CPInstruction o2) {
        int idx = o2.getIndex();
        if (idx < 0 || idx >= this.cpg.getSize()) {
            throw new AssertionViolatedException("Huh?! Constant pool index of instruction '" + o2 + "' illegal? Pass 3a should have checked this!");
        }
    }

    public void visitFieldInstruction(FieldInstruction o2) {
        String name;
        Verifier v2;
        VerificationResult vr;
        Type t2;
        Constant c2 = this.cpg.getConstant(o2.getIndex());
        if (!(c2 instanceof ConstantFieldref)) {
            this.constraintViolated(o2, "Index '" + o2.getIndex() + "' should refer to a CONSTANT_Fieldref_info structure, but refers to '" + c2 + "'.");
        }
        if ((t2 = o2.getType(this.cpg)) instanceof ObjectType && (vr = (v2 = VerifierFactory.getVerifier(name = ((ObjectType)t2).getClassName())).doPass2()).getStatus() != 1) {
            this.constraintViolated(o2, "Class '" + name + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
        }
    }

    public void visitInvokeInstruction(InvokeInstruction o2) {
    }

    public void visitStackInstruction(StackInstruction o2) {
        this._visitStackAccessor(o2);
    }

    public void visitLocalVariableInstruction(LocalVariableInstruction o2) {
        if (this.locals().maxLocals() <= (o2.getType(this.cpg).getSize() == 1 ? o2.getIndex() : o2.getIndex() + 1)) {
            this.constraintViolated(o2, "The 'index' is not a valid index into the local variable array.");
        }
    }

    public void visitLoadInstruction(LoadInstruction o2) {
        if (this.locals().get(o2.getIndex()) == Type.UNKNOWN) {
            this.constraintViolated(o2, "Read-Access on local variable " + o2.getIndex() + " with unknown content.");
        }
        if (o2.getType(this.cpg).getSize() == 2 && this.locals().get(o2.getIndex() + 1) != Type.UNKNOWN) {
            this.constraintViolated(o2, "Reading a two-locals value from local variables " + o2.getIndex() + " and " + (o2.getIndex() + 1) + " where the latter one is destroyed.");
        }
        if (!(o2 instanceof ALOAD)) {
            if (this.locals().get(o2.getIndex()) != o2.getType(this.cpg)) {
                this.constraintViolated(o2, "Local Variable type and LOADing Instruction type mismatch: Local Variable: '" + this.locals().get(o2.getIndex()) + "'; Instruction type: '" + o2.getType(this.cpg) + "'.");
            }
        } else if (!(this.locals().get(o2.getIndex()) instanceof ReferenceType)) {
            this.constraintViolated(o2, "Local Variable type and LOADing Instruction type mismatch: Local Variable: '" + this.locals().get(o2.getIndex()) + "'; Instruction expects a ReferenceType.");
        }
        if (this.stack().maxStack() - this.stack().slotsUsed() < o2.getType(this.cpg).getSize()) {
            this.constraintViolated(o2, "Not enough free stack slots to load a '" + o2.getType(this.cpg) + "' onto the OperandStack.");
        }
    }

    public void visitStoreInstruction(StoreInstruction o2) {
        if (this.stack().isEmpty()) {
            this.constraintViolated(o2, "Cannot STORE: Stack to read from is empty.");
        }
        if (!(o2 instanceof ASTORE)) {
            if (this.stack().peek() != o2.getType(this.cpg)) {
                this.constraintViolated(o2, "Stack top type and STOREing Instruction type mismatch: Stack top: '" + this.stack().peek() + "'; Instruction type: '" + o2.getType(this.cpg) + "'.");
            }
        } else {
            Type stacktop = this.stack().peek();
            if (!(stacktop instanceof ReferenceType) && !(stacktop instanceof ReturnaddressType)) {
                this.constraintViolated(o2, "Stack top type and STOREing Instruction type mismatch: Stack top: '" + this.stack().peek() + "'; Instruction expects a ReferenceType or a ReturnadressType.");
            }
        }
    }

    public void visitReturnInstruction(ReturnInstruction o2) {
        Type method_type = this.mg.getType();
        if (method_type == Type.BOOLEAN || method_type == Type.BYTE || method_type == Type.SHORT || method_type == Type.CHAR) {
            method_type = Type.INT;
        }
        if (o2 instanceof RETURN) {
            if (method_type != Type.VOID) {
                this.constraintViolated(o2, "RETURN instruction in non-void method.");
            } else {
                return;
            }
        }
        if (o2 instanceof ARETURN) {
            if (this.stack().peek() == Type.NULL) {
                return;
            }
            if (!(this.stack().peek() instanceof ReferenceType)) {
                this.constraintViolated(o2, "Reference type expected on top of stack, but is: '" + this.stack().peek() + "'.");
            }
            this.referenceTypeIsInitialized(o2, (ReferenceType)this.stack().peek());
        } else if (!method_type.equals(this.stack().peek())) {
            this.constraintViolated(o2, "Current method has return type of '" + this.mg.getType() + "' expecting a '" + method_type + "' on top of the stack. But stack top is a '" + this.stack().peek() + "'.");
        }
    }

    public void visitAALOAD(AALOAD o2) {
        Type arrayref = this.stack().peek(1);
        Type index = this.stack().peek(0);
        this.indexOfInt(o2, index);
        if (this.arrayrefOfArrayType(o2, arrayref) && !(((ArrayType)arrayref).getElementType() instanceof ReferenceType)) {
            this.constraintViolated(o2, "The 'arrayref' does not refer to an array with elements of a ReferenceType but to an array of " + ((ArrayType)arrayref).getElementType() + ".");
        }
    }

    public void visitAASTORE(AASTORE o2) {
        try {
            Type arrayref = this.stack().peek(2);
            Type index = this.stack().peek(1);
            Type value = this.stack().peek(0);
            this.indexOfInt(o2, index);
            if (!(value instanceof ReferenceType)) {
                this.constraintViolated(o2, "The 'value' is not of a ReferenceType but of type " + value + ".");
            }
            if (this.arrayrefOfArrayType(o2, arrayref)) {
                if (!(((ArrayType)arrayref).getElementType() instanceof ReferenceType)) {
                    this.constraintViolated(o2, "The 'arrayref' does not refer to an array with elements of a ReferenceType but to an array of " + ((ArrayType)arrayref).getElementType() + ".");
                }
                if (!((ReferenceType)value).isAssignmentCompatibleWith((ReferenceType)((ArrayType)arrayref).getElementType())) {
                    this.constraintViolated(o2, "The type of 'value' ('" + value + "') is not assignment compatible to the components of the array 'arrayref' refers to. ('" + ((ArrayType)arrayref).getElementType() + "')");
                }
            }
        }
        catch (ClassNotFoundException e2) {
            throw new AssertionViolatedException("Missing class: " + e2.toString());
        }
    }

    public void visitACONST_NULL(ACONST_NULL o2) {
    }

    public void visitALOAD(ALOAD o2) {
    }

    public void visitANEWARRAY(ANEWARRAY o2) {
        if (!this.stack().peek().equals(Type.INT)) {
            this.constraintViolated(o2, "The 'count' at the stack top is not of type '" + Type.INT + "' but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitARETURN(ARETURN o2) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o2, "The 'objectref' at the stack top is not of a ReferenceType but of type '" + this.stack().peek() + "'.");
        }
        ReferenceType objectref = (ReferenceType)this.stack().peek();
        this.referenceTypeIsInitialized(o2, objectref);
    }

    public void visitARRAYLENGTH(ARRAYLENGTH o2) {
        Type arrayref = this.stack().peek(0);
        this.arrayrefOfArrayType(o2, arrayref);
    }

    public void visitASTORE(ASTORE o2) {
        if (!(this.stack().peek() instanceof ReferenceType) && !(this.stack().peek() instanceof ReturnaddressType)) {
            this.constraintViolated(o2, "The 'objectref' is not of a ReferenceType or of ReturnaddressType but of " + this.stack().peek() + ".");
        }
    }

    public void visitATHROW(ATHROW o2) {
        try {
            ObjectType throwable;
            if (!(this.stack().peek() instanceof ObjectType) && !this.stack().peek().equals(Type.NULL)) {
                this.constraintViolated(o2, "The 'objectref' is not of an (initialized) ObjectType but of type " + this.stack().peek() + ".");
            }
            if (this.stack().peek().equals(Type.NULL)) {
                return;
            }
            ObjectType exc = (ObjectType)this.stack().peek();
            if (!exc.subclassOf(throwable = (ObjectType)Type.getType("Ljava/lang/Throwable;")) && !exc.equals(throwable)) {
                this.constraintViolated(o2, "The 'objectref' is not of class Throwable or of a subclass of Throwable, but of '" + this.stack().peek() + "'.");
            }
        }
        catch (ClassNotFoundException e2) {
            throw new AssertionViolatedException("Missing class: " + e2.toString());
        }
    }

    public void visitBALOAD(BALOAD o2) {
        Type arrayref = this.stack().peek(1);
        Type index = this.stack().peek(0);
        this.indexOfInt(o2, index);
        if (this.arrayrefOfArrayType(o2, arrayref) && !((ArrayType)arrayref).getElementType().equals(Type.BOOLEAN) && !((ArrayType)arrayref).getElementType().equals(Type.BYTE)) {
            this.constraintViolated(o2, "The 'arrayref' does not refer to an array with elements of a Type.BYTE or Type.BOOLEAN but to an array of '" + ((ArrayType)arrayref).getElementType() + "'.");
        }
    }

    public void visitBASTORE(BASTORE o2) {
        Type arrayref = this.stack().peek(2);
        Type index = this.stack().peek(1);
        Type value = this.stack().peek(0);
        this.indexOfInt(o2, index);
        this.valueOfInt(o2, value);
        if (this.arrayrefOfArrayType(o2, arrayref) && !((ArrayType)arrayref).getElementType().equals(Type.BOOLEAN) && !((ArrayType)arrayref).getElementType().equals(Type.BYTE)) {
            this.constraintViolated(o2, "The 'arrayref' does not refer to an array with elements of a Type.BYTE or Type.BOOLEAN but to an array of '" + ((ArrayType)arrayref).getElementType() + "'.");
        }
    }

    public void visitBIPUSH(BIPUSH o2) {
    }

    public void visitBREAKPOINT(BREAKPOINT o2) {
        throw new AssertionViolatedException("In this JustIce verification pass there should not occur an illegal instruction such as BREAKPOINT.");
    }

    public void visitCALOAD(CALOAD o2) {
        Type arrayref = this.stack().peek(1);
        Type index = this.stack().peek(0);
        this.indexOfInt(o2, index);
        this.arrayrefOfArrayType(o2, arrayref);
    }

    public void visitCASTORE(CASTORE o2) {
        Type arrayref = this.stack().peek(2);
        Type index = this.stack().peek(1);
        Type value = this.stack().peek(0);
        this.indexOfInt(o2, index);
        this.valueOfInt(o2, value);
        if (this.arrayrefOfArrayType(o2, arrayref) && !((ArrayType)arrayref).getElementType().equals(Type.CHAR)) {
            this.constraintViolated(o2, "The 'arrayref' does not refer to an array with elements of type char but to an array of type " + ((ArrayType)arrayref).getElementType() + ".");
        }
    }

    public void visitCHECKCAST(CHECKCAST o2) {
        Constant c2;
        Type objectref = this.stack().peek(0);
        if (!(objectref instanceof ReferenceType)) {
            this.constraintViolated(o2, "The 'objectref' is not of a ReferenceType but of type " + objectref + ".");
        }
        if (!((c2 = this.cpg.getConstant(o2.getIndex())) instanceof ConstantClass)) {
            this.constraintViolated(o2, "The Constant at 'index' is not a ConstantClass, but '" + c2 + "'.");
        }
    }

    public void visitD2F(D2F o2) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitD2I(D2I o2) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitD2L(D2L o2) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitDADD(DADD o2) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDALOAD(DALOAD o2) {
        Type t2;
        this.indexOfInt(o2, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(o2, "Stack next-to-top must be of type double[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((t2 = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.DOUBLE) {
            this.constraintViolated(o2, "Stack next-to-top must be of type double[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDASTORE(DASTORE o2) {
        Type t2;
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(o2, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(o2, "Stack next-to-next-to-top must be of type double[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((t2 = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.DOUBLE) {
            this.constraintViolated(o2, "Stack next-to-next-to-top must be of type double[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    public void visitDCMPG(DCMPG o2) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDCMPL(DCMPL o2) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDCONST(DCONST o2) {
    }

    public void visitDDIV(DDIV o2) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDLOAD(DLOAD o2) {
    }

    public void visitDMUL(DMUL o2) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDNEG(DNEG o2) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitDREM(DREM o2) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDRETURN(DRETURN o2) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitDSTORE(DSTORE o2) {
    }

    public void visitDSUB(DSUB o2) {
        if (this.stack().peek() != Type.DOUBLE) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'double', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.DOUBLE) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'double', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitDUP(DUP o2) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(o2, "Won't DUP type on stack top '" + this.stack().peek() + "' because it must occupy exactly one slot, not '" + this.stack().peek().getSize() + "'.");
        }
    }

    public void visitDUP_X1(DUP_X1 o2) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(o2, "Type on stack top '" + this.stack().peek() + "' should occupy exactly one slot, not '" + this.stack().peek().getSize() + "'.");
        }
        if (this.stack().peek(1).getSize() != 1) {
            this.constraintViolated(o2, "Type on stack next-to-top '" + this.stack().peek(1) + "' should occupy exactly one slot, not '" + this.stack().peek(1).getSize() + "'.");
        }
    }

    public void visitDUP_X2(DUP_X2 o2) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(o2, "Stack top type must be of size 1, but is '" + this.stack().peek() + "' of size '" + this.stack().peek().getSize() + "'.");
        }
        if (this.stack().peek(1).getSize() == 2) {
            return;
        }
        if (this.stack().peek(2).getSize() != 1) {
            this.constraintViolated(o2, "If stack top's size is 1 and stack next-to-top's size is 1, stack next-to-next-to-top's size must also be 1, but is: '" + this.stack().peek(2) + "' of size '" + this.stack().peek(2).getSize() + "'.");
        }
    }

    public void visitDUP2(DUP2 o2) {
        if (this.stack().peek().getSize() == 2) {
            return;
        }
        if (this.stack().peek(1).getSize() != 1) {
            this.constraintViolated(o2, "If stack top's size is 1, then stack next-to-top's size must also be 1. But it is '" + this.stack().peek(1) + "' of size '" + this.stack().peek(1).getSize() + "'.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitDUP2_X1(DUP2_X1 o2) {
        if (this.stack().peek().getSize() == 2) {
            if (this.stack().peek(1).getSize() == 1) return;
            this.constraintViolated(o2, "If stack top's size is 2, then stack next-to-top's size must be 1. But it is '" + this.stack().peek(1) + "' of size '" + this.stack().peek(1).getSize() + "'.");
            return;
        } else {
            if (this.stack().peek(1).getSize() != 1) {
                this.constraintViolated(o2, "If stack top's size is 1, then stack next-to-top's size must also be 1. But it is '" + this.stack().peek(1) + "' of size '" + this.stack().peek(1).getSize() + "'.");
            }
            if (this.stack().peek(2).getSize() == 1) return;
            this.constraintViolated(o2, "If stack top's size is 1, then stack next-to-next-to-top's size must also be 1. But it is '" + this.stack().peek(2) + "' of size '" + this.stack().peek(2).getSize() + "'.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitDUP2_X2(DUP2_X2 o2) {
        if (this.stack().peek(0).getSize() == 2) {
            if (this.stack().peek(1).getSize() == 2) {
                return;
            }
            if (this.stack().peek(2).getSize() == 1) return;
            this.constraintViolated(o2, "If stack top's size is 2 and stack-next-to-top's size is 1, then stack next-to-next-to-top's size must also be 1. But it is '" + this.stack().peek(2) + "' of size '" + this.stack().peek(2).getSize() + "'.");
        } else if (this.stack().peek(1).getSize() == 1) {
            if (this.stack().peek(2).getSize() == 2) {
                return;
            }
            if (this.stack().peek(3).getSize() == 1) {
                return;
            }
        }
        this.constraintViolated(o2, "The operand sizes on the stack do not match any of the four forms of usage of this instruction.");
    }

    public void visitF2D(F2D o2) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitF2I(F2I o2) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitF2L(F2L o2) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitFADD(FADD o2) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFALOAD(FALOAD o2) {
        Type t2;
        this.indexOfInt(o2, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(o2, "Stack next-to-top must be of type float[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((t2 = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.FLOAT) {
            this.constraintViolated(o2, "Stack next-to-top must be of type float[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFASTORE(FASTORE o2) {
        Type t2;
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(o2, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(o2, "Stack next-to-next-to-top must be of type float[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((t2 = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.FLOAT) {
            this.constraintViolated(o2, "Stack next-to-next-to-top must be of type float[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    public void visitFCMPG(FCMPG o2) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFCMPL(FCMPL o2) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFCONST(FCONST o2) {
    }

    public void visitFDIV(FDIV o2) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFLOAD(FLOAD o2) {
    }

    public void visitFMUL(FMUL o2) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFNEG(FNEG o2) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitFREM(FREM o2) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitFRETURN(FRETURN o2) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitFSTORE(FSTORE o2) {
    }

    public void visitFSUB(FSUB o2) {
        if (this.stack().peek() != Type.FLOAT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'float', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.FLOAT) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'float', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitGETFIELD(GETFIELD o2) {
        try {
            ObjectType curr;
            ObjectType classtype;
            Type objectref = this.stack().peek();
            if (!(objectref instanceof ObjectType) && objectref != Type.NULL) {
                this.constraintViolated(o2, "Stack top should be an object reference that's not an array reference, but is '" + objectref + "'.");
            }
            String field_name = o2.getFieldName(this.cpg);
            JavaClass jc = Repository.lookupClass(o2.getClassType(this.cpg).getClassName());
            Field[] fields = jc.getFields();
            AccessFlags f2 = null;
            for (int i2 = 0; i2 < fields.length; ++i2) {
                Type o_type;
                Type f_type;
                if (!fields[i2].getName().equals(field_name) || !(f_type = Type.getType(fields[i2].getSignature())).equals(o_type = o2.getType(this.cpg))) continue;
                f2 = fields[i2];
                break;
            }
            if (f2 == null) {
                JavaClass[] superclasses = jc.getSuperClasses();
                block3: for (int j2 = 0; j2 < superclasses.length; ++j2) {
                    fields = superclasses[j2].getFields();
                    for (int i3 = 0; i3 < fields.length; ++i3) {
                        Type o_type;
                        Type f_type;
                        if (!fields[i3].getName().equals(field_name) || !(f_type = Type.getType(fields[i3].getSignature())).equals(o_type = o2.getType(this.cpg))) continue;
                        f2 = fields[i3];
                        if ((f2.getAccessFlags() & 5) != 0) break block3;
                        f2 = null;
                        break block3;
                    }
                }
                if (f2 == null) {
                    throw new AssertionViolatedException("Field '" + field_name + "' not found?!?");
                }
            }
            if (f2.isProtected() && ((classtype = o2.getClassType(this.cpg)).equals(curr = new ObjectType(this.mg.getClassName())) || curr.subclassOf(classtype))) {
                ObjectType objreftype;
                Type t2 = this.stack().peek();
                if (t2 == Type.NULL) {
                    return;
                }
                if (!(t2 instanceof ObjectType)) {
                    this.constraintViolated(o2, "The 'objectref' must refer to an object that's not an array. Found instead: '" + t2 + "'.");
                }
                if ((objreftype = (ObjectType)t2).equals(curr) || !objreftype.subclassOf(curr)) {
                    // empty if block
                }
            }
            if (f2.isStatic()) {
                this.constraintViolated(o2, "Referenced field '" + f2 + "' is static which it shouldn't be.");
            }
        }
        catch (ClassNotFoundException e2) {
            throw new AssertionViolatedException("Missing class: " + e2.toString());
        }
    }

    public void visitGETSTATIC(GETSTATIC o2) {
    }

    public void visitGOTO(GOTO o2) {
    }

    public void visitGOTO_W(GOTO_W o2) {
    }

    public void visitI2B(I2B o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitI2C(I2C o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitI2D(I2D o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitI2F(I2F o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitI2L(I2L o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitI2S(I2S o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIADD(IADD o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIALOAD(IALOAD o2) {
        Type t2;
        this.indexOfInt(o2, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(o2, "Stack next-to-top must be of type int[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((t2 = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.INT) {
            this.constraintViolated(o2, "Stack next-to-top must be of type int[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIAND(IAND o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIASTORE(IASTORE o2) {
        Type t2;
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(o2, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(o2, "Stack next-to-next-to-top must be of type int[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((t2 = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.INT) {
            this.constraintViolated(o2, "Stack next-to-next-to-top must be of type int[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    public void visitICONST(ICONST o2) {
    }

    public void visitIDIV(IDIV o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIF_ACMPEQ(IF_ACMPEQ o2) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o2, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
        }
        if (!(this.stack().peek(1) instanceof ReferenceType)) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of a ReferenceType, but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIF_ACMPNE(IF_ACMPNE o2) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o2, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
        }
        if (!(this.stack().peek(1) instanceof ReferenceType)) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of a ReferenceType, but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIF_ICMPEQ(IF_ICMPEQ o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIF_ICMPGE(IF_ICMPGE o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIF_ICMPGT(IF_ICMPGT o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIF_ICMPLE(IF_ICMPLE o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIF_ICMPLT(IF_ICMPLT o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIF_ICMPNE(IF_ICMPNE o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIFEQ(IFEQ o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIFGE(IFGE o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIFGT(IFGT o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIFLE(IFLE o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIFLT(IFLT o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIFNE(IFNE o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitIFNONNULL(IFNONNULL o2) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o2, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
        }
        this.referenceTypeIsInitialized(o2, (ReferenceType)this.stack().peek());
    }

    public void visitIFNULL(IFNULL o2) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o2, "The value at the stack top is not of a ReferenceType, but of type '" + this.stack().peek() + "'.");
        }
        this.referenceTypeIsInitialized(o2, (ReferenceType)this.stack().peek());
    }

    public void visitIINC(IINC o2) {
        if (this.locals().maxLocals() <= (o2.getType(this.cpg).getSize() == 1 ? o2.getIndex() : o2.getIndex() + 1)) {
            this.constraintViolated(o2, "The 'index' is not a valid index into the local variable array.");
        }
        this.indexOfInt(o2, this.locals().get(o2.getIndex()));
    }

    public void visitILOAD(ILOAD o2) {
    }

    public void visitIMPDEP1(IMPDEP1 o2) {
        throw new AssertionViolatedException("In this JustIce verification pass there should not occur an illegal instruction such as IMPDEP1.");
    }

    public void visitIMPDEP2(IMPDEP2 o2) {
        throw new AssertionViolatedException("In this JustIce verification pass there should not occur an illegal instruction such as IMPDEP2.");
    }

    public void visitIMUL(IMUL o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitINEG(INEG o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitINSTANCEOF(INSTANCEOF o2) {
        Constant c2;
        Type objectref = this.stack().peek(0);
        if (!(objectref instanceof ReferenceType)) {
            this.constraintViolated(o2, "The 'objectref' is not of a ReferenceType but of type " + objectref + ".");
        }
        if (!((c2 = this.cpg.getConstant(o2.getIndex())) instanceof ConstantClass)) {
            this.constraintViolated(o2, "The Constant at 'index' is not a ConstantClass, but '" + c2 + "'.");
        }
    }

    public void visitINVOKEINTERFACE(INVOKEINTERFACE o2) {
        String name;
        Verifier v2;
        VerificationResult vr;
        Type t2;
        int count = o2.getCount();
        if (count == 0) {
            this.constraintViolated(o2, "The 'count' argument must not be 0.");
        }
        if ((t2 = o2.getType(this.cpg)) instanceof ObjectType && (vr = (v2 = VerifierFactory.getVerifier(name = ((ObjectType)t2).getClassName())).doPass2()).getStatus() != 1) {
            this.constraintViolated(o2, "Class '" + name + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
        }
        Type[] argtypes = o2.getArgumentTypes(this.cpg);
        int nargs = argtypes.length;
        for (int i2 = nargs - 1; i2 >= 0; --i2) {
            Type fromStack = this.stack().peek(nargs - 1 - i2);
            Type fromDesc = argtypes[i2];
            if (fromDesc == Type.BOOLEAN || fromDesc == Type.BYTE || fromDesc == Type.CHAR || fromDesc == Type.SHORT) {
                fromDesc = Type.INT;
            }
            if (fromStack.equals(fromDesc)) continue;
            if (fromStack instanceof ReferenceType && fromDesc instanceof ReferenceType) {
                ReferenceType rFromStack = (ReferenceType)fromStack;
                this.referenceTypeIsInitialized(o2, rFromStack);
                continue;
            }
            this.constraintViolated(o2, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack.");
        }
        Type objref = this.stack().peek(nargs);
        if (objref == Type.NULL) {
            return;
        }
        if (!(objref instanceof ReferenceType)) {
            this.constraintViolated(o2, "Expecting a reference type as 'objectref' on the stack, not a '" + objref + "'.");
        }
        this.referenceTypeIsInitialized(o2, (ReferenceType)objref);
        if (!(objref instanceof ObjectType)) {
            if (!(objref instanceof ArrayType)) {
                this.constraintViolated(o2, "Expecting an ObjectType as 'objectref' on the stack, not a '" + objref + "'.");
            } else {
                objref = GENERIC_ARRAY;
            }
        }
        int counted_count = 1;
        for (int i3 = 0; i3 < nargs; ++i3) {
            counted_count += argtypes[i3].getSize();
        }
        if (count != counted_count) {
            this.constraintViolated(o2, "The 'count' argument should probably read '" + counted_count + "' but is '" + count + "'.");
        }
    }

    public void visitINVOKESPECIAL(INVOKESPECIAL o2) {
        try {
            String name;
            Verifier v2;
            VerificationResult vr;
            Type t2;
            if (o2.getMethodName(this.cpg).equals("<init>") && !(this.stack().peek(o2.getArgumentTypes(this.cpg).length) instanceof UninitializedObjectType)) {
                this.constraintViolated(o2, "Possibly initializing object twice. A valid instruction sequence must not have an uninitialized object on the operand stack or in a local variable during a backwards branch, or in a local variable in code protected by an exception handler. Please see The Java Virtual Machine Specification, Second Edition, 4.9.4 (pages 147 and 148) for details.");
            }
            if ((t2 = o2.getType(this.cpg)) instanceof ObjectType && (vr = (v2 = VerifierFactory.getVerifier(name = ((ObjectType)t2).getClassName())).doPass2()).getStatus() != 1) {
                this.constraintViolated(o2, "Class '" + name + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
            }
            Type[] argtypes = o2.getArgumentTypes(this.cpg);
            int nargs = argtypes.length;
            for (int i2 = nargs - 1; i2 >= 0; --i2) {
                Type fromStack = this.stack().peek(nargs - 1 - i2);
                Type fromDesc = argtypes[i2];
                if (fromDesc == Type.BOOLEAN || fromDesc == Type.BYTE || fromDesc == Type.CHAR || fromDesc == Type.SHORT) {
                    fromDesc = Type.INT;
                }
                if (fromStack.equals(fromDesc)) continue;
                if (fromStack instanceof ReferenceType && fromDesc instanceof ReferenceType) {
                    ReferenceType rFromStack = (ReferenceType)fromStack;
                    ReferenceType rFromDesc = (ReferenceType)fromDesc;
                    if (!rFromStack.isAssignmentCompatibleWith(rFromDesc)) {
                        this.constraintViolated(o2, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack (which is not assignment compatible).");
                    }
                    this.referenceTypeIsInitialized(o2, rFromStack);
                    continue;
                }
                this.constraintViolated(o2, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack.");
            }
            Type objref = this.stack().peek(nargs);
            if (objref == Type.NULL) {
                return;
            }
            if (!(objref instanceof ReferenceType)) {
                this.constraintViolated(o2, "Expecting a reference type as 'objectref' on the stack, not a '" + objref + "'.");
            }
            String objref_classname = null;
            if (!o2.getMethodName(this.cpg).equals("<init>")) {
                this.referenceTypeIsInitialized(o2, (ReferenceType)objref);
                if (!(objref instanceof ObjectType)) {
                    if (!(objref instanceof ArrayType)) {
                        this.constraintViolated(o2, "Expecting an ObjectType as 'objectref' on the stack, not a '" + objref + "'.");
                    } else {
                        objref = GENERIC_ARRAY;
                    }
                }
                objref_classname = ((ObjectType)objref).getClassName();
            } else {
                if (!(objref instanceof UninitializedObjectType)) {
                    this.constraintViolated(o2, "Expecting an UninitializedObjectType as 'objectref' on the stack, not a '" + objref + "'. Otherwise, you couldn't invoke a method since an array has no methods (not to speak of a return address).");
                }
                objref_classname = ((UninitializedObjectType)objref).getInitialized().getClassName();
            }
            String theClass = o2.getClassName(this.cpg);
            if (!Repository.instanceOf(objref_classname, theClass)) {
                this.constraintViolated(o2, "The 'objref' item '" + objref + "' does not implement '" + theClass + "' as expected.");
            }
        }
        catch (ClassNotFoundException e2) {
            throw new AssertionViolatedException("Missing class: " + e2.toString());
        }
    }

    public void visitINVOKESTATIC(INVOKESTATIC o2) {
        try {
            String name;
            Verifier v2;
            VerificationResult vr;
            Type t2 = o2.getType(this.cpg);
            if (t2 instanceof ObjectType && (vr = (v2 = VerifierFactory.getVerifier(name = ((ObjectType)t2).getClassName())).doPass2()).getStatus() != 1) {
                this.constraintViolated(o2, "Class '" + name + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
            }
            Type[] argtypes = o2.getArgumentTypes(this.cpg);
            int nargs = argtypes.length;
            for (int i2 = nargs - 1; i2 >= 0; --i2) {
                Type fromStack = this.stack().peek(nargs - 1 - i2);
                Type fromDesc = argtypes[i2];
                if (fromDesc == Type.BOOLEAN || fromDesc == Type.BYTE || fromDesc == Type.CHAR || fromDesc == Type.SHORT) {
                    fromDesc = Type.INT;
                }
                if (fromStack.equals(fromDesc)) continue;
                if (fromStack instanceof ReferenceType && fromDesc instanceof ReferenceType) {
                    ReferenceType rFromStack = (ReferenceType)fromStack;
                    ReferenceType rFromDesc = (ReferenceType)fromDesc;
                    if (!rFromStack.isAssignmentCompatibleWith(rFromDesc)) {
                        this.constraintViolated(o2, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack (which is not assignment compatible).");
                    }
                    this.referenceTypeIsInitialized(o2, rFromStack);
                    continue;
                }
                this.constraintViolated(o2, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack.");
            }
        }
        catch (ClassNotFoundException e2) {
            throw new AssertionViolatedException("Missing class: " + e2.toString());
        }
    }

    public void visitINVOKEVIRTUAL(INVOKEVIRTUAL o2) {
        try {
            String theClass;
            String objref_classname;
            String name;
            Verifier v2;
            VerificationResult vr;
            Type t2 = o2.getType(this.cpg);
            if (t2 instanceof ObjectType && (vr = (v2 = VerifierFactory.getVerifier(name = ((ObjectType)t2).getClassName())).doPass2()).getStatus() != 1) {
                this.constraintViolated(o2, "Class '" + name + "' is referenced, but cannot be loaded and resolved: '" + vr + "'.");
            }
            Type[] argtypes = o2.getArgumentTypes(this.cpg);
            int nargs = argtypes.length;
            for (int i2 = nargs - 1; i2 >= 0; --i2) {
                Type fromStack = this.stack().peek(nargs - 1 - i2);
                Type fromDesc = argtypes[i2];
                if (fromDesc == Type.BOOLEAN || fromDesc == Type.BYTE || fromDesc == Type.CHAR || fromDesc == Type.SHORT) {
                    fromDesc = Type.INT;
                }
                if (fromStack.equals(fromDesc)) continue;
                if (fromStack instanceof ReferenceType && fromDesc instanceof ReferenceType) {
                    ReferenceType rFromStack = (ReferenceType)fromStack;
                    ReferenceType rFromDesc = (ReferenceType)fromDesc;
                    if (!rFromStack.isAssignmentCompatibleWith(rFromDesc)) {
                        this.constraintViolated(o2, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack (which is not assignment compatible).");
                    }
                    this.referenceTypeIsInitialized(o2, rFromStack);
                    continue;
                }
                this.constraintViolated(o2, "Expecting a '" + fromDesc + "' but found a '" + fromStack + "' on the stack.");
            }
            Type objref = this.stack().peek(nargs);
            if (objref == Type.NULL) {
                return;
            }
            if (!(objref instanceof ReferenceType)) {
                this.constraintViolated(o2, "Expecting a reference type as 'objectref' on the stack, not a '" + objref + "'.");
            }
            this.referenceTypeIsInitialized(o2, (ReferenceType)objref);
            if (!(objref instanceof ObjectType)) {
                if (!(objref instanceof ArrayType)) {
                    this.constraintViolated(o2, "Expecting an ObjectType as 'objectref' on the stack, not a '" + objref + "'.");
                } else {
                    objref = GENERIC_ARRAY;
                }
            }
            if (!Repository.instanceOf(objref_classname = ((ObjectType)objref).getClassName(), theClass = o2.getClassName(this.cpg))) {
                this.constraintViolated(o2, "The 'objref' item '" + objref + "' does not implement '" + theClass + "' as expected.");
            }
        }
        catch (ClassNotFoundException e2) {
            throw new AssertionViolatedException("Missing class: " + e2.toString());
        }
    }

    public void visitIOR(IOR o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIREM(IREM o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIRETURN(IRETURN o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitISHL(ISHL o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitISHR(ISHR o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitISTORE(ISTORE o2) {
    }

    public void visitISUB(ISUB o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIUSHR(IUSHR o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitIXOR(IXOR o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.INT) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'int', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitJSR(JSR o2) {
    }

    public void visitJSR_W(JSR_W o2) {
    }

    public void visitL2D(L2D o2) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitL2F(L2F o2) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitL2I(L2I o2) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitLADD(LADD o2) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLALOAD(LALOAD o2) {
        Type t2;
        this.indexOfInt(o2, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(o2, "Stack next-to-top must be of type long[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((t2 = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.LONG) {
            this.constraintViolated(o2, "Stack next-to-top must be of type long[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLAND(LAND o2) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLASTORE(LASTORE o2) {
        Type t2;
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(o2, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(o2, "Stack next-to-next-to-top must be of type long[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((t2 = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.LONG) {
            this.constraintViolated(o2, "Stack next-to-next-to-top must be of type long[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    public void visitLCMP(LCMP o2) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLCONST(LCONST o2) {
    }

    public void visitLDC(LDC o2) {
        Constant c2 = this.cpg.getConstant(o2.getIndex());
        if (!(c2 instanceof ConstantInteger || c2 instanceof ConstantFloat || c2 instanceof ConstantString)) {
            this.constraintViolated(o2, "Referenced constant should be a CONSTANT_Integer, a CONSTANT_Float or a CONSTANT_String, but is '" + c2 + "'.");
        }
    }

    public void visitLDC_W(LDC_W o2) {
        Constant c2 = this.cpg.getConstant(o2.getIndex());
        if (!(c2 instanceof ConstantInteger || c2 instanceof ConstantFloat || c2 instanceof ConstantString)) {
            this.constraintViolated(o2, "Referenced constant should be a CONSTANT_Integer, a CONSTANT_Float or a CONSTANT_String, but is '" + c2 + "'.");
        }
    }

    public void visitLDC2_W(LDC2_W o2) {
        Constant c2 = this.cpg.getConstant(o2.getIndex());
        if (!(c2 instanceof ConstantLong) && !(c2 instanceof ConstantDouble)) {
            this.constraintViolated(o2, "Referenced constant should be a CONSTANT_Integer, a CONSTANT_Float or a CONSTANT_String, but is '" + c2 + "'.");
        }
    }

    public void visitLDIV(LDIV o2) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLLOAD(LLOAD o2) {
    }

    public void visitLMUL(LMUL o2) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLNEG(LNEG o2) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitLOOKUPSWITCH(LOOKUPSWITCH o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitLOR(LOR o2) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLREM(LREM o2) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLRETURN(LRETURN o2) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitLSHL(LSHL o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLSHR(LSHR o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLSTORE(LSTORE o2) {
    }

    public void visitLSUB(LSUB o2) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLUSHR(LUSHR o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitLXOR(LXOR o2) {
        if (this.stack().peek() != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'long', but of type '" + this.stack().peek() + "'.");
        }
        if (this.stack().peek(1) != Type.LONG) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of type 'long', but of type '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitMONITORENTER(MONITORENTER o2) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o2, "The stack top should be of a ReferenceType, but is '" + this.stack().peek() + "'.");
        }
    }

    public void visitMONITOREXIT(MONITOREXIT o2) {
        if (!(this.stack().peek() instanceof ReferenceType)) {
            this.constraintViolated(o2, "The stack top should be of a ReferenceType, but is '" + this.stack().peek() + "'.");
        }
    }

    public void visitMULTIANEWARRAY(MULTIANEWARRAY o2) {
        int dimensions = o2.getDimensions();
        for (int i2 = 0; i2 < dimensions; ++i2) {
            if (this.stack().peek(i2) == Type.INT) continue;
            this.constraintViolated(o2, "The '" + dimensions + "' upper stack types should be 'int' but aren't.");
        }
    }

    public void visitNEW(NEW o2) {
        ObjectType obj;
        Type t2 = o2.getType(this.cpg);
        if (!(t2 instanceof ReferenceType)) {
            throw new AssertionViolatedException("NEW.getType() returning a non-reference type?!");
        }
        if (!(t2 instanceof ObjectType)) {
            this.constraintViolated(o2, "Expecting a class type (ObjectType) to work on. Found: '" + t2 + "'.");
        }
        if (!(obj = (ObjectType)t2).referencesClass()) {
            this.constraintViolated(o2, "Expecting a class type (ObjectType) to work on. Found: '" + obj + "'.");
        }
    }

    public void visitNEWARRAY(NEWARRAY o2) {
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
    }

    public void visitNOP(NOP o2) {
    }

    public void visitPOP(POP o2) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(o2, "Stack top size should be 1 but stack top is '" + this.stack().peek() + "' of size '" + this.stack().peek().getSize() + "'.");
        }
    }

    public void visitPOP2(POP2 o2) {
        if (this.stack().peek().getSize() != 2) {
            this.constraintViolated(o2, "Stack top size should be 2 but stack top is '" + this.stack().peek() + "' of size '" + this.stack().peek().getSize() + "'.");
        }
    }

    public void visitPUTFIELD(PUTFIELD o2) {
        try {
            ObjectType curr;
            ObjectType classtype;
            Type objectref = this.stack().peek(1);
            if (!(objectref instanceof ObjectType) && objectref != Type.NULL) {
                this.constraintViolated(o2, "Stack next-to-top should be an object reference that's not an array reference, but is '" + objectref + "'.");
            }
            String field_name = o2.getFieldName(this.cpg);
            JavaClass jc = Repository.lookupClass(o2.getClassType(this.cpg).getClassName());
            Field[] fields = jc.getFields();
            FieldOrMethod f2 = null;
            for (int i2 = 0; i2 < fields.length; ++i2) {
                Type o_type;
                Type f_type;
                if (!fields[i2].getName().equals(field_name) || !(f_type = Type.getType(fields[i2].getSignature())).equals(o_type = o2.getType(this.cpg))) continue;
                f2 = fields[i2];
                break;
            }
            if (f2 == null) {
                throw new AssertionViolatedException("Field not found?!?");
            }
            Type value = this.stack().peek();
            Type t2 = Type.getType(f2.getSignature());
            Type shouldbe = t2;
            if (shouldbe == Type.BOOLEAN || shouldbe == Type.BYTE || shouldbe == Type.CHAR || shouldbe == Type.SHORT) {
                shouldbe = Type.INT;
            }
            if (t2 instanceof ReferenceType) {
                ReferenceType rvalue = null;
                if (value instanceof ReferenceType) {
                    rvalue = (ReferenceType)value;
                    this.referenceTypeIsInitialized(o2, rvalue);
                } else {
                    this.constraintViolated(o2, "The stack top type '" + value + "' is not of a reference type as expected.");
                }
                if (!rvalue.isAssignmentCompatibleWith(shouldbe)) {
                    this.constraintViolated(o2, "The stack top type '" + value + "' is not assignment compatible with '" + shouldbe + "'.");
                }
            } else if (shouldbe != value) {
                this.constraintViolated(o2, "The stack top type '" + value + "' is not of type '" + shouldbe + "' as expected.");
            }
            if (f2.isProtected() && ((classtype = o2.getClassType(this.cpg)).equals(curr = new ObjectType(this.mg.getClassName())) || curr.subclassOf(classtype))) {
                ObjectType objreftype;
                Type tp = this.stack().peek(1);
                if (tp == Type.NULL) {
                    return;
                }
                if (!(tp instanceof ObjectType)) {
                    this.constraintViolated(o2, "The 'objectref' must refer to an object that's not an array. Found instead: '" + tp + "'.");
                }
                if (!(objreftype = (ObjectType)tp).equals(curr) && !objreftype.subclassOf(curr)) {
                    this.constraintViolated(o2, "The referenced field has the ACC_PROTECTED modifier, and it's a member of the current class or a superclass of the current class. However, the referenced object type '" + this.stack().peek() + "' is not the current class or a subclass of the current class.");
                }
            }
            if (f2.isStatic()) {
                this.constraintViolated(o2, "Referenced field '" + f2 + "' is static which it shouldn't be.");
            }
        }
        catch (ClassNotFoundException e2) {
            throw new AssertionViolatedException("Missing class: " + e2.toString());
        }
    }

    public void visitPUTSTATIC(PUTSTATIC o2) {
        try {
            String field_name = o2.getFieldName(this.cpg);
            JavaClass jc = Repository.lookupClass(o2.getClassType(this.cpg).getClassName());
            Field[] fields = jc.getFields();
            FieldOrMethod f2 = null;
            for (int i2 = 0; i2 < fields.length; ++i2) {
                Type o_type;
                Type f_type;
                if (!fields[i2].getName().equals(field_name) || !(f_type = Type.getType(fields[i2].getSignature())).equals(o_type = o2.getType(this.cpg))) continue;
                f2 = fields[i2];
                break;
            }
            if (f2 == null) {
                throw new AssertionViolatedException("Field not found?!?");
            }
            Type value = this.stack().peek();
            Type t2 = Type.getType(f2.getSignature());
            Type shouldbe = t2;
            if (shouldbe == Type.BOOLEAN || shouldbe == Type.BYTE || shouldbe == Type.CHAR || shouldbe == Type.SHORT) {
                shouldbe = Type.INT;
            }
            if (t2 instanceof ReferenceType) {
                ReferenceType rvalue = null;
                if (value instanceof ReferenceType) {
                    rvalue = (ReferenceType)value;
                    this.referenceTypeIsInitialized(o2, rvalue);
                } else {
                    this.constraintViolated(o2, "The stack top type '" + value + "' is not of a reference type as expected.");
                }
                if (!rvalue.isAssignmentCompatibleWith(shouldbe)) {
                    this.constraintViolated(o2, "The stack top type '" + value + "' is not assignment compatible with '" + shouldbe + "'.");
                }
            } else if (shouldbe != value) {
                this.constraintViolated(o2, "The stack top type '" + value + "' is not of type '" + shouldbe + "' as expected.");
            }
        }
        catch (ClassNotFoundException e2) {
            throw new AssertionViolatedException("Missing class: " + e2.toString());
        }
    }

    public void visitRET(RET o2) {
        if (!(this.locals().get(o2.getIndex()) instanceof ReturnaddressType)) {
            this.constraintViolated(o2, "Expecting a ReturnaddressType in local variable " + o2.getIndex() + ".");
        }
        if (this.locals().get(o2.getIndex()) == ReturnaddressType.NO_TARGET) {
            throw new AssertionViolatedException("Oops: RET expecting a target!");
        }
    }

    public void visitRETURN(RETURN o2) {
        if (this.mg.getName().equals("<init>") && Frame._this != null && !this.mg.getClassName().equals(Type.OBJECT.getClassName())) {
            this.constraintViolated(o2, "Leaving a constructor that itself did not call a constructor.");
        }
    }

    public void visitSALOAD(SALOAD o2) {
        Type t2;
        this.indexOfInt(o2, this.stack().peek());
        if (this.stack().peek(1) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(1) instanceof ArrayType)) {
            this.constraintViolated(o2, "Stack next-to-top must be of type short[] but is '" + this.stack().peek(1) + "'.");
        }
        if ((t2 = ((ArrayType)this.stack().peek(1)).getBasicType()) != Type.SHORT) {
            this.constraintViolated(o2, "Stack next-to-top must be of type short[] but is '" + this.stack().peek(1) + "'.");
        }
    }

    public void visitSASTORE(SASTORE o2) {
        Type t2;
        if (this.stack().peek() != Type.INT) {
            this.constraintViolated(o2, "The value at the stack top is not of type 'int', but of type '" + this.stack().peek() + "'.");
        }
        this.indexOfInt(o2, this.stack().peek(1));
        if (this.stack().peek(2) == Type.NULL) {
            return;
        }
        if (!(this.stack().peek(2) instanceof ArrayType)) {
            this.constraintViolated(o2, "Stack next-to-next-to-top must be of type short[] but is '" + this.stack().peek(2) + "'.");
        }
        if ((t2 = ((ArrayType)this.stack().peek(2)).getBasicType()) != Type.SHORT) {
            this.constraintViolated(o2, "Stack next-to-next-to-top must be of type short[] but is '" + this.stack().peek(2) + "'.");
        }
    }

    public void visitSIPUSH(SIPUSH o2) {
    }

    public void visitSWAP(SWAP o2) {
        if (this.stack().peek().getSize() != 1) {
            this.constraintViolated(o2, "The value at the stack top is not of size '1', but of size '" + this.stack().peek().getSize() + "'.");
        }
        if (this.stack().peek(1).getSize() != 1) {
            this.constraintViolated(o2, "The value at the stack next-to-top is not of size '1', but of size '" + this.stack().peek(1).getSize() + "'.");
        }
    }

    public void visitTABLESWITCH(TABLESWITCH o2) {
        this.indexOfInt(o2, this.stack().peek());
    }
}

