/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.statics;

import org.apache.bcel.Repository;
import org.apache.bcel.classfile.AccessFlags;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BREAKPOINT;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DLOAD;
import org.apache.bcel.generic.DSTORE;
import org.apache.bcel.generic.EmptyVisitor;
import org.apache.bcel.generic.FLOAD;
import org.apache.bcel.generic.FSTORE;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.GotoInstruction;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.IMPDEP1;
import org.apache.bcel.generic.IMPDEP2;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.ISTORE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.JsrInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.LLOAD;
import org.apache.bcel.generic.LOOKUPSWITCH;
import org.apache.bcel.generic.LSTORE;
import org.apache.bcel.generic.LoadClass;
import org.apache.bcel.generic.MULTIANEWARRAY;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUTSTATIC;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.TABLESWITCH;
import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.PassVerifier;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.Verifier;
import org.apache.bcel.verifier.VerifierFactory;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.ClassConstraintException;
import org.apache.bcel.verifier.exc.InvalidMethodException;
import org.apache.bcel.verifier.exc.StaticCodeConstraintException;
import org.apache.bcel.verifier.exc.StaticCodeInstructionConstraintException;
import org.apache.bcel.verifier.exc.StaticCodeInstructionOperandConstraintException;
import org.apache.bcel.verifier.statics.IntList;

public final class Pass3aVerifier
extends PassVerifier {
    private Verifier myOwner;
    private int method_no;
    InstructionList instructionList;
    Code code;

    public Pass3aVerifier(Verifier owner, int method_no) {
        this.myOwner = owner;
        this.method_no = method_no;
    }

    public VerificationResult do_verify() {
        try {
            if (this.myOwner.doPass2().equals(VerificationResult.VR_OK)) {
                JavaClass jc = Repository.lookupClass(this.myOwner.getClassName());
                Method[] methods = jc.getMethods();
                if (this.method_no >= methods.length) {
                    throw new InvalidMethodException("METHOD DOES NOT EXIST!");
                }
                Method method = methods[this.method_no];
                this.code = method.getCode();
                if (method.isAbstract() || method.isNative()) {
                    return VerificationResult.VR_OK;
                }
                try {
                    this.instructionList = new InstructionList(method.getCode().getCode());
                }
                catch (RuntimeException re) {
                    return new VerificationResult(2, "Bad bytecode in the code array of the Code attribute of method '" + method + "'.");
                }
                this.instructionList.setPositions(true);
                VerificationResult vr = VerificationResult.VR_OK;
                try {
                    this.delayedPass2Checks();
                }
                catch (ClassConstraintException cce) {
                    vr = new VerificationResult(2, cce.getMessage());
                    return vr;
                }
                try {
                    this.pass3StaticInstructionChecks();
                    this.pass3StaticInstructionOperandsChecks();
                }
                catch (StaticCodeConstraintException scce) {
                    vr = new VerificationResult(2, scce.getMessage());
                }
                catch (ClassCastException cce) {
                    vr = new VerificationResult(2, "Class Cast Exception: " + cce.getMessage());
                }
                return vr;
            }
            return VerificationResult.VR_NOTYET;
        }
        catch (ClassNotFoundException e2) {
            throw new AssertionViolatedException("Missing class: " + e2.toString());
        }
    }

    private void delayedPass2Checks() {
        int i2;
        int[] instructionPositions = this.instructionList.getInstructionPositions();
        int codeLength = this.code.getCode().length;
        LineNumberTable lnt = this.code.getLineNumberTable();
        if (lnt != null) {
            LineNumber[] lineNumbers = lnt.getLineNumberTable();
            IntList offsets = new IntList();
            block0: for (i2 = 0; i2 < lineNumbers.length; ++i2) {
                for (int j2 = 0; j2 < instructionPositions.length; ++j2) {
                    int offset = lineNumbers[i2].getStartPC();
                    if (instructionPositions[j2] != offset) continue;
                    if (offsets.contains(offset)) {
                        this.addMessage("LineNumberTable attribute '" + this.code.getLineNumberTable() + "' refers to the same code offset ('" + offset + "') more than once which is violating the semantics [but is sometimes produced by IBM's 'jikes' compiler].");
                        continue block0;
                    }
                    offsets.add(offset);
                    continue block0;
                }
                throw new ClassConstraintException("Code attribute '" + this.code + "' has a LineNumberTable attribute '" + this.code.getLineNumberTable() + "' referring to a code offset ('" + lineNumbers[i2].getStartPC() + "') that does not exist.");
            }
        }
        Attribute[] atts = this.code.getAttributes();
        for (int a = 0; a < atts.length; ++a) {
            LocalVariableTable lvt;
            if (!(atts[a] instanceof LocalVariableTable) || (lvt = (LocalVariableTable)atts[a]) == null) continue;
            LocalVariable[] localVariables = lvt.getLocalVariableTable();
            for (int i3 = 0; i3 < localVariables.length; ++i3) {
                int startpc = localVariables[i3].getStartPC();
                int length = localVariables[i3].getLength();
                if (!Pass3aVerifier.contains(instructionPositions, startpc)) {
                    throw new ClassConstraintException("Code attribute '" + this.code + "' has a LocalVariableTable attribute '" + this.code.getLocalVariableTable() + "' referring to a code offset ('" + startpc + "') that does not exist.");
                }
                if (Pass3aVerifier.contains(instructionPositions, startpc + length) || startpc + length == codeLength) continue;
                throw new ClassConstraintException("Code attribute '" + this.code + "' has a LocalVariableTable attribute '" + this.code.getLocalVariableTable() + "' referring to a code offset start_pc+length ('" + (startpc + length) + "') that does not exist.");
            }
        }
        CodeException[] exceptionTable = this.code.getExceptionTable();
        for (i2 = 0; i2 < exceptionTable.length; ++i2) {
            int startpc = exceptionTable[i2].getStartPC();
            int endpc = exceptionTable[i2].getEndPC();
            int handlerpc = exceptionTable[i2].getHandlerPC();
            if (startpc >= endpc) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + exceptionTable[i2] + "' that has its start_pc ('" + startpc + "') not smaller than its end_pc ('" + endpc + "').");
            }
            if (!Pass3aVerifier.contains(instructionPositions, startpc)) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + exceptionTable[i2] + "' that has a non-existant bytecode offset as its start_pc ('" + startpc + "').");
            }
            if (!Pass3aVerifier.contains(instructionPositions, endpc) && endpc != codeLength) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + exceptionTable[i2] + "' that has a non-existant bytecode offset as its end_pc ('" + startpc + "') [that is also not equal to code_length ('" + codeLength + "')].");
            }
            if (Pass3aVerifier.contains(instructionPositions, handlerpc)) continue;
            throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + exceptionTable[i2] + "' that has a non-existant bytecode offset as its handler_pc ('" + handlerpc + "').");
        }
    }

    private void pass3StaticInstructionChecks() {
        if (this.code.getCode().length >= 65536) {
            throw new StaticCodeInstructionConstraintException("Code array in code attribute '" + this.code + "' too big: must be smaller than 65536 bytes.");
        }
        for (InstructionHandle ih = this.instructionList.getStart(); ih != null; ih = ih.getNext()) {
            Instruction i2 = ih.getInstruction();
            if (i2 instanceof IMPDEP1) {
                throw new StaticCodeInstructionConstraintException("IMPDEP1 must not be in the code, it is an illegal instruction for _internal_ JVM use!");
            }
            if (i2 instanceof IMPDEP2) {
                throw new StaticCodeInstructionConstraintException("IMPDEP2 must not be in the code, it is an illegal instruction for _internal_ JVM use!");
            }
            if (!(i2 instanceof BREAKPOINT)) continue;
            throw new StaticCodeInstructionConstraintException("BREAKPOINT must not be in the code, it is an illegal instruction for _internal_ JVM use!");
        }
        Instruction last = this.instructionList.getEnd().getInstruction();
        if (!(last instanceof ReturnInstruction || last instanceof RET || last instanceof GotoInstruction || last instanceof ATHROW)) {
            throw new StaticCodeInstructionConstraintException("Execution must not fall off the bottom of the code array. This constraint is enforced statically as some existing verifiers do - so it may be a false alarm if the last instruction is not reachable.");
        }
    }

    private void pass3StaticInstructionOperandsChecks() {
        try {
            ConstantPoolGen cpg = new ConstantPoolGen(Repository.lookupClass(this.myOwner.getClassName()).getConstantPool());
            InstOperandConstraintVisitor v2 = new InstOperandConstraintVisitor(cpg);
            for (InstructionHandle ih = this.instructionList.getStart(); ih != null; ih = ih.getNext()) {
                Instruction i2 = ih.getInstruction();
                if (i2 instanceof JsrInstruction) {
                    InstructionHandle target = ((JsrInstruction)i2).getTarget();
                    if (target == this.instructionList.getStart()) {
                        throw new StaticCodeInstructionOperandConstraintException("Due to JustIce's clear definition of subroutines, no JSR or JSR_W may have a top-level instruction (such as the very first instruction, which is targeted by instruction '" + ih + "' as its target.");
                    }
                    if (!(target.getInstruction() instanceof ASTORE)) {
                        throw new StaticCodeInstructionOperandConstraintException("Due to JustIce's clear definition of subroutines, no JSR or JSR_W may target anything else than an ASTORE instruction. Instruction '" + ih + "' targets '" + target + "'.");
                    }
                }
                ih.accept(v2);
            }
        }
        catch (ClassNotFoundException e2) {
            throw new AssertionViolatedException("Missing class: " + e2.toString());
        }
    }

    private static boolean contains(int[] ints, int i2) {
        for (int j2 = 0; j2 < ints.length; ++j2) {
            if (ints[j2] != i2) continue;
            return true;
        }
        return false;
    }

    public int getMethodNo() {
        return this.method_no;
    }

    private class InstOperandConstraintVisitor
    extends EmptyVisitor {
        private ConstantPoolGen cpg;

        InstOperandConstraintVisitor(ConstantPoolGen cpg) {
            this.cpg = cpg;
        }

        private int max_locals() {
            try {
                return Repository.lookupClass(Pass3aVerifier.this.myOwner.getClassName()).getMethods()[Pass3aVerifier.this.method_no].getCode().getMaxLocals();
            }
            catch (ClassNotFoundException e2) {
                throw new AssertionViolatedException("Missing class: " + e2.toString());
            }
        }

        private void constraintViolated(Instruction i2, String message) {
            throw new StaticCodeInstructionOperandConstraintException("Instruction " + i2 + " constraint violated: " + message);
        }

        private void indexValid(Instruction i2, int idx) {
            if (idx < 0 || idx >= this.cpg.getSize()) {
                this.constraintViolated(i2, "Illegal constant pool index '" + idx + "'.");
            }
        }

        public void visitLoadClass(LoadClass o2) {
            Verifier v2;
            VerificationResult vr;
            ObjectType t2 = o2.getLoadClassType(this.cpg);
            if (t2 != null && (vr = (v2 = VerifierFactory.getVerifier(t2.getClassName())).doPass1()).getStatus() != 1) {
                this.constraintViolated((Instruction)((Object)o2), "Class '" + o2.getLoadClassType(this.cpg).getClassName() + "' is referenced, but cannot be loaded: '" + vr + "'.");
            }
        }

        public void visitLDC(LDC o2) {
            this.indexValid(o2, o2.getIndex());
            Constant c2 = this.cpg.getConstant(o2.getIndex());
            if (c2 instanceof ConstantClass) {
                Pass3aVerifier.this.addMessage("Operand of LDC or LDC_W is CONSTANT_Class '" + c2 + "' - this is only supported in JDK 1.5 and higher.");
            } else if (!(c2 instanceof ConstantInteger || c2 instanceof ConstantFloat || c2 instanceof ConstantString)) {
                this.constraintViolated(o2, "Operand of LDC or LDC_W must be one of CONSTANT_Integer, CONSTANT_Float or CONSTANT_String, but is '" + c2 + "'.");
            }
        }

        public void visitLDC2_W(LDC2_W o2) {
            this.indexValid(o2, o2.getIndex());
            Constant c2 = this.cpg.getConstant(o2.getIndex());
            if (!(c2 instanceof ConstantLong) && !(c2 instanceof ConstantDouble)) {
                this.constraintViolated(o2, "Operand of LDC2_W must be CONSTANT_Long or CONSTANT_Double, but is '" + c2 + "'.");
            }
            try {
                this.indexValid(o2, o2.getIndex() + 1);
            }
            catch (StaticCodeInstructionOperandConstraintException e2) {
                throw new AssertionViolatedException("OOPS: Does not BCEL handle that? LDC2_W operand has a problem.");
            }
        }

        public void visitFieldInstruction(FieldInstruction o2) {
            try {
                this.indexValid(o2, o2.getIndex());
                Constant c2 = this.cpg.getConstant(o2.getIndex());
                if (!(c2 instanceof ConstantFieldref)) {
                    this.constraintViolated(o2, "Indexing a constant that's not a CONSTANT_Fieldref but a '" + c2 + "'.");
                }
                String field_name = o2.getFieldName(this.cpg);
                JavaClass jc = Repository.lookupClass(o2.getClassType(this.cpg).getClassName());
                Field[] fields = jc.getFields();
                FieldOrMethod f2 = null;
                for (int i2 = 0; i2 < fields.length; ++i2) {
                    Type o_type;
                    Type f_type;
                    if (!fields[i2].getName().equals(field_name) || !(f_type = Type.getType(fields[i2].getSignature())).equals(o_type = o2.getType(this.cpg))) continue;
                    f2 = fields[i2];
                    break;
                }
                if (f2 == null) {
                    JavaClass[] superclasses = jc.getSuperClasses();
                    block3: for (int j2 = 0; j2 < superclasses.length; ++j2) {
                        fields = superclasses[j2].getFields();
                        for (int i3 = 0; i3 < fields.length; ++i3) {
                            Type o_type;
                            Type f_type;
                            if (!fields[i3].getName().equals(field_name) || !(f_type = Type.getType(fields[i3].getSignature())).equals(o_type = o2.getType(this.cpg))) continue;
                            f2 = fields[i3];
                            if ((f2.getAccessFlags() & 5) != 0) break block3;
                            f2 = null;
                            break block3;
                        }
                    }
                    if (f2 == null) {
                        this.constraintViolated(o2, "Referenced field '" + field_name + "' does not exist in class '" + jc.getClassName() + "'.");
                    }
                } else {
                    Type f_type = Type.getType(f2.getSignature());
                    Type o_type = o2.getType(this.cpg);
                }
            }
            catch (ClassNotFoundException e2) {
                throw new AssertionViolatedException("Missing class: " + e2.toString());
            }
        }

        public void visitInvokeInstruction(InvokeInstruction o2) {
            Verifier v2;
            VerificationResult vr;
            ConstantNameAndType cnat;
            Constant c2;
            this.indexValid(o2, o2.getIndex());
            if (o2 instanceof INVOKEVIRTUAL || o2 instanceof INVOKESPECIAL || o2 instanceof INVOKESTATIC) {
                c2 = this.cpg.getConstant(o2.getIndex());
                if (!(c2 instanceof ConstantMethodref)) {
                    this.constraintViolated(o2, "Indexing a constant that's not a CONSTANT_Methodref but a '" + c2 + "'.");
                } else {
                    cnat = (ConstantNameAndType)this.cpg.getConstant(((ConstantMethodref)c2).getNameAndTypeIndex());
                    ConstantUtf8 cutf8 = (ConstantUtf8)this.cpg.getConstant(cnat.getNameIndex());
                    if (cutf8.getBytes().equals("<init>") && !(o2 instanceof INVOKESPECIAL)) {
                        this.constraintViolated(o2, "Only INVOKESPECIAL is allowed to invoke instance initialization methods.");
                    }
                    if (!cutf8.getBytes().equals("<init>") && cutf8.getBytes().startsWith("<")) {
                        this.constraintViolated(o2, "No method with a name beginning with '<' other than the instance initialization methods may be called by the method invocation instructions.");
                    }
                }
            } else {
                String name;
                c2 = this.cpg.getConstant(o2.getIndex());
                if (!(c2 instanceof ConstantInterfaceMethodref)) {
                    this.constraintViolated(o2, "Indexing a constant that's not a CONSTANT_InterfaceMethodref but a '" + c2 + "'.");
                }
                if ((name = ((ConstantUtf8)this.cpg.getConstant((cnat = (ConstantNameAndType)this.cpg.getConstant(((ConstantInterfaceMethodref)c2).getNameAndTypeIndex())).getNameIndex())).getBytes()).equals("<init>")) {
                    this.constraintViolated(o2, "Method to invoke must not be '<init>'.");
                }
                if (name.equals("<clinit>")) {
                    this.constraintViolated(o2, "Method to invoke must not be '<clinit>'.");
                }
            }
            Type t2 = o2.getReturnType(this.cpg);
            if (t2 instanceof ArrayType) {
                t2 = ((ArrayType)t2).getBasicType();
            }
            if (t2 instanceof ObjectType && (vr = (v2 = VerifierFactory.getVerifier(((ObjectType)t2).getClassName())).doPass2()).getStatus() != 1) {
                this.constraintViolated(o2, "Return type class/interface could not be verified successfully: '" + vr.getMessage() + "'.");
            }
            Type[] ts = o2.getArgumentTypes(this.cpg);
            for (int i2 = 0; i2 < ts.length; ++i2) {
                Verifier v3;
                VerificationResult vr2;
                t2 = ts[i2];
                if (t2 instanceof ArrayType) {
                    t2 = ((ArrayType)t2).getBasicType();
                }
                if (!(t2 instanceof ObjectType) || (vr2 = (v3 = VerifierFactory.getVerifier(((ObjectType)t2).getClassName())).doPass2()).getStatus() == 1) continue;
                this.constraintViolated(o2, "Argument type class/interface could not be verified successfully: '" + vr2.getMessage() + "'.");
            }
        }

        public void visitINSTANCEOF(INSTANCEOF o2) {
            this.indexValid(o2, o2.getIndex());
            Constant c2 = this.cpg.getConstant(o2.getIndex());
            if (!(c2 instanceof ConstantClass)) {
                this.constraintViolated(o2, "Expecting a CONSTANT_Class operand, but found a '" + c2 + "'.");
            }
        }

        public void visitCHECKCAST(CHECKCAST o2) {
            this.indexValid(o2, o2.getIndex());
            Constant c2 = this.cpg.getConstant(o2.getIndex());
            if (!(c2 instanceof ConstantClass)) {
                this.constraintViolated(o2, "Expecting a CONSTANT_Class operand, but found a '" + c2 + "'.");
            }
        }

        public void visitNEW(NEW o2) {
            this.indexValid(o2, o2.getIndex());
            Constant c2 = this.cpg.getConstant(o2.getIndex());
            if (!(c2 instanceof ConstantClass)) {
                this.constraintViolated(o2, "Expecting a CONSTANT_Class operand, but found a '" + c2 + "'.");
            } else {
                ConstantUtf8 cutf8 = (ConstantUtf8)this.cpg.getConstant(((ConstantClass)c2).getNameIndex());
                Type t2 = Type.getType("L" + cutf8.getBytes() + ";");
                if (t2 instanceof ArrayType) {
                    this.constraintViolated(o2, "NEW must not be used to create an array.");
                }
            }
        }

        public void visitMULTIANEWARRAY(MULTIANEWARRAY o2) {
            Type t2;
            short dimensions2create;
            this.indexValid(o2, o2.getIndex());
            Constant c2 = this.cpg.getConstant(o2.getIndex());
            if (!(c2 instanceof ConstantClass)) {
                this.constraintViolated(o2, "Expecting a CONSTANT_Class operand, but found a '" + c2 + "'.");
            }
            if ((dimensions2create = o2.getDimensions()) < 1) {
                this.constraintViolated(o2, "Number of dimensions to create must be greater than zero.");
            }
            if ((t2 = o2.getType(this.cpg)) instanceof ArrayType) {
                int dimensions = ((ArrayType)t2).getDimensions();
                if (dimensions < dimensions2create) {
                    this.constraintViolated(o2, "Not allowed to create array with more dimensions ('+dimensions2create+') than the one referenced by the CONSTANT_Class '" + t2 + "'.");
                }
            } else {
                this.constraintViolated(o2, "Expecting a CONSTANT_Class referencing an array type. [Constraint not found in The Java Virtual Machine Specification, Second Edition, 4.8.1]");
            }
        }

        public void visitANEWARRAY(ANEWARRAY o2) {
            int dimensions;
            Type t2;
            this.indexValid(o2, o2.getIndex());
            Constant c2 = this.cpg.getConstant(o2.getIndex());
            if (!(c2 instanceof ConstantClass)) {
                this.constraintViolated(o2, "Expecting a CONSTANT_Class operand, but found a '" + c2 + "'.");
            }
            if ((t2 = o2.getType(this.cpg)) instanceof ArrayType && (dimensions = ((ArrayType)t2).getDimensions()) >= 255) {
                this.constraintViolated(o2, "Not allowed to create an array with more than 255 dimensions.");
            }
        }

        public void visitNEWARRAY(NEWARRAY o2) {
            byte t2 = o2.getTypecode();
            if (t2 != 4 && t2 != 5 && t2 != 6 && t2 != 7 && t2 != 8 && t2 != 9 && t2 != 10 && t2 != 11) {
                this.constraintViolated(o2, "Illegal type code '+t+' for 'atype' operand.");
            }
        }

        public void visitILOAD(ILOAD o2) {
            int idx = o2.getIndex();
            if (idx < 0) {
                this.constraintViolated(o2, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o2, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        public void visitFLOAD(FLOAD o2) {
            int idx = o2.getIndex();
            if (idx < 0) {
                this.constraintViolated(o2, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o2, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        public void visitALOAD(ALOAD o2) {
            int idx = o2.getIndex();
            if (idx < 0) {
                this.constraintViolated(o2, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o2, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        public void visitISTORE(ISTORE o2) {
            int idx = o2.getIndex();
            if (idx < 0) {
                this.constraintViolated(o2, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o2, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        public void visitFSTORE(FSTORE o2) {
            int idx = o2.getIndex();
            if (idx < 0) {
                this.constraintViolated(o2, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o2, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        public void visitASTORE(ASTORE o2) {
            int idx = o2.getIndex();
            if (idx < 0) {
                this.constraintViolated(o2, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o2, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        public void visitIINC(IINC o2) {
            int idx = o2.getIndex();
            if (idx < 0) {
                this.constraintViolated(o2, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o2, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        public void visitRET(RET o2) {
            int idx = o2.getIndex();
            if (idx < 0) {
                this.constraintViolated(o2, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o2, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        public void visitLLOAD(LLOAD o2) {
            int idx = o2.getIndex();
            if (idx < 0) {
                this.constraintViolated(o2, "Index '" + idx + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int maxminus2 = this.max_locals() - 2;
                if (idx > maxminus2) {
                    this.constraintViolated(o2, "Index '" + idx + "' must not be greater than max_locals-2 '" + maxminus2 + "'.");
                }
            }
        }

        public void visitDLOAD(DLOAD o2) {
            int idx = o2.getIndex();
            if (idx < 0) {
                this.constraintViolated(o2, "Index '" + idx + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int maxminus2 = this.max_locals() - 2;
                if (idx > maxminus2) {
                    this.constraintViolated(o2, "Index '" + idx + "' must not be greater than max_locals-2 '" + maxminus2 + "'.");
                }
            }
        }

        public void visitLSTORE(LSTORE o2) {
            int idx = o2.getIndex();
            if (idx < 0) {
                this.constraintViolated(o2, "Index '" + idx + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int maxminus2 = this.max_locals() - 2;
                if (idx > maxminus2) {
                    this.constraintViolated(o2, "Index '" + idx + "' must not be greater than max_locals-2 '" + maxminus2 + "'.");
                }
            }
        }

        public void visitDSTORE(DSTORE o2) {
            int idx = o2.getIndex();
            if (idx < 0) {
                this.constraintViolated(o2, "Index '" + idx + "' must be non-negative. [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int maxminus2 = this.max_locals() - 2;
                if (idx > maxminus2) {
                    this.constraintViolated(o2, "Index '" + idx + "' must not be greater than max_locals-2 '" + maxminus2 + "'.");
                }
            }
        }

        public void visitLOOKUPSWITCH(LOOKUPSWITCH o2) {
            int[] matchs = o2.getMatchs();
            int max = Integer.MIN_VALUE;
            for (int i2 = 0; i2 < matchs.length; ++i2) {
                if (matchs[i2] == max && i2 != 0) {
                    this.constraintViolated(o2, "Match '" + matchs[i2] + "' occurs more than once.");
                }
                if (matchs[i2] < max) {
                    this.constraintViolated(o2, "Lookup table must be sorted but isn't.");
                    continue;
                }
                max = matchs[i2];
            }
        }

        public void visitTABLESWITCH(TABLESWITCH o2) {
        }

        public void visitPUTSTATIC(PUTSTATIC o2) {
            try {
                String field_name = o2.getFieldName(this.cpg);
                JavaClass jc = Repository.lookupClass(o2.getClassType(this.cpg).getClassName());
                Field[] fields = jc.getFields();
                AccessFlags f2 = null;
                for (int i2 = 0; i2 < fields.length; ++i2) {
                    if (!fields[i2].getName().equals(field_name)) continue;
                    f2 = fields[i2];
                    break;
                }
                if (f2 == null) {
                    throw new AssertionViolatedException("Field not found?!?");
                }
                if (f2.isFinal() && !Pass3aVerifier.this.myOwner.getClassName().equals(o2.getClassType(this.cpg).getClassName())) {
                    this.constraintViolated(o2, "Referenced field '" + f2 + "' is final and must therefore be declared in the current class '" + Pass3aVerifier.this.myOwner.getClassName() + "' which is not the case: it is declared in '" + o2.getClassType(this.cpg).getClassName() + "'.");
                }
                if (!f2.isStatic()) {
                    this.constraintViolated(o2, "Referenced field '" + f2 + "' is not static which it should be.");
                }
                String meth_name = Repository.lookupClass(Pass3aVerifier.this.myOwner.getClassName()).getMethods()[Pass3aVerifier.this.method_no].getName();
                if (!jc.isClass() && !meth_name.equals("<clinit>")) {
                    this.constraintViolated(o2, "Interface field '" + f2 + "' must be set in a '" + "<clinit>" + "' method.");
                }
            }
            catch (ClassNotFoundException e2) {
                throw new AssertionViolatedException("Missing class: " + e2.toString());
            }
        }

        public void visitGETSTATIC(GETSTATIC o2) {
            try {
                String field_name = o2.getFieldName(this.cpg);
                JavaClass jc = Repository.lookupClass(o2.getClassType(this.cpg).getClassName());
                Field[] fields = jc.getFields();
                AccessFlags f2 = null;
                for (int i2 = 0; i2 < fields.length; ++i2) {
                    if (!fields[i2].getName().equals(field_name)) continue;
                    f2 = fields[i2];
                    break;
                }
                if (f2 == null) {
                    throw new AssertionViolatedException("Field not found?!?");
                }
                if (!f2.isStatic()) {
                    this.constraintViolated(o2, "Referenced field '" + f2 + "' is not static which it should be.");
                }
            }
            catch (ClassNotFoundException e2) {
                throw new AssertionViolatedException("Missing class: " + e2.toString());
            }
        }

        public void visitINVOKEINTERFACE(INVOKEINTERFACE o2) {
            try {
                String classname = o2.getClassName(this.cpg);
                JavaClass jc = Repository.lookupClass(classname);
                Method[] ms = jc.getMethods();
                Method m2 = null;
                for (int i2 = 0; i2 < ms.length; ++i2) {
                    if (!ms[i2].getName().equals(o2.getMethodName(this.cpg)) || !Type.getReturnType(ms[i2].getSignature()).equals(o2.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(ms[i2].getSignature()), o2.getArgumentTypes(this.cpg))) continue;
                    m2 = ms[i2];
                    break;
                }
                if (m2 == null) {
                    this.constraintViolated(o2, "Referenced method '" + o2.getMethodName(this.cpg) + "' with expected signature '" + o2.getSignature(this.cpg) + "' not found in class '" + jc.getClassName() + "'. The native verifier does allow the method to be declared in some superinterface, which the Java Virtual Machine Specification, Second Edition does not.");
                }
                if (jc.isClass()) {
                    this.constraintViolated(o2, "Referenced class '" + jc.getClassName() + "' is a class, but not an interface as expected.");
                }
            }
            catch (ClassNotFoundException e2) {
                throw new AssertionViolatedException("Missing class: " + e2.toString());
            }
        }

        public void visitINVOKESPECIAL(INVOKESPECIAL o2) {
            try {
                JavaClass current;
                String classname = o2.getClassName(this.cpg);
                JavaClass jc = Repository.lookupClass(classname);
                Method[] ms = jc.getMethods();
                Method m2 = null;
                for (int i2 = 0; i2 < ms.length; ++i2) {
                    if (!ms[i2].getName().equals(o2.getMethodName(this.cpg)) || !Type.getReturnType(ms[i2].getSignature()).equals(o2.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(ms[i2].getSignature()), o2.getArgumentTypes(this.cpg))) continue;
                    m2 = ms[i2];
                    break;
                }
                if (m2 == null) {
                    this.constraintViolated(o2, "Referenced method '" + o2.getMethodName(this.cpg) + "' with expected signature '" + o2.getSignature(this.cpg) + "' not found in class '" + jc.getClassName() + "'. The native verifier does allow the method to be declared in some superclass or implemented interface, which the Java Virtual Machine Specification, Second Edition does not.");
                }
                if ((current = Repository.lookupClass(Pass3aVerifier.this.myOwner.getClassName())).isSuper() && Repository.instanceOf(current, jc) && !current.equals(jc) && !o2.getMethodName(this.cpg).equals("<init>")) {
                    int supidx = -1;
                    Method meth = null;
                    while (supidx != 0) {
                        supidx = current.getSuperclassNameIndex();
                        current = Repository.lookupClass(current.getSuperclassName());
                        Method[] meths = current.getMethods();
                        for (int i3 = 0; i3 < meths.length; ++i3) {
                            if (!meths[i3].getName().equals(o2.getMethodName(this.cpg)) || !Type.getReturnType(meths[i3].getSignature()).equals(o2.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(meths[i3].getSignature()), o2.getArgumentTypes(this.cpg))) continue;
                            meth = meths[i3];
                            break;
                        }
                        if (meth == null) continue;
                        break;
                    }
                    if (meth == null) {
                        this.constraintViolated(o2, "ACC_SUPER special lookup procedure not successful: method '" + o2.getMethodName(this.cpg) + "' with proper signature not declared in superclass hierarchy.");
                    }
                }
            }
            catch (ClassNotFoundException e2) {
                throw new AssertionViolatedException("Missing class: " + e2.toString());
            }
        }

        public void visitINVOKESTATIC(INVOKESTATIC o2) {
            try {
                String classname = o2.getClassName(this.cpg);
                JavaClass jc = Repository.lookupClass(classname);
                Method[] ms = jc.getMethods();
                AccessFlags m2 = null;
                for (int i2 = 0; i2 < ms.length; ++i2) {
                    if (!ms[i2].getName().equals(o2.getMethodName(this.cpg)) || !Type.getReturnType(ms[i2].getSignature()).equals(o2.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(ms[i2].getSignature()), o2.getArgumentTypes(this.cpg))) continue;
                    m2 = ms[i2];
                    break;
                }
                if (m2 == null) {
                    this.constraintViolated(o2, "Referenced method '" + o2.getMethodName(this.cpg) + "' with expected signature '" + o2.getSignature(this.cpg) + "' not found in class '" + jc.getClassName() + "'. The native verifier possibly allows the method to be declared in some superclass or implemented interface, which the Java Virtual Machine Specification, Second Edition does not.");
                } else if (!m2.isStatic()) {
                    this.constraintViolated(o2, "Referenced method '" + o2.getMethodName(this.cpg) + "' has ACC_STATIC unset.");
                }
            }
            catch (ClassNotFoundException e2) {
                throw new AssertionViolatedException("Missing class: " + e2.toString());
            }
        }

        public void visitINVOKEVIRTUAL(INVOKEVIRTUAL o2) {
            try {
                String classname = o2.getClassName(this.cpg);
                JavaClass jc = Repository.lookupClass(classname);
                Method[] ms = jc.getMethods();
                Method m2 = null;
                for (int i2 = 0; i2 < ms.length; ++i2) {
                    if (!ms[i2].getName().equals(o2.getMethodName(this.cpg)) || !Type.getReturnType(ms[i2].getSignature()).equals(o2.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(ms[i2].getSignature()), o2.getArgumentTypes(this.cpg))) continue;
                    m2 = ms[i2];
                    break;
                }
                if (m2 == null) {
                    this.constraintViolated(o2, "Referenced method '" + o2.getMethodName(this.cpg) + "' with expected signature '" + o2.getSignature(this.cpg) + "' not found in class '" + jc.getClassName() + "'. The native verifier does allow the method to be declared in some superclass or implemented interface, which the Java Virtual Machine Specification, Second Edition does not.");
                }
                if (!jc.isClass()) {
                    this.constraintViolated(o2, "Referenced class '" + jc.getClassName() + "' is an interface, but not a class as expected.");
                }
            }
            catch (ClassNotFoundException e2) {
                throw new AssertionViolatedException("Missing class: " + e2.toString());
            }
        }

        private boolean objarrayequals(Object[] o2, Object[] p2) {
            if (o2.length != p2.length) {
                return false;
            }
            for (int i2 = 0; i2 < o2.length; ++i2) {
                if (o2[i2].equals(p2[i2])) continue;
                return false;
            }
            return true;
        }
    }
}

