/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.ByteArrayInputStream;
import java.util.Hashtable;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.util.ClassLoaderRepository;
import org.apache.bcel.util.Repository;
import org.apache.bcel.util.SyntheticRepository;

public class ClassLoader
extends java.lang.ClassLoader {
    public static final String[] DEFAULT_IGNORED_PACKAGES = new String[]{"java.", "javax.", "sun."};
    private Hashtable classes = new Hashtable();
    private String[] ignored_packages;
    private Repository repository = SyntheticRepository.getInstance();

    public ClassLoader() {
        this(DEFAULT_IGNORED_PACKAGES);
    }

    public ClassLoader(java.lang.ClassLoader deferTo) {
        super(deferTo);
        this.ignored_packages = DEFAULT_IGNORED_PACKAGES;
        this.repository = new ClassLoaderRepository(deferTo);
    }

    public ClassLoader(String[] ignored_packages) {
        this.ignored_packages = ignored_packages;
    }

    public ClassLoader(java.lang.ClassLoader deferTo, String[] ignored_packages) {
        this(ignored_packages);
        this.repository = new ClassLoaderRepository(deferTo);
    }

    protected Class loadClass(String class_name, boolean resolve) throws ClassNotFoundException {
        Class<?> cl = null;
        cl = (Class<?>)this.classes.get(class_name);
        if (cl == null) {
            for (int i2 = 0; i2 < this.ignored_packages.length; ++i2) {
                if (!class_name.startsWith(this.ignored_packages[i2])) continue;
                cl = this.getParent().loadClass(class_name);
                break;
            }
            if (cl == null) {
                JavaClass clazz = null;
                if (class_name.indexOf("$$BCEL$$") >= 0) {
                    clazz = this.createClass(class_name);
                } else {
                    clazz = this.repository.loadClass(class_name);
                    if (clazz != null) {
                        clazz = this.modifyClass(clazz);
                    } else {
                        throw new ClassNotFoundException(class_name);
                    }
                }
                if (clazz != null) {
                    byte[] bytes = clazz.getBytes();
                    cl = this.defineClass(class_name, bytes, 0, bytes.length);
                } else {
                    cl = Class.forName(class_name);
                }
            }
            if (resolve) {
                this.resolveClass(cl);
            }
        }
        this.classes.put(class_name, cl);
        return cl;
    }

    protected JavaClass modifyClass(JavaClass clazz) {
        return clazz;
    }

    protected JavaClass createClass(String class_name) {
        int index = class_name.indexOf("$$BCEL$$");
        String real_name = class_name.substring(index + 8);
        JavaClass clazz = null;
        try {
            byte[] bytes = Utility.decode(real_name, true);
            ClassParser parser = new ClassParser(new ByteArrayInputStream(bytes), "foo");
            clazz = parser.parse();
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return null;
        }
        ConstantPool cp = clazz.getConstantPool();
        ConstantClass cl = (ConstantClass)cp.getConstant(clazz.getClassNameIndex(), (byte)7);
        ConstantUtf8 name = (ConstantUtf8)cp.getConstant(cl.getNameIndex(), (byte)1);
        name.setBytes(class_name.replace('.', '/'));
        return clazz;
    }
}

