/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import com.rsa.jsafe.bz;
import java.io.Serializable;

public class JA_RSAPublicKey
extends JSAFE_PublicKey
implements Cloneable,
Serializable {
    private byte[] a;
    private byte[] b;

    public String getAlgorithm() {
        return "RSA";
    }

    public String[] getSupportedSetFormats() {
        String[] stringArray = new String[]{"RSAPublicKey", "RSAPublicKeyBER"};
        return stringArray;
    }

    public String[] getSupportedGetFormats() {
        if (this.a == null || this.b == null) {
            return new String[0];
        }
        String[] stringArray = new String[]{"RSAPublicKey", "RSAPublicKeyBER"};
        return stringArray;
    }

    public void setKeyData(String string, byte[][] byArray) throws JSAFE_InvalidKeyException, JSAFE_UnimplementedException {
        if (string.compareTo("RSAPublicKeyBER") == 0) {
            if (byArray == null || byArray.length != 1) {
                this.c();
                throw new JSAFE_InvalidKeyException("Invalid key data format.");
            }
            this.a(byArray[0], 0);
            return;
        }
        if (string.compareTo("RSAPublicKey") != 0) {
            this.c();
            throw new JSAFE_InvalidKeyException("Unknown key data format.");
        }
        this.setKeyData(byArray);
    }

    public void setKeyData(byte[][] byArray) throws JSAFE_InvalidKeyException {
        this.c();
        if (byArray == null || byArray.length != 2) {
            throw new JSAFE_InvalidKeyException("Invalid input for RSA public key, expected { modulus, publicExponent }");
        }
        this.a(byArray[0], 0, byArray[0].length, byArray[1], 0, byArray[1].length);
    }

    public void a(byte[] byArray, int n2) throws JSAFE_InvalidKeyException {
        this.c();
        bz.a(this, byArray, n2);
    }

    void a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) throws JSAFE_InvalidKeyException {
        this.c();
        if (byArray == null || n3 <= 0) {
            throw new JSAFE_InvalidKeyException("RSA modulus not found.");
        }
        while (byArray[n2] == 0) {
            --n3;
            ++n2;
        }
        this.a = new byte[n3];
        System.arraycopy(byArray, n2, this.a, 0, n3);
        int n6 = this.a.length * 8;
        int n7 = this.a[0] & 0xFF;
        int n8 = n7 & 0x80;
        while (n8 == 0) {
            --n6;
            n8 = n7 << 1 & 0xFF;
        }
        if (n6 < 256 || n6 > 4096) {
            throw new JSAFE_InvalidKeyException("Invalid RSA modulus size. Expected a value from 256 to 4096 bits long.");
        }
        while (byArray2[n4] == 0) {
            --n5;
            ++n4;
        }
        this.b = new byte[n5];
        System.arraycopy(byArray2, n4, this.b, 0, n5);
    }

    public int getMaximumKeyLength() {
        return 4096;
    }

    public int getMinimumKeyLength() {
        return 256;
    }

    public byte[][] getKeyData(String string) throws JSAFE_UnimplementedException {
        if (string.compareTo("RSAPublicKeyBER") == 0) {
            return this.d();
        }
        if (string.compareTo("RSAPublicKey") != 0) {
            throw new JSAFE_UnimplementedException("Unknown key data format.");
        }
        return this.getKeyData();
    }

    public byte[][] getKeyData() {
        if (this.a == null || this.b == null) {
            return new byte[0][];
        }
        byte[] byArray = (byte[])this.a.clone();
        byte[] byArray2 = (byte[])this.b.clone();
        byte[][] byArrayArray = new byte[][]{byArray, byArray2};
        return byArrayArray;
    }

    private byte[][] d() {
        if (this.a == null || this.b == null) {
            return new byte[0][];
        }
        try {
            byte[] byArray = bz.a(this.a, this.b);
            byte[][] byArrayArray = new byte[][]{byArray};
            return byArrayArray;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            return new byte[0][];
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof JA_RSAPublicKey)) {
            return false;
        }
        return this.dataEquals(object);
    }

    public boolean dataEquals(Object object) {
        try {
            JSAFE_PublicKey jSAFE_PublicKey = (JSAFE_PublicKey)object;
            if (this.a == null || this.b == null) {
                if (jSAFE_PublicKey.getAlgorithm().compareTo("RSA") != 0) {
                    return false;
                }
                String[] stringArray = jSAFE_PublicKey.getSupportedGetFormats();
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    if (!stringArray[i2].equals("RSAPublicKey")) continue;
                    return false;
                }
                return true;
            }
            byte[][] byArray = jSAFE_PublicKey.getKeyData("RSAPublicKey");
            if (!this.a(this.a, null, byArray[0], null)) {
                return false;
            }
            return this.a(this.b, null, byArray[1], null);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        JA_RSAPublicKey jA_RSAPublicKey = new JA_RSAPublicKey();
        this.a(jA_RSAPublicKey);
        return jA_RSAPublicKey;
    }

    protected void a(JA_RSAPublicKey jA_RSAPublicKey) throws CloneNotSupportedException {
        if (this.a != null) {
            jA_RSAPublicKey.a = (byte[])this.a.clone();
        }
        if (this.b != null) {
            jA_RSAPublicKey.b = (byte[])this.b.clone();
        }
        jA_RSAPublicKey.a((JSAFE_PublicKey)this);
    }

    protected void c() {
        this.b = null;
        this.a = null;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.c();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        try {
            this.clearSensitiveData();
        }
        finally {
            super.finalize();
        }
    }
}

