/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.crmf.Authenticator;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.NonStandardControl;
import com.rsa.certj.crmf.OldCertID;
import com.rsa.certj.crmf.PKIArchiveOptions;
import com.rsa.certj.crmf.PKIPublicationInfo;
import com.rsa.certj.crmf.ProtocolEncryptionKey;
import com.rsa.certj.crmf.RegistrationToken;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.Serializable;

public abstract class Control
implements Cloneable,
Serializable {
    public static final int REG_TOKEN = 0;
    public static final int AUTHENTICATOR = 1;
    public static final int PKI_PUBLICATION_INFO = 2;
    public static final int PKI_ARCHIVE_OPTIONS = 3;
    public static final int OLD_CERT_ID = 4;
    public static final int PROTOCOL_ENCR_KEY = 5;
    public static final int NON_STANDARD = 6;
    protected static byte[][] OID_LIST = new byte[][]{{43, 6, 1, 5, 5, 7, 5, 1, 1}, {43, 6, 1, 5, 5, 7, 5, 1, 2}, {43, 6, 1, 5, 5, 7, 5, 1, 3}, {43, 6, 1, 5, 5, 7, 5, 1, 4}, {43, 6, 1, 5, 5, 7, 5, 1, 5}, {43, 6, 1, 5, 5, 7, 5, 1, 6}};
    protected int controlTypeFlag;
    byte[] a;
    protected int special;
    protected ASN1Template asn1Template;
    protected String controlTypeString;
    protected static CertPathCtx theCertPathCtx;
    protected static CertJ theCertJ;
    protected JSAFE_PublicKey pubKey = null;
    protected JSAFE_PrivateKey privKey = null;

    public static Control getInstance(byte[] byArray, int n2, int n3, CertJ certJ, CertPathCtx certPathCtx, JSAFE_PublicKey jSAFE_PublicKey, JSAFE_PrivateKey jSAFE_PrivateKey) throws CRMFException {
        if (byArray == null || n2 < 0) {
            throw new CRMFException("Control encoding is null.");
        }
        ASN1Container[] aSN1ContainerArray = Control.decodeControl(byArray, n2, n3);
        int n4 = Control.a(aSN1ContainerArray[1].data, aSN1ContainerArray[1].dataOffset, aSN1ContainerArray[1].dataLen);
        Control control = null;
        switch (n4) {
            case 0: {
                control = new RegistrationToken();
                break;
            }
            case 1: {
                control = new Authenticator();
                break;
            }
            case 2: {
                control = new PKIPublicationInfo();
                break;
            }
            case 3: {
                control = new PKIArchiveOptions();
                control.setEnvironment(certJ, certPathCtx, jSAFE_PublicKey, jSAFE_PrivateKey);
                break;
            }
            case 4: {
                control = new OldCertID();
                break;
            }
            case 5: {
                control = new ProtocolEncryptionKey();
                break;
            }
            case 6: {
                control = new NonStandardControl();
                control.a = new byte[aSN1ContainerArray[1].dataLen];
                System.arraycopy(aSN1ContainerArray[1].data, aSN1ContainerArray[1].dataOffset, control.a, 0, aSN1ContainerArray[1].dataLen);
            }
        }
        control.decodeValue(aSN1ContainerArray[2].data, aSN1ContainerArray[2].dataOffset);
        for (int i2 = 0; i2 < aSN1ContainerArray.length; ++i2) {
            aSN1ContainerArray[i2].clearSensitiveData();
        }
        return control;
    }

    public static Control getInstance(byte[] byArray, int n2, int n3) throws CRMFException {
        return Control.getInstance(byArray, n2, n3, null, null, null, null);
    }

    protected static ASN1Container[] decodeControl(byte[] byArray, int n2, int n3) throws CRMFException {
        if (byArray == null || n2 < 0) {
            throw new CRMFException("Control encoding is null.");
        }
        SequenceContainer sequenceContainer = new SequenceContainer(n3);
        EndContainer endContainer = new EndContainer();
        OIDContainer oIDContainer = new OIDContainer(0x1000000);
        EncodedContainer encodedContainer = new EncodedContainer(65280);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
        try {
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Cannot read the BER of the control." + aSN_Exception.getMessage());
        }
        return aSN1ContainerArray;
    }

    private static int a(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            return 6;
        }
        for (int i2 = 0; i2 < 6; ++i2) {
            int n4;
            if (n3 != OID_LIST[i2].length) continue;
            for (n4 = 0; n4 < n3 && (byArray[n4 + n2] & 0xFF) == (OID_LIST[i2][n4] & 0xFF); ++n4) {
            }
            if (n4 < n3) continue;
            return i2;
        }
        return 6;
    }

    public String getControlTypeString() {
        return this.controlTypeString;
    }

    protected abstract void decodeValue(byte[] var1, int var2) throws CRMFException;

    public byte[] getOID() {
        if (this.a == null) {
            return null;
        }
        return (byte[])this.a.clone();
    }

    public boolean compareOID(byte[] byArray) {
        if (byArray == null || this.a == null) {
            return false;
        }
        if (byArray.length != this.a.length) {
            return false;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == this.a[i2]) continue;
            return false;
        }
        return true;
    }

    public int getControlType() {
        return this.controlTypeFlag;
    }

    public int getDERLen(int n2) throws CRMFException {
        return this.derEncodeControlLen(n2, this.derEncodeValueInit());
    }

    protected abstract int derEncodeValueInit() throws CRMFException;

    public static int getNextBEROffset(byte[] byArray, int n2) throws CRMFException {
        if (byArray == null || n2 < 0) {
            throw new CRMFException("Control encoding is null.");
        }
        try {
            return n2 + ASN1Lengths.determineLength(byArray, n2);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Could not read the BER encoding." + aSN_Exception.getMessage());
        }
    }

    public int getDEREncoding(byte[] byArray, int n2, int n3) throws CRMFException {
        if (byArray == null || n2 < 0) {
            throw new CRMFException("Passed control array is null.");
        }
        return this.derEncodeControl(byArray, n2, n3);
    }

    public boolean isControlType(int n2) {
        return n2 == this.controlTypeFlag;
    }

    public int derEncodeControlLen(int n2, int n3) throws CRMFException {
        this.special = n2;
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            EndContainer endContainer = new EndContainer();
            OIDContainer oIDContainer = new OIDContainer(0x1000000, true, 0, this.a, 0, this.a.length);
            EncodedContainer encodedContainer = new EncodedContainer(65280, true, 0, null, 0, n3);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
            this.asn1Template = new ASN1Template(aSN1ContainerArray);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Cannot encode control. " + aSN_Exception.getMessage());
        }
    }

    protected int derEncodeControl(byte[] byArray, int n2, int n3) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("Passed control array is null.");
        }
        if ((this.asn1Template == null || this.special != n3) && this.getDERLen(n3) == 0) {
            throw new CRMFException("Could not encode, missing data");
        }
        int n4 = 0;
        try {
            n4 = this.asn1Template.derEncode(byArray, n2);
            this.asn1Template = null;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Cannot encode control. " + aSN_Exception.getMessage());
        }
        n4 += this.derEncodeValue(byArray, n2 + n4);
        return n4;
    }

    protected abstract int derEncodeValue(byte[] var1, int var2) throws CRMFException;

    protected void copyValues(Control control) throws CloneNotSupportedException {
        control.special = this.special;
        if (this.asn1Template == null) {
            return;
        }
        try {
            control.getDERLen(this.special);
        }
        catch (CRMFException cRMFException) {
            throw new CloneNotSupportedException(cRMFException.getMessage());
        }
    }

    public void setEnvironment(CertJ certJ, CertPathCtx certPathCtx, JSAFE_PublicKey jSAFE_PublicKey, JSAFE_PrivateKey jSAFE_PrivateKey) throws CRMFException {
        theCertJ = certJ;
        theCertPathCtx = certPathCtx;
        if (jSAFE_PublicKey != null) {
            this.pubKey = jSAFE_PublicKey;
        }
        if (jSAFE_PrivateKey != null) {
            this.privKey = jSAFE_PrivateKey;
        }
    }

    public abstract boolean equals(Object var1);

    public abstract Object clone() throws CloneNotSupportedException;
}

