/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ucf;

import com.adobe.ucf.ISigner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.pkcs.PKCS9Attributes;
import sun.security.pkcs.SignerInfo;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;

class DetachedPKCS7Signer
implements ISigner {
    private static final String SHA1_WITH_RSA = "SHA1withRSA";
    private static final String SHA1 = "SHA1";
    private PrivateKey m_privateKey;
    private X509Certificate m_signingCertificate;
    private List<X509Certificate> m_certificateChain;
    private byte[] m_bytesToSign;
    private File m_output;

    public DetachedPKCS7Signer() {
        int TYPICAL_CHAIN_LENGTH = 3;
        this.m_certificateChain = new ArrayList<X509Certificate>(3);
    }

    public void setPrivateKey(PrivateKey privateKey) {
        if (privateKey.getAlgorithm() != "RSA") {
            throw new IllegalArgumentException("not an RSA key");
        }
        this.m_privateKey = privateKey;
    }

    public void setCertificateChain(Certificate[] certificateChain) throws CertificateException {
        this.m_certificateChain = new ArrayList<X509Certificate>();
        for (int i2 = 0; i2 < certificateChain.length; ++i2) {
            Certificate c2 = certificateChain[i2];
            if (!(c2 instanceof X509Certificate)) {
                throw new CertificateException("not an X509 certificate");
            }
            ((X509Certificate)c2).checkValidity();
            this.m_certificateChain.add((X509Certificate)c2);
        }
    }

    public void setSignerCertificate(Certificate signingCertificate) throws CertificateException {
        if (!(signingCertificate instanceof X509Certificate)) {
            throw new CertificateException("not an X509 certificate");
        }
        ((X509Certificate)signingCertificate).checkValidity();
        this.m_signingCertificate = (X509Certificate)signingCertificate;
    }

    public void setAlsoIncludeOldStyleTimestamp() {
        throw new UnsupportedOperationException("setAlsoIncludeOldStyleTimestamp() not supported");
    }

    public void setTimestampURL(String url) {
    }

    public void setOutput(File output) throws IOException {
        this.m_output = output;
    }

    public void setInput(File input) throws IOException {
        FileInputStream fis = new FileInputStream(input);
        this.m_bytesToSign = new byte[(int)input.length()];
        fis.read(this.m_bytesToSign, 0, (int)input.length());
        fis.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sign() throws GeneralSecurityException, IOException {
        try {
            byte[] signatureBytes;
            PKCS9Attributes authenticatedPkcs9Attributes;
            block6: {
                MessageDigest digester = MessageDigest.getInstance(SHA1);
                digester.update(this.m_bytesToSign);
                byte[] digestBytes = digester.digest();
                Date signingDate = new Date();
                PKCS9Attribute[] pkcs9AttributeArray = new PKCS9Attribute[]{new PKCS9Attribute(PKCS9Attribute.CONTENT_TYPE_OID, ContentInfo.DATA_OID), new PKCS9Attribute(PKCS9Attribute.MESSAGE_DIGEST_OID, digestBytes), new PKCS9Attribute(PKCS9Attribute.SIGNING_TIME_OID, signingDate)};
                authenticatedPkcs9Attributes = new PKCS9Attributes(pkcs9AttributeArray);
                signatureBytes = null;
                try {
                    Signature signature = Signature.getInstance(SHA1_WITH_RSA);
                    signature.initSign(this.m_privateKey);
                    signature.update(authenticatedPkcs9Attributes.getDerEncoding());
                    signatureBytes = signature.sign();
                }
                catch (NoSuchAlgorithmException e2) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError();
                }
            }
            PKCS9Attributes unauthenticatedPkcs9Attributes = null;
            X500Name signingCertificateName = new X500Name(this.m_signingCertificate.getIssuerX500Principal().getName());
            BigInteger signingCertificateSerial = this.m_signingCertificate.getSerialNumber();
            SignerInfo signerInfo = new SignerInfo(signingCertificateName, signingCertificateSerial, new AlgorithmId(AlgorithmId.SHA_oid), authenticatedPkcs9Attributes, new AlgorithmId(AlgorithmId.RSAEncryption_oid), signatureBytes, unauthenticatedPkcs9Attributes);
            ContentInfo noContent = new ContentInfo(ContentInfo.DATA_OID, null);
            AlgorithmId[] algorithmIds = new AlgorithmId[]{AlgorithmId.get(SHA1)};
            SignerInfo[] signerInfos = new SignerInfo[]{signerInfo};
            PKCS7 pkcs7 = new PKCS7(algorithmIds, noContent, this.m_certificateChain.toArray(new X509Certificate[0]), signerInfos);
            FileOutputStream fos = new FileOutputStream(this.m_output);
            try {
                fos = new FileOutputStream(this.m_output);
                pkcs7.encodeSignedData(fos);
                Object var16_16 = null;
            }
            catch (Throwable throwable) {
                Object var16_17 = null;
                fos.close();
                fos = null;
                throw throwable;
            }
            fos.close();
            fos = null;
            Object var18_19 = null;
        }
        catch (Throwable throwable) {
            Object var18_20 = null;
            throw throwable;
        }
    }
}

