/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.png;

import com.adobe.png.PNGChunk;
import java.io.UnsupportedEncodingException;

public class PNGTextChunk
extends PNGChunk {
    public static final String TYPE_STR = "tEXt";
    private static final String LATIN_1_ENCODING = "ISO-8859-1";
    public final String m_keyword;
    public final String m_value;

    public PNGTextChunk(PNGChunk chunk) {
        super(chunk.type, chunk.data);
        int pos;
        if (this.typeStr != TYPE_STR) {
            throw new IllegalArgumentException("chunk.type");
        }
        byte[] data = chunk.data;
        for (pos = 0; pos < data.length && data[pos] != 0; ++pos) {
        }
        try {
            this.m_keyword = new String(data, 0, pos, LATIN_1_ENCODING).intern();
            this.m_value = ++pos < data.length ? new String(data, pos, data.length - pos, LATIN_1_ENCODING) : null;
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
    }

    public PNGTextChunk(String keyword, String value) {
        super(TYPE_STR, PNGTextChunk.makeData(keyword, value));
        this.m_keyword = keyword.intern();
        this.m_value = value;
    }

    private static byte[] makeData(String keyword, String value) {
        byte[] keywordBytes;
        try {
            keywordBytes = keyword.getBytes(LATIN_1_ENCODING);
        }
        catch (UnsupportedEncodingException e2) {
            throw new IllegalArgumentException("keyword");
        }
        byte[] valueBytes = null;
        try {
            if (value != null) {
                valueBytes = value.getBytes(LATIN_1_ENCODING);
            }
        }
        catch (UnsupportedEncodingException e3) {
            throw new IllegalArgumentException("value");
        }
        byte[] data = new byte[keywordBytes.length + (valueBytes != null ? 1 + valueBytes.length : 0)];
        System.arraycopy(keywordBytes, 0, data, 0, keywordBytes.length);
        if (valueBytes != null) {
            System.arraycopy(valueBytes, 0, data, keywordBytes.length + 1, valueBytes.length);
        }
        return data;
    }
}

