/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.png;

import com.adobe.png.PNGChunk;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.zip.DeflaterOutputStream;

public class PNGCompressedChunk
extends PNGChunk {
    public static final String TYPE_STR = "zTXt";
    public static final byte COMPRESSION_METHOD = 0;
    private static final String LATIN_1_ENCODING = "ISO-8859-1";
    public final String m_keyword;

    public PNGCompressedChunk(PNGChunk chunk) {
        super(chunk.type, chunk.data);
        int pos;
        if (this.typeStr != TYPE_STR) {
            throw new IllegalArgumentException("chunk.type");
        }
        byte[] data = chunk.data;
        for (pos = 0; pos < data.length && data[pos] != 0; ++pos) {
        }
        try {
            this.m_keyword = new String(data, 0, pos, LATIN_1_ENCODING).intern();
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
    }

    public PNGCompressedChunk(String keyword, byte[] dataToCompress) {
        super(TYPE_STR, PNGCompressedChunk.makeData(keyword, dataToCompress));
        this.m_keyword = keyword.intern();
    }

    private static byte[] makeData(String keyword, byte[] dataToCompress) {
        byte[] keywordBytes;
        try {
            keywordBytes = keyword.getBytes(LATIN_1_ENCODING);
        }
        catch (UnsupportedEncodingException e2) {
            throw new IllegalArgumentException("keyword");
        }
        byte[] compressedBytes = null;
        try {
            ByteArrayOutputStream compressedByteStream = new ByteArrayOutputStream();
            DeflaterOutputStream compressor = new DeflaterOutputStream(compressedByteStream);
            compressor.write(dataToCompress);
            compressor.finish();
            compressor.close();
            compressedBytes = compressedByteStream.toByteArray();
        }
        catch (IOException e3) {
            throw new IllegalArgumentException("filepath");
        }
        byte[] data = new byte[keywordBytes.length + (compressedBytes != null ? 2 + compressedBytes.length : 0)];
        System.arraycopy(keywordBytes, 0, data, 0, keywordBytes.length);
        data[keywordBytes.length] = 0;
        data[keywordBytes.length + 1] = 0;
        if (compressedBytes != null) {
            System.arraycopy(compressedBytes, 0, data, keywordBytes.length + 2, compressedBytes.length);
        }
        return data;
    }
}

