/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.validator;

import com.adobe.air.validator.DescriptorValidator;
import com.adobe.air.validator.IosExtensionDescriptorValidator34;
import java.util.ArrayList;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IosExtensionDescriptorValidator35
extends IosExtensionDescriptorValidator34 {
    private static final Pattern dependencyPattern = Pattern.compile("(\\S|\\s)*\\S+\\.(o|a|framework)$");
    private ArrayList<String> _dependencies = new ArrayList();

    @Override
    protected DescriptorValidator.ElementInfo createElementInfoTree() {
        DescriptorValidator.ElementInfo root = super.createElementInfoTree();
        root.addChild(new DescriptorValidator.ElementInfo("packagedDependencies", 0, 1));
        DescriptorValidator.ElementInfo temp = root.getChild("packagedDependencies");
        temp.addChild(new DescriptorValidator.ElementInfo("packagedDependency", 0, -1));
        return root;
    }

    @Override
    protected boolean validateElement(String elementPath, String value) {
        if (!super.validateElement(elementPath, value)) {
            return false;
        }
        if (elementPath.equals("platform.packagedDependencies.packagedDependency")) {
            if (dependencyPattern.matcher(value).matches()) {
                return this._dependencies.add(value.trim());
            }
            this.dispatchError(105, new String[]{elementPath});
        }
        return true;
    }

    @Override
    protected String getNamespace() {
        return "http://ns.adobe.com/air/extension/3.5";
    }

    public ArrayList<String> dependencies() {
        return this._dependencies;
    }
}

