/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.validator;

import com.adobe.air.UnicodeInputStream;
import com.adobe.air.Utils;
import com.adobe.air.validator.ApplicationDescriptorValidator36;
import com.adobe.air.validator.DescriptorValidator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationDescriptorValidator37
extends ApplicationDescriptorValidator36 {
    private String _iosRenderModeCPUDevices = null;
    private String _externalSwfsPathFile = null;
    protected HashSet<String> _externalSwfs = null;

    @Override
    protected String getNamespace() {
        return "http://ns.adobe.com/air/application/3.7";
    }

    @Override
    public int getMaximumSWFVersion() {
        return 20;
    }

    @Override
    protected DescriptorValidator.ElementInfo createElementInfoTree() {
        DescriptorValidator.ElementInfo root = super.createElementInfoTree();
        DescriptorValidator.ElementInfo temp = root.getChild("icon");
        temp.addChild(new DescriptorValidator.ElementInfo("image96x96", 0, 1));
        temp.addChild(new DescriptorValidator.ElementInfo("image732x412", 0, 1));
        temp = root.getChild("iPhone");
        temp.addChild(new DescriptorValidator.ElementInfo("forceCPURenderModeForDevices", 0, 1));
        temp.addChild(new DescriptorValidator.ElementInfo("externalSwfs", 0, 1));
        return root;
    }

    @Override
    protected boolean validateElement(String elementPath, String value) {
        int size;
        boolean valid = super.validateElement(elementPath, value);
        if (elementPath.equals("application.icon.image96x96")) {
            size = this.getIntFromIconSize(elementPath);
            String imageUri = this.validateImageUri(value, size, size);
            valid = imageUri != null;
            this._appIcons.put(this.getIntFromIconSize(elementPath), imageUri);
        }
        if (elementPath.equals("application.icon.image732x412")) {
            size = this.getIntFromIconSize(elementPath);
            int height = this.getHeightFromIconSize(elementPath);
            String imageUri = this.validateImageUri(value, height, size);
            valid = imageUri != null;
            this._appIcons.put(this.getIntFromIconSize(elementPath), imageUri);
        }
        if (elementPath.equals("application.iPhone.forceCPURenderModeForDevices")) {
            valid = true;
            this._iosRenderModeCPUDevices = value.trim().replace(System.getProperty("line.separator"), " ");
        } else if (elementPath.equals("application.iPhone.externalSwfs")) {
            valid = this.validExternalSwfsPathFileUri(value) != null;
        }
        return valid;
    }

    @Override
    protected boolean validateAttribute(String attributePath, String value) {
        return super.validateAttribute(attributePath, value);
    }

    protected String validExternalSwfsPathFileUri(String path) {
        String uriPath;
        URI uri = this.validateUri(path);
        if (uri == null) {
            return null;
        }
        this._externalSwfsPathFile = uriPath = Utils.performPlatformUnicodePathNormalization(uri.getPath().substring(1));
        return uriPath;
    }

    public void validateExternalSwfs(Map<String, File> sources) {
        if (this._externalSwfsPathFile != null) {
            if (!sources.containsKey(this._externalSwfsPathFile)) {
                this.dispatchError(308, new String[]{this._externalSwfsPathFile.trim()});
                return;
            }
            File file = sources.get(this._externalSwfsPathFile);
            try {
                FileInputStream inputStream = new FileInputStream(file);
                this.validateExternalSwfsFileContent(inputStream);
                inputStream.close();
                Iterator<String> iter = this._externalSwfs.iterator();
                while (iter.hasNext()) {
                    String swf = iter.next().toString();
                    if (sources.containsKey(swf)) continue;
                    this.dispatchError(308, new String[]{swf});
                    return;
                }
            }
            catch (IOException ex) {
                this.dispatchError(300, new String[]{this._externalSwfsPathFile.trim()});
            }
        }
    }

    private void validateExternalSwfsFileContent(FileInputStream inputStream) {
        try {
            String strLine;
            UnicodeInputStream uInputStream = new UnicodeInputStream(inputStream);
            InputStreamReader inputReader = uInputStream.getByteOrderMark() != UnicodeInputStream.ByteOrderMark.NONE ? new InputStreamReader((InputStream)uInputStream, uInputStream.getBOMCharsetKey()) : new InputStreamReader(uInputStream);
            BufferedReader buffReader = new BufferedReader(inputReader);
            this._externalSwfs = new HashSet();
            String swfExt = "swf";
            uInputStream.skipByteOrderMark();
            while ((strLine = buffReader.readLine()) != null) {
                if ((strLine = strLine.trim()).equals("")) continue;
                if (strLine.substring(strLine.lastIndexOf(".") + 1, strLine.length()).equalsIgnoreCase("swf")) {
                    this._externalSwfs.add(strLine);
                    continue;
                }
                this.dispatchError(309, new String[]{this._externalSwfsPathFile});
                break;
            }
            buffReader.close();
            inputReader.close();
            uInputStream.close();
        }
        catch (IOException ex) {
            this.dispatchError(300, new String[]{this._externalSwfsPathFile.trim()});
        }
    }

    protected int getHeightFromIconSize(String size) {
        String str = size.substring(0, size.lastIndexOf(120));
        return Integer.parseInt(str.substring(str.lastIndexOf(101) + 1));
    }

    public HashSet<String> externalSwfs() {
        return this._externalSwfs;
    }

    public String iosRenderModeCPUDevices() {
        return this._iosRenderModeCPUDevices;
    }
}

