/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.validator;

import com.adobe.air.validator.ApplicationDescriptorValidator35;
import com.adobe.air.validator.DescriptorValidator;

public class ApplicationDescriptorValidator36
extends ApplicationDescriptorValidator35 {
    private String _iosDisplayModeExcludedDevices = null;
    private String _osxDisplayMode = "standard";

    protected String getNamespace() {
        return "http://ns.adobe.com/air/application/3.6";
    }

    public int getMaximumSWFVersion() {
        return 19;
    }

    protected DescriptorValidator.ElementInfo createElementInfoTree() {
        DescriptorValidator.ElementInfo root = super.createElementInfoTree();
        DescriptorValidator.ElementInfo temp = root.getChild("initialWindow");
        temp.addChild(new DescriptorValidator.ElementInfo("requestedDisplayResolution", 0, 1));
        temp = root.getChild("iPhone");
        temp = temp.getChild("requestedDisplayResolution");
        temp.addAttribute(new DescriptorValidator.AttributeInfo("excludeDevices", false));
        return root;
    }

    protected boolean validateElement(String elementPath, String value) {
        boolean valid = super.validateElement(elementPath, value);
        if (elementPath.equals("application.initialWindow.requestedDisplayResolution")) {
            valid = this._validDisplayModes.contains(value);
            this._osxDisplayMode = value;
        }
        return valid;
    }

    protected boolean validateAttribute(String attributePath, String value) {
        boolean valid = super.validateAttribute(attributePath, value);
        if (attributePath.equals("application.iPhone.requestedDisplayResolution@excludeDevices")) {
            this._iosDisplayModeExcludedDevices = value.trim().replace(System.getProperty("line.separator"), " ");
        }
        return valid;
    }

    public String iosDisplayModeExcludedDevices() {
        return this._iosDisplayModeExcludedDevices;
    }

    public String osxDisplayMode() {
        return this._osxDisplayMode;
    }
}

