/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.validator;

import com.adobe.air.ApplicationDescriptor;
import com.adobe.air.validator.ApplicationDescriptorValidator;
import com.adobe.air.validator.ApplicationDescriptorValidator31;
import com.adobe.air.validator.DescriptorValidator;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationDescriptorValidator32
extends ApplicationDescriptorValidator31 {
    private List<String> _supportedLanguages = null;
    private Boolean _depthAndStencil = null;

    @Override
    protected String getNamespace() {
        return "http://ns.adobe.com/air/application/3.2";
    }

    @Override
    public int getMaximumSWFVersion() {
        return 15;
    }

    @Override
    protected DescriptorValidator.ElementInfo createElementInfoTree() {
        DescriptorValidator.ElementInfo root = super.createElementInfoTree();
        root.addChild(new DescriptorValidator.ElementInfo("supportedLanguages", 0, 1));
        DescriptorValidator.ElementInfo temp = root.getChild("initialWindow");
        temp.addChild(new DescriptorValidator.ElementInfo("depthAndStencil", 0, 1));
        return root;
    }

    @Override
    protected boolean validateElement(String elementPath, String value) {
        boolean valid = super.validateElement(elementPath, value);
        if (elementPath.equals("application.supportedLanguages")) {
            String[] languageArray = value.trim().split("\\s+");
            if (languageArray.length == 0) {
                this.dispatchError(110, new String[]{elementPath, value});
            } else {
                this._supportedLanguages = new ArrayList<String>();
                for (int i2 = 0; i2 < languageArray.length; ++i2) {
                    if (this._supportedLanguages.contains(languageArray[i2])) {
                        this.dispatchError(109, new String[]{elementPath, value});
                        break;
                    }
                    if (!ApplicationDescriptor.ALL_SUPPORTED_LANGUAGES.contains(languageArray[i2])) {
                        valid = false;
                        break;
                    }
                    this._supportedLanguages.add(languageArray[i2]);
                }
            }
        } else if (elementPath.equals("application.initialWindow.depthAndStencil")) {
            valid = ApplicationDescriptorValidator.validateBooleanType(value);
            this._depthAndStencil = ApplicationDescriptorValidator32.evaluateBooleanType(value);
        }
        return valid;
    }

    public List<String> supportedLanguages() {
        return this._supportedLanguages;
    }

    public Boolean depthAndStencil() {
        return this._depthAndStencil;
    }
}

