/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.validator;

import com.adobe.air.validator.ApplicationDescriptorValidator25;
import com.adobe.air.validator.DescriptorValidator;
import java.util.HashSet;
import java.util.Set;

public class ApplicationDescriptorValidator26
extends ApplicationDescriptorValidator25 {
    private Set<String> _validSoftKeyboardBehaviors = new HashSet<String>();
    private String _softKeyboardBehavior;
    protected Set<String> _validDisplayModes = new HashSet<String>();
    private String _iosDisplayMode = "standard";

    public ApplicationDescriptorValidator26() {
        this._validSoftKeyboardBehaviors.add("pan");
        this._validSoftKeyboardBehaviors.add("none");
        this._validDisplayModes.add("high");
        this._validDisplayModes.add("standard");
    }

    protected String getNamespace() {
        return "http://ns.adobe.com/air/application/2.6";
    }

    public int getMaximumSWFVersion() {
        return 11;
    }

    protected DescriptorValidator.ElementInfo createElementInfoTree() {
        DescriptorValidator.ElementInfo root = super.createElementInfoTree();
        DescriptorValidator.ElementInfo temp = root.getChild("initialWindow");
        temp.addChild(new DescriptorValidator.ElementInfo("softKeyboardBehavior", 0, 1));
        temp = root.getChild("iPhone");
        temp.addChild(new DescriptorValidator.ElementInfo("requestedDisplayResolution", 0, 1));
        temp = root.getChild("icon");
        temp.addChild(new DescriptorValidator.ElementInfo("image114x114", 0, 1));
        return root;
    }

    protected boolean validateElement(String elementPath, String value) {
        boolean valid = super.validateElement(elementPath, value);
        if (elementPath.equals("application.initialWindow.softKeyboardBehavior")) {
            valid = this._validSoftKeyboardBehaviors.contains(value);
            this._softKeyboardBehavior = value;
        }
        if (elementPath.equals("application.iPhone.requestedDisplayResolution")) {
            valid = this._validDisplayModes.contains(value);
            this._iosDisplayMode = value;
        }
        if (elementPath.equals("application.icon.image114x114")) {
            int size = this.getIntFromIconSize(elementPath);
            String imageUri = this.validateImageUri(value, size, size);
            valid = imageUri != null;
            this._appIcons.put(this.getIntFromIconSize(elementPath), imageUri);
        }
        return valid;
    }

    public String softKeyboardBehavior() {
        return this._softKeyboardBehavior;
    }

    public String iosDisplayMode() {
        return this._iosDisplayMode;
    }
}

