/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.validator;

import com.adobe.air.validator.DescriptorValidator;
import com.adobe.air.validator.PlatformExtensionDescriptorValidator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidExtensionDescriptorValidator40
extends PlatformExtensionDescriptorValidator {
    private static final Pattern namePattern = Pattern.compile("[A-Za-z0-9\\-\\.\\_]{1,255}");
    private String _copyright;
    private ArrayList<String> _dependencies = new ArrayList();
    private ArrayList<String> _resourceFolders = new ArrayList();
    private ArrayList<String> _resourcePackages = new ArrayList();
    private Set<String> _descriptionLangs = new HashSet<String>();
    private final DescriptorValidator.ElementInfo ROOT_ELEMENT_INFO = this.createElementInfoTree();

    protected DescriptorValidator.ElementInfo createElementInfoTree() {
        DescriptorValidator.ElementInfo root = new DescriptorValidator.ElementInfo("platform", 1, 1);
        root.addChild(new DescriptorValidator.ElementInfo("description", 0, 1));
        root.addChild(new DescriptorValidator.ElementInfo("copyright", 0, 1));
        root.addChild(new DescriptorValidator.ElementInfo("packagedDependencies", 0, 1));
        root.addChild(new DescriptorValidator.ElementInfo("packagedResources", 0, 1));
        DescriptorValidator.ElementInfo temp = root.getChild("description");
        temp.contentTypeMixed = true;
        temp.addChild(new DescriptorValidator.ElementInfo("text", 0, -1));
        temp = temp.getChild("text");
        temp.addAttribute(new DescriptorValidator.AttributeInfo("xml:lang", true));
        temp = root.getChild("packagedDependencies");
        temp.addChild(new DescriptorValidator.ElementInfo("packagedDependency", 0, -1));
        temp = root.getChild("packagedResources");
        temp.addChild(new DescriptorValidator.ElementInfo("packagedResource", 0, -1));
        temp = temp.getChild("packagedResource");
        temp.addChild(new DescriptorValidator.ElementInfo("packageName", 1, 1));
        temp.addChild(new DescriptorValidator.ElementInfo("folderName", 1, 1));
        return root;
    }

    @Override
    protected DescriptorValidator.ElementInfo getRootElementInfo() {
        return this.ROOT_ELEMENT_INFO;
    }

    @Override
    protected boolean validateElement(String elementPath, String value) {
        if (elementPath.equals("platform.packagedDependencies.packagedDependency")) {
            if (!namePattern.matcher(value).matches()) {
                this.dispatchError(105, new String[]{elementPath});
            }
            if (this._dependencies.contains(value)) {
                this.dispatchError(109, new String[]{elementPath, value});
            }
            return this._dependencies.add(value.trim());
        }
        if (elementPath.equals("platform.packagedResources.packagedResource.packageName")) {
            if (!namePattern.matcher(value).matches()) {
                this.dispatchError(105, new String[]{elementPath});
            }
            if (!this._resourcePackages.contains(value)) {
                this._resourcePackages.add(value.trim());
            }
            return true;
        }
        if (elementPath.equals("platform.packagedResources.packagedResource.folderName")) {
            if (!namePattern.matcher(value).matches()) {
                this.dispatchError(105, new String[]{elementPath});
            }
            if (!this._resourceFolders.contains(value)) {
                this._resourceFolders.add(value.trim());
            }
            return true;
        }
        if (elementPath.equals("platform.copyright")) {
            this._copyright = value;
        }
        return true;
    }

    @Override
    protected boolean validateAttribute(String attributePath, String value) throws SAXException {
        boolean result = true;
        if (attributePath.equals("platform.description.text@xml:lang")) {
            if (this._descriptionLangs.contains(value)) {
                this.dispatchError(108, new String[]{attributePath, value});
            } else if (DescriptorValidator.validateLanguageType(value)) {
                this._descriptionLangs.add(value);
            } else {
                result = false;
            }
        }
        return result;
    }

    public String copyright() {
        return this._copyright;
    }

    public ArrayList<String> dependencies() {
        return this._dependencies;
    }

    public ArrayList<String> resourceFolders() {
        return this._resourceFolders;
    }

    public ArrayList<String> resourcePackages() {
        return this._resourcePackages;
    }

    @Override
    protected String getNamespace() {
        return "http://ns.adobe.com/air/extension/4.0";
    }

    @Override
    protected void finalizeValidation() throws SAXException {
    }
}

