/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.nai;

import com.adobe.air.ApplicationDescriptor;
import com.adobe.air.nai.NativePackager;
import com.adobe.air.validator.DescriptorValidationException;
import com.adobe.ucf.Utils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WinPackager
extends NativePackager {
    public WinPackager() {
        super("Windows-x86", true, false);
    }

    @Override
    protected String getPlatformConverterName() {
        return ENTRYPOINT_NAME + ".exe";
    }

    @Override
    protected void parseDescriptorValues() {
        try {
            ApplicationDescriptor descriptor = new ApplicationDescriptor(new File(this.m_conversionOutput, "META-INF/AIR/application.xml"));
            this.m_appName = descriptor.filename();
        }
        catch (DescriptorValidationException e2) {
            throw new IllegalStateException("Conversion produced an invalid descriptor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFileWithPermissions(File sourceFile, File destFile) throws IOException {
        AbstractInterruptibleChannel dstChannel;
        block5: {
            FileChannel srcChannel = null;
            dstChannel = null;
            try {
                srcChannel = new FileInputStream(sourceFile).getChannel();
                dstChannel = new FileOutputStream(destFile).getChannel();
                ((FileChannel)dstChannel).transferFrom(srcChannel, 0L, srcChannel.size());
                Object var6_5 = null;
                if (srcChannel == null) break block5;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (srcChannel != null) {
                    srcChannel.close();
                }
                if (dstChannel != null) {
                    dstChannel.close();
                }
                throw throwable;
            }
            srcChannel.close();
        }
        if (dstChannel != null) {
            dstChannel.close();
        }
    }

    protected void copyDirWithPermissions(File sourceFile, File destFile) throws IOException {
        assert (sourceFile.isDirectory());
        assert (destFile.isDirectory());
        ArrayList<String> command = new ArrayList<String>();
        this.formXcopyCommand(command, sourceFile, destFile);
        Process copy = new ProcessBuilder(command).start();
        ByteArrayOutputStream processOutputBytes = new ByteArrayOutputStream();
        new Utils.OutputEater(copy.getInputStream(), processOutputBytes).run();
        new Utils.OutputEater(copy.getErrorStream()).run();
        try {
            copy.waitFor();
        }
        catch (InterruptedException e2) {
            throw new IOException("Copy Interrupted");
        }
        int exitValue = copy.exitValue();
        if (exitValue != 0) {
            String copyOutput = processOutputBytes.toString("UTF-8");
            throw new IOException("Copy failed: " + copyOutput + "\nExit code was " + exitValue);
        }
    }

    private void formXcopyCommand(List<String> command, File sourceFile, File destFile) {
        command.add("xcopy");
        command.add(sourceFile.getParent());
        command.add(destFile.getPath());
        command.add("/E");
        command.add("/H");
        command.add("/K");
        command.add("/Y");
    }
}

