/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.nai;

import com.adobe.air.ADTException;
import com.adobe.air.AIRPackager;
import com.adobe.air.ANEFile;
import com.adobe.air.ApplicationDescriptor;
import com.adobe.air.ApplicationPackager;
import com.adobe.air.InvalidInputException;
import com.adobe.air.SDKDamagedException;
import com.adobe.air.Utils;
import com.adobe.ucf.UCF;
import com.adobe.ucf.Utils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NativePackager
extends ApplicationPackager {
    public static final ApplicationDescriptor.ValidationParams NAI_VALIDATION_PARAMS = new ApplicationDescriptor.ValidationParams("http://ns.adobe.com/air/application/2.0", "http://ns.adobe.com/air/application/3.0", new String[]{"extendedDesktop"}, true, false);
    public static final ApplicationDescriptor.ValidationParams BUNDLE_VALIDATION_PARAMS = new ApplicationDescriptor.ValidationParams("http://ns.adobe.com/air/application/3.0", "http://ns.adobe.com/air/application/3.0", new String[]{"extendedDesktop"}, true, false, false);
    protected static String ENTRYPOINT_NAME = "naip";
    protected UCF.SigningOptions m_nativeSigningOptions = null;
    private AIRPackager m_airPackager;
    private File m_airFileTemp = null;
    protected File m_conversionOutput = null;
    protected String m_appName;
    private boolean m_needsCaptiveFlag = false;

    public NativePackager(String platform, boolean allowAppBundledExtensions, boolean allowDeviceBundledExtensions) {
        super("AIR", platform, allowAppBundledExtensions, allowDeviceBundledExtensions);
        this.m_airPackager = new AIRForNAIPackager(platform, allowAppBundledExtensions, allowDeviceBundledExtensions);
    }

    public void setNativeSigningOptions(UCF.SigningOptions options) {
        this.m_nativeSigningOptions = options;
    }

    @Override
    public void createPackage() throws GeneralSecurityException, IOException {
        if (this.m_airFile == null) {
            this.m_airFileTemp = File.createTempFile("air", null, this.getOutput().getAbsoluteFile().getParentFile());
            this.m_airPackager.setOutput(this.m_airFileTemp);
            this.m_airPackager.createPackage();
            this.m_airFile = this.m_airFileTemp;
            this.m_appName = this.m_airPackager.getApplicationDescriptor().filename();
        }
        if (this.m_migrateSigner != null) {
            this.m_airFileTemp = File.createTempFile("air", null, this.getOutput().getAbsoluteFile().getParentFile());
            this.m_migrateSigner.setInput(this.m_airFile);
            this.m_migrateSigner.setOutput(this.m_airFileTemp);
            try {
                this.m_migrateSigner.sign(NAI_VALIDATION_PARAMS);
            }
            catch (CertificateExpiredException ex) {
                throw new GeneralSecurityException("certificate has expired");
            }
            catch (CertificateNotYetValidException ex) {
                throw new GeneralSecurityException("certificate is not yet valid");
            }
            catch (CertificateException ex) {
                throw new GeneralSecurityException("not an X509 code-signing certificate");
            }
            catch (GeneralSecurityException ex) {
                throw new GeneralSecurityException(ex.getMessage());
            }
            catch (InvalidInputException ex) {
                throw new GeneralSecurityException(ex.getMessage());
            }
            catch (IOException ex) {
                throw new IOException(ex.getMessage());
            }
            if (!this.m_airFile.delete()) {
                throw new IOException("Could not delete temp file " + this.m_airFile.getPath());
            }
            this.m_airFile = this.m_airFileTemp;
        }
        this.invokePlatformConversion();
        this.assembleInternalFiles();
        if (this.m_nativeSigningOptions != null) {
            this.signInternalFiles();
        }
        this.createFinalPackage();
        if (this.m_nativeSigningOptions != null) {
            this.signFinalPackage();
        }
        this.finalizePackage();
    }

    protected abstract String getPlatformConverterName();

    protected abstract void assembleInternalFiles() throws IOException, SDKDamagedException;

    protected abstract void signInternalFiles() throws IOException, SDKDamagedException, GeneralSecurityException;

    protected abstract void createFinalPackage() throws IOException, SDKDamagedException;

    protected abstract void signFinalPackage() throws IOException, SDKDamagedException, GeneralSecurityException;

    protected abstract void finalizePackage() throws IOException;

    protected abstract void parseDescriptorValues() throws IOException;

    public void invokePlatformConversion() throws IOException {
        File converter = new File(this.getNAISDKBinDir(), this.getPlatformConverterName());
        if (!converter.exists()) {
            throw new SDKDamagedException(converter.getPath());
        }
        ArrayList<String> command = new ArrayList<String>(6);
        command.add(converter.getAbsolutePath());
        if (this.m_runtimeDir != null) {
            command.add("-runtime");
            command.add(this.m_runtimeDir.getAbsolutePath());
        } else if (!Utils.getSDKRuntimesDir().exists()) {
            throw new SDKDamagedException("runtimes/");
        }
        this.m_conversionOutput = new File(this.getTempFile(), "temp");
        command.add("-convert");
        command.add(this.m_airFile.getPath());
        command.add(this.m_conversionOutput.getPath());
        if (this.m_needsCaptiveFlag) {
            command.add("-captive");
        }
        try {
            Process conversion = new ProcessBuilder(command).redirectErrorStream(true).start();
            ByteArrayOutputStream processOutputBytes = new ByteArrayOutputStream();
            new Utils.OutputEater(conversion.getInputStream(), processOutputBytes).run();
            new Utils.OutputEater(conversion.getErrorStream()).run();
            conversion.waitFor();
            String processOutput = processOutputBytes.toString("UTF-8");
            switch (conversion.exitValue()) {
                case 0: {
                    break;
                }
                case 7: {
                    throw new InvalidInputException("Descriptor is invalid for native install. The namespace must be at least 2.0 and the app must support the profile extendedDesktop");
                }
                case 4: {
                    throw new ADTException("Failed to load the AIR Runtime", 5);
                }
                case 2: 
                case 6: {
                    if (this.m_airFileTemp == null) {
                        throw new InvalidInputException("Invalid AIR file");
                    }
                    throw new InvalidInputException("Packaging failed. Packager internal error");
                }
                default: {
                    if (this.m_airFileTemp != null) {
                        this.conversionFail("Process exited with error " + conversion.exitValue() + ". Output was \"" + processOutput + "\"");
                    }
                    throw new InvalidInputException("AIR file at " + this.m_airFile + " could not be converted.\n The error was \"" + processOutput + "\"");
                }
            }
        }
        catch (InterruptedException e2) {
            this.conversionFail("Conversion was interrupted");
        }
        this.parseDescriptorValues();
    }

    protected File getNAISDKBinDir() throws IOException {
        return new File(new File(Utils.getSDKLibDir(), "nai"), "bin");
    }

    protected File getNAISDKLibDir() throws IOException {
        return new File(new File(Utils.getSDKLibDir(), "nai"), "lib");
    }

    protected void conversionFail(String reason) throws IOException {
        throw new IOException("Platform conversion failed. " + reason);
    }

    protected void conversionFail() throws IOException {
        this.conversionFail("");
    }

    @Override
    public void close() {
        this.m_airPackager.close();
        if (this.m_airFileTemp != null) {
            this.m_airFileTemp.delete();
        }
        if (this.getTempFile() != null) {
            Utils.deleteAll(this.getTempFile());
        }
    }

    @Override
    public void setOutput(File output) throws FileNotFoundException, IOException {
        super.setOutput(output);
        this.initTempFolder("adt");
    }

    @Override
    public void addSourceWithRoot(File source, File root) {
        this.m_airPackager.addSourceWithRoot(source, root);
    }

    @Override
    public void addSourceWithPath(File source, String path) {
        this.m_airPackager.addSourceWithPath(source, path);
    }

    @Override
    public void addSourceFileOrDir(File file, File root) {
        this.m_airPackager.addSourceFileOrDir(file, root);
    }

    @Override
    protected void addMetaWithPath(File source, String path) {
        this.m_airPackager.addMetaWithPath(source, path);
    }

    @Override
    protected void addMetaFileOrDir(File file, File root, String prefixPath) {
        this.m_airPackager.addMetaFileOrDir(file, root, prefixPath);
    }

    @Override
    public void setValidateExtensions(boolean validate) {
        super.setValidateExtensions(validate);
        this.m_airPackager.setValidateExtensions(validate);
    }

    @Override
    public void setAllowAppBundledExtensions(boolean value) {
        this.m_airPackager.setAllowAppBundledExtensions(value);
    }

    @Override
    public void setAllowDeviceBundledExtensions(boolean value) {
        this.m_airPackager.setAllowDeviceBundledExtensions(value);
    }

    @Override
    public List<ANEFile> getExtensions() {
        return this.m_airPackager.getExtensions();
    }

    @Override
    public void addExtensionDir(File dir) throws InvalidInputException {
        this.m_airPackager.addExtensionDir(dir);
    }

    @Override
    public void setAIRIFile(File intermediate) {
        this.m_airPackager.setAIRIFile(intermediate);
    }

    @Override
    public void setApplicationDescriptor(File descriptorFile) {
        this.m_airPackager.setApplicationDescriptor(descriptorFile);
    }

    @Override
    protected ApplicationDescriptor.ValidationParams getValidationParams(ApplicationDescriptor appDescriptor) {
        return NAI_VALIDATION_PARAMS;
    }

    @Override
    public void setDebug(boolean debug) {
        this.m_airPackager.setDebug(debug);
    }

    @Override
    public void setPrivateKey(PrivateKey key) {
        this.m_airPackager.setPrivateKey(key);
    }

    @Override
    public void setCertificateChain(Certificate[] certchain) throws CertificateException {
        this.m_airPackager.setCertificateChain(certchain);
    }

    @Override
    public void setSignerCertificate(Certificate cert) throws CertificateException {
        this.m_airPackager.setSignerCertificate(cert);
    }

    @Override
    public void setTimestampURL(String url) {
        this.m_airPackager.setTimestampURL(url);
    }

    public void setCaptiveFlag(boolean needsFlag) {
        this.m_needsCaptiveFlag = needsFlag;
    }

    private class AIRForNAIPackager
    extends AIRPackager {
        protected ApplicationDescriptor.ValidationParams getValidationParams(ApplicationDescriptor appDescriptor) {
            return NativePackager.this.getValidationParams(appDescriptor);
        }

        public AIRForNAIPackager(String platform, boolean allowAppBundledExtensions, boolean allowDeviceBundledExtensions) {
            super(platform, allowAppBundledExtensions, allowDeviceBundledExtensions);
        }

        protected boolean validateAssetFile(ApplicationDescriptor appDescriptor, String filePath) throws InvalidInputException {
            return NativePackager.this.validateAssetFile(appDescriptor, filePath);
        }
    }
}

