/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.nai;

import com.adobe.air.ApplicationDescriptor;
import com.adobe.air.Plist;
import com.adobe.air.SDKDamagedException;
import com.adobe.air.Utils;
import com.adobe.air.nai.MacPackager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class DMGPackager
extends MacPackager {
    protected void assembleInternalFiles() throws IOException, SDKDamagedException {
        File conversionOutputMoved = new File(this.getTempFile(), this.m_appName);
        this.m_conversionOutput.renameTo(conversionOutputMoved);
        this.m_conversionOutput = conversionOutputMoved;
        File bootstrapper = new File(this.getNAISDKLibDir(), "naib.app");
        if (!bootstrapper.exists()) {
            throw new SDKDamagedException(bootstrapper.getPath());
        }
        File bootstrapperContents = new File(bootstrapper, "Contents");
        if (!bootstrapperContents.exists()) {
            throw new SDKDamagedException("lib/" + bootstrapper.getName() + "/Contents");
        }
        String installAppName = "Install " + this.m_appName;
        File installApp = new File(this.getTempFile(), installAppName + ".app");
        installApp.mkdir();
        this.copyWithPermissions(bootstrapperContents, installApp);
        File naib = new File(installApp, "Contents/MacOS/naib");
        File executable = new File(installApp, "Contents/MacOS/" + installAppName);
        naib.renameTo(executable);
        File infoPlistFile = new File(installApp, "Contents/Info.plist");
        Plist infoPlist = Plist.newFromFile(infoPlistFile);
        Plist.DictionaryNode dict = infoPlist.getRootDictionary();
        dict.putString("CFBundleExecutable", installAppName);
        dict.putString("CFBundleIdentifier", this.m_applicationDescriptor.id() + ".installer");
        dict.putString("CFBundleShortVersionString", this.m_applicationDescriptor.versionNumber());
        dict.putString("NSHumanReadableCopyright", this.m_applicationDescriptor.copyright() == null ? "" : this.m_applicationDescriptor.copyright());
        dict.putString("LSMinimumSystemVersion", this.m_applicationDescriptor.getLSMinimumSystemVersion());
        FileOutputStream infoPlistOut = new FileOutputStream(infoPlistFile);
        infoPlistOut.write(infoPlist.getXMLString().getBytes("UTF-8"));
        infoPlistOut.close();
        String appPath = "Contents/Resources/" + this.m_appName;
        File app = new File(installApp, appPath).getCanonicalFile();
        this.m_conversionOutput.renameTo(app);
        if (!app.exists()) {
            throw new IOException("Copy failed");
        }
    }

    protected void signInternalFiles() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createFinalPackage() throws IOException {
        File tempDMG2;
        block9: {
            File tempDMG1 = null;
            tempDMG2 = null;
            try {
                try {
                    File tempFile = File.createTempFile("dmg", null, this.getOutput().getAbsoluteFile().getParentFile());
                    tempFile.delete();
                    tempDMG1 = new File(tempFile.getAbsolutePath() + ".dmg");
                    Process makeDMG = new ProcessBuilder("/usr/bin/hdiutil", "makehybrid", "-hfs", "-hfs-volume-name", "Install " + this.m_appName, "-hfs-openfolder", this.getTempFile().getAbsolutePath(), this.getTempFile().getAbsolutePath(), "-o", tempDMG1.getAbsolutePath()).start();
                    Utils.consumeOutput(makeDMG);
                    makeDMG.waitFor();
                    if (makeDMG.exitValue() != 0) {
                        throw new IOException("DMG Creation failed");
                    }
                    tempFile = File.createTempFile("dmg", null, this.getOutput().getAbsoluteFile().getParentFile());
                    tempFile.delete();
                    tempDMG2 = new File(tempFile.getAbsolutePath() + ".dmg");
                    Process compressDMG = new ProcessBuilder("/usr/bin/hdiutil", "convert", tempDMG1.getAbsolutePath(), "-format", "UDBZ", "-o", tempDMG2.getAbsolutePath()).start();
                    Utils.consumeOutput(compressDMG);
                    compressDMG.waitFor();
                    if (compressDMG.exitValue() != 0) {
                        throw new IOException("DMG Creation failed");
                    }
                    if (this.getOutput().exists()) {
                        Utils.deleteAll(this.getOutput());
                    }
                    tempDMG2.renameTo(this.getOutput());
                }
                catch (InterruptedException e2) {
                    throw new IOException("DMG Packaging interrupted");
                }
                Object var7_7 = null;
                if (tempDMG1 == null) break block9;
                tempDMG1.delete();
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (tempDMG1 != null) {
                    tempDMG1.delete();
                }
                if (tempDMG2 == null) throw throwable;
                tempDMG2.delete();
                throw throwable;
            }
        }
        if (tempDMG2 == null) return;
        tempDMG2.delete();
    }

    protected void signFinalPackage() {
    }

    protected void finalizePackage() throws IOException {
    }

    protected ApplicationDescriptor.ValidationParams getValidationParams(ApplicationDescriptor appDescriptor) {
        return NAI_VALIDATION_PARAMS;
    }
}

