/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.ipa;

import com.adobe.air.InvalidInputException;
import com.adobe.air.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IPAUtils {
    public static boolean hasUniversalIOSBinary(String filePath) throws IOException {
        File m_SDKLocation = null;
        try {
            m_SDKLocation = Utils.getSDKLibDir().getParentFile();
        }
        catch (IOException e1) {
            throw new IOException("Error occurred while getting SDK Location");
        }
        String IOS_SDK_FOLDER_NAME = "lib/aot";
        String airIOSSDK = new File(m_SDKLocation, "lib/aot").getAbsolutePath();
        String exeSuffix = "";
        String osName = System.getProperty("os.name");
        if (osName.contains("Windows")) {
            exeSuffix = ".exe";
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(airIOSSDK + File.separator + "bin" + File.separator + "lipo" + File.separator + "lipo" + exeSuffix);
        args.add("-info");
        args.add(filePath);
        try {
            Process cProcess = Utils.execSafely(null, args);
            InputStream stdout = cProcess.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stdout));
            cProcess.waitFor();
            String tempString = "";
            String lastLine = "";
            while ((tempString = reader.readLine()) != null) {
                lastLine = tempString;
            }
            if (lastLine.length() > 0 && lastLine.startsWith("Architectures in the fat file")) {
                String stringAfterLastColon = lastLine.substring(lastLine.lastIndexOf(58) + 1);
                if (stringAfterLastColon.length() > 0) {
                    Pattern p1 = Pattern.compile("\\barmv7\\b");
                    Matcher m1 = p1.matcher(stringAfterLastColon);
                    Pattern p2 = Pattern.compile("\\barm64\\b");
                    Matcher m2 = p2.matcher(stringAfterLastColon);
                    if (m1.find() && m2.find()) {
                        return true;
                    }
                }
                return false;
            }
        }
        catch (InterruptedException e2) {
            throw new InvalidInputException("Couldn't determine the type of Binary.");
        }
        return false;
    }
}

