/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.ipa;

import com.adobe.air.ADTException;
import com.adobe.air.ANEFile;
import com.adobe.air.ApplicationDescriptor;
import com.adobe.air.ApplicationPackager;
import com.adobe.air.InvalidInputException;
import com.adobe.air.Utils;
import com.adobe.air.ipa.ExtensionData;
import com.adobe.air.ipa.IPAOutputStream;
import com.adobe.air.ipa.IPAUtils;
import com.adobe.air.ipa.IosExtensionDescriptor;
import com.adobe.air.ipa.SWFUtils;
import com.adobe.air.validator.DescriptorValidationException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IPAPackager
extends ApplicationPackager {
    private static final Pattern objFilePattern = Pattern.compile("\\S+\\.o");
    private static final Pattern libraryPattern = Pattern.compile("lib\\S+\\.a$");
    private static final Pattern frameworkPattern = Pattern.compile("\\S+\\.framework$");
    private HashMap<String, List<String>> m_dependencies = new HashMap();
    public static final ApplicationDescriptor.ValidationParams IPA_VALIDATION_PARAMS = new ApplicationDescriptor.ValidationParams("http://ns.adobe.com/air/application/2.0", "http://ns.adobe.com/air/application/3.0", new String[]{"mobileDevice", "mobileDeviceBase"}, false, true);

    public IPAPackager() {
        super("AIR", "iPhone-ARM", true, false);
        this.setStream(new IPAOutputStream());
    }

    @Override
    public void setOutput(File output) throws FileNotFoundException, IOException {
        super.setOutput(output);
        this.initTempFile("air");
    }

    @Override
    protected ApplicationDescriptor.ValidationParams getValidationParams(ApplicationDescriptor appDescriptor) {
        return IPA_VALIDATION_PARAMS;
    }

    public void setOptimizeLevel(int optLevel) {
        this.getIPAStream().setOptimizeLevel(optLevel);
    }

    public void setInlineLevel(int inlineLevel) {
        this.getIPAStream().setInlineLevel(inlineLevel);
    }

    public void setCompressSWF(boolean compressFlag) {
        this.getIPAStream().setCompressSWF(compressFlag);
    }

    public void setVerbose(int verbosity) {
        this.getIPAStream().setVerbose(verbosity);
    }

    public int getVerbose() {
        return this.getIPAStream().getVerbose();
    }

    @Override
    public void setDebug(boolean debugFlag) {
        this.getIPAStream().setDebug(debugFlag);
    }

    public void setNoStrip(boolean stripFlag) {
        this.getIPAStream().setNoStrip(stripFlag);
    }

    public void setEnableSSC(boolean enableSSC) {
        this.getIPAStream().setEnableSSC(enableSSC);
    }

    public void setModuleSplitLimit(int splitLimit) {
        this.getIPAStream().setModuleSplitLimit(splitLimit);
    }

    public void setPoolSize(int poolSize) {
        this.getIPAStream().setPoolSize(poolSize);
    }

    public void setForce32Bit(boolean force32Bit) {
        this.getIPAStream().setForce32Bit(force32Bit);
    }

    public void setStackSize(String stackSize) {
        this.getIPAStream().setStackSize(stackSize);
    }

    public void setLogAOTPerf(boolean logPerf) {
        this.getIPAStream().setLogAOTPerf(logPerf);
    }

    public void setHideAneSymbols(boolean hide) {
        this.getIPAStream().setHideAneSymbols(hide);
    }

    public void setGenerateDSYM(boolean genDSYM) {
        this.getIPAStream().setGenerateDSYM(genDSYM);
    }

    public void setDebugRuntime(boolean debugRuntimeFlag) {
        this.getIPAStream().setDebugRuntime(debugRuntimeFlag);
    }

    public void setDebugBuiltins(boolean debugBuiltinsFlag) {
        this.getIPAStream().setDebugBuiltins(debugBuiltinsFlag);
    }

    public void setSamplerEnabled(boolean samplerEnabledFlag) {
        this.getIPAStream().setSamplerEnabled(samplerEnabledFlag);
    }

    @Override
    public void setForOutgoingDebuggingConnection(String debugHost, int debugPort) throws IOException {
        this.getIPAStream().setForOutgoingDebuggingConnection(debugHost, debugPort);
    }

    @Override
    public void setForIncomingDebuggerConnection(int portToListenOn) throws IOException {
        this.getIPAStream().setForIncomingDebuggerConnection(portToListenOn);
    }

    public void setUseInterpreter(boolean interpreterFlag) {
        this.getIPAStream().setUseInterpreter(interpreterFlag);
    }

    public boolean getUseInterpreter() {
        return this.getIPAStream().getUseInterpreter();
    }

    public void setUseHalfmoonAOT(boolean hmaotFlag) {
        this.getIPAStream().setUseHalfmoonAOT(hmaotFlag);
    }

    public void setDryRun(boolean dryRun) {
        this.getIPAStream().setDryRun(dryRun);
    }

    public void setTarget(String target) {
        if (target.equals("x86-simulator-air")) {
            this.m_targetPlatform = "iPhone-x86";
            this.getIPAStream().setSimulatorFlag(true);
        }
        this.getIPAStream().setTarget(target);
    }

    public void setSDKLocation(String location) {
        this.getIPAStream().setSDKLocation(new File(location));
    }

    @Override
    public void setDeviceSDKDirectory(File sdkDir) throws InvalidInputException {
        if (!sdkDir.exists()) {
            throw new InvalidInputException("Directory " + sdkDir.getPath() + " does not exist.");
        }
        if (!sdkDir.isDirectory()) {
            throw new InvalidInputException(sdkDir.getPath() + " is not a directory.");
        }
        Pattern versionString = Pattern.compile("iPhone(OS|Simulator)[0-9]\\.[0-9]\\.sdk");
        Matcher matcher = versionString.matcher(sdkDir.getName());
        if (!matcher.find()) {
            System.out.println("Warning: The path to platform sdk should end with iPhoneOSx.x or iPhoneSimulatorx.x format to avoid any unintended behavior.");
        }
        this.getIPAStream().setPlatformSDKLocation(sdkDir);
    }

    public void setRemoteContentURI(String remoteContent) {
        this.getIPAStream().setRemoteContentURI(remoteContent);
    }

    public void setTimeout(int timeoutSeconds) {
        this.getIPAStream().setTimeout(timeoutSeconds);
    }

    public void addExtraABC(String abc) {
        this.getIPAStream().addExtraABC(abc);
    }

    public void addLinkerOption(String linkoption) {
        this.getIPAStream().addLinkerOption(linkoption);
    }

    public void compileShellApp() throws IOException {
        this.getIPAStream().compileShellApp();
    }

    @Override
    public void setPackageConfiguration(String configType) {
        this.getIPAStream().setPackageConfiguration(configType);
    }

    public void setMobileProvisioningProfile(File profile) {
        this.getIPAStream().setMobileProvisioningProfile(profile);
    }

    public void createIPA() throws GeneralSecurityException, IOException {
        this.createPackage();
    }

    @Override
    public void createPackage() throws IOException, GeneralSecurityException {
        if (System.getProperty("os.name").indexOf("Mac") != -1) {
            String[] versionNumbers = System.getProperty("os.version").split("\\.");
            int majorVersion = Integer.parseInt(versionNumbers[0]);
            int minorVersion = Integer.parseInt(versionNumbers[1]);
            if (majorVersion < 10 || majorVersion == 10 && minorVersion < 7) {
                throw new ADTException("IPA packaging is not supported on mac 10.6 and earlier", 5);
            }
        }
        super.createPackage();
    }

    @Override
    public void setValidate(boolean validate) {
        super.setValidate(validate);
    }

    @Override
    protected void processExtensions() throws IOException, DescriptorValidationException, InvalidInputException {
        super.processExtensions();
        ArrayList<String> faultyIOSLibs = new ArrayList<String>();
        for (ANEFile ane : this.getExtensions()) {
            try {
                ExtensionData extensionData = new ExtensionData(ane.id());
                this.getIPAStream().addExtensionData(extensionData);
                File tempDir = Utils.createTempDirectory();
                this.addFileForCleanup(tempDir);
                String nativeLibraryPath = ane.getNativeLibraryPath(this.m_targetPlatform);
                if (nativeLibraryPath == null) continue;
                ZipFile zipFile = new ZipFile(ane.getFile());
                this.copyFromZip(zipFile, nativeLibraryPath, tempDir.getAbsolutePath() + File.separator + "lib" + ane.id() + ".a");
                if (this.m_targetPlatform.equals("iPhone-ARM") && !IPAUtils.hasUniversalIOSBinary(tempDir.getAbsolutePath() + File.separator + "lib" + ane.id() + ".a")) {
                    faultyIOSLibs.add(nativeLibraryPath.substring(nativeLibraryPath.lastIndexOf(File.separator) + 1));
                }
                extensionData.dependencyOptions.add("-l" + ane.id());
                extensionData.dependencyOptions.add("-L" + tempDir.getAbsolutePath());
                extensionData.dependencyOptions.add("-F" + tempDir.getAbsolutePath());
                String initializer = ane.getInitializer(this.m_targetPlatform);
                assert (initializer != null);
                extensionData.exportedSymbols.add(initializer);
                String finalizer = ane.getFinalizer(this.m_targetPlatform);
                if (finalizer != null) {
                    extensionData.exportedSymbols.add(finalizer);
                }
                if (ane.getDescriptor().namespaceCompare("http://ns.adobe.com/air/extension/3.1") >= 0) {
                    String platformOptionsPath = ane.getPlatformPath(this.m_targetPlatform) + "/" + "platform.xml";
                    ZipEntry platformOptionsFile = zipFile.getEntry(platformOptionsPath);
                    if (platformOptionsFile != null) {
                        IosExtensionDescriptor desc = new IosExtensionDescriptor(zipFile.getInputStream(platformOptionsFile), true, platformOptionsFile.getName());
                        extensionData.linkerOptions.addAll(desc.linkerOptions());
                        if (ane.getDescriptor().namespaceCompare("http://ns.adobe.com/air/extension/3.5") >= 0) {
                            extensionData.dependencySupported = true;
                            ArrayList<String> dependencies = desc.dependencies();
                            this.m_dependencies.put(ane.id(), dependencies);
                            for (String dependency : dependencies) {
                                String entryPath = ane.getPlatformPath(this.m_targetPlatform) + "/" + dependency;
                                String file = IPAPackager.getBaseName(dependency);
                                String outFile = tempDir.getAbsolutePath() + File.separator + dependency;
                                this.copyFromZip(zipFile, entryPath, outFile);
                                String searchPath = new File(outFile).getParentFile().getAbsolutePath();
                                if (IPAPackager.isStaticLib(file)) {
                                    extensionData.dependencyOptions.add(Utils.quote("-L" + searchPath));
                                    extensionData.dependencyOptions.add(Utils.quote("-l" + this.getLinkName(file)));
                                    continue;
                                }
                                if (IPAPackager.isFramework(file)) {
                                    extensionData.dependencyOptions.add(Utils.quote("-F" + searchPath));
                                    extensionData.dependencyOptions.add("-framework");
                                    extensionData.dependencyOptions.add(Utils.quote(this.getLinkName(file)));
                                    continue;
                                }
                                if (!new File(outFile).isFile()) continue;
                                extensionData.dependencyOptions.add(Utils.quote(outFile));
                            }
                        }
                    }
                } else {
                    this.getIPAStream().setLinkAllFrameworks(true);
                }
                zipFile.close();
            }
            catch (IOException e2) {
                throw new InvalidInputException(ane.getFile().getAbsoluteFile() + " is not a valid native extension file.");
            }
        }
        if (!faultyIOSLibs.isEmpty()) {
            String errorString = "";
            Iterator itr = faultyIOSLibs.iterator();
            errorString = (String)itr.next();
            while (itr.hasNext()) {
                errorString = errorString + ", " + (String)itr.next();
            }
            throw new InvalidInputException("Error: " + errorString + " are required to have universal iOS libraries. " + "Please contact the ANE developer(s) to get the same.");
        }
    }

    private void copyFromZip(ZipFile zipFile, String entryPath, String outFile) throws IOException {
        ZipEntry zipEntry = zipFile.getEntry(entryPath);
        if (zipEntry == null || zipEntry.isDirectory()) {
            this.copyDirFromZip(zipFile, entryPath, outFile);
        } else {
            this.copyFileFromZip(zipFile, entryPath, outFile);
        }
    }

    private void copyFileFromZip(ZipFile zipFile, String entryName, String outFile) throws IOException, FileNotFoundException {
        ZipEntry zipEntry = zipFile.getEntry(entryName);
        if (zipEntry == null) {
            return;
        }
        new File(outFile).getParentFile().mkdirs();
        int size = 0;
        byte[] buffer = new byte[1024];
        InputStream in = zipFile.getInputStream(zipEntry);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));
        while ((size = in.read(buffer, 0, buffer.length)) != -1) {
            ((OutputStream)out).write(buffer, 0, size);
        }
        in.close();
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
    }

    private void copyDirFromZip(ZipFile zipFile, String entryName, String outFile) throws IOException, FileNotFoundException {
        ZipEntry zipEntry;
        String dirEntryName = entryName.charAt(entryName.length() - 1) == '/' ? entryName : entryName + '/';
        ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile.getName()));
        while ((zipEntry = zis.getNextEntry()) != null) {
            String currentOutFile = null;
            String currentEntryName = zipEntry.getName();
            if (!currentEntryName.startsWith(dirEntryName)) continue;
            if (!currentEntryName.equals(dirEntryName)) {
                currentOutFile = outFile + File.separator + currentEntryName.substring(dirEntryName.length());
            }
            if (zipEntry.isDirectory()) {
                new File(currentOutFile).mkdirs();
                continue;
            }
            new File(currentOutFile).getParentFile().mkdirs();
            this.copyFileFromZip(zipFile, currentEntryName, currentOutFile);
        }
        zis.close();
    }

    @Override
    protected void addExtensions() throws IOException, DescriptorValidationException, InvalidInputException {
        File tempDir = Utils.createTempDirectory();
        for (ANEFile ane : this.getExtensions()) {
            String platform = ane.supportsPlatform(this.m_targetPlatform, true, false) ? this.m_targetPlatform : ANEFile.DEFAULT_PLATFORM;
            String platformOptionsPath = ane.getPlatformPath(platform) + "/" + "platform.xml";
            ZipFile zipFile = new ZipFile(ane.getFile());
            String pathPrefix = "META-INF/ANE/" + platform + "/";
            ANEFile.ZipEntryIterator entries = ane.getFilesForPlatform(platform);
            for (ZipEntry entry : entries) {
                String entryName = entry.getName();
                if (entryName.equals(ane.getNativeLibraryPath(platform)) || entryName.equals("library.swf")) continue;
                List<String> dependencies = this.m_dependencies.get(ane.id());
                if (dependencies != null) {
                    boolean skip = false;
                    String truncatedName = entryName.startsWith(pathPrefix) ? entryName.substring(pathPrefix.length()) : entryName;
                    for (String dependency : dependencies) {
                        if (!truncatedName.startsWith(dependency)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                }
                if (entryName.equals(ane.getExtensionSwfPath(platform))) {
                    if (!this.getIPAStream().getUseInterpreter()) {
                        InputStream swfStream = zipFile.getInputStream(entry);
                        SWFUtils util = null;
                        try {
                            util = new SWFUtils(swfStream, ((IPAOutputStream)this.getADTStream()).getCompressSWF(), true, tempDir.getPath());
                        }
                        catch (NoSuchAlgorithmException e2) {
                            throw new InvalidInputException("Invalid swf " + entry.getName() + " in extension " + ane.id());
                        }
                        int index = 0;
                        ExtensionData extensionData = this.getIPAStream().getExtensionData(ane.id());
                        assert (extensionData != null);
                        for (byte[] abcData : util.getABCs()) {
                            File temp = new File(tempDir, ane.id() + "-" + index + ".abc");
                            extensionData.abcs.add(temp);
                            FileOutputStream fop = new FileOutputStream(temp);
                            fop.write(abcData);
                            fop.flush();
                            fop.close();
                            ++index;
                        }
                        File strippedSwfFile = new File(tempDir, ane.id() + "-stripped.swf");
                        util.exportToFile(strippedSwfFile);
                        this.getIPAStream().addExtensionFile(strippedSwfFile, "META-INF/AIR/extensions/" + ane.id() + "/" + entryName, true);
                        continue;
                    }
                    this.getADTStream().addFileFromZipEntry(entry, entries.getZipFile(), "META-INF/AIR/extensions/" + ane.id() + "/" + entryName);
                    continue;
                }
                if (!entryName.startsWith(pathPrefix) || ane.getDescriptor().namespaceCompare("http://ns.adobe.com/air/extension/3.1") >= 0 && entryName.equals(platformOptionsPath)) {
                    this.getADTStream().addFileFromZipEntry(entry, entries.getZipFile(), "META-INF/AIR/extensions/" + ane.id() + "/" + entryName);
                    continue;
                }
                if (!this.validateAssetFile(this.getApplicationDescriptor(), entryName.substring(pathPrefix.length()))) continue;
                this.getADTStream().addFileFromZipEntry(entry, entries.getZipFile(), entryName.substring(pathPrefix.length()));
            }
        }
    }

    private String getLinkName(String name) {
        Matcher m2 = libraryPattern.matcher(name);
        if (m2.matches()) {
            return name.substring(3, name.lastIndexOf(46));
        }
        m2 = frameworkPattern.matcher(name);
        if (m2.matches()) {
            return name.substring(0, name.lastIndexOf(46));
        }
        return name;
    }

    private static boolean isObjectFile(String name) {
        return objFilePattern.matcher(name).matches();
    }

    private static boolean isStaticLib(String name) {
        return libraryPattern.matcher(name).matches();
    }

    private static boolean isFramework(String name) {
        return frameworkPattern.matcher(name).matches();
    }

    private static String getBaseName(String fileName) {
        return new File(fileName).getName();
    }

    private IPAOutputStream getIPAStream() {
        return (IPAOutputStream)this.getStream();
    }

    public List<String> getSupportedLanguagesList(ApplicationDescriptor appDescriptor) {
        List<String> supportedLanguages = appDescriptor.supportedLanguages();
        if (supportedLanguages == null) {
            this.getApplicationDescriptor();
            supportedLanguages = new ArrayList<String>(ApplicationDescriptor.ALL_SUPPORTED_LANGUAGES);
        }
        ListIterator<String> langListIter = supportedLanguages.listIterator();
        while (langListIter.hasNext()) {
            if (!langListIter.next().equals("zh")) continue;
            langListIter.remove();
            supportedLanguages.add("zh_Hans");
            supportedLanguages.add("zh_Hant");
            break;
        }
        return supportedLanguages;
    }

    @Override
    protected boolean validateAssetFile(ApplicationDescriptor appDescriptor, String filePath) {
        return Utils.validateMacResourceAgainstSupportedLanguages(filePath, this.getSupportedLanguagesList(appDescriptor));
    }

    protected SortedMap<String, File> getPackageSources() {
        return this.getSources();
    }
}

