/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.ipa;

import com.adobe.air.SDKDamagedException;
import com.adobe.air.Utils;
import com.adobe.air.ipa.AOTCompiler;
import com.adobe.air.ipa.AOTCompilerOptions;
import com.adobe.air.ipa.ExtensionData;
import com.adobe.air.ipa.ProcessError;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HMAOTCompiler
extends AOTCompiler {
    private static final String O_FILE_EXTENSION = "o";

    public HMAOTCompiler(AOTCompilerOptions options) throws IOException {
        super(options);
        String osName = System.getProperty("os.name");
        String exeSuffix = "";
        if (osName.contains("Windows")) {
            exeSuffix = ".exe";
        }
        if (options.iosArch == 32) {
            this.m_tools.put("compile-abc", this.m_opts.airIosSdkRoot + "/bin" + "/compile-abc/compile-abc" + exeSuffix);
            this.m_tools.put("builtin_abc.o", this.m_opts.airIosSdkRoot + "/lib" + "/builtin_abc." + this.m_opts.target + ".o");
            this.m_tools.put("field-file", this.m_opts.airIosSdkRoot + "/lib" + "/air-fields." + this.m_opts.target + ".txt");
        } else {
            this.m_tools.put("compile-abc", this.m_opts.airIosSdkRoot + "/bin" + "/compile-abc/compile-abc-64" + exeSuffix);
            this.m_tools.put("builtin_abc.o", this.m_opts.airIosSdkRoot + "/lib" + "/builtin_abc." + this.m_opts.target_64 + ".o");
            this.m_tools.put("field-file", this.m_opts.airIosSdkRoot + "/lib" + "/air-fields." + this.m_opts.target_64 + ".txt");
        }
        if (this.m_targetRuntime.equals("air")) {
            this.m_tools.put("libruntimehmaot", this.m_opts.airIosSdkRoot + "/lib" + "/libRuntimeHMAOT." + this.m_opts.target + ".a");
        } else if (this.m_targetRuntime.equals("shell")) {
            this.m_tools.put("libavmshellhmaot", this.m_opts.airIosSdkRoot + "/lib" + "/libAVMShell_HMAOT." + this.m_opts.target + ".a");
        }
    }

    protected void compileABCFiles() throws IOException, ProcessError {
        ArrayList<String> exportedSymbols = new ArrayList<String>();
        if (this.m_targetRuntime.equals("air")) {
            this.moveAbcsToSubDir();
            if (this.m_opts.extensionsMap != null && this.m_opts.extensionsMap.size() > 0) {
                for (ExtensionData extData : this.m_opts.extensionsMap.values()) {
                    assert (extData.abcs != null);
                    for (File abc : extData.abcs) {
                        this.m_abcFiles.add(abc);
                    }
                    assert (extData.id != null && extData.exportedSymbols != null);
                    String symbolPrefix = this.m_opts.hideAneSymbols ? extData.id + "_" : "";
                    for (String symbol : extData.exportedSymbols) {
                        exportedSymbols.add(symbolPrefix + symbol);
                    }
                }
            }
            Object[] files = this.m_abcDir.listFiles();
            Arrays.sort(files);
            for (int i2 = 0; i2 < files.length; ++i2) {
                this.m_abcFiles.add(files[i2]);
            }
        }
        String[] stringArray = new String[7];
        stringArray[0] = (String)this.m_tools.get("compile-abc");
        stringArray[1] = "-mtriple=" + (this.m_targetArch.equals("arm") ? (this.m_opts.iosArch == 64 ? "arm64-apple-ios" : "armv7-apple-ios") : "i386-apple-darwin10");
        stringArray[2] = "-filetype=obj";
        stringArray[3] = "-sdk";
        stringArray[4] = this.m_targetRuntime.equals("shell") ? (String)this.m_tools.get("toplevel") : (String)this.m_tools.get("avmglue");
        stringArray[5] = "-fields";
        stringArray[6] = (String)this.m_tools.get("field-file");
        ArrayList<String> args = HMAOTCompiler.createArgs(stringArray);
        if (this.m_opts.verbosity > 2) {
            HMAOTCompiler.appendArgs(args, "-save-ll");
        }
        if (this.m_opts.logPerf) {
            HMAOTCompiler.appendArgs(args, "-perf-log");
        }
        if (this.m_opts.debugger) {
            HMAOTCompiler.appendArgs(args, "-as3debugger");
        }
        if (this.m_opts.samplerEnabled) {
            HMAOTCompiler.appendArgs(args, "-telemetry-sampler");
        }
        HMAOTCompiler.appendArgs(args, "-O" + this.m_opts.optLevel);
        for (String sym : exportedSymbols) {
            HMAOTCompiler.appendArgs(args, "-ane-symbol=" + sym);
        }
        File abcFilesList = this.getNewTempFile("ABCFilesList.txt");
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(abcFilesList), "UTF8"));
            boolean firstEntryFlag = true;
            for (File abcFile : this.m_abcFiles) {
                if (firstEntryFlag) {
                    firstEntryFlag = false;
                } else {
                    writer.write("\n");
                }
                writer.write(abcFile.getPath());
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e2) {
            System.out.println("# Writing abc Files in ABCFilesList.txt... FAILED");
        }
        HMAOTCompiler.appendArgs(args, "-abc-file-list=" + abcFilesList.getPath());
        this.launchProcess(args, "compile-abc", "Unable to compile abc", true);
    }

    @Override
    protected void appendObjectFilesToCommand(ArrayList<String> args) {
        String[] oFiles = this.m_tempFolder.list(new ObjectFileFilter());
        try {
            File objFilesList = this.getNewTempFile("OBJFilesList.txt");
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(objFilesList), "UTF8"));
            for (String oFile : oFiles) {
                writer.write(oFile + "\n");
            }
            writer.flush();
            writer.close();
            HMAOTCompiler.appendArgs(args, "-filelist " + Utils.quote(objFilesList.getPath()));
        }
        catch (IOException e2) {
            System.out.println("# Writing .o Files in OBJFilesList.txt... FAILED");
        }
        HMAOTCompiler.appendArgs(args, Utils.quote((String)this.m_tools.get("builtin_abc.o")));
    }

    @Override
    protected void appendRuntimeLibToCommand(ArrayList<String> args) {
        if (this.m_targetRuntime.equals("air")) {
            HMAOTCompiler.appendArgs(args, Utils.quote((String)this.m_tools.get("libruntimehmaot")));
        } else if (this.m_targetRuntime.equals("shell")) {
            HMAOTCompiler.appendArgs(args, Utils.quote((String)this.m_tools.get("libavmshellhmaot")));
        }
    }

    @Override
    protected int getTotalStepCount() {
        return 3;
    }

    @Override
    protected void executeTargetSpecificSteps() throws IOException, ProcessError, SDKDamagedException {
        this.validateIosSDK();
        this.convertSwfsToAbc();
        this.reportProgress("convertSwfsToAbc");
        this.compileABCFiles();
        this.reportProgress("compileAbc");
    }

    private class ObjectFileFilter
    implements FilenameFilter {
        public boolean accept(File directory, String filename) {
            boolean fileOK = false;
            fileOK = filename.toLowerCase().endsWith(".o");
            return fileOK;
        }
    }
}

