/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.ipa;

import adobe.abc.LLVMEmitter;
import adobe.abc.LLVMEmitterOptions;
import com.adobe.air.SDKDamagedException;
import com.adobe.air.Utils;
import com.adobe.air.ipa.AOTCompiler;
import com.adobe.air.ipa.AOTCompilerOptions;
import com.adobe.air.ipa.ExtensionData;
import com.adobe.air.ipa.ProcessError;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.PriorityQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import llvm.Function;
import llvm.FunctionPassManager;
import llvm.Function_vector;
import llvm.GlobalValue;
import llvm.GlobalValue_vector;
import llvm.GlobalVariable;
import llvm.GlobalVariable_vector;
import llvm.JNIStringRef;
import llvm.LLVM;
import llvm.LLVMContext;
import llvm.Level;
import llvm.Linker;
import llvm.MemoryBuffer;
import llvm.Model;
import llvm.Module;
import llvm.Pass;
import llvm.PassManager;
import llvm.StringRef;
import llvm.Target;
import llvm.TargetData;
import llvm.TargetMachine;
import llvm.TargetRegistry;
import llvm.Twine;
import llvm.formatted_raw_ostream;
import llvm.raw_fd_ostream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GOAOTCompiler
extends AOTCompiler {
    private boolean m_debugSDK = false;
    private int m_numstublibs = 10;
    private Module m_module = null;
    private LLVMContext m_ctx = null;
    private int m_apiVersion = 46;
    private int m_numFuncs = 0;
    private int m_moduleSplitLimit = 0;
    private static final int WRITE_MODULE_BUFFER_SIZE = 262144;
    private static final int MAX_POOL_SIZE = 12;
    private static final int MODULE_SPLIT_LIMIT_MAX = 10000;
    private static final int MODULE_SPLIT_LIMIT_MIN = 4000;
    private static final String MAP_FUNC_POINTER = "g_com_adobe_air_fre_fmap";
    private String[] constFuncs = new String[]{"_ZNK7avmplus10ScopeChain6vtableEv", "_ZNK7avmplus9MethodEnv4coreEv", "_ZNK7avmplus6VTable8toplevelEv", "_ZNK7avmplus9MethodEnv5scopeEv", "_ZNK7avmplus9MethodEnv8toplevelEv", "_ZNK7avmplus6VTable2gcEv", "_ZNK7avmplus6VTable4coreEv", "_ZNK7avmplus10MethodInfo4poolEv", "_ZNK7avmplus9MethodEnv6vtableEv", "_ZNK4MMgc6GCRoot5GetGCEv", "_ZNK7avmplus10PoolObject9getStringEi", "_Z12aotGetStringPKN7avmplus9MethodEnvEi", "_Z8aotGetGCPKN7avmplus9MethodEnvE", "_Z10aotGetPoolPKN7avmplus9MethodEnvE"};

    public GOAOTCompiler(AOTCompilerOptions options) throws IOException {
        super(options);
        this.m_debugSDK = new File(this.m_opts.airIosSdkRoot + "/lib" + "/libavmplus." + this.m_opts.target + ".a").exists();
        this.m_tools.put("bitcode.api", this.m_opts.airIosSdkRoot + "/lib" + "/bitcode.api." + this.m_opts.target + ".txt");
        this.m_tools.put("aotcompiler", this.m_opts.airIosSdkRoot + "/lib" + this.m_opts.supportedProfile + "/AOTCompiler." + this.m_opts.target + ".bc");
        for (int i2 = 0; i2 < this.m_numstublibs; ++i2) {
            this.m_tools.put("libaot" + i2, this.m_opts.airIosSdkRoot + "/lib" + "/libAOTCompiler" + String.format("%02d", i2) + "." + this.m_opts.target + ".bc.a");
        }
        this.m_tools.put("libavmplus", this.m_opts.airIosSdkRoot + "/lib" + this.m_opts.supportedProfile + "/libavmplus." + this.m_opts.target + (this.m_debugSDK ? ".a" : ".bc.a"));
        this.m_tools.put("libmmgc", this.m_opts.airIosSdkRoot + "/lib" + "/libMMgc." + this.m_opts.target + (this.m_debugSDK ? ".a" : ".bc.a"));
        if (this.m_targetRuntime.equals("air")) {
            this.m_tools.put("libruntimeaot", this.m_opts.airIosSdkRoot + "/lib" + this.m_opts.supportedProfile + "/libRuntimeAOT." + this.m_opts.target + ".a");
            this.m_tools.put("libdebugger1", this.m_opts.airIosSdkRoot + "/lib" + "/libDebugger1." + this.m_opts.target + ".a");
            this.m_tools.put("libnodebugger1", this.m_opts.airIosSdkRoot + "/lib" + "/libNoDebugger1." + this.m_opts.target + ".a");
            this.m_tools.put("libdebugger2", this.m_opts.airIosSdkRoot + "/lib" + "/libDebugger2." + this.m_opts.target + ".a");
            this.m_tools.put("libnodebugger2", this.m_opts.airIosSdkRoot + "/lib" + "/libNoDebugger2." + this.m_opts.target + ".a");
        }
        if (this.m_opts.interpreter) {
            this.m_tools.put("interpreter", this.m_opts.airIosSdkRoot + "/lib" + this.m_opts.supportedProfile + "/libRuntimeInterpreter." + this.m_opts.target + ".a");
        }
    }

    private void generateExtensionsGlue() throws IOException, ProcessError {
        Module module = null;
        ArrayList<String> exportedSymbols = new ArrayList<String>();
        if (this.m_opts.extensionsMap != null) {
            for (ExtensionData extData : this.m_opts.extensionsMap.values()) {
                assert (extData.id != null && extData.exportedSymbols != null);
                String symbolPrefix = this.m_opts.hideAneSymbols ? extData.id + "_" : "";
                for (String symbol : extData.exportedSymbols) {
                    exportedSymbols.add(symbolPrefix + symbol);
                }
            }
        }
        if (exportedSymbols != null) {
            if (this.m_verbose) {
                System.out.println("# Generating extensions glue...");
            }
            if ((module = LLVMEmitter.generateSymbolToFunctionPtrMap(MAP_FUNC_POINTER, this.m_targetArch.equals("arm"), exportedSymbols)) == null) {
                throw new IOException("Failed to generate extensions glue");
            }
            File asmFile = this.getNewTempFile("extensionglue.asm");
            File macOFile = this.getNewTempFile("extensionglue.o");
            this.compileModule(module, asmFile, macOFile, -1);
            this.m_macOFiles.add(macOFile);
        }
    }

    protected void dumpBitcode(String name) throws IOException {
        this.dumpBitcode(name, this.m_module);
    }

    protected void dumpBitcode(String name, Module m2) throws IOException {
        if (this.m_opts.verbosity > 3) {
            System.out.println("# Verifying bitcode...");
            LLVM.verifyModule(m2);
            this.writeBitcode(name, m2);
        }
    }

    protected File writeBitcode(String name, Module m2) throws IOException {
        File generatedBitcode = this.getNewTempFile(name);
        if (this.m_opts.verbosity > 0) {
            System.out.println("# Writing bitcode: " + generatedBitcode.getCanonicalPath());
        }
        LLVM.WriteModuleToFile(generatedBitcode.getCanonicalPath(), m2, 262144L);
        return generatedBitcode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Module readBitcode(File f2, LLVMContext ctx) throws IOException {
        MemoryBuffer buff = null;
        Module m2 = null;
        try {
            buff = MemoryBuffer.getFile(new JNIStringRef(f2.getCanonicalPath()));
            assert (buff != null);
            m2 = LLVM.ParseBitcodeFile(buff, ctx);
            buff.delete();
            Object var5_4 = null;
            if (buff != null) {
                buff.delete();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (buff != null) {
                buff.delete();
            }
            throw throwable;
        }
        if (m2 == null) {
            throw new IOException("unable to read bitcode " + f2.getCanonicalPath());
        }
        return m2;
    }

    protected void convertAbcToLlvmBitcode() throws IOException, ProcessError {
        this.moveAbcsToSubDir();
        File serFile = this.getNewTempFile("BitcodeGenerator_opts.ser");
        ArrayList<String> args = GOAOTCompiler.createArgs("com.adobe.air.ipa.BitcodeGenerator", GOAOTCompiler.writeObject(this.m_opts, serFile), this.m_abcDir.getPath());
        long xmx = Runtime.getRuntime().maxMemory();
        if ((xmx /= 0x100000L) < 1024L) {
            xmx = 1024L;
        }
        this.invokeADT(256, xmx, 3.0, this.m_opts.stackSize, args.toArray(new String[0]));
        serFile.delete();
    }

    protected void convertAbcToLlvmBitcodeImpl() throws IOException, ProcessError {
        this.LogTiming("convertAbcToLlvmBitcodeImpl_Start");
        System.gc();
        LLVMEmitter.loadJNI();
        if (this.m_verbose) {
            System.out.println("# Generating bitcode...");
        }
        LLVMEmitterOptions opts = new LLVMEmitterOptions();
        opts.useARMCallingConvention = this.m_targetArch.equals("arm");
        opts.debugger = this.m_opts.debugger;
        opts.runtimeDebugging = this.m_opts.debugRuntime;
        opts.debugBuiltins = this.m_opts.debugBuiltins;
        opts.samplerEnabled = this.m_opts.samplerEnabled;
        opts.optLevel = this.m_opts.optLevel;
        opts.disableLazyEval = false;
        opts.apiVersion = this.m_apiVersion;
        opts.runtimeBitcode = new File((String)this.m_tools.get("aotcompiler"));
        opts.logPerf = this.m_opts.logPerf;
        opts.builtInABCs.add((String)this.m_tools.get("builtin"));
        opts.builtInABCs.add(this.m_targetRuntime.equals("shell") ? (String)this.m_tools.get("toplevel") : (String)this.m_tools.get("avmglue"));
        long abcFileSize = 0L;
        for (File abcFile : this.m_abcFiles) {
            opts.appABCs.add(abcFile.getPath());
            if (!this.m_opts.logPerf) continue;
            abcFileSize += abcFile.length();
        }
        this.LogPerfMsg("numABCFiles " + this.m_abcFiles.size());
        this.LogPerfMsg("ABCFileSize " + abcFileSize);
        if (this.m_opts.extensionsMap != null && this.m_opts.extensionsMap.size() > 0) {
            ArrayList<String> abcs = new ArrayList<String>(opts.appABCs);
            opts.appABCs.clear();
            for (ExtensionData extData : this.m_opts.extensionsMap.values()) {
                assert (extData.abcs != null);
                for (File abc : extData.abcs) {
                    opts.appABCs.add(abc.getAbsolutePath());
                }
            }
            opts.appABCs.addAll(abcs);
        }
        this.m_module = LLVMEmitter.generateBitcode(opts, false);
        this.m_ctx = this.m_module.getContext();
        if (this.m_opts.verbosity > 2) {
            System.out.println("# Generating stub stats...");
            HashMap<String, Integer> stats = new HashMap<String, Integer>();
            Function_vector funcs = LLVM.toVector(this.m_module.getFunctionList());
            int size = (int)funcs.size();
            for (int i2 = 0; i2 < size; ++i2) {
                Function fn = funcs.get(i2);
                String fname = fn.getName().data();
                if (fname.indexOf("abcOP_") < 0) continue;
                stats.put(fname, (int)fn.getNumUses());
            }
            funcs.delete();
            try {
                File file = this.getNewTempFile(this.m_baseName + ".stats.txt");
                BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                for (String k2 : stats.keySet()) {
                    writer.write(k2 + " | " + stats.get(k2) + "\n");
                }
                writer.flush();
                writer.close();
            }
            catch (IOException e2) {
                System.out.println("# Generating stub stats... FAILED");
            }
        }
        this.writeBitcode(this.m_baseName + ".bc", this.m_module);
    }

    protected void linkAndOptimizeBitcode(boolean outOfProcess) throws IOException, ProcessError {
        if (outOfProcess) {
            File serFile = this.getNewTempFile("BitcodeOptimizer_opts.ser");
            ArrayList<String> args = GOAOTCompiler.createArgs("com.adobe.air.ipa.BitcodeOptimizer", GOAOTCompiler.writeObject(this.m_opts, serFile));
            this.invokeADT(32, 64L, 1.0, null, args.toArray(new String[0]));
            serFile.delete();
        } else {
            this.linkAndOptimizeBitcodeImpl();
        }
    }

    protected void linkAndOptimizeBitcodeImpl() throws IOException {
        this.LogTiming("linkAndOptimizeBitcodeImpl_Start");
        LLVMEmitter.loadJNI();
        if (this.m_ctx == null) {
            this.m_ctx = new LLVMContext();
        }
        if (this.m_module == null) {
            this.m_module = GOAOTCompiler.readBitcode(new File(this.m_tempFolder, this.m_baseName + ".bc"), this.m_ctx);
            this.LogTiming("readbitcode");
        }
        this.linkBitcodeFiles();
        this.LogTiming("linkBitcodeFiles");
        this.optimizeBitcode();
        this.LogTiming("optimizeBitcode");
        if (this.m_opts.moduleSplitLimit >= 0) {
            this.prepareBitcodeForSplitting();
            this.LogTiming("prepareBitcodeForSplitting");
        }
        this.writeBitcode(this.m_baseName + "-all.bc", this.m_module);
        this.LogTiming("writeBitcodeAllBitcode");
    }

    private void linkBitcodeFiles() throws IOException {
        if (this.m_verbose) {
            System.out.println("# Linking bitcode libraries...");
        }
        Linker lnk = new Linker((StringRef)new JNIStringRef("jni-llvm-ld"), this.m_module, this.m_verbose ? 1L : 0L);
        for (int i2 = 0; i2 < this.m_numstublibs; ++i2) {
            lnk.LinkInArchive((String)this.m_tools.get("libaot" + i2));
        }
        if (!this.m_debugSDK) {
            lnk.LinkInFile((String)this.m_tools.get("libavmplus"));
            lnk.LinkInFile((String)this.m_tools.get("libmmgc"));
        }
        this.m_module = lnk.releaseModule();
        lnk.delete();
        for (String cfn : this.constFuncs) {
            Function f2 = this.m_module.getFunction(new JNIStringRef(cfn));
            if (f2 == null) {
                System.out.printf("Failed to find %s%n", cfn);
                continue;
            }
            f2.setOnlyReadsMemory(false);
            f2.setDoesNotAccessMemory(true);
            f2.addFnAttr(LLVM.getNoInline());
        }
        this.dumpBitcode(this.m_baseName + "-linked.bc");
    }

    private void optimizeBitcode() throws IOException {
        System.gc();
        PassManager pm = new PassManager();
        TargetData td = new TargetData(this.m_module);
        pm.add(td);
        pm.add(LLVM.createInternalizePass((String)this.m_tools.get("bitcode.api")));
        pm.add(LLVM.createGlobalDCEPass());
        pm.add(LLVM.createAggressiveDCEPass());
        if (this.m_opts.optLevel > 0) {
            if (this.m_verbose) {
                System.out.println("# Optimizing functions...");
            }
            FunctionPassManager fpm = FunctionPassManager.create(this.m_module);
            fpm.add(new TargetData(td));
            LLVM.createStandardFunctionPasses(fpm, this.m_opts.optLevel);
            int inlineLevel = this.m_opts.inlineLevel;
            if (inlineLevel == 0) {
                int n2 = inlineLevel = this.m_opts.optLevel > 2 ? 250 : 200;
            }
            if (this.m_verbose) {
                System.out.println("# inline level " + inlineLevel);
            }
            Pass inliningPass = LLVM.createFunctionInliningPass(inlineLevel);
            LLVM.createStandardModulePasses(pm, this.m_opts.optLevel, false, true, this.m_opts.optLevel > 1, true, true, inliningPass);
            fpm.doInitialization();
            Function_vector funcs = LLVM.toVector(this.m_module.getFunctionList());
            int size = (int)funcs.size();
            for (int i2 = 0; i2 < size; ++i2) {
                if (this.m_verbose && i2 % (size / 10) == 0) {
                    System.out.println("# -- function " + i2 + "/" + size + "...");
                }
                fpm.run(funcs.get(i2));
            }
            fpm.doFinalization();
            fpm.delete();
        }
        if (this.m_verbose) {
            System.out.println("# Optimizing module...");
        }
        pm.run(this.m_module);
        pm.delete();
        if (this.m_verbose) {
            System.out.println("# Final inlining pass...");
        }
        for (String cfn : this.constFuncs) {
            Function f2 = this.m_module.getFunction(new JNIStringRef(cfn));
            if (f2 == null) {
                System.out.printf("Failed to find %s%n", cfn);
                continue;
            }
            f2.setDoesNotAccessMemory(true);
            f2.removeFnAttr(LLVM.getNoInline());
            f2.addFnAttr(LLVM.getAlwaysInline());
        }
        pm = new PassManager();
        td = new TargetData(this.m_module);
        pm.add(td);
        Pass inliningPass = LLVM.createAlwaysInlinerPass();
        LLVM.createStandardModulePasses(pm, this.m_opts.optLevel, false, true, false, true, true, inliningPass);
        pm.add(LLVM.createLowerInvokePass(null, true));
        pm.run(this.m_module);
        pm.delete();
        System.gc();
        this.dumpBitcode(this.m_baseName + "-opt.bc");
    }

    private void prepareBitcodeForSplitting() throws IOException {
        GlobalVariable_vector globals = LLVM.toVector(this.m_module.getGlobalList());
        int unnamedCount = 0;
        int i2 = 0;
        while ((long)i2 < globals.size()) {
            GlobalVariable gv = globals.get(i2);
            if (!gv.hasName()) {
                JNIStringRef name = new JNIStringRef("ug_" + unnamedCount++);
                Twine tn = new Twine(name);
                gv.setName(tn);
                tn.delete();
                name.delete();
            }
            if (gv.hasInternalLinkage() || gv.hasPrivateLinkage()) {
                gv.setLinkage(GlobalValue.LinkageTypes.ExternalLinkage);
            }
            ++i2;
        }
        globals.delete();
        Function_vector funcs = LLVM.toVector(this.m_module.getFunctionList());
        int size = (int)funcs.size();
        for (int i3 = 0; i3 < size; ++i3) {
            Function f2 = funcs.get(i3);
            String fName = f2.getName().data();
            if (fName.startsWith("_Unwind_SjLj")) {
                f2.deleteBody();
                continue;
            }
            if (!f2.hasName()) {
                JNIStringRef name = new JNIStringRef("uf_" + unnamedCount++);
                Twine tn = new Twine(name);
                f2.setName(tn);
                tn.delete();
                name.delete();
            }
            if (!f2.hasInternalLinkage()) continue;
            f2.setLinkage(GlobalValue.LinkageTypes.ExternalLinkage);
        }
        funcs.delete();
        this.writeSizeToFile(size);
    }

    private void writeSizeToFile(int size) throws IOException {
        FileWriter out = new FileWriter(new File(this.m_tempFolder, this.m_baseName + "_size.txt"));
        out.write(Integer.toString(size));
        out.close();
    }

    private int readSizeFromFile() throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(new File(this.m_tempFolder, this.m_baseName + "_size.txt")));
        String sizeStr = in.readLine();
        in.close();
        int size = Integer.parseInt(sizeStr);
        if (size <= 0) {
            throw new IOException("unable to read size, numFuncs");
        }
        return size;
    }

    protected boolean splitBitcode(boolean outOfProcess, boolean requestCompileAfterSplit) throws IOException, ProcessError, InterruptedException {
        if (this.m_opts.moduleSplitLimit < 0) {
            return false;
        }
        this.LogTiming("splitBitcode_Start");
        this.m_numFuncs = this.readSizeFromFile();
        int poolSize = this.computePoolSize();
        this.m_moduleSplitLimit = this.computeModuleSplitLimit(this.m_numFuncs, poolSize);
        poolSize = Math.min(poolSize, (int)Math.ceil((double)this.m_numFuncs / (double)this.m_moduleSplitLimit));
        this.LogPerfMsg("nFuncs " + this.m_numFuncs);
        this.LogPerfMsg("SplitSize " + this.m_moduleSplitLimit);
        ExecutorService pool = null;
        if (requestCompileAfterSplit) {
            pool = Executors.newFixedThreadPool(poolSize);
        }
        int moduleCount = 0;
        for (int i2 = 0; i2 < this.m_numFuncs; i2 += this.m_moduleSplitLimit) {
            this.trimBitcode(moduleCount, i2, i2 + this.m_moduleSplitLimit, outOfProcess);
            if (requestCompileAfterSplit) {
                this.executeCompileTask(moduleCount, pool, outOfProcess);
            }
            ++moduleCount;
        }
        if (this.m_module != null) {
            this.m_module.dropAllReferences();
            this.m_module.delete();
            this.m_module = null;
        }
        if (this.m_ctx != null) {
            this.m_ctx.delete();
            this.m_ctx = null;
        }
        if (pool != null) {
            pool.shutdown();
            pool.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        if (this.m_verbose) {
            System.out.println("# splitBitcode done ");
        }
        return requestCompileAfterSplit;
    }

    private int computePoolSize() {
        if (this.m_opts.poolSize > 0) {
            return this.m_opts.poolSize;
        }
        int nCPU = Runtime.getRuntime().availableProcessors();
        int poolSize = nCPU + 1;
        if (poolSize > 12) {
            poolSize = 12;
        }
        return poolSize;
    }

    private int computeModuleSplitLimit(int nFuncs, int poolSize) {
        if (this.m_opts.moduleSplitLimit > 0) {
            return this.m_opts.moduleSplitLimit;
        }
        int moduleSplitLimit = (int)Math.ceil((double)nFuncs / (double)poolSize);
        if (moduleSplitLimit > 10000) {
            moduleSplitLimit = 10000;
        } else if (moduleSplitLimit < 4000) {
            moduleSplitLimit = 4000;
        }
        return moduleSplitLimit;
    }

    private void trimBitcode(int moduleCount, int startPos, int endPos, boolean outOfProcess) throws IOException, ProcessError {
        if (outOfProcess) {
            File serFile = this.getNewTempFile("TrimBitCode_opts.ser");
            ArrayList<String> args = GOAOTCompiler.createArgs("com.adobe.air.ipa.BitcodeTrimmer", GOAOTCompiler.writeObject(this.m_opts, serFile), Integer.toString(moduleCount), Integer.toString(startPos), Integer.toString(endPos));
            this.invokeADT(32, 64L, 1.0, null, args.toArray(new String[0]));
            serFile.delete();
        } else {
            this.trimBitcodeImpl(moduleCount, startPos, endPos);
        }
    }

    protected void trimBitcodeImpl(int moduleCount, int startPos, int endPos) throws IOException {
        this.LogTiming("trimBitcodeImpl_Start-" + moduleCount);
        LLVMEmitter.loadJNI();
        LLVMContext ctx = new LLVMContext();
        Module m2 = GOAOTCompiler.readBitcode(new File(this.m_tempFolder, this.m_baseName + "-all.bc"), ctx);
        this.LogTiming("readAllBitcode-" + moduleCount);
        this.trimModule(m2, moduleCount, startPos, endPos);
        this.LogTiming("trimModule-" + moduleCount);
        this.writeBitcode(this.m_baseName + "-split-" + moduleCount + ".bc", m2);
        this.LogTiming("writeBitcode-" + moduleCount);
        m2.dropAllReferences();
        m2.delete();
        ctx.delete();
    }

    private Module trimModule(Module m2, int moduleCount, int startPos, int endPos) throws IOException {
        Function_vector _funcs = LLVM.toVector(m2.getFunctionList());
        int size = (int)_funcs.size();
        if (moduleCount == 0) {
            Function f2;
            int i2;
            for (i2 = 0; i2 < startPos; ++i2) {
                f2 = _funcs.get(i2);
                f2.deleteBody();
            }
            for (i2 = endPos; i2 < size; ++i2) {
                f2 = _funcs.get(i2);
                f2.deleteBody();
            }
        } else {
            int nFuncs = 0;
            GlobalValue_vector gvs = new GlobalValue_vector();
            endPos = Math.min(endPos, size);
            for (int j2 = startPos; j2 < endPos; ++j2) {
                Function f3 = _funcs.get(j2);
                gvs.add(f3);
                ++nFuncs;
            }
            if (nFuncs > 0) {
                this.extractGlobals(m2, "-split-" + moduleCount, gvs);
            }
            gvs.delete();
        }
        _funcs.delete();
        return m2;
    }

    private void extractGlobals(Module m2, String name, GlobalValue_vector gvs) throws IOException {
        System.gc();
        GlobalValue.LinkageTypes[] linkageTypes = new GlobalValue.LinkageTypes[(int)gvs.size()];
        int i2 = 0;
        while ((long)i2 < gvs.size()) {
            GlobalValue gval = gvs.get(i2);
            linkageTypes[i2] = gval.getLinkage();
            ++i2;
        }
        if (this.m_verbose) {
            System.out.println("# extracting " + gvs.size() + " globals");
        }
        PassManager pm = new PassManager();
        TargetData td = new TargetData(m2);
        pm.add(td);
        pm.add(LLVM.createGVExtractionPass(gvs, false, false));
        pm.add(LLVM.createGlobalDCEPass());
        pm.add(LLVM.createDeadTypeEliminationPass());
        pm.add(LLVM.createStripDeadPrototypesPass());
        pm.run(m2);
        pm.delete();
        GlobalVariable gv = m2.getGlobalVariable(new JNIStringRef("llvm.used1"));
        if (gv != null) {
            gv.eraseFromParent();
        }
        GlobalVariable_vector globals = LLVM.toVector(m2.getGlobalList());
        int i3 = 0;
        while ((long)i3 < globals.size()) {
            GlobalVariable global = globals.get(i3);
            if (global.hasInternalLinkage()) {
                global.setLinkage(GlobalValue.LinkageTypes.ExternalLinkage);
                global.setInitializer(null);
            }
            ++i3;
        }
        globals.delete();
        i3 = 0;
        while ((long)i3 < gvs.size()) {
            GlobalValue gval = gvs.get(i3);
            gval.setLinkage(linkageTypes[i3]);
            ++i3;
        }
        this.dumpBitcode(this.m_baseName + name + ".bc", m2);
    }

    protected void compileAllBitcode(boolean outOfProcess) throws IOException, ProcessError, InterruptedException {
        if (this.m_opts.moduleSplitLimit < 0) {
            File bitcode = new File(this.m_tempFolder, this.m_baseName + "-all.bc");
            this.compileBitcode(this.m_module, bitcode.toString(), 0, outOfProcess);
        } else {
            int poolSize = this.computePoolSize();
            poolSize = Math.min(poolSize, (int)Math.ceil((double)this.m_numFuncs / (double)this.m_moduleSplitLimit));
            ExecutorService pool = Executors.newFixedThreadPool(poolSize);
            int moduleCount = 0;
            while (this.executeCompileTask(moduleCount, pool, outOfProcess)) {
                ++moduleCount;
            }
            pool.shutdown();
            pool.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
    }

    private boolean executeCompileTask(int moduleCount, ExecutorService pool, boolean outOfProcess) {
        boolean retval = false;
        File bitcode = new File(this.m_tempFolder, this.m_baseName + "-split-" + moduleCount + ".bc");
        if (bitcode.exists()) {
            pool.execute(new CompileTask(bitcode.toString(), moduleCount, outOfProcess));
            retval = true;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compileBitcode(Module m2, String bitcode, int moduleCount, boolean outOfProcess) throws IOException, ProcessError {
        assert (bitcode != null);
        File asmFile = this.getNewTempFile(this.m_baseName + "-" + moduleCount + ".asm");
        File macOFile = this.getNewTempFile(this.m_baseName + "-" + moduleCount + ".o");
        if (outOfProcess) {
            File serFile = this.getNewTempFile("ASMGenerator_" + moduleCount + "_opts.ser");
            String[] args = new String[]{"com.adobe.air.ipa.ASMGenerator", GOAOTCompiler.writeObject(this.m_opts, serFile), bitcode, Integer.toString(moduleCount), asmFile.getPath(), macOFile.getPath()};
            this.invokeADT(32, 256L, 1.0, null, args);
            serFile.delete();
        } else {
            this.compileBitcodeImpl(m2, new File(bitcode), moduleCount, asmFile, macOFile);
        }
        GOAOTCompiler gOAOTCompiler = this;
        synchronized (gOAOTCompiler) {
            if (macOFile.length() > 0L) {
                this.m_macOFiles.add(macOFile);
            }
        }
    }

    private void compileModule(Module module, File asmFile, File macOFile, int moduleCount) throws IOException, ProcessError {
        PriorityQueue<AOTCompiler.Timing> compileTimes = new PriorityQueue<AOTCompiler.Timing>();
        if (this.m_verbose) {
            System.out.println("# Generating asm... " + asmFile.toString());
            System.out.println("SSC optimization is " + this.m_opts.enableSSC);
        }
        LLVM.InitializeAllTargets();
        LLVM.InitializeAllAsmPrinters();
        LLVM.setNoFramePointerElim(true);
        LLVM.setDisableSSCOpt(!this.m_opts.enableSSC);
        Target thetarget = TargetRegistry.lookupTarget(module.getTargetTriple());
        TargetMachine themachine = thetarget.createTargetMachine(module.getTargetTriple(), this.m_targetArch.equals("arm") ? ",+v6,+vfp2" : "");
        TargetMachine.setRelocationModel(Model.Kernel);
        FunctionPassManager fpm = FunctionPassManager.create(module);
        raw_fd_ostream rfdos = raw_fd_ostream.create(asmFile.getCanonicalPath());
        formatted_raw_ostream os = new formatted_raw_ostream(rfdos);
        if (this.m_opts.optLevel == 0) {
            LLVM.setEnableFastISel(true);
        }
        fpm.add(new TargetData(themachine.getTargetData()));
        themachine.addPassesToEmitFile(fpm, os, TargetMachine.CodeGenFileType.CGFT_AssemblyFile, this.m_opts.optLevel == 0 ? Level.None : Level.Aggressive, true);
        long startTime = System.currentTimeMillis();
        fpm.doInitialization();
        Function_vector funcs = LLVM.toVector(module.getFunctionList());
        int size = (int)funcs.size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (this.m_verbose) {
                if (size >= 10 && i2 % (size / 10) == 0) {
                    System.out.println("# -- function " + i2 + "/" + size + "...");
                }
                String funcName = funcs.get(i2).getName().data();
                long fstartTime = System.currentTimeMillis();
                fpm.run(funcs.get(i2));
                compileTimes.add(new AOTCompiler.Timing(System.currentTimeMillis() - fstartTime, funcName));
                continue;
            }
            fpm.run(funcs.get(i2));
        }
        funcs.delete();
        fpm.doFinalization();
        fpm.delete();
        themachine.delete();
        os.flush();
        rfdos.flush();
        rfdos.close();
        os.delete();
        rfdos.delete();
        if (this.m_verbose) {
            double llcTime = System.currentTimeMillis() - startTime;
            System.out.println("# llc took " + llcTime / 1000.0 + "s");
            long nonabctime = 0L;
            for (AOTCompiler.Timing t2 : compileTimes) {
                if (t2.name.startsWith("abcMethod")) continue;
                nonabctime += t2.timeMS;
            }
            System.out.println("# non-abcMethod functions took " + (double)nonabctime / 1000.0 + "s");
            if (llcTime > 0.0) {
                for (int i3 = 0; i3 < 10; ++i3) {
                    AOTCompiler.Timing t2;
                    t2 = (AOTCompiler.Timing)compileTimes.poll();
                    if (t2 == null) continue;
                    System.out.println("# " + (double)t2.timeMS / 1000.0 + "s (" + (double)t2.timeMS / llcTime * 100.0 + "%) for " + t2.name);
                }
            }
        }
        this.LogTiming("compileModule-" + moduleCount);
        this.launchProcess(GOAOTCompiler.createArgs((String)this.m_tools.get("as"), "-arch", this.m_targetArch.equals("arm") ? "armv7" : "i686", "-o", macOFile.getName(), asmFile.getName()), "as", "Assembler failed", false);
        this.LogTiming("assembleAsm-" + moduleCount);
    }

    protected void compileBitcodeImpl(Module module, File bitcode, int moduleCount, File asmFile, File macOFile) throws IOException, ProcessError {
        LLVMContext ctx;
        assert (module != null || bitcode != null);
        this.LogTiming("compileBitcodeImpl_Start-" + moduleCount);
        LLVMEmitter.loadJNI();
        boolean moduleCreated = false;
        Module m2 = module;
        if (m2 == null) {
            ctx = new LLVMContext();
            if (this.m_verbose) {
                System.out.println("# Reading bitcode..." + bitcode.getCanonicalPath());
            }
            m2 = GOAOTCompiler.readBitcode(bitcode, ctx);
            this.LogTiming("readBitcode-" + moduleCount);
            moduleCreated = true;
        }
        this.compileModule(m2, asmFile, macOFile, moduleCount);
        if (moduleCreated) {
            ctx = m2.getContext();
            m2.dropAllReferences();
            m2.delete();
            ctx.delete();
        }
    }

    @Override
    protected void appendObjectFilesToCommand(ArrayList<String> args) {
        for (File f2 : this.m_macOFiles) {
            GOAOTCompiler.appendArgs(args, Utils.quote(f2.getName()));
        }
    }

    @Override
    protected void appendRuntimeLibToCommand(ArrayList<String> args) {
        if (this.m_opts.interpreter) {
            GOAOTCompiler.appendArgs(args, Utils.quote((String)this.m_tools.get("interpreter")));
        } else {
            if (this.m_targetRuntime.equals("air")) {
                GOAOTCompiler.appendArgs(args, Utils.quote((String)this.m_tools.get(this.m_opts.debugger ? "libdebugger1" : "libnodebugger1")), Utils.quote((String)this.m_tools.get(this.m_opts.debugger ? "libdebugger2" : "libnodebugger2")), Utils.quote((String)this.m_tools.get("libruntimeaot")));
            }
            if (this.m_debugSDK) {
                GOAOTCompiler.appendArgs(args, Utils.quote((String)this.m_tools.get("libavmplus")), Utils.quote((String)this.m_tools.get("libmmgc")));
            }
        }
    }

    @Override
    protected int getTotalStepCount() {
        return this.m_opts.interpreter ? (this.m_opts.noStrip ? 2 : 3) : (this.m_opts.noStrip ? 7 : 8);
    }

    @Override
    protected void executeTargetSpecificSteps() throws IOException, ProcessError, InterruptedException, SDKDamagedException {
        if (!this.m_opts.interpreter) {
            this.generateExtensionsGlue();
            this.reportProgress("generateExtensionsGlue");
            this.validateIosSDK();
            this.convertSwfsToAbc();
            this.reportProgress("convertSwfsToAbc");
            this.convertAbcToLlvmBitcode();
            this.reportProgress("convertAbcToLlvmBitcode");
            this.linkAndOptimizeBitcode(true);
            this.reportProgress("linkAndOptimizeBitcode");
            boolean bitcodeCompiled = this.splitBitcode(true, true);
            this.reportProgress("splitBitcode");
            if (!bitcodeCompiled) {
                this.compileAllBitcode(true);
            }
            this.reportProgress("compileAllBitcode");
        } else {
            this.generateExtensionsGlueWithHMAOTCompiler();
            this.reportProgress("generateExtensionsGlueWithHMAOTCompiler");
        }
    }

    private void generateExtensionsGlueWithHMAOTCompiler() throws IOException, ProcessError {
        ArrayList<String> exportedSymbols = new ArrayList<String>();
        String osName = System.getProperty("os.name");
        String exeSuffix = "";
        if (osName.contains("Windows")) {
            exeSuffix = ".exe";
        }
        if (this.m_opts.iosArch == 64) {
            this.m_tools.put("compile-abc", this.m_opts.airIosSdkRoot + "/bin" + "/compile-abc/compile-abc-64" + exeSuffix);
        } else {
            this.m_tools.put("compile-abc", this.m_opts.airIosSdkRoot + "/bin" + "/compile-abc/compile-abc" + exeSuffix);
        }
        if (this.m_targetRuntime.equals("air") && this.m_opts.extensionsMap != null && this.m_opts.extensionsMap.size() > 0) {
            for (ExtensionData extData : this.m_opts.extensionsMap.values()) {
                assert (extData.abcs != null);
                assert (extData.id != null && extData.exportedSymbols != null);
                String symbolPrefix = this.m_opts.hideAneSymbols ? extData.id + "_" : "";
                for (String symbol : extData.exportedSymbols) {
                    exportedSymbols.add(symbolPrefix + symbol);
                }
            }
        }
        String[] stringArray = new String[3];
        stringArray[0] = (String)this.m_tools.get("compile-abc");
        stringArray[1] = "-mtriple=" + (this.m_targetArch.equals("arm") ? (this.m_opts.iosArch == 64 ? "arm64-apple-ios" : "armv7-apple-ios") : "i386-apple-darwin10");
        stringArray[2] = "-emit-ane-map";
        ArrayList<String> args = GOAOTCompiler.createArgs(stringArray);
        if (this.m_opts.verbosity > 2) {
            GOAOTCompiler.appendArgs(args, "-save-ll");
        }
        for (String sym : exportedSymbols) {
            GOAOTCompiler.appendArgs(args, "-ane-symbol=" + sym);
        }
        File macOFile = this.getNewTempFile("extensionglue.o");
        this.launchProcess(args, "compile-abc", "Unable to compile abc", true);
        this.m_macOFiles.add(macOFile);
    }

    class CompileTask
    implements Runnable {
        private int m_moduleCount;
        private String m_bitcode;
        private boolean m_outOfProcess;

        public CompileTask(String bitcode, int moduleCount, boolean outOfProcess) {
            this.m_moduleCount = moduleCount;
            this.m_bitcode = bitcode;
            this.m_outOfProcess = outOfProcess;
        }

        public void run() {
            block4: {
                try {
                    GOAOTCompiler.this.compileBitcode(null, this.m_bitcode, this.m_moduleCount, this.m_outOfProcess);
                }
                catch (IOException e2) {
                    if (GOAOTCompiler.this.m_verbose) {
                        e2.printStackTrace();
                    }
                }
                catch (ProcessError e3) {
                    if (!GOAOTCompiler.this.m_verbose) break block4;
                    e3.printStackTrace();
                }
            }
        }
    }
}

