/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.ipa;

import com.adobe.air.InvalidInputException;
import com.adobe.air.Listener;
import com.adobe.air.SDKDamagedException;
import com.adobe.air.Utils;
import com.adobe.air.ipa.AOTCompilerOptions;
import com.adobe.air.ipa.ExtensionData;
import com.adobe.air.ipa.ProcessError;
import com.adobe.ucf.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AOTCompiler {
    protected AOTCompilerOptions m_opts = null;
    protected Vector<File> m_macOFiles = new Vector();
    private File m_macExe = null;
    protected String m_baseName = "AOTBuildOutput";
    protected String m_targetArch = "arm";
    protected String m_targetRuntime = "air";
    protected boolean m_verbose = false;
    private boolean m_useCaptiveSdk = false;
    protected File m_tempFolder = null;
    private File m_outputFolder = null;
    private String m_captiveSdkRoot = null;
    private String m_platformSdkRoot = null;
    protected File m_abcDir = null;
    private int m_currStep;
    private int m_totalSteps;
    private Listener m_listener;
    protected HashMap<String, String> m_tools = new HashMap();
    private boolean m_hostIsMac = System.getProperty("os.name").indexOf("Mac") != -1;
    private boolean m_modernObjCSupported = false;
    private String m_libArcLite = null;
    public Vector<File> m_abcFiles = new Vector();
    protected static final String LIB_DIR = "/lib";
    protected static final String BIN_DIR = "/bin";
    private static final String STUB_DIR = "/stub";
    private static final String DEFAULT_FRAMEWORK_DIR = "/System/Library/Frameworks";
    protected static final int DEFAULT_MAX_HEAP = 1024;
    protected static final double MAX_HEAP_MULTIPLIER = 3.0;
    private static final int COMMAND_NOT_FOUND = 127;

    protected static ArrayList<String> createArgs(String ... args) {
        return new ArrayList<String>(Arrays.asList(args));
    }

    protected static void appendArgs(ArrayList<String> args, String ... moreargs) {
        args.addAll(Arrays.asList(moreargs));
    }

    protected static void appendArgs(ArrayList<String> args, List<String> moreargs) {
        args.addAll(moreargs);
    }

    public void setListener(Listener listener) {
        this.m_listener = listener;
    }

    protected static void checkAndReportMissingGPLComponent(String path) throws SDKDamagedException {
        if (!new File(path).exists()) {
            throw new SDKDamagedException(path, false, true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AOTCompiler(AOTCompilerOptions options) throws IOException {
        this.m_opts = options;
        this.m_verbose = this.m_opts.verbosity > 0;
        this.m_outputFolder = new File(this.m_opts.outputPath);
        this.m_captiveSdkRoot = this.m_opts.airIosSdkRoot;
        try {
            int delim = this.m_opts.target.lastIndexOf(45);
            this.m_targetArch = this.m_opts.target.substring(0, delim);
            this.m_targetRuntime = this.m_opts.target.substring(delim + 1, this.m_opts.target.length());
        }
        catch (Exception e2) {
            throw new UnsupportedOperationException("Invalid target '" + this.m_opts.target + "'");
        }
        if (!(this.m_targetArch.equals("arm") || this.m_targetArch.equals("x86") || this.m_targetArch.equals("x86-simulator"))) {
            throw new UnsupportedOperationException("Unknown architechture '" + this.m_targetArch + "'");
        }
        if (!this.m_targetRuntime.equals("air") && !this.m_targetRuntime.equals("shell")) {
            throw new UnsupportedOperationException("Unknown runtime type '" + this.m_targetRuntime + "'");
        }
        if (this.m_opts.platformSdkRoot != null) {
            this.m_platformSdkRoot = this.m_opts.platformSdkRoot;
        } else if (this.m_targetArch.equals("arm")) {
            this.m_useCaptiveSdk = true;
        } else if (this.m_targetArch.equals("x86-simulator")) {
            File platformSDKRootFolder = new File("${env.AIR_PATH_TO_SIMULATOR_SDK}");
            if (!platformSDKRootFolder.exists()) throw new InvalidInputException("Use -platformsdk option to specify iPhone Simulator SDK.");
            this.m_platformSdkRoot = "${env.AIR_PATH_TO_SIMULATOR_SDK}";
        } else if (this.m_targetArch.equals("x86")) {
            this.m_platformSdkRoot = this.m_opts.platformSdkRoot != null ? this.m_opts.platformSdkRoot : "/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.9.sdk";
        }
        boolean bl2 = this.m_modernObjCSupported = this.m_hostIsMac && !this.m_useCaptiveSdk;
        if (this.m_modernObjCSupported) {
            this.m_libArcLite = this.m_targetArch.equals("x86-simulator") ? new File(this.m_platformSdkRoot + "/../../../../../../Developer/Toolchains/XcodeDefault.xctoolchain/usr/lib/arc/libarclite_iphonesimulator.a").getAbsolutePath() : new File(this.m_platformSdkRoot + "/../../../../../../Developer/Toolchains/XcodeDefault.xctoolchain/usr/lib/arc/libarclite_iphoneos.a").getAbsolutePath();
            this.m_modernObjCSupported = new File(this.m_libArcLite).exists();
        }
        if (this.m_opts.baseName != null) {
            this.m_baseName = this.m_opts.baseName;
        } else if (!this.m_opts.interpreter && this.m_targetRuntime.equals("shell")) {
            this.m_baseName = this.m_opts.shellAbcs.get(this.m_opts.shellAbcs.size() - 1).getName();
            this.m_baseName = this.m_baseName.substring(0, this.m_baseName.lastIndexOf(46));
            this.m_baseName = this.m_baseName + "_";
            this.m_baseName = this.m_baseName + this.m_opts.iosArch;
        }
        this.m_opts.baseName = this.m_baseName;
        if (this.m_opts.tempFolder != null) {
            this.m_tempFolder = this.m_opts.tempFolder;
        } else if (!this.m_opts.interpreter && this.m_targetRuntime.equals("shell")) {
            this.m_tempFolder = File.createTempFile(this.m_baseName, null, this.m_outputFolder);
            this.m_tempFolder.delete();
            this.m_tempFolder.mkdirs();
            for (File abcFile : this.m_opts.shellAbcs) {
                File f2 = new File(this.m_tempFolder, abcFile.getName());
                Utils.copyTo(abcFile, f2);
                this.m_abcFiles.add(f2);
            }
        } else {
            this.m_tempFolder = File.createTempFile(this.m_baseName, null, this.m_outputFolder);
            this.m_tempFolder.delete();
            this.m_tempFolder.mkdirs();
        }
        this.m_opts.tempFolder = this.m_tempFolder;
        this.m_abcDir = new File(this.m_tempFolder, "ABCFiles");
        this.m_abcDir.mkdir();
        String osName = System.getProperty("os.name");
        String exeSuffix = "";
        if (osName.contains("Windows")) {
            exeSuffix = ".exe";
        } else if (!this.m_hostIsMac) {
            throw new UnsupportedOperationException("Functionality not supported on : " + osName);
        }
        this.m_tools.put("as", this.m_opts.airIosSdkRoot + BIN_DIR + "/as/" + "as-" + (this.m_targetArch.equals("arm") ? "arm" : "386") + exeSuffix);
        this.m_tools.put("ld64", this.m_opts.airIosSdkRoot + BIN_DIR + "/ld64/ld64" + exeSuffix);
        this.m_tools.put("builtin", this.m_opts.airIosSdkRoot + LIB_DIR + "/builtin.abc");
        this.m_tools.put("avmglue", this.m_opts.airIosSdkRoot + LIB_DIR + this.m_opts.supportedProfile + "/avmglue.abc");
        AOTCompiler.checkAndReportMissingGPLComponent(this.m_tools.get("as"));
        AOTCompiler.checkAndReportMissingGPLComponent(this.m_opts.airIosSdkRoot + LIB_DIR + "/gcc/libgcc.a");
        if (this.m_targetRuntime.equals("air")) {
            this.m_tools.put("libNotification", this.m_opts.airIosSdkRoot + LIB_DIR + "/libNotification." + this.m_opts.target + ".a");
        }
        if (!this.m_targetRuntime.equals("shell")) return;
        this.m_tools.put("toplevel", this.m_opts.airIosSdkRoot + LIB_DIR + "/shell_toplevel.abc");
    }

    public void launchProcess(List<String> argv, String name, String msg, boolean displayProcessErrors) throws ProcessError, IOException {
        int retcode = this.launchProcess(argv, displayProcessErrors, true);
        if (retcode != 0) {
            throw new ProcessError(name, msg, retcode);
        }
    }

    public void launchProcess(List<String> argv, String name, String msg, boolean displayProcessErrors, boolean quoteArgs) throws ProcessError, IOException {
        int retcode = this.launchProcess(argv, displayProcessErrors, quoteArgs);
        if (retcode != 0) {
            throw new ProcessError(name, msg, retcode);
        }
    }

    private int launchProcess(List<String> argv, boolean displayProcessErrors, boolean quoteArgs) throws IOException {
        if (this.m_verbose) {
            for (String arg : argv) {
                System.out.print(arg + " ");
            }
            System.out.println("");
        }
        if (this.m_opts.dryRun) {
            return 0;
        }
        int retCode = 1;
        try {
            Process rProcess = Utils.execSafely(this.m_tempFolder, argv, quoteArgs, null);
            Utils.OutputEater consumeInput = new Utils.OutputEater(rProcess.getInputStream(), this.m_opts.logPerf ? System.out : null);
            Utils.OutputEater consumeErr = new Utils.OutputEater(rProcess.getErrorStream(), this.m_verbose || displayProcessErrors ? System.out : null);
            consumeInput.start();
            consumeErr.start();
            retCode = rProcess.waitFor();
            consumeInput.join();
            consumeErr.join();
        }
        catch (InterruptedException e2) {
            retCode = 0;
        }
        return retCode;
    }

    public File getNewTempFile(String path) throws IOException {
        boolean parentDirectoryExists;
        File rFile = new File(this.m_tempFolder, path);
        if (rFile.exists()) {
            rFile.delete();
        }
        if (!(parentDirectoryExists = rFile.getParentFile().exists())) {
            parentDirectoryExists = rFile.getParentFile().mkdirs();
        }
        rFile.createNewFile();
        return rFile;
    }

    protected void moveAbcsToSubDir() throws IOException {
        for (File f2 : this.m_abcFiles) {
            if (f2.renameTo(new File(this.m_abcDir, f2.getName()))) continue;
            throw new IOException("Couldn't move " + f2.getName());
        }
    }

    protected void convertSwfsToAbc() throws InvalidInputException, IOException, ProcessError {
        if (this.m_targetRuntime.equals("shell")) {
            return;
        }
        this.convertSwfToAbc(this.m_opts.rootSwf, this.m_opts.rootSwf.getName());
        Set<String> aSet = this.m_opts.secondarySWFs.keySet();
        for (String aKey : aSet) {
            File aFile = (File)this.m_opts.secondarySWFs.get(aKey);
            if (this.m_opts.aotSecondarySwfs) {
                this.convertSwfToAbc(aFile, aKey);
                continue;
            }
            this.addStrippedSWFWithPath(aFile, aKey);
        }
    }

    protected void convertSwfToAbc(File swfFile, String path) throws InvalidInputException, IOException, ProcessError {
        File aStrippedSwfFile = this.getNewTempFile(path);
        File serFile = this.getNewTempFile("SWFSplitter_opts.ser");
        ArrayList<String> args = AOTCompiler.createArgs("com.adobe.air.ipa.SWFSplitter", AOTCompiler.writeObject(this.m_opts, serFile), swfFile.toString(), aStrippedSwfFile.toString(), this.m_abcDir.getPath());
        long xmx = Runtime.getRuntime().maxMemory();
        if ((xmx /= 0x100000L) < 1024L) {
            xmx = 1024L;
        }
        this.invokeADT(256, xmx, 3.0, null, args.toArray(new String[0]));
        serFile.delete();
        this.addStrippedSWFWithPath(aStrippedSwfFile, path);
    }

    protected void addStrippedSWFWithPath(File source, String path) {
        this.m_opts.strippedSWFs.put(path, source);
    }

    protected void appendObjectFilesToCommand(ArrayList<String> args) {
    }

    protected void appendRuntimeLibToCommand(ArrayList<String> args) {
    }

    protected void linkMachO() throws IOException, ProcessError {
        block43: {
            this.m_macExe = this.m_targetRuntime.equals("shell") ? new File(this.m_outputFolder, this.m_baseName) : File.createTempFile("aot", null, this.m_outputFolder);
            ArrayList<String> args = AOTCompiler.createArgs(this.m_tools.get("ld64"), "-pie", "-ObjC", "-dead_strip", "-Z");
            AOTCompiler.appendArgs(args, "-arch", this.getTargetArch());
            String frameworkDir = null;
            if (this.m_useCaptiveSdk) {
                AOTCompiler.appendArgs(args, "-L" + Utils.quote(this.m_captiveSdkRoot + STUB_DIR));
                frameworkDir = this.m_captiveSdkRoot + STUB_DIR;
                AOTCompiler.appendArgs(args, "-sdk_version", "8.1");
            } else {
                AOTCompiler.appendArgs(args, "-syslibroot", Utils.quote(this.m_platformSdkRoot));
                if (this.m_hostIsMac) {
                    AOTCompiler.appendArgs(args, "-L/usr/lib");
                    frameworkDir = DEFAULT_FRAMEWORK_DIR;
                } else {
                    AOTCompiler.appendArgs(args, "-L" + Utils.quote(this.m_platformSdkRoot + "/usr/lib"));
                    frameworkDir = this.m_platformSdkRoot + DEFAULT_FRAMEWORK_DIR;
                }
                if (!this.m_targetArch.equals("arm")) {
                    String[] subdirs;
                    String gccLibraryRoot;
                    File gccLibraryRootDir;
                    if (this.m_targetArch.equals("x86")) {
                        AOTCompiler.appendArgs(args, "-L" + Utils.quote(this.m_platformSdkRoot + "/usr/lib/gcc/i686-apple-darwin10/4.2.1"), "-L" + Utils.quote(this.m_platformSdkRoot + "/usr/lib/gcc/i686-apple-darwin11/4.2.1"));
                    }
                    if (!(gccLibraryRootDir = new File(gccLibraryRoot = this.m_platformSdkRoot + "/../../usr/llvm-gcc-4.2/lib/gcc/")).exists()) {
                        gccLibraryRoot = this.m_platformSdkRoot + "/../../../../../usr/llvm-gcc-4.2/lib/gcc/";
                        gccLibraryRootDir = new File(gccLibraryRoot);
                    }
                    if (!gccLibraryRootDir.exists()) {
                        gccLibraryRoot = this.m_platformSdkRoot + "/../../../../../usr/lib/llvm-gcc/";
                        gccLibraryRootDir = new File(gccLibraryRoot);
                    }
                    if (!gccLibraryRootDir.exists()) {
                        throw new SDKDamagedException(gccLibraryRoot, false, true);
                    }
                    File gccDir = null;
                    for (String subdir : subdirs = new String[]{"i686-apple-darwin10", "i686-apple-darwin11", ""}) {
                        String gccDirPath = gccLibraryRoot + subdir + "/4.2.1/";
                        gccDir = new File(gccDirPath);
                        if (gccDir.exists()) break;
                    }
                    if (!gccDir.exists()) {
                        throw new SDKDamagedException(gccDir.getAbsolutePath() + "/libgcc.a", false, true);
                    }
                    AOTCompiler.appendArgs(args, Utils.quote(gccDir.getAbsolutePath() + "/libgcc.a"));
                }
            }
            AOTCompiler.appendArgs(args, "-F" + Utils.quote(frameworkDir));
            AOTCompiler.appendArgs(args, "-L" + Utils.quote(this.m_captiveSdkRoot + LIB_DIR));
            AOTCompiler.appendArgs(args, "-o", Utils.quote("../" + this.m_macExe.getName()));
            AOTCompiler.appendArgs(args, "-exported_symbol", "_main");
            this.appendObjectFilesToCommand(args);
            if (!this.m_opts.noStrip) {
                if (this.m_opts.extensionsMap != null && this.m_opts.extensionsMap.size() > 0 && this.m_modernObjCSupported) {
                    AOTCompiler.appendArgs(args, "-non_global_symbols_no_strip_list", Utils.quote(this.m_opts.airIosSdkRoot + LIB_DIR + "/local_nostrip." + this.m_opts.target + ".txt"));
                } else {
                    AOTCompiler.appendArgs(args, "-x");
                }
            }
            if (this.m_opts.linkerOptions != null && !this.m_opts.linkerOptions.isEmpty()) {
                args.addAll(this.m_opts.linkerOptions);
            }
            this.appendRuntimeLibToCommand(args);
            if (this.m_targetRuntime.equals("air") && this.m_opts.includePushNotification) {
                AOTCompiler.appendArgs(args, Utils.quote(this.m_tools.get("libNotification")));
            }
            if (this.m_targetArch.equals("x86")) {
                AOTCompiler.appendArgs(args, "-lstdc++.6", "-lcrt3.o", "-lcrt1.10.5.o", "-lgcc_s.10.5", "-lSystem.B_debug", "-lz", "-macosx_version_min", "10.5.6", "-framework", "CoreServices");
            } else {
                if (this.m_targetArch.equals("arm")) {
                    if (this.getTargetArch().equals("armv7")) {
                        AOTCompiler.appendArgs(args, "-lgcc_s.1", "-lSystem.B", "-lcrt1.o");
                    } else {
                        AOTCompiler.appendArgs(args, "-lSystem.B");
                    }
                } else {
                    AOTCompiler.appendArgs(args, "-lSystem", "-lcrt1.o");
                }
                if (this.m_targetRuntime.equals("shell")) {
                    AOTCompiler.appendArgs(args, "-lstdc++");
                } else {
                    AOTCompiler.appendArgs(args, "-lstdc++");
                }
                AOTCompiler.appendArgs(args, "-lz", "-lobjc", "-framework", "CoreFoundation", "-framework", "UIKit", "-framework", "MobileCoreServices", "-framework", "CoreGraphics", "-framework", "Foundation", "-framework", "SystemConfiguration", "-framework", "AudioToolbox", "-framework", "CFNetwork", "-framework", "QuartzCore", "-framework", "OpenGLES", "-framework", "CoreLocation", "-framework", "CoreMedia", "-framework", "CoreVideo", "-framework", "AVFoundation", "-framework", "Security");
                if (this.m_opts.linkAllFrameworks && this.m_opts.extensionsMap != null && this.m_opts.extensionsMap.size() > 0) {
                    AOTCompiler.appendArgs(args, "-framework", "Accelerate", "-framework", "AddressBook", "-framework", "AddressBookUI", "-framework", "AssetsLibrary", "-framework", "CoreAudio", "-framework", "CoreData", "-framework", "CoreMotion", "-framework", "CoreTelephony", "-framework", "CoreText", "-framework", "EventKit", "-framework", "EventKitUI", "-framework", "ExternalAccessory", "-framework", "GameKit", "-framework", "IOKit", "-framework", "ImageIO", "-framework", "MapKit", "-framework", "MediaPlayer", "-framework", "MessageUI", "-framework", "OpenAL", "-framework", "QuickLook", "-framework", "StoreKit", "-framework", "iAd");
                }
            }
            if (!(this.m_verbose || this.m_opts.extensionsMap != null && this.m_opts.extensionsMap.size() != 0)) {
                AOTCompiler.appendArgs(args, "-w");
            }
            if (this.m_opts.extensionsMap != null && this.m_opts.extensionsMap.size() > 0) {
                for (ExtensionData ed : this.m_opts.extensionsMap.values()) {
                    ExtensionData extData;
                    assert (ed.id != null);
                    ExtensionData extensionData = extData = this.m_opts.hideAneSymbols ? this.hideAneSymbols(ed) : ed;
                    if (extData.linkerOptions != null && extData.linkerOptions.size() > 0) {
                        AOTCompiler.appendArgs(args, extData.linkerOptions);
                    }
                    if (extData.dependencyOptions != null && extData.dependencyOptions.size() > 0) {
                        AOTCompiler.appendArgs(args, extData.dependencyOptions);
                    }
                    assert (extData.exportedSymbols != null);
                    for (String symbol : extData.exportedSymbols) {
                        AOTCompiler.appendArgs(args, "-exported_symbol", "_" + symbol);
                    }
                }
                if (this.m_modernObjCSupported) {
                    AOTCompiler.appendArgs(args, "-force_load", Utils.quote(this.m_libArcLite));
                }
            }
            AOTCompiler.appendArgs(args, "-ios_version_min", this.m_opts.minIOSVersion);
            if (this.m_verbose) {
                System.out.println("# Generating executable...");
            }
            this.launchProcess(args, "ld64", "Unable to generate executable", true, false);
            if (this.m_hostIsMac && (this.m_opts.extensionsMap != null && this.m_opts.extensionsMap.size() > 0 || this.m_opts.generateDSYM)) {
                if (this.m_verbose) {
                    System.out.println("# Extracting DWARF info...");
                }
                try {
                    String dsymFileName = this.m_opts.outputPath + "/" + this.m_opts.filename + ".app.dSYM";
                    File oldDsymFile = new File(dsymFileName);
                    boolean oldFileDeleted = true;
                    if (oldDsymFile.exists()) {
                        oldFileDeleted = Utils.deleteAll(oldDsymFile);
                    }
                    if (oldFileDeleted) {
                        args = AOTCompiler.createArgs("dsymutil", "-o", dsymFileName, this.m_macExe.getCanonicalPath());
                        this.launchProcess(args, "dsymutil", "failed to extract DWARF info", this.m_verbose);
                    } else {
                        System.out.println("Warning: Skipping dsym file generation. Unable to delete " + dsymFileName);
                    }
                }
                catch (ProcessError pe) {
                    if (this.m_verbose) {
                        System.out.println("Warning: " + pe.getMessage());
                    }
                    if (pe.getExitCode() != 127) break block43;
                    System.out.println("Warning: dsymutil: Command not found");
                }
            }
        }
    }

    private ExtensionData hideAneSymbols(ExtensionData extData) throws IOException, ProcessError {
        ExtensionData ed = new ExtensionData(extData.id);
        ed.abcs = extData.abcs;
        ed.linkerOptions = extData.linkerOptions;
        ed.dependencySupported = extData.dependencySupported;
        ArrayList<String> args = AOTCompiler.createArgs(this.m_tools.get("ld64"), "-r", "-ObjC", "-arch", this.getTargetArch());
        assert (extData.exportedSymbols != null);
        for (String symbol : extData.exportedSymbols) {
            String alias = extData.id + "_" + symbol;
            AOTCompiler.appendArgs(args, "-alias", "_" + symbol, "_" + alias);
            AOTCompiler.appendArgs(args, "-exported_symbol", "_" + alias);
            ed.exportedSymbols.add(alias);
        }
        if (!extData.dependencySupported && extData.linkerOptions != null && extData.linkerOptions.size() > 0) {
            if (this.m_useCaptiveSdk) {
                AOTCompiler.appendArgs(args, "-Z", "-L", Utils.quote(this.m_captiveSdkRoot + STUB_DIR), "-F", Utils.quote(this.m_captiveSdkRoot + STUB_DIR));
            } else {
                assert (this.m_platformSdkRoot != null);
                AOTCompiler.appendArgs(args, "-syslibroot", Utils.quote(this.m_platformSdkRoot));
            }
            AOTCompiler.appendArgs(args, extData.linkerOptions);
        }
        if (extData.dependencyOptions != null && extData.dependencyOptions.size() > 0) {
            AOTCompiler.appendArgs(args, extData.dependencyOptions);
        }
        String output = Utils.quote(new File(this.m_tempFolder, extData.id + ".o").getAbsolutePath());
        AOTCompiler.appendArgs(args, "-o", output);
        this.launchProcess(args, "ld64", "Unable to link ANE lib" + extData.id, false, false);
        ed.dependencyOptions.add(output);
        return ed;
    }

    private String getTargetArch() {
        if (this.m_targetArch.equals("arm")) {
            if (this.m_opts.iosArch == 64) {
                return "arm64";
            }
            return "armv7";
        }
        return "i386";
    }

    public void validateIosSDK() throws SDKDamagedException {
        if (!this.m_opts.target.equals("arm-air") || this.m_opts.interpreter) {
            return;
        }
        for (String filePath : this.m_tools.values()) {
            if (filePath.indexOf(this.m_captiveSdkRoot) < 0 || new File(filePath).exists()) continue;
            throw new SDKDamagedException(filePath);
        }
    }

    protected int getTotalStepCount() {
        return -1;
    }

    protected void executeTargetSpecificSteps() throws IOException, ProcessError, InterruptedException, SDKDamagedException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateMachineBinaries() throws IOException, InvalidInputException, SDKDamagedException {
        boolean success = false;
        try {
            try {
                this.LogTiming("Step_0:Start");
                this.m_totalSteps = this.getTotalStepCount();
                this.m_currStep = 0;
                this.executeTargetSpecificSteps();
                this.linkMachO();
                this.reportProgress("linkMachO");
                if (this.m_hostIsMac) {
                    Runtime.getRuntime().exec("chmod a+x " + this.m_macExe.getAbsolutePath());
                }
                this.LogPerfMsg("ExecutableSize " + this.m_macExe.length());
                success = true;
            }
            catch (ProcessError e2) {
                if (!this.m_verbose) throw new InvalidInputException("Compilation failed while executing : " + e2.getProcessName());
                e2.printStackTrace();
                throw new InvalidInputException("Compilation failed while executing : " + e2.getProcessName());
            }
            catch (SDKDamagedException e3) {
                throw e3;
            }
            catch (Exception e4) {
                if (!this.m_verbose) throw new InvalidInputException("Compilation failed...");
                e4.printStackTrace();
                throw new InvalidInputException("Compilation failed...");
            }
            Object var4_2 = null;
            if (this.m_verbose) return;
            if (success) return;
            if (this.m_macExe == null) return;
            if (!this.m_macExe.exists()) return;
            this.m_macExe.delete();
            return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (this.m_verbose) throw throwable;
            if (success) throw throwable;
            if (this.m_macExe == null) throw throwable;
            if (!this.m_macExe.exists()) throw throwable;
            this.m_macExe.delete();
            throw throwable;
        }
    }

    protected void reportProgress(String msg) {
        this.LogTiming("Step_" + (this.m_currStep + 1) + ":" + msg);
        int percentDone = (int)((float)(++this.m_currStep) / ((float)this.m_totalSteps + 1.0f) * 100.0f);
        if (this.m_listener != null) {
            this.m_listener.progress(percentDone, 100);
        }
    }

    protected void invokeADT(int minHeap, long maxHeap, double maxHeapMultiplier, String xss, String[] args) throws IOException, ProcessError {
        String javaVersion;
        String[] debugMatches;
        String debugMatch;
        ArrayList<String> newArgs = new ArrayList<String>();
        newArgs.add("java");
        if (AOTCompiler.assertsEnabled() || this.m_opts.verbosity > 1) {
            newArgs.add("-ea");
        }
        boolean is64BitJVM = System.getProperty("java.vm.name").contains("64");
        boolean need32BitFlag = false;
        if (this.m_opts.force32Bit) {
            if (is64BitJVM) {
                assert (false);
                return;
            }
            if (this.m_hostIsMac) {
                need32BitFlag = true;
            }
        }
        if (need32BitFlag) {
            newArgs.add("-d32");
        }
        if ("".equals(debugMatch = System.getenv("ADT_AOT_DEBUG_MATCH"))) {
            debugMatch = null;
        }
        String argsStr = "";
        for (int i2 = 1; i2 < args.length; ++i2) {
            argsStr = argsStr + ' ' + args[i2];
        }
        if (this.m_verbose || debugMatch != null) {
            System.err.println("# invoking ADT " + args[0] + argsStr);
        }
        if (debugMatch != null && args[0].contains((debugMatches = debugMatch.split(";"))[0])) {
            boolean allMatch = true;
            for (int i3 = 1; i3 < debugMatches.length; ++i3) {
                if (argsStr.contains(debugMatches[i3])) continue;
                allMatch = false;
            }
            if (allMatch) {
                String jDebugOpt = System.getenv("ADT_AOT_JDEBUGOPT");
                if (jDebugOpt == null || jDebugOpt.length() == 0) {
                    jDebugOpt = "-Xrunjdwp:transport=dt_socket,address=1044,server=y,suspend=y";
                }
                System.err.println("# Setting Debug options: -Xdebug " + jDebugOpt);
                newArgs.add("-Xdebug");
                newArgs.add(jDebugOpt);
            }
        }
        if ((javaVersion = System.getProperty("java.version")) != null) {
            String[] versionInfo = javaVersion.split("\\.");
            try {
                if (Integer.parseInt(versionInfo[0]) > 1 || Integer.parseInt(versionInfo[1]) >= 7) {
                    newArgs.add("-Djava.util.Arrays.useLegacyMergeSort=true");
                }
            }
            catch (NumberFormatException e2) {
                System.err.println("Unable to retrieve the java version correctly.");
            }
        }
        if (is64BitJVM && !need32BitFlag) {
            maxHeap = (long)((double)maxHeap * maxHeapMultiplier);
        }
        if (xss != null) {
            newArgs.add("-Xss" + xss);
        }
        if (maxHeap < (long)minHeap) {
            maxHeap = minHeap;
        }
        if (this.m_verbose) {
            System.out.println("min, max heap = " + minHeap + " , " + maxHeap);
        }
        newArgs.addAll(Arrays.asList("-Xms" + minHeap + "m", "-Xmx" + maxHeap + "m", "-cp"));
        try {
            String jarFile = Utils.getJarFile().getAbsolutePath();
            if (!jarFile.endsWith("jar")) {
                String errorText = "Unable to locate ADT.jar";
                System.err.println(errorText);
                return;
            }
            newArgs.add(jarFile);
        }
        catch (IOException e3) {
            System.err.println("Error while reinvoking");
            e3.printStackTrace();
            return;
        }
        newArgs.addAll(Arrays.asList(args));
        try {
            Process child = Utils.execSafely(null, newArgs);
            new Utils.OutputEater(child.getInputStream(), System.out).start();
            new Utils.OutputEater(child.getErrorStream(), System.err).start();
            try {
                child.waitFor();
            }
            catch (InterruptedException e4) {
                System.err.println("Error while reinvoking");
                e4.printStackTrace();
                return;
            }
            if (child.exitValue() != 0) {
                String msg = "failed to invoke ADT with the following args: ";
                for (String s2 : args) {
                    msg = msg + s2 + " ";
                }
                throw new ProcessError("ADT", msg, child.exitValue());
            }
        }
        catch (IOException e5) {
            System.err.println("Error while reinvoking");
            e5.printStackTrace();
            return;
        }
    }

    public static boolean assertsEnabled() {
        int i2 = 0;
        assert (++i2 > 0);
        return i2 > 0;
    }

    public File getExecutable() {
        return this.m_macExe;
    }

    public static Object readObject(File serFile) throws IOException, ClassNotFoundException {
        Object retval = null;
        FileInputStream fis = new FileInputStream(serFile);
        ObjectInputStream in = new ObjectInputStream(fis);
        retval = in.readObject();
        in.close();
        return retval;
    }

    public static String writeObject(Object obj, File serFile) throws IOException {
        String retval = null;
        retval = serFile.getPath();
        FileOutputStream fos = new FileOutputStream(serFile);
        ObjectOutputStream out = new ObjectOutputStream(fos);
        out.writeObject(obj);
        out.close();
        return retval;
    }

    protected void LogPerfMsg(String msg) {
        if (this.m_opts.logPerf) {
            System.out.println("#PerfLog: " + msg);
        }
    }

    protected void LogTiming(String msg) {
        if (this.m_opts.logPerf) {
            System.out.println("#PerfLog:Timing: " + msg + " " + System.currentTimeMillis());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Timing
    implements Comparable<Timing> {
        public long timeMS;
        public String name;

        public Timing(long timeMS, String name) {
            this.timeMS = timeMS;
            this.name = name;
        }

        @Override
        public int compareTo(Timing t2) {
            return (int)(t2.timeMS - this.timeMS);
        }
    }
}

