/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.ios;

import com.adobe.air.ADTDeviceOperations;
import com.adobe.air.ADTException;
import com.adobe.air.InvalidInputException;
import com.adobe.air.SDKDamagedException;
import com.adobe.air.Utils;
import com.adobe.ucf.Utils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOSSimulatorOperations
implements ADTDeviceOperations {
    private static final String SDK_DIR_PREFIX = "iPhoneSimulator";
    private static final String SDK_DIR_SUFFIX = ".sdk";
    private static final String DYLD_FALLBACK_FRAMEWORK_PATH_ENV = "DYLD_FALLBACK_FRAMEWORK_PATH";
    private static final String PRIVATE_FWK_PATH_WRT_DEVELOPER = "/Library/PrivateFrameworks";
    private static final String OTHER_FRAMEWORK_REL_PATH = "/../../../../../../OtherFrameworks";
    private File m_isb = null;
    private String m_sdkPath = null;
    private String m_deviceType = null;
    protected Set<String> validSimulatorDeviceType = new HashSet<String>();

    private List<String> getIOSSimulatorOperationCommand() throws InvalidInputException {
        if (null == this.m_isb) {
            throw new InvalidInputException("isb path must be non-null");
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.m_isb.getAbsolutePath());
        return command;
    }

    private String execCommandSafely(List<String> command) throws InterruptedException, IOException, ADTException {
        return this.execCommandSafely(command, false);
    }

    private String execCommandSafely(List<String> command, boolean ignoreStdErr) throws InterruptedException, IOException, ADTException {
        HashMap<String, String> env = new HashMap<String, String>();
        File sdkDir = new File(this.m_sdkPath);
        StringBuffer fallbackFmwkPath = new StringBuffer(sdkDir.getParentFile().getParentFile().getAbsolutePath() + PRIVATE_FWK_PATH_WRT_DEVELOPER);
        File otherFrameworksDir = new File(this.m_sdkPath + OTHER_FRAMEWORK_REL_PATH);
        if (otherFrameworksDir.exists()) {
            fallbackFmwkPath.append(":" + otherFrameworksDir.getAbsolutePath());
        }
        env.put(DYLD_FALLBACK_FRAMEWORK_PATH_ENV, fallbackFmwkPath.toString());
        Process simLauncher = Utils.execSafely(null, command, true, env);
        ByteArrayOutputStream adbOutBytes = new ByteArrayOutputStream();
        ByteArrayOutputStream adbErrBytes = new ByteArrayOutputStream();
        new Utils.OutputEater(simLauncher.getInputStream(), adbOutBytes).run();
        new Utils.OutputEater(simLauncher.getErrorStream(), adbErrBytes).run();
        simLauncher.waitFor();
        if (!ignoreStdErr && adbErrBytes.size() > 0) {
            throw new ADTException(adbErrBytes.toString(), 14);
        }
        return adbOutBytes.toString("UTF-8");
    }

    public IOSSimulatorOperations() {
        this.validSimulatorDeviceType.add("iPhone 5");
        this.validSimulatorDeviceType.add("iPhone 4s");
        this.validSimulatorDeviceType.add("iPhone 5s");
        this.validSimulatorDeviceType.add("iPad Air");
        this.validSimulatorDeviceType.add("iPhone 6");
        this.validSimulatorDeviceType.add("iPhone 6 Plus");
        this.validSimulatorDeviceType.add("iPhone Retina (3.5-inch)");
        this.validSimulatorDeviceType.add("iPhone Retina (4-inch)");
        this.validSimulatorDeviceType.add("iPad Retina");
        this.validSimulatorDeviceType.add("iPhone");
        this.validSimulatorDeviceType.add("iPad");
    }

    @Override
    public void installApplication(File application) throws IOException, InvalidInputException, ADTException {
        if (application == null) {
            throw new InvalidInputException("Missing <ipa-file> ");
        }
        if (!application.exists()) {
            throw new InvalidInputException("Cannot find <ipa-file> " + application.getPath());
        }
        File tempDir = Utils.createTempDirectory();
        try {
            try {
                ArrayList<String> unzipCommand = new ArrayList<String>(Arrays.asList("unzip", "-uo", application.getAbsolutePath(), "-d", tempDir.getAbsolutePath()));
                this.execCommandSafely(unzipCommand, true);
                File appDir = tempDir.listFiles()[0].listFiles()[0];
                if (!appDir.exists()) {
                    throw new IOException("Invalid ipa file");
                }
                List<String> command = this.getIOSSimulatorOperationCommand();
                command.add("-install");
                command.add("-apppath");
                command.add(appDir.getAbsolutePath());
                if (this.m_sdkPath != null) {
                    command.add("-sdkpath");
                    command.add(this.m_sdkPath);
                }
                this.execCommandSafely(command);
            }
            catch (ADTException adtEx) {
                throw adtEx;
            }
            catch (Exception e2) {
                throw new ADTException("Failed to install " + application.getCanonicalPath(), 14);
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            Utils.deleteAll(tempDir);
            throw throwable;
        }
        Utils.deleteAll(tempDir);
    }

    @Override
    public void installRuntime(File runtime) throws IOException, InvalidInputException, SDKDamagedException {
        throw new InvalidInputException("Runtime install/uninstall is not supported on ios-simulator");
    }

    @Override
    public void uninstallApplication(String appId) throws InvalidInputException, ADTException {
        if (appId == null || appId.equals("")) {
            throw new InvalidInputException("<app-id> must be of non-zero length");
        }
        try {
            List<String> command = this.getIOSSimulatorOperationCommand();
            command.add("-uninstall");
            command.add("-appid");
            command.add(appId);
            if (this.m_sdkPath != null) {
                command.add("-sdkpath");
                command.add(this.m_sdkPath);
            }
            this.execCommandSafely(command);
        }
        catch (ADTException adtEx) {
            throw adtEx;
        }
        catch (Exception e2) {
            throw new ADTException("Failed to uninstall " + appId, 14);
        }
    }

    @Override
    public void uninstallRuntime() throws IOException, InvalidInputException {
        throw new InvalidInputException("Runtime install/uninstall not supported on ios-simulator");
    }

    @Override
    public void launchApplication(String appId, int debuggerPort) throws InvalidInputException, ADTException {
        this.launchApplication(appId);
    }

    @Override
    public void launchApplication(String appId) throws InvalidInputException, ADTException {
        if (appId == null || appId.equals("")) {
            throw new InvalidInputException("<app-id> must be non-zero length");
        }
        try {
            List<String> command = this.getIOSSimulatorOperationCommand();
            command.add("-launch");
            command.add("-appid");
            command.add(appId);
            if (this.m_sdkPath != null) {
                command.add("-sdkpath");
                command.add(this.m_sdkPath);
            }
            if (this.m_deviceType != null) {
                command.add("-deviceType");
                command.add(this.m_deviceType);
            }
            this.execCommandSafely(command);
        }
        catch (ADTException adtEx) {
            throw adtEx;
        }
        catch (Exception e2) {
            throw new ADTException("Failed to launch " + appId, 14);
        }
    }

    @Override
    public String getApplicationVersion(String appId) throws ADTException, InvalidInputException {
        String appVersion = null;
        if (appId == null || appId.equals("")) {
            throw new InvalidInputException("<app-id> must be non-zero length");
        }
        try {
            List<String> command = this.getIOSSimulatorOperationCommand();
            command.add("-appversion");
            command.add("-appid");
            command.add(appId);
            if (this.m_sdkPath != null) {
                command.add("-sdkpath");
                command.add(this.m_sdkPath);
            }
            appVersion = this.execCommandSafely(command);
        }
        catch (ADTException adtEx) {
            throw adtEx;
        }
        catch (Exception e2) {
            throw new ADTException("Failed to find package " + appId, 14);
        }
        return appVersion;
    }

    @Override
    public String getRuntimeVersion() throws IOException {
        return null;
    }

    @Override
    public void listDevices() throws IOException {
        throw new InvalidInputException("List devices is not supported on ios-simulator");
    }

    public void setSimulatorBridgePath(String isbPath) throws IOException, InvalidInputException {
        if (isbPath == null) {
            throw new InvalidInputException("isb path must be non-null");
        }
        this.m_isb = new File(isbPath);
        if (!this.m_isb.exists()) {
            throw new InvalidInputException("Could not locate isb");
        }
    }

    public void setIOSSimulatorSDK(File sdk) throws InvalidInputException {
        if (sdk == null || !sdk.exists() || !sdk.isDirectory()) {
            throw new InvalidInputException("SDK should point to valid path.");
        }
        String sdkDirName = sdk.getName();
        if (!sdkDirName.startsWith(SDK_DIR_PREFIX) || !sdkDirName.endsWith(SDK_DIR_SUFFIX)) {
            throw new InvalidInputException("SDK should point to valid path.");
        }
        this.m_sdkPath = sdk.getAbsolutePath();
    }

    public void setIOSSimulatorDeviceType(String deviceType) {
        if (deviceType != null && this.validSimulatorDeviceType.contains(deviceType)) {
            this.m_deviceType = deviceType;
        }
    }
}

