/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.apk;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.InnerClasses;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;

public class RClassCreator
implements Constants {
    private InstructionFactory _factory;
    private ConstantPoolGen _cp;
    private ClassGen _cg;
    private String _packageName;
    private String _resourceClassName;
    private RClassCreator _outerClass = null;
    private List<RClassCreator> _innerClasses = new LinkedList<RClassCreator>();

    public RClassCreator(String packageName, String resourceClassName, ConstantPoolGen constantPool) {
        this.init(packageName, resourceClassName, constantPool);
    }

    private void init(String packageName, String resourceClassName, ConstantPoolGen constantPool) {
        this._packageName = packageName;
        this._resourceClassName = resourceClassName;
        this._cp = constantPool;
        this._cg = new ClassGen(this.getFullResourceClassName(), "java.lang.Object", "R.java", 49, new String[0], this._cp);
        this._factory = new InstructionFactory(this._cg, this._cp);
    }

    public RClassCreator(String packageName, String resourceClassName, ConstantPoolGen constantPool, RClassCreator outerClass) {
        this.init(packageName, resourceClassName, constantPool);
        this._outerClass = outerClass;
        this._outerClass._innerClasses.add(this);
    }

    public String getClassFilePath() {
        return this.getPackageName().replace('.', File.separatorChar) + File.separator + this.getResourceClassName() + ".class";
    }

    public void create(OutputStream out) throws IOException {
        this.createMethod_0();
        this.createInnerClasses();
        this._cg.getJavaClass().dump(out);
    }

    private void createInnerClasses() {
        LinkedList<InnerClass> innerClassesList = new LinkedList<InnerClass>();
        if (this._outerClass != null) {
            int inner_class_index = this._cp.addClass(this.getFullResourceClassName());
            int outer_class_index = this._cp.addClass(this._outerClass.getFullResourceClassName());
            int inner_name_index = this._cp.addUtf8(this.getInnerClassName());
            int inner_access_flags = this._cg.getAccessFlags();
            InnerClass ic = new InnerClass(inner_class_index, outer_class_index, inner_name_index, inner_access_flags);
            innerClassesList.add(ic);
        }
        for (RClassCreator item : this._innerClasses) {
            int inner_class_index = this._cp.addClass(item.getFullResourceClassName());
            int outer_class_index = this._cp.addClass(this.getFullResourceClassName());
            int inner_name_index = this._cp.addUtf8(item.getInnerClassName());
            int inner_access_flags = item._cg.getAccessFlags();
            InnerClass ic = new InnerClass(inner_class_index, outer_class_index, inner_name_index, inner_access_flags);
            innerClassesList.add(ic);
        }
        InnerClass[] innerClassesArray = innerClassesList.toArray(new InnerClass[0]);
        int name_index = this._cp.addUtf8("InnerClasses");
        int innerClassesSize = innerClassesArray.length * 8 + 2;
        InnerClasses innerClassesAttrib = new InnerClasses(name_index, innerClassesSize, innerClassesArray, this._cp.getConstantPool());
        this._cg.addAttribute(innerClassesAttrib);
    }

    private String getInnerClassName() {
        String innerClassName = this._resourceClassName;
        int indexOfDollarSign = innerClassName.lastIndexOf(36) + 1;
        if (indexOfDollarSign > 0) {
            innerClassName = innerClassName.substring(indexOfDollarSign);
        }
        return innerClassName;
    }

    public String getFullResourceClassName() {
        return String.format("%s.%s", this._packageName, this._resourceClassName);
    }

    public String getResourceClassName() {
        return this._resourceClassName;
    }

    public String getPackageName() {
        return this._packageName;
    }

    public void appendResourceId(String resourceName, int resourceId) {
        FieldGen field = new FieldGen(25, Type.INT, resourceName, this._cp);
        field.setInitValue(resourceId);
        this._cg.addField(field.getField());
    }

    private void createMethod_0() {
        InstructionList il = new InstructionList();
        MethodGen method = new MethodGen(1, Type.VOID, Type.NO_ARGS, new String[0], "<init>", this.getFullResourceClassName(), il, this._cp);
        il.append(InstructionFactory.createLoad(Type.OBJECT, 0));
        il.append(this._factory.createInvoke("java.lang.Object", "<init>", Type.VOID, Type.NO_ARGS, (short)183));
        il.append(InstructionFactory.createReturn(Type.VOID));
        method.setMaxStack();
        method.setMaxLocals();
        this._cg.addMethod(method.getMethod());
        il.dispose();
    }
}

