/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.apk;

import com.adobe.air.ANEFile;
import com.adobe.air.ApplicationDescriptor;
import com.adobe.air.ApplicationPackager;
import com.adobe.air.InvalidInputException;
import com.adobe.air.Utils;
import com.adobe.air.android.AndroidDeviceSDK;
import com.adobe.air.apk.APKOutputStream;
import com.adobe.air.apk.AndroidExtensionDescriptor;
import com.adobe.air.validator.DescriptorValidationException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class APKPackager
extends ApplicationPackager {
    public static final ApplicationDescriptor.ValidationParams APK_VALIDATION_PARAMS = new ApplicationDescriptor.ValidationParams("http://ns.adobe.com/air/application/2.5", "http://ns.adobe.com/air/application/3.0", new String[]{"mobileDevice"}, false, false);
    public static final ApplicationDescriptor.ValidationParams APK_CAPTIVE_RUNTIME_VALIDATION_PARAMS = new ApplicationDescriptor.ValidationParams("http://ns.adobe.com/air/application/3.0", "http://ns.adobe.com/air/application/3.0", new String[]{"mobileDevice", "mobileDeviceBase"}, false, false);
    private static final String AIR_ANDROID_SHARED_RUNTIME = "AIR_ANDROID_SHARED_RUNTIME";
    private static final String JAR_FILE_EXTENSION = "jar";
    private static final String LIB_FILE_EXTENSION = "so";

    public APKPackager() {
        super("AIR", "Android-ARM", true, false);
        this.setStream(new APKOutputStream());
        this.setIsSharedRuntime();
        this.setArch("armv7");
    }

    public APKPackager(String platform) {
        super("AIR", platform, true, false);
        this.setStream(new APKOutputStream());
        this.setIsSharedRuntime();
    }

    @Override
    public void setPrivateKey(PrivateKey key) {
        super.setPrivateKey(key);
    }

    @Override
    public void setApplicationDescriptor(File descriptorFile) {
        try {
            super.setApplicationDescriptor(descriptorFile);
            this.getAPKStream().addApplicationDescriptorFile(descriptorFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected void validateApplicationDescriptor() throws DescriptorValidationException {
        super.validateApplicationDescriptor();
        this.getAPKStream().setSources(this.getSources());
    }

    @Override
    protected ApplicationDescriptor.ValidationParams getValidationParams(ApplicationDescriptor appDescriptor) {
        return this.getAPKStream().hasCaptiveRuntime() ? APK_CAPTIVE_RUNTIME_VALIDATION_PARAMS : APK_VALIDATION_PARAMS;
    }

    private static String getFileExtension(String f2) {
        String ext = "";
        int i2 = f2.lastIndexOf(46);
        if (i2 > 0 && i2 < f2.length() - 1) {
            ext = f2.substring(i2 + 1).toLowerCase();
        }
        return ext;
    }

    private void checkAndRemoveDuplicates(List<String> appList, List<String> aneList, String listType) {
        Iterator<String> i2 = aneList.iterator();
        while (i2.hasNext()) {
            String entry = i2.next();
            if (appList.contains(entry)) {
                System.out.println("Warning: " + listType + " " + entry + " used by more than one ANE. Ignoring this entry");
                i2.remove();
                continue;
            }
            appList.add(entry);
        }
    }

    @Override
    protected void processExtensions() throws IOException, DescriptorValidationException, InvalidInputException {
        super.processExtensions();
        File tempDir = Utils.createTempDirectory();
        this.addFileForCleanup(tempDir);
        byte[] buf = new byte[1024];
        LinkedList<String> appDependencyList = new LinkedList<String>();
        LinkedList<String> appResourceList = new LinkedList<String>();
        LinkedList<String> appPackageList = new LinkedList<String>();
        for (ANEFile ane : this.getExtensions()) {
            try {
                String nativeLibraryFileExtension;
                String platform = null;
                String platformPath = null;
                String libPlatformPath = null;
                if (this.getAPKStream().getArch().equals("armv7")) {
                    platform = "Android-ARM";
                    platformPath = ane.getPlatformPath(platform);
                    libPlatformPath = platformPath + "/libs/armeabi-v7a/";
                } else if (this.getAPKStream().getArch().equals("x86")) {
                    platform = "Android-x86";
                    platformPath = ane.getPlatformPath(platform);
                    libPlatformPath = platformPath + "/libs/x86/";
                }
                String resPlatformPath = platformPath + "/res/";
                String nativeLibraryPath = ane.getNativeLibraryPath(platform);
                if (nativeLibraryPath == null || !(nativeLibraryFileExtension = APKPackager.getFileExtension(nativeLibraryPath)).equals(JAR_FILE_EXTENSION) && !nativeLibraryFileExtension.equals(LIB_FILE_EXTENSION)) continue;
                ZipFile zipFile = new ZipFile(ane.getFile());
                ArrayList<String> dependencies = Collections.EMPTY_LIST;
                ArrayList<String> resources = Collections.EMPTY_LIST;
                ArrayList<String> packages = Collections.EMPTY_LIST;
                String platformOptionsPath = ane.getPlatformPath(this.m_targetPlatform) + "/" + "platform.xml";
                ZipEntry platformOptionsFile = zipFile.getEntry(platformOptionsPath);
                if (platformOptionsFile != null) {
                    AndroidExtensionDescriptor desc = new AndroidExtensionDescriptor(zipFile.getInputStream(platformOptionsFile), true, platformOptionsFile.getName());
                    dependencies = desc.dependencies();
                    resources = desc.resourceFolders();
                    packages = desc.resourcePackages();
                    this.checkAndRemoveDuplicates(appDependencyList, dependencies, "packagedDependency");
                    this.checkAndRemoveDuplicates(appResourceList, resources, "folderName");
                    this.checkAndRemoveDuplicates(appPackageList, packages, "packageName");
                    this.getAPKStream().setPackages(packages);
                }
                LinkedHashMap<File, String> extraResources = new LinkedHashMap<File, String>();
                LinkedList<File> extraLibs = new LinkedList<File>();
                Enumeration<? extends ZipEntry> e2 = zipFile.entries();
                while (e2.hasMoreElements()) {
                    File outFile;
                    ZipEntry currentEntry;
                    block14: {
                        String itemRelativeName;
                        String currentEntryName;
                        block15: {
                            block13: {
                                currentEntry = e2.nextElement();
                                currentEntryName = currentEntry.getName();
                                outFile = null;
                                if (!currentEntryName.startsWith(libPlatformPath)) break block13;
                                itemRelativeName = currentEntryName.substring(libPlatformPath.length());
                                outFile = new File(tempDir, "libs" + File.separator + itemRelativeName);
                                extraLibs.add(outFile);
                                break block14;
                            }
                            if (!currentEntry.getName().startsWith(resPlatformPath)) break block15;
                            itemRelativeName = currentEntryName.substring(resPlatformPath.length());
                            if (!this.validateANEResourcesAgainstSupportedLanguages(itemRelativeName)) break block14;
                            outFile = new File(tempDir, "res" + File.separator + itemRelativeName);
                            extraResources.put(outFile, "res");
                            break block14;
                        }
                        if (currentEntry.getName().startsWith(platformPath)) {
                            itemRelativeName = currentEntryName.substring(platformPath.length() + 1);
                            for (String resource : resources) {
                                if (!itemRelativeName.startsWith(resource + "/") || !this.validateANEResourcesAgainstSupportedLanguages(itemRelativeName)) continue;
                                outFile = new File(tempDir, itemRelativeName);
                                extraResources.put(outFile, resource);
                                break;
                            }
                            for (String dependency : dependencies) {
                                if (!itemRelativeName.equals(dependency)) continue;
                                outFile = new File(tempDir, itemRelativeName);
                                break;
                            }
                        }
                    }
                    if (outFile == null) continue;
                    InputStream in = zipFile.getInputStream(currentEntry);
                    outFile.getParentFile().mkdirs();
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));
                    Utils.writeThrough(in, out);
                    ((OutputStream)out).close();
                }
                if (extraResources.size() > 0) {
                    this.getAPKStream().addExtraResources(extraResources);
                }
                if (extraLibs.size() > 0) {
                    this.getAPKStream().addExtraLibs(extraLibs);
                }
                InputStream in = zipFile.getInputStream(zipFile.getEntry(nativeLibraryPath));
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(tempDir, ane.id() + "." + nativeLibraryFileExtension)));
                Utils.writeThrough(in, out);
                in.close();
                ((OutputStream)out).close();
                zipFile.close();
            }
            catch (IOException e3) {
                throw new InvalidInputException(ane.getFile().getAbsoluteFile() + " is not a valid native extension file.");
            }
        }
        File[] jarFiles = tempDir.listFiles(new FileExtensionFilter(JAR_FILE_EXTENSION));
        this.getAPKStream().setExtensionsJars(jarFiles);
        File[] libFile = tempDir.listFiles(new FileExtensionFilter(LIB_FILE_EXTENSION));
        this.getAPKStream().setExtensionsLibs(libFile);
    }

    @Override
    protected void addExtensions() throws IOException, DescriptorValidationException, InvalidInputException {
        super.addExtensions();
        this.getAPKStream().addExtensionsNativeLibs();
    }

    @Override
    public void setOutput(File output) throws FileNotFoundException, IOException {
        super.setOutput(output);
        this.initTempFile("apk");
    }

    @Override
    public void setPackageConfiguration(String configType) {
        this.getAPKStream().setConfigType(configType);
    }

    @Override
    public void setForOutgoingDebuggingConnection(String host, int port) throws IOException {
        this.getAPKStream().setForOutgoingDebuggingConnection(host, port);
    }

    @Override
    public void setPreloadSWFPath(String path) {
        this.getAPKStream().setPreloadSWFPath(path);
    }

    @Override
    public void setForIncomingDebuggerConnection(int portToListenOn) throws IOException {
        this.getAPKStream().setForIncomingDebuggerConnection(portToListenOn);
    }

    @Override
    public void setAIRDownloadURL(String airDownloadURL) {
        this.getAPKStream().setAIRDownloadURL(airDownloadURL);
    }

    @Override
    protected APKOutputStream getStream() {
        return (APKOutputStream)super.getStream();
    }

    private APKOutputStream getAPKStream() {
        return this.getStream();
    }

    @Override
    public void setDeviceSDKDirectory(File sdkDir) throws InvalidInputException {
        this.getAPKStream().setAndroidDeviceSDK(new AndroidDeviceSDK(sdkDir));
    }

    @Override
    public void setArch(String arch) {
        this.getAPKStream().setArch(arch);
    }

    @Override
    public void setTimestampURL(String url) {
        throw new UnsupportedOperationException("timestamp not supported for APK");
    }

    public boolean allowAIRDownloadURL() {
        return this.getAPKStream().getConfigType().equals("apk") || this.getAPKStream().getConfigType().equals("apk-debug");
    }

    public static boolean isSharedRuntimeVarSet() {
        String airSharedRuntimeVar = System.getenv(AIR_ANDROID_SHARED_RUNTIME);
        boolean isShared = airSharedRuntimeVar != null && airSharedRuntimeVar.indexOf("true") != -1;
        return isShared;
    }

    private void setIsSharedRuntime() {
        this.getAPKStream().setIsSharedRuntime(APKPackager.isSharedRuntimeVarSet());
    }

    private boolean validateANEResourcesAgainstSupportedLanguages(String relativeName) {
        String folderName;
        String[] qualifiers;
        int folderSeparatorIndex = relativeName.indexOf(47);
        if (folderSeparatorIndex != -1 && relativeName.lastIndexOf(45, folderSeparatorIndex) != -1 && (qualifiers = (folderName = relativeName.substring(0, folderSeparatorIndex)).split("-"))[1].length() == 2 && qualifiers[1].matches("[a-z]{2}")) {
            String lang = qualifiers[1];
            List<String> supportedLanguages = this.getApplicationDescriptor().supportedLanguages();
            if (supportedLanguages == null) {
                this.getApplicationDescriptor();
                supportedLanguages = new ArrayList<String>(ApplicationDescriptor.ALL_SUPPORTED_LANGUAGES);
            }
            if (!supportedLanguages.contains(lang.toLowerCase()) && !lang.equals("en")) {
                System.out.println("Warning: Resource " + relativeName + " has been skipped because of mismatch with supported languages information in application descriptor.");
                return false;
            }
        }
        return true;
    }

    class FileExtensionFilter
    implements FilenameFilter {
        private String extension;

        public FileExtensionFilter(String extension) {
            this.extension = extension.toLowerCase();
        }

        public boolean accept(File directory, String filename) {
            boolean fileOK = true;
            if (this.extension != null) {
                fileOK &= filename.toLowerCase().endsWith('.' + this.extension);
            }
            return fileOK;
        }
    }
}

