/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class UnicodeInputStream
extends InputStream {
    private final PushbackInputStream in;
    private final ByteOrderMark bom;
    private boolean bomAlreadySkipped = false;
    private static final int BOM_SIZE = 4;

    public UnicodeInputStream(InputStream inputStream) throws NullPointerException, IOException {
        if (inputStream == null) {
            throw new NullPointerException("invalid input stream: null is not allowed");
        }
        this.in = new PushbackInputStream(inputStream, 4);
        byte[] bom = new byte[4];
        int read = this.in.read(bom);
        switch (read) {
            case 4: {
                if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
                    this.bom = ByteOrderMark.UTF_32_LE;
                    break;
                }
                if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
                    this.bom = ByteOrderMark.UTF_32_BE;
                    break;
                }
            }
            case 3: {
                if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
                    this.bom = ByteOrderMark.UTF_8;
                    break;
                }
            }
            case 2: {
                if (bom[0] == -1 && bom[1] == -2) {
                    this.bom = ByteOrderMark.UTF_16_LE;
                    break;
                }
                if (bom[0] == -2 && bom[1] == -1) {
                    this.bom = ByteOrderMark.UTF_16_BE;
                    break;
                }
            }
            default: {
                this.bom = ByteOrderMark.NONE;
            }
        }
        if (read > 0) {
            this.in.unread(bom, 0, read);
        }
    }

    public final ByteOrderMark getByteOrderMark() {
        return this.bom;
    }

    public final String getBOMCharsetKey() {
        return this.bom.getCharsetKey();
    }

    public final synchronized void skipByteOrderMark() throws IOException {
        if (!this.bomAlreadySkipped) {
            this.in.skip(this.bom.bytes.length);
            this.bomAlreadySkipped = true;
        }
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public int read(byte[] b3) throws IOException, NullPointerException {
        return this.in.read(b3, 0, b3.length);
    }

    public int read(byte[] b3, int off, int len) throws IOException, NullPointerException {
        return this.in.read(b3, off, len);
    }

    public long skip(long n2) throws IOException {
        return this.in.skip(n2);
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public static final class ByteOrderMark {
        public static final ByteOrderMark NONE = new ByteOrderMark(new byte[0], "NONE", "NONE");
        public static final ByteOrderMark UTF_8 = new ByteOrderMark(new byte[]{-17, -69, -65}, "UTF-8", "UTF-8");
        public static final ByteOrderMark UTF_16_LE = new ByteOrderMark(new byte[]{-1, -2}, "UTF-16 little-endian", "UTF-16LE");
        public static final ByteOrderMark UTF_16_BE = new ByteOrderMark(new byte[]{-2, -1}, "UTF-16 big-endian", "UTF-16BE");
        public static final ByteOrderMark UTF_32_LE = new ByteOrderMark(new byte[]{-1, -2, 0, 0}, "UTF-32 little-endian", "UTF-32LE");
        public static final ByteOrderMark UTF_32_BE = new ByteOrderMark(new byte[]{0, 0, -2, -1}, "UTF-32 big-endian", "UTF-32BE");
        private final byte[] bytes;
        private final String description;
        private final String javaCharsetKey;

        public final String toString() {
            return this.description;
        }

        public final String getCharsetKey() {
            return this.javaCharsetKey;
        }

        public final byte[] getBytes() {
            int length = this.bytes.length;
            byte[] result = new byte[length];
            System.arraycopy(this.bytes, 0, result, 0, length);
            return result;
        }

        private ByteOrderMark(byte[] bom, String description, String javaCharsetKey) {
            assert (bom != null) : "invalid BOM: null is not allowed";
            assert (description != null) : "invalid description: null is not allowed";
            assert (description.length() != 0) : "invalid description: empty string is not allowed";
            assert (javaCharsetKey != null) : "invalid javaCharset: null is not allowed";
            assert (javaCharsetKey.length() != 0) : "invalid javaCharset: empty string is not allowed";
            this.bytes = bom;
            this.description = description;
            this.javaCharsetKey = javaCharsetKey;
        }
    }
}

