/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.air.Descriptor;
import com.adobe.air.validator.DescriptorValidationException;
import com.adobe.air.validator.ExtensionDescriptorValidator;
import com.adobe.air.validator.ExtensionDescriptorValidator25;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionDescriptor
extends Descriptor {
    public static final String NAMESPACE_2_5 = "http://ns.adobe.com/air/extension/2.5";
    public static final String NAMESPACE_3_1 = "http://ns.adobe.com/air/extension/3.1";
    public static final String NAMESPACE_3_2 = "http://ns.adobe.com/air/extension/3.2";
    public static final String NAMESPACE_3_3 = "http://ns.adobe.com/air/extension/3.3";
    public static final String NAMESPACE_3_4 = "http://ns.adobe.com/air/extension/3.4";
    public static final String NAMESPACE_3_5 = "http://ns.adobe.com/air/extension/3.5";
    public static final String NAMESPACE_3_6 = "http://ns.adobe.com/air/extension/3.6";
    public static final String NAMESPACE_3_7 = "http://ns.adobe.com/air/extension/3.7";
    public static final String NAMESPACE_3_8 = "http://ns.adobe.com/air/extension/3.8";
    public static final String NAMESPACE_3_9 = "http://ns.adobe.com/air/extension/3.9";
    public static final String NAMESPACE_4_0 = "http://ns.adobe.com/air/extension/4.0";
    public static final String NAMESPACE_13_0 = "http://ns.adobe.com/air/extension/13.0";
    public static final String NAMESPACE_14_0 = "http://ns.adobe.com/air/extension/14.0";
    public static final String NAMESPACE_15_0 = "http://ns.adobe.com/air/extension/15.0";
    public static final String NAMESPACE_16_0 = "http://ns.adobe.com/air/extension/16.0";
    public static final String NAMESPACE_17_0 = "http://ns.adobe.com/air/extension/17.0";
    private static final String[] NAMESPACES = new String[]{"http://ns.adobe.com/air/extension/2.5", "http://ns.adobe.com/air/extension/3.1", "http://ns.adobe.com/air/extension/3.2", "http://ns.adobe.com/air/extension/3.3", "http://ns.adobe.com/air/extension/3.4", "http://ns.adobe.com/air/extension/3.5", "http://ns.adobe.com/air/extension/3.6", "http://ns.adobe.com/air/extension/3.7", "http://ns.adobe.com/air/extension/3.8", "http://ns.adobe.com/air/extension/3.9", "http://ns.adobe.com/air/extension/4.0", "http://ns.adobe.com/air/extension/13.0", "http://ns.adobe.com/air/extension/14.0", "http://ns.adobe.com/air/extension/15.0", "http://ns.adobe.com/air/extension/16.0", "http://ns.adobe.com/air/extension/17.0"};
    private static final Map<String, String> NAMESPACE_CLASSNAMES;
    private static final Map<String, Integer> NAMESPACE_APIVERSIONS;

    public ExtensionDescriptor(File descriptorFile) throws DescriptorValidationException {
        super(descriptorFile, true);
    }

    public ExtensionDescriptor(File descriptorFile, boolean validate) throws DescriptorValidationException {
        super(descriptorFile, validate);
    }

    public ExtensionDescriptor(InputStream in, boolean validate, String name) throws DescriptorValidationException {
        super(in, validate, name);
    }

    public String id() {
        return ((ExtensionDescriptorValidator25)this._validator).id();
    }

    public boolean supportsPlatform(String platform) {
        return this.platforms().containsKey(platform);
    }

    public String getNativeLibrary(String platform) {
        return this.supportsPlatform(platform) ? this.platforms().get((Object)platform).nativeLibrary : null;
    }

    public String getInitializer(String platform) {
        return this.supportsPlatform(platform) ? this.platforms().get((Object)platform).initializer : null;
    }

    public String getFinalizer(String platform) {
        return this.supportsPlatform(platform) ? this.platforms().get((Object)platform).finalizer : null;
    }

    public String versionNumber() {
        return ((ExtensionDescriptorValidator25)this._validator).versionNumber();
    }

    public String copyright() {
        return ((ExtensionDescriptorValidator25)this._validator).copyright();
    }

    public int maxSWFVersion() {
        return ((ExtensionDescriptorValidator)this._validator).getMaximumSWFVersion();
    }

    public int getAPIVersionForExtensionNS() {
        Integer uriVersion = NAMESPACE_APIVERSIONS.get(this.getNamespaceURI());
        if (uriVersion == null) {
            throw new IllegalArgumentException("Invalid namespaceURI");
        }
        return uriVersion;
    }

    public String getNamespaceURI() {
        return this._document.getDocumentElement().getNamespaceURI();
    }

    public int namespaceCompare(String compareTo) {
        List<String> nameSpacesAsList = Arrays.asList(NAMESPACES);
        int appDescInx = nameSpacesAsList.indexOf(this._document.getDocumentElement().getNamespaceURI());
        int compareInx = nameSpacesAsList.indexOf(compareTo);
        return appDescInx - compareInx;
    }

    @Override
    protected String getValidatorClassNameFromNamespaceUri(String namespaceUri) {
        return NAMESPACE_CLASSNAMES.get(namespaceUri);
    }

    public Map<String, Platform> platforms() {
        return ((ExtensionDescriptorValidator25)this._validator).platforms();
    }

    public Map<String, Platform> applicationDeployedPlatforms() {
        return ((ExtensionDescriptorValidator25)this._validator).applicationDeployedPlatforms();
    }

    static {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put(NAMESPACE_2_5, "com.adobe.air.validator.ExtensionDescriptorValidator25");
        tempMap.put(NAMESPACE_3_1, "com.adobe.air.validator.ExtensionDescriptorValidator31");
        tempMap.put(NAMESPACE_3_2, "com.adobe.air.validator.ExtensionDescriptorValidator32");
        tempMap.put(NAMESPACE_3_3, "com.adobe.air.validator.ExtensionDescriptorValidator33");
        tempMap.put(NAMESPACE_3_4, "com.adobe.air.validator.ExtensionDescriptorValidator34");
        tempMap.put(NAMESPACE_3_5, "com.adobe.air.validator.ExtensionDescriptorValidator35");
        tempMap.put(NAMESPACE_3_6, "com.adobe.air.validator.ExtensionDescriptorValidator36");
        tempMap.put(NAMESPACE_3_7, "com.adobe.air.validator.ExtensionDescriptorValidator37");
        tempMap.put(NAMESPACE_3_8, "com.adobe.air.validator.ExtensionDescriptorValidator38");
        tempMap.put(NAMESPACE_3_9, "com.adobe.air.validator.ExtensionDescriptorValidator39");
        tempMap.put(NAMESPACE_4_0, "com.adobe.air.validator.ExtensionDescriptorValidator40");
        tempMap.put(NAMESPACE_13_0, "com.adobe.air.validator.ExtensionDescriptorValidator130");
        tempMap.put(NAMESPACE_14_0, "com.adobe.air.validator.ExtensionDescriptorValidator140");
        tempMap.put(NAMESPACE_15_0, "com.adobe.air.validator.ExtensionDescriptorValidator150");
        tempMap.put(NAMESPACE_16_0, "com.adobe.air.validator.ExtensionDescriptorValidator160");
        tempMap.put(NAMESPACE_17_0, "com.adobe.air.validator.ExtensionDescriptorValidator170");
        NAMESPACE_CLASSNAMES = Collections.unmodifiableMap(tempMap);
        HashMap<String, Integer> versionsTempMap = new HashMap<String, Integer>();
        versionsTempMap.put(NAMESPACE_2_5, 9);
        versionsTempMap.put(NAMESPACE_3_1, 17);
        versionsTempMap.put(NAMESPACE_3_2, 19);
        versionsTempMap.put(NAMESPACE_3_3, 21);
        versionsTempMap.put(NAMESPACE_3_4, 23);
        versionsTempMap.put(NAMESPACE_3_5, 25);
        versionsTempMap.put(NAMESPACE_3_6, 27);
        versionsTempMap.put(NAMESPACE_3_7, 29);
        versionsTempMap.put(NAMESPACE_3_8, 31);
        versionsTempMap.put(NAMESPACE_3_9, 33);
        versionsTempMap.put(NAMESPACE_4_0, 35);
        versionsTempMap.put(NAMESPACE_13_0, 37);
        versionsTempMap.put(NAMESPACE_14_0, 39);
        versionsTempMap.put(NAMESPACE_15_0, 41);
        versionsTempMap.put(NAMESPACE_16_0, 43);
        versionsTempMap.put(NAMESPACE_17_0, 45);
        NAMESPACE_APIVERSIONS = Collections.unmodifiableMap(versionsTempMap);
    }

    public static class Platform {
        public String name = "";
        public String deploymentModel;
        public String nativeLibrary;
        public String initializer;
        public String finalizer;
    }
}

