/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.air.ADTPackager;
import com.adobe.air.ANEFile;
import com.adobe.air.ApplicationDescriptor;
import com.adobe.air.CentralDirectoryReader;
import com.adobe.air.InvalidInputException;
import com.adobe.air.Listener;
import com.adobe.air.SDKDamagedException;
import com.adobe.air.Utils;
import com.adobe.air.validator.DescriptorValidationException;
import com.adobe.ucf.Utils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ApplicationPackager
extends ADTPackager {
    protected static final boolean ALLOW_APP_BUNDLED_EXTENSIONS = true;
    protected static final boolean ALLOW_DEVICE_BUNDLED_EXTENSIONS = true;
    protected Listener m_listener;
    protected File m_applicationDescriptorFile;
    protected ApplicationDescriptor m_applicationDescriptor = null;
    protected File m_airiFile;
    protected File m_airFile;
    protected boolean m_debug = false;
    protected File m_runtimeDir = null;
    private List<File> m_availableExtensions = new LinkedList<File>();
    private List<ANEFile> m_extensions = new LinkedList<ANEFile>();
    private boolean m_allowAppBundledExtensions;
    private boolean m_allowDeviceBundledExtensions;
    protected String m_targetPlatform = "ALL";

    protected ApplicationPackager(String subtype, String targetPlaform, boolean allowAppBundledExtensions, boolean allowDeviceBundledExtensions) {
        super(subtype);
        this.m_allowAppBundledExtensions = allowAppBundledExtensions;
        this.m_allowDeviceBundledExtensions = allowDeviceBundledExtensions;
        this.m_targetPlatform = targetPlaform;
    }

    @Override
    public void createPackage() throws GeneralSecurityException, InvalidInputException, IOException {
        this.reportProgress(0);
        if (this.getOutput() == null) {
            throw new IllegalStateException("output not set");
        }
        if (this.m_airFile == null && this.m_airiFile == null && (this.m_applicationDescriptorFile == null || this.getSources().isEmpty())) {
            throw new IllegalStateException("inputs not set");
        }
        this.getADTStream().setPackager(this);
        if (!this.getSources().isEmpty()) {
            this.validateApplicationDescriptor();
            this.processExtensions();
            this.addSpecialFiles();
            this.validateExtensionSignatures();
            this.addExtensions();
            for (String path : this.getSources().keySet()) {
                File file = (File)this.getSources().get(path);
                if (!this.validateAssetFile(this.getApplicationDescriptor(), path)) continue;
                this.getStream().addFile(file, path, this.m_sign);
            }
        } else {
            String expectedMimetype;
            ZipFile zipFile;
            if (this.m_airiFile != null) {
                zipFile = new ZipFile(this.m_airiFile);
                expectedMimetype = "application/vnd.adobe.air-application-intermediate-package+zip";
            } else if (this.m_airFile != null) {
                zipFile = new ZipFile(this.m_airFile);
                expectedMimetype = "application/vnd.adobe.air-application-installer-package+zip";
            } else {
                throw new IllegalStateException("inputs not set");
            }
            this.getADTStream().addMimeTypeFile(this.getMimetype(), true);
            this.getADTStream().addAIRFile(zipFile, expectedMimetype, this.m_targetPlatform, null);
            this.m_applicationDescriptor = this.getADTStream().getApplicationDescriptor();
            zipFile.close();
        }
        if (this.m_sign) {
            this.getStream().finalizeSig();
        }
        this.getStream().close();
        this.renameOutput();
        this.reportProgress(100);
    }

    private void reportProgress(int percentDone) {
        if (this.m_listener != null) {
            this.m_listener.progress(percentDone, 100);
        }
    }

    protected void validateApplicationDescriptor() throws DescriptorValidationException {
        this.m_applicationDescriptor = new ApplicationDescriptor(this.m_applicationDescriptorFile, this.m_validate);
        this.getApplicationDescriptor().validate(this.getValidationParams(this.m_applicationDescriptor), this.getSources());
    }

    protected void processExtensions() throws IOException, DescriptorValidationException, InvalidInputException {
        this.processAirExtensionPath();
        Set<String> extensionIds = this.m_applicationDescriptor.getRequiredExtensions();
        if (extensionIds == null || extensionIds.size() == 0) {
            return;
        }
        if (!this.m_allowAppBundledExtensions && !this.m_allowDeviceBundledExtensions) {
            throw new InvalidInputException("Native extensions are not allowed for the current target.");
        }
        HashMap<String, ANEFile> aneCache = new HashMap<String, ANEFile>();
        int cAppRootSWFVersion = this.m_applicationDescriptor.getApplicationRootSWFVersion(this.getSources());
        int cAppNSVersion = ApplicationDescriptor.GetAPIVersionForNSURI(this.m_applicationDescriptor.getNamespaceURI());
        for (String id : extensionIds) {
            if (aneCache.containsKey(id)) {
                this.m_extensions.add((ANEFile)aneCache.get(id));
                continue;
            }
            boolean foundANE = false;
            LinkedList<File> processedExtensions = new LinkedList<File>();
            for (File file : this.m_availableExtensions) {
                ANEFile ane = new ANEFile(file);
                processedExtensions.add(file);
                if (id.equals(ane.id())) {
                    boolean supportsPlatform = ane.supportsPlatform(this.m_targetPlatform, this.m_allowAppBundledExtensions, this.m_allowDeviceBundledExtensions);
                    boolean supportsDefault = ane.supportsPlatform(ANEFile.DEFAULT_PLATFORM, this.m_allowAppBundledExtensions, this.m_allowDeviceBundledExtensions);
                    if (this.m_targetPlatform != "ALL" && !supportsPlatform && !supportsDefault) continue;
                    if (!supportsPlatform) {
                        System.out.println("Warning: Using default implementation for native extension '" + id + "'");
                    }
                    if (cAppNSVersion < ane.getDescriptor().getAPIVersionForExtensionNS()) {
                        throw new InvalidInputException("Included native extension '" + id + "' specifies namespace '" + ane.getDescriptor().getNamespaceURI() + "' which is greater than the application namespace: " + this.m_applicationDescriptor.getNamespaceURI());
                    }
                    int cExtMaxSWFVersion = ane.getMaxSWFVersion(supportsPlatform ? this.m_targetPlatform : ANEFile.DEFAULT_PLATFORM);
                    if (cExtMaxSWFVersion > cAppRootSWFVersion) {
                        throw new InvalidInputException("Included native extension '" + id + "' includes a SWF version " + cExtMaxSWFVersion + " which is greater than the version of the root SWF of this application: " + cAppRootSWFVersion);
                    }
                    this.m_extensions.add(ane);
                    foundANE = true;
                    break;
                }
                if (aneCache.containsKey(ane.id())) continue;
                aneCache.put(ane.id(), ane);
            }
            if (!foundANE) {
                throw new InvalidInputException("An implementation for native extension '" + id + "' required " + "by the application was not found for the target platform.");
            }
            this.m_availableExtensions.removeAll(processedExtensions);
        }
    }

    private void validateExtensionSignatures() throws IOException, InvalidInputException {
        if (this.validateExtensions()) {
            for (ANEFile ane : this.m_extensions) {
                if (!ane.isSigned()) {
                    throw new InvalidInputException(ane.getFile().getCanonicalPath() + " is not signed.");
                }
                this.invokeANESignatureValidation(ane.getFile().getCanonicalPath());
            }
        }
    }

    protected void addExtensions() throws IOException, DescriptorValidationException, InvalidInputException {
        Iterator<ANEFile> i$ = this.m_extensions.iterator();
        while (i$.hasNext()) {
            ANEFile ane;
            boolean supportsPlatform = (ane = i$.next()).supportsPlatform(this.m_targetPlatform, this.m_allowAppBundledExtensions, this.m_allowDeviceBundledExtensions);
            ANEFile.ZipEntryIterator entries = ane.getFilesForPlatform(supportsPlatform ? this.m_targetPlatform : ANEFile.DEFAULT_PLATFORM);
            ZipFile zipfile = entries.getZipFile();
            CentralDirectoryReader cdr = new CentralDirectoryReader(zipfile);
            for (ZipEntry entry : entries) {
                String zippedEntry = entry.getName();
                if (!cdr.searchHeader(zippedEntry)) {
                    throw new IOException("Could not find entry for " + zippedEntry + "in ZIP file central directory");
                }
                this.getADTStream().addFileFromZipEntry(entry, entries.getZipFile(), "META-INF/AIR/extensions/" + ane.id() + "/" + entry.getName(), cdr.getPermissions());
            }
            if (cdr == null) continue;
            cdr.close();
        }
    }

    private void processAirExtensionPath() throws InvalidInputException {
        String extpath = System.getenv("AIR_EXTENSION_PATH");
        if (extpath != null) {
            String[] extdirs;
            for (String extdir : extdirs = extpath.split(File.pathSeparator)) {
                File f2 = new File(extdir = extdir.trim());
                if (!f2.exists() || !f2.isDirectory()) continue;
                this.addExtensionDir(f2);
            }
        }
    }

    private void invokeANESignatureValidation(String anePath) throws IOException, SDKDamagedException, InvalidInputException {
        boolean isWin = System.getProperty("os.name").startsWith("Win");
        String toolPath = Utils.getSDKLibDir() + File.separator + "nai" + File.separator + "bin" + File.separator + "naip" + (isWin ? ".exe" : "");
        File tool = new File(toolPath);
        if (!tool.exists()) {
            throw new SDKDamagedException(tool.getPath());
        }
        ArrayList<String> command = new ArrayList<String>(6);
        command.add(tool.getAbsolutePath());
        if (this.m_runtimeDir != null) {
            command.add("-runtime");
            command.add(this.m_runtimeDir.getAbsolutePath());
            if (!this.m_runtimeDir.exists()) {
                throw new InvalidInputException("Runtime directory doesn't exist: " + this.m_runtimeDir.getAbsolutePath());
            }
        } else {
            File runtimes = new File(Utils.getSDKLibDir().getParent(), "runtimes");
            if (!runtimes.exists()) {
                throw new SDKDamagedException("runtimes/");
            }
        }
        command.add("-validateAneSignature");
        command.add(anePath);
        try {
            Process toolProcess = Utils.execSafely(null, command);
            ByteArrayOutputStream processOutputBytes = new ByteArrayOutputStream();
            ByteArrayOutputStream processErrorOutputBytes = new ByteArrayOutputStream();
            new Utils.OutputEater(toolProcess.getInputStream(), processOutputBytes).run();
            new Utils.OutputEater(toolProcess.getErrorStream(), processErrorOutputBytes).run();
            toolProcess.waitFor();
            String processOutput = processOutputBytes.toString("UTF-8") + " " + processErrorOutputBytes.toString("UTF-8");
            switch (toolProcess.exitValue()) {
                case 0: {
                    break;
                }
                case 2: 
                case 6: {
                    throw new InvalidInputException(anePath + " does not contain a valid and trusted signature. " + processOutput);
                }
                default: {
                    throw new InvalidInputException("Unable to verify ANE signature for " + anePath + ". Tool exited with error " + toolProcess.exitValue() + ". Tool output was: \n" + processOutput);
                }
            }
        }
        catch (InterruptedException e2) {
            throw new IOException("ANE signature validation was interrupted.");
        }
    }

    protected void setPackageConfiguration(String config) {
    }

    protected void setForOutgoingDebuggingConnection(String host, int port) throws IOException {
    }

    protected void setPreloadSWFPath(String path) {
    }

    protected void setForIncomingDebuggerConnection(int portToListenOn) throws IOException {
    }

    protected void addSpecialFiles() throws IOException {
        this.getADTStream().addApplicationDescriptor(this.m_applicationDescriptor, this.m_sign);
    }

    public void setDebug(boolean debug) {
        this.m_debug = debug;
    }

    protected void setRuntimeDir(File runtimeDir) {
        this.m_runtimeDir = runtimeDir;
    }

    @Override
    public void setIntermediateFile(File file) {
        this.setAIRIFile(file);
    }

    public void setAIRIFile(File airiFile) {
        if (!this.getSources().isEmpty()) {
            throw new IllegalStateException("sources already added");
        }
        this.m_airiFile = airiFile;
    }

    public void setAIRFile(File airFile) {
        if (!this.getSources().isEmpty()) {
            throw new IllegalStateException("sources already added");
        }
        this.m_airFile = airFile;
    }

    @Override
    public void addSourceWithPath(File source, String path) {
        if (this.m_airiFile != null) {
            throw new IllegalStateException(".airi input already set");
        }
        if (path.startsWith("/")) {
            throw new IllegalArgumentException("absolute path");
        }
        super.addSourceWithPath(source, Utils.performPlatformUnicodePathNormalization(path));
    }

    public void setApplicationDescriptor(File appDescriptorFile) {
        this.m_applicationDescriptorFile = appDescriptorFile;
    }

    public void setDescriptor(File appDescriptorFile) {
        this.setApplicationDescriptor(appDescriptorFile);
    }

    public ApplicationDescriptor getApplicationDescriptor() {
        return this.m_applicationDescriptor;
    }

    protected abstract ApplicationDescriptor.ValidationParams getValidationParams(ApplicationDescriptor var1);

    public void setListener(Listener listener) {
        this.m_listener = listener;
        this.getADTStream().setListener(listener);
    }

    public void addExtensionDir(File dir) throws InvalidInputException {
        if (!dir.exists() || !dir.isDirectory()) {
            throw new InvalidInputException(dir.getPath() + " is not a valid directory.");
        }
        for (File f2 : dir.listFiles()) {
            if (!f2.getName().endsWith(".ane")) continue;
            this.m_availableExtensions.add(f2);
        }
    }

    public void setDeviceSDKDirectory(File sdkDir) throws InvalidInputException {
    }

    public void setAIRDownloadURL(String airDownloadURL) {
    }

    public void setArch(String arch) {
    }

    public void setAllowAppBundledExtensions(boolean value) {
        this.m_allowAppBundledExtensions = value;
    }

    public void setAllowDeviceBundledExtensions(boolean value) {
        this.m_allowDeviceBundledExtensions = value;
    }

    public List<ANEFile> getExtensions() {
        return this.m_extensions;
    }

    protected String getMimetype() {
        return null;
    }

    protected boolean validateAssetFile(ApplicationDescriptor appDescriptor, String filePath) throws InvalidInputException {
        return true;
    }
}

