/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.air.ADTPackager;
import com.adobe.air.AIROutputStream;
import com.adobe.air.ANEFile;
import com.adobe.air.ExtensionDescriptor;
import com.adobe.air.InvalidInputException;
import com.adobe.air.PlatformExtensionDescriptor;
import com.adobe.air.Utils;
import com.adobe.air.apk.AndroidExtensionDescriptor;
import com.adobe.air.ipa.IPAUtils;
import com.adobe.air.ipa.IosExtensionDescriptor;
import com.adobe.air.validator.DescriptorValidationException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public final class ANEPackager
extends ADTPackager {
    protected static final int MIN_SWF_VERSION = 10;
    protected static final String PATH_CATALOG = "catalog.xml";
    protected static final String PATH_LIBRARY_SWF = "library.swf";
    public static final String PATH_PLATFORM_OPTIONS = "platform.xml";
    private File m_swcFile;
    private File m_extensionDescriptorFile;
    private File m_unsignedAneFile;
    private HashSet<String> m_implementedPlatformNames = new HashSet();
    private LinkedList<String> m_supportedPlatforms = new LinkedList<String>(Arrays.asList("default", "Android-ARM", "Android-x86", "iPhone-ARM", "iPhone-x86", "MacOS-x86", "Windows-x86"));

    public ANEPackager() {
        super("ANE");
        this.setStream(new AIROutputStream());
    }

    protected void validate(File mainLibrarySWF) throws InvalidInputException, IOException {
        ExtensionDescriptor descriptor = new ExtensionDescriptor(this.m_extensionDescriptorFile, true);
        SortedMap<String, File> sources = this.getSources();
        if (!sources.containsKey(PATH_CATALOG) || !sources.containsKey(PATH_LIBRARY_SWF)) {
            throw new InvalidInputException("Invalid swc file: " + this.m_swcFile.getCanonicalPath());
        }
        int cMainSWFVersion = Utils.getSWFVersion(mainLibrarySWF);
        if (cMainSWFVersion < 10) {
            throw new InvalidInputException("Invalid swc file, SWF verison must be 10 or higher.");
        }
        int cMaxNameSpaceSWFVersion = descriptor.maxSWFVersion();
        if (cMainSWFVersion > cMaxNameSpaceSWFVersion) {
            throw new InvalidInputException("Invalid swc file. The extension NameSpace requires the SWF verison to be " + cMaxNameSpaceSWFVersion + " or lower.");
        }
        Map<String, ExtensionDescriptor.Platform> descriptorPlatforms = descriptor.applicationDeployedPlatforms();
        Set<String> descriptorPlatformNames = descriptorPlatforms.keySet();
        LinkedList<String> unexpectedPlatformImplementations = new LinkedList<String>(this.m_implementedPlatformNames);
        unexpectedPlatformImplementations.removeAll(descriptorPlatformNames);
        if (unexpectedPlatformImplementations.size() > 0) {
            throw new InvalidInputException("Unexpected implementation for platform: " + unexpectedPlatformImplementations.getFirst());
        }
        LinkedList<String> missingImplementations = new LinkedList<String>(descriptorPlatformNames);
        missingImplementations.removeAll(this.m_implementedPlatformNames);
        if (missingImplementations.size() > 0) {
            throw new InvalidInputException("Missing implementation for platform: " + missingImplementations.getFirst());
        }
        for (ExtensionDescriptor.Platform platform : descriptorPlatforms.values()) {
            String librarySwfPath = "META-INF/ANE/" + platform.name + "/library.swf";
            if (!sources.containsKey(librarySwfPath)) {
                throw new InvalidInputException("Missing 'library.swf' for platform: " + platform.name);
            }
            int cSWFVersion = Utils.getSWFVersion((File)sources.get(librarySwfPath));
            if (cSWFVersion < 10) {
                throw new InvalidInputException("Invalid 'library.swf' for platform: " + platform.name + ". SWF version must be " + 10 + " or higher.");
            }
            if (cSWFVersion > cMaxNameSpaceSWFVersion) {
                throw new InvalidInputException("Invalid 'library.swf' for platform: " + platform.name + ". The extension NameSpace requires the SWF version to be " + cMaxNameSpaceSWFVersion + " or lower.");
            }
            String srcNameToCheck = "META-INF/ANE/" + platform.name + "/" + platform.nativeLibrary;
            String srcNameToReport = platform.nativeLibrary;
            if (platform.name.equals("iPhone-ARM") && platform.nativeLibrary != null && this.getSources().get(srcNameToCheck) != null && !IPAUtils.hasUniversalIOSBinary(((File)this.getSources().get(srcNameToCheck)).getAbsolutePath())) {
                throw new InvalidInputException("Error: Apple App Store allows only universal applications. \"" + ((File)this.getSources().get(srcNameToCheck)).getName() + "\" is not a universal binary." + " Please change build settings in Xcode project to \"Standard Architecture\" to create universal library/framework.");
            }
            if ("MacOS-x86".equalsIgnoreCase(platform.name)) {
                int endOfLib = platform.nativeLibrary.lastIndexOf(".framework");
                if (endOfLib == -1) {
                    throw new InvalidInputException("Illegal native library name '" + srcNameToReport + "' for platform: " + platform.name + ".  '.framework' is required in library name.");
                }
                String dylibName = platform.nativeLibrary.substring(0, endOfLib);
                srcNameToCheck = srcNameToCheck + "/" + dylibName;
                srcNameToReport = srcNameToReport + "/" + dylibName;
            }
            if (platform.nativeLibrary != null && !sources.containsKey(srcNameToCheck)) {
                throw new InvalidInputException("Missing native library implementation '" + srcNameToReport + "' for platform: " + platform.name);
            }
            srcNameToCheck = "META-INF/ANE/" + platform.name + "/" + PATH_PLATFORM_OPTIONS;
            if (!sources.containsKey(srcNameToCheck)) continue;
            this.validatePlatformExtensionDescriptor(((File)sources.get(srcNameToCheck)).getAbsoluteFile(), platform.name, descriptor);
        }
    }

    private void validatePlatformExtensionDescriptor(File platformDescFile, String platform, ExtensionDescriptor extDesc) throws DescriptorValidationException, InvalidInputException, IOException {
        block15: {
            PlatformExtensionDescriptor descriptor;
            block14: {
                descriptor = null;
                if (!platformDescFile.exists()) {
                    throw new InvalidInputException("Missing file " + platformDescFile.getAbsolutePath());
                }
                if (platform.equals("iPhone-ARM") || platform.equals("iPhone-x86")) {
                    descriptor = new IosExtensionDescriptor(platformDescFile);
                } else if (platform.equals("Android-ARM") || platform.equals("Android-x86")) {
                    descriptor = new AndroidExtensionDescriptor(platformDescFile);
                } else {
                    throw new InvalidInputException("platform.xml is not supported for platform " + platform);
                }
                if (!descriptor.getNamespaceURI().equals(extDesc.getNamespaceURI())) {
                    throw new InvalidInputException("Namespace of " + platformDescFile.getName() + " should match extension namespace.");
                }
                if (!(descriptor instanceof IosExtensionDescriptor)) break block14;
                ArrayList<String> files = ((IosExtensionDescriptor)descriptor).dependencies();
                if (files == null || files.size() <= 0) break block15;
                SortedMap<String, File> sources = this.getSources();
                String pathPrefix = "META-INF/ANE/" + platform + "/";
                String path = null;
                for (String file : files) {
                    if (this.isFramework(file)) {
                        String baseName = new File(file).getName();
                        path = pathPrefix + file + '/' + baseName.substring(0, baseName.lastIndexOf(46));
                    } else {
                        path = pathPrefix + file;
                    }
                    if (!sources.containsKey(path)) {
                        throw new InvalidInputException("Missing dependency " + file + " for platform " + platform);
                    }
                    if (!platform.equals("iPhone-ARM") || this.getSources().get(path) == null || IPAUtils.hasUniversalIOSBinary(((File)this.getSources().get(path)).getAbsolutePath())) continue;
                    throw new InvalidInputException("Error: Apple App Store allows only universal applications. \"" + ((File)this.getSources().get(path)).getName() + "\" is not a universal binary." + " Please change build settings in Xcode project to \"Standard Architecture\" to create universal library/framework.");
                }
                break block15;
            }
            if (descriptor instanceof AndroidExtensionDescriptor) {
                SortedMap<String, File> sources = this.getSources();
                String pathPrefix = "META-INF/ANE/" + platform + "/";
                ArrayList<String> dependencies = ((AndroidExtensionDescriptor)descriptor).dependencies();
                for (String dependency : dependencies) {
                    String path = pathPrefix + dependency;
                    if (sources.containsKey(path)) continue;
                    throw new InvalidInputException("Missing dependency " + dependency + " for platform " + platform);
                }
                ArrayList<String> resourceFolders = ((AndroidExtensionDescriptor)descriptor).resourceFolders();
                for (String resourceFolder : resourceFolders) {
                    String path = pathPrefix + resourceFolder + "/";
                    boolean foundResourceFolder = false;
                    for (String resFolderPath : sources.keySet()) {
                        if (!resFolderPath.startsWith(path)) continue;
                        foundResourceFolder = true;
                        break;
                    }
                    if (foundResourceFolder) continue;
                    throw new InvalidInputException("Missing resource folder " + resourceFolder + " for platform " + platform);
                }
            }
        }
    }

    public void createPackage() throws IOException, GeneralSecurityException {
        if (this.m_unsignedAneFile != null) {
            this.getStream().addANEFile(ANEFile.getZipFile(this.m_unsignedAneFile), false);
        } else {
            File tmpSwcDir = Utils.createTempDirectory(this.getOutput().getAbsoluteFile().getParentFile());
            this.addFileForCleanup(tmpSwcDir);
            try {
                Utils.extractZipFile(this.m_swcFile, tmpSwcDir, "");
            }
            catch (Exception e2) {
                String swcPath = this.m_swcFile == null ? "" : this.m_swcFile.getCanonicalPath();
                throw new InvalidInputException("Invalid swc file: " + swcPath);
            }
            this.addSourceFileOrDir(tmpSwcDir, tmpSwcDir);
            if (this.m_validate) {
                this.validate(new File(tmpSwcDir, PATH_LIBRARY_SWF));
            }
            if (this.getOutput() == null) {
                throw new IllegalStateException("output not set");
            }
            this.addSpecialFiles();
            for (String path : this.getSources().keySet()) {
                File file = (File)this.getSources().get(path);
                this.getStream().addFile(file, path, this.m_sign);
            }
        }
        if (this.m_sign) {
            this.getStream().finalizeSig();
        }
        this.getStream().close();
        this.renameOutput();
    }

    public void createIntermediate() throws IOException {
        this.m_sign = false;
        try {
            this.createPackage();
        }
        catch (GeneralSecurityException ex) {
            throw new RuntimeException("certificate exception with signing disabled");
        }
    }

    public void setOutput(File output) throws FileNotFoundException, IOException {
        super.setOutput(output);
        this.initTempFile("ane");
    }

    protected void addSpecialFiles() throws IOException {
        this.getStream().addMimeTypeFile("application/vnd.adobe.air-native-extension-package+zip", this.m_sign);
        this.getStream().addFile(this.m_extensionDescriptorFile, "META-INF/ANE/extension.xml", this.m_sign);
    }

    public void setPrivateKey(PrivateKey key) {
        super.setPrivateKey(key);
        this.setTimestampURL("https://timestamp.geotrust.com/tsa");
    }

    public void setCertificateChain(Certificate[] certchain) throws CertificateException {
        this.validateSigningCertificate(certchain);
        super.setCertificateChain(certchain);
    }

    public void setSWC(File file) {
        this.m_swcFile = file;
    }

    public void setIntermediateFile(File aneiFile) {
        this.m_unsignedAneFile = aneiFile;
    }

    public void setExtensionDescriptor(File file) {
        this.m_extensionDescriptorFile = file;
    }

    public void setPlatformExtensionDescriptor(File file, String platform) {
        this.addExtensionFileWithPath(file, platform, PATH_PLATFORM_OPTIONS);
    }

    public void addExtensionFileOrDir(File file, File root, String platform) {
        this.m_implementedPlatformNames.add(platform);
        this.addMetaFileOrDir(file, root, platform);
    }

    public void addExtensionFileWithPath(File file, String platform, String path) {
        String normalizedPath = Utils.performPlatformUnicodePathNormalization(path);
        if (normalizedPath.startsWith("/") || normalizedPath.length() == 0) {
            throw new IllegalArgumentException("Invalid path '" + path + "' for file " + file.getPath());
        }
        this.m_implementedPlatformNames.add(platform);
        this.addMetaWithPath(file, platform + "/" + normalizedPath);
    }

    protected AIROutputStream getStream() {
        return (AIROutputStream)super.getStream();
    }

    public boolean isSupportedPlatform(String platform) {
        return this.m_supportedPlatforms.contains(platform);
    }

    public String supportedPlatforms() {
        return this.m_supportedPlatforms.toString();
    }

    private boolean isFramework(String path) {
        return path.endsWith(".framework");
    }
}

